/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.EncryptKeyName;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;

public class EncryptKey
implements Writable {
    @SerializedName(value="encryptKeyName")
    private EncryptKeyName encryptKeyName;
    @SerializedName(value="keyString")
    private String keyString;

    public EncryptKey(EncryptKeyName encryptKeyname, String keyString) {
        this.encryptKeyName = encryptKeyname;
        this.keyString = keyString;
    }

    public EncryptKeyName getEncryptKeyName() {
        return this.encryptKeyName;
    }

    public String getKeyString() {
        return this.keyString;
    }

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this);
        Text.writeString((DataOutput)out, (String)json);
    }

    public static EncryptKey read(DataInput input) throws IOException {
        String json = Text.readString((DataInput)input);
        return (EncryptKey)GsonUtils.GSON.fromJson(json, EncryptKey.class);
    }

    public boolean isIdentical(EncryptKey other) {
        return this.encryptKeyName.equals(other.getEncryptKeyName());
    }

    public List<Comparable> getInfo() {
        ArrayList row = Lists.newArrayList();
        row.add(this.encryptKeyName.toString());
        row.add(this.keyString);
        return row;
    }
}

