/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import java.util.Map;
import java.util.TimeZone;
import org.apache.doris.analysis.TimestampArithmeticExpr;
import org.apache.doris.catalog.ReplicaAllocation;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.util.DynamicPartitionUtil;
import org.apache.doris.common.util.PropertyAnalyzer;
import org.apache.doris.common.util.TimeUtils;

public class DynamicPartitionProperty {
    public static final String DYNAMIC_PARTITION_PROPERTY_PREFIX = "dynamic_partition.";
    public static final String TIME_UNIT = "dynamic_partition.time_unit";
    public static final String START = "dynamic_partition.start";
    public static final String END = "dynamic_partition.end";
    public static final String PREFIX = "dynamic_partition.prefix";
    public static final String BUCKETS = "dynamic_partition.buckets";
    public static final String ENABLE = "dynamic_partition.enable";
    public static final String START_DAY_OF_WEEK = "dynamic_partition.start_day_of_week";
    public static final String START_DAY_OF_MONTH = "dynamic_partition.start_day_of_month";
    public static final String TIME_ZONE = "dynamic_partition.time_zone";
    public static final String REPLICATION_NUM = "dynamic_partition.replication_num";
    public static final String REPLICATION_ALLOCATION = "dynamic_partition.replication_allocation";
    public static final String CREATE_HISTORY_PARTITION = "dynamic_partition.create_history_partition";
    public static final String HISTORY_PARTITION_NUM = "dynamic_partition.history_partition_num";
    public static final String HOT_PARTITION_NUM = "dynamic_partition.hot_partition_num";
    public static final String RESERVED_HISTORY_PERIODS = "dynamic_partition.reserved_history_periods";
    public static final int MIN_START_OFFSET = Integer.MIN_VALUE;
    public static final int MAX_END_OFFSET = Integer.MAX_VALUE;
    public static final int NOT_SET_REPLICATION_NUM = -1;
    public static final int NOT_SET_HISTORY_PARTITION_NUM = -1;
    public static final String NOT_SET_RESERVED_HISTORY_PERIODS = "NULL";
    private boolean exist;
    private boolean enable;
    private String timeUnit;
    private int start;
    private int end;
    private String prefix;
    private int buckets;
    private DynamicPartitionUtil.StartOfDate startOfWeek;
    private DynamicPartitionUtil.StartOfDate startOfMonth;
    private TimeZone tz = TimeUtils.getSystemTimeZone();
    private ReplicaAllocation replicaAlloc;
    private boolean createHistoryPartition = false;
    private int historyPartitionNum;
    private int hotPartitionNum;
    private String reservedHistoryPeriods;

    public DynamicPartitionProperty(Map<String, String> properties) {
        if (properties != null && !properties.isEmpty()) {
            this.exist = true;
            this.enable = Boolean.parseBoolean(properties.get(ENABLE));
            this.timeUnit = properties.get(TIME_UNIT);
            this.tz = TimeUtils.getOrSystemTimeZone(properties.get(TIME_ZONE));
            this.start = Integer.parseInt(properties.getOrDefault(START, String.valueOf(Integer.MIN_VALUE)));
            this.end = Integer.parseInt(properties.get(END));
            this.prefix = properties.get(PREFIX);
            this.buckets = Integer.parseInt(properties.get(BUCKETS));
            this.replicaAlloc = this.analyzeReplicaAllocation(properties);
            this.createHistoryPartition = Boolean.parseBoolean(properties.get(CREATE_HISTORY_PARTITION));
            this.historyPartitionNum = Integer.parseInt(properties.getOrDefault(HISTORY_PARTITION_NUM, String.valueOf(-1)));
            this.hotPartitionNum = Integer.parseInt(properties.getOrDefault(HOT_PARTITION_NUM, "0"));
            this.reservedHistoryPeriods = properties.getOrDefault(RESERVED_HISTORY_PERIODS, NOT_SET_RESERVED_HISTORY_PERIODS);
            this.createStartOfs(properties);
        } else {
            this.exist = false;
        }
    }

    private ReplicaAllocation analyzeReplicaAllocation(Map<String, String> properties) {
        try {
            return PropertyAnalyzer.analyzeReplicaAllocation(properties, "dynamic_partition");
        }
        catch (AnalysisException e) {
            return ReplicaAllocation.NOT_SET;
        }
    }

    private void createStartOfs(Map<String, String> properties) {
        this.startOfWeek = properties.containsKey(START_DAY_OF_WEEK) ? new DynamicPartitionUtil.StartOfDate(-1, -1, Integer.valueOf(properties.get(START_DAY_OF_WEEK))) : new DynamicPartitionUtil.StartOfDate(-1, -1, 1);
        this.startOfMonth = properties.containsKey(START_DAY_OF_MONTH) ? new DynamicPartitionUtil.StartOfDate(-1, Integer.valueOf(properties.get(START_DAY_OF_MONTH)), -1) : new DynamicPartitionUtil.StartOfDate(-1, 1, -1);
    }

    public boolean isExist() {
        return this.exist;
    }

    public String getTimeUnit() {
        return this.timeUnit;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getBuckets() {
        return this.buckets;
    }

    public boolean getEnable() {
        return this.enable;
    }

    public DynamicPartitionUtil.StartOfDate getStartOfWeek() {
        return this.startOfWeek;
    }

    public DynamicPartitionUtil.StartOfDate getStartOfMonth() {
        return this.startOfMonth;
    }

    public boolean isCreateHistoryPartition() {
        return this.createHistoryPartition;
    }

    public int getHistoryPartitionNum() {
        return this.historyPartitionNum;
    }

    public int getHotPartitionNum() {
        return this.hotPartitionNum;
    }

    public String getStartOfInfo() {
        if (this.getTimeUnit().equalsIgnoreCase(TimestampArithmeticExpr.TimeUnit.WEEK.toString())) {
            return this.startOfWeek.toDisplayInfo();
        }
        if (this.getTimeUnit().equalsIgnoreCase(TimestampArithmeticExpr.TimeUnit.MONTH.toString())) {
            return this.startOfMonth.toDisplayInfo();
        }
        return FeConstants.null_string;
    }

    public TimeZone getTimeZone() {
        return this.tz;
    }

    public ReplicaAllocation getReplicaAllocation() {
        return this.replicaAlloc;
    }

    public String getReservedHistoryPeriods() {
        return this.reservedHistoryPeriods;
    }

    public String getSortedReservedHistoryPeriods(String reservedHistoryPeriods, String timeUnit) throws DdlException {
        return DynamicPartitionUtil.sortedListedToString(reservedHistoryPeriods, timeUnit);
    }

    public String getProperties(ReplicaAllocation tableReplicaAlloc) {
        ReplicaAllocation tmpAlloc = this.replicaAlloc.isNotSet() ? tableReplicaAlloc : this.replicaAlloc;
        String res = ",\n\"dynamic_partition.enable\" = \"" + this.enable + "\",\n\"" + TIME_UNIT + "\" = \"" + this.timeUnit + "\",\n\"" + TIME_ZONE + "\" = \"" + this.tz.getID() + "\",\n\"" + START + "\" = \"" + this.start + "\",\n\"" + END + "\" = \"" + this.end + "\",\n\"" + PREFIX + "\" = \"" + this.prefix + "\",\n\"" + REPLICATION_ALLOCATION + "\" = \"" + tmpAlloc.toCreateStmt() + "\",\n\"" + BUCKETS + "\" = \"" + this.buckets + "\",\n\"" + CREATE_HISTORY_PARTITION + "\" = \"" + this.createHistoryPartition + "\",\n\"" + HISTORY_PARTITION_NUM + "\" = \"" + this.historyPartitionNum + "\",\n\"" + HOT_PARTITION_NUM + "\" = \"" + this.hotPartitionNum + "\",\n\"" + RESERVED_HISTORY_PERIODS + "\" = \"" + this.reservedHistoryPeriods + "\"";
        if (this.getTimeUnit().equalsIgnoreCase(TimestampArithmeticExpr.TimeUnit.WEEK.toString())) {
            res = res + ",\n\"dynamic_partition.start_day_of_week\" = \"" + this.startOfWeek.dayOfWeek + "\"";
        } else if (this.getTimeUnit().equalsIgnoreCase(TimestampArithmeticExpr.TimeUnit.MONTH.toString())) {
            res = res + ",\n\"dynamic_partition.start_day_of_month\" = \"" + this.startOfMonth.day + "\"";
        }
        return res;
    }
}

