/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.doris.common.util.MasterDaemon;
import org.apache.doris.mysql.privilege.PaloAuth;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DomainResolver
extends MasterDaemon {
    private static final Logger LOG = LogManager.getLogger(DomainResolver.class);
    private static final String BNS_RESOLVER_TOOLS_PATH = "/usr/bin/get_instance_by_service";
    private PaloAuth auth;

    public DomainResolver(PaloAuth auth) {
        super("domain resolver", 10000L);
        this.auth = auth;
    }

    @Override
    public void runAfterCatalogReady() {
        HashSet allDomains = Sets.newHashSet();
        this.auth.getAllDomains(allDomains);
        HashMap resolvedIPsMap = Maps.newHashMap();
        for (String domain : allDomains) {
            LOG.debug("begin to resolve domain: {}", (Object)domain);
            HashSet resolvedIPs = Sets.newHashSet();
            if (!this.resolveWithBNS(domain, resolvedIPs) && !this.resolveWithDNS(domain, resolvedIPs)) continue;
            LOG.debug("get resolved ip of domain {}: {}", (Object)domain, (Object)resolvedIPs);
            resolvedIPsMap.put(domain, resolvedIPs);
        }
        this.auth.refreshUserPrivEntriesByResovledIPs(resolvedIPsMap);
    }

    public boolean isValidDomain(String domainName) {
        if (Strings.isNullOrEmpty((String)domainName)) {
            LOG.warn("Domain name is null or empty");
            return false;
        }
        HashSet ipSet = Sets.newHashSet();
        return this.resolveWithDNS(domainName, ipSet) || this.resolveWithBNS(domainName, ipSet);
    }

    public boolean resolveWithDNS(String domainName, Set<String> resolvedIPs) {
        InetAddress[] address;
        try {
            address = InetAddress.getAllByName(domainName);
        }
        catch (UnknownHostException e) {
            LOG.warn("unknown domain name " + domainName + " with dns: " + e.getMessage());
            return false;
        }
        for (InetAddress addr : address) {
            resolvedIPs.add(addr.getHostAddress());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resolveWithBNS(String domainName, Set<String> resolvedIPs) {
        File binaryFile = new File(BNS_RESOLVER_TOOLS_PATH);
        if (!binaryFile.exists()) {
            LOG.info("{} does not exist", (Object)BNS_RESOLVER_TOOLS_PATH);
            return false;
        }
        StringBuilder cmdBuilder = new StringBuilder();
        cmdBuilder.append(BNS_RESOLVER_TOOLS_PATH).append(" -a ").append(domainName);
        Process process = null;
        BufferedReader bufferedReader = null;
        String str = null;
        String ip = null;
        try {
            process = Runtime.getRuntime().exec(cmdBuilder.toString());
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((str = bufferedReader.readLine()) != null) {
                ip = str.split(" ")[1];
                resolvedIPs.add(ip);
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                LOG.warn("failed to execute cmd: {}, exit code: {}", (Object)cmdBuilder.toString(), (Object)exitCode);
                resolvedIPs.clear();
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException | InterruptedException e) {
            LOG.warn("failed to resolve domain with BNS", (Throwable)e);
            resolvedIPs.clear();
            boolean bl = false;
            return bl;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                LOG.error("Close bufferedReader error! " + e);
            }
        }
    }
}

