/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.common.Config;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.doris.thrift.TStorageMedium;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DiskInfo
implements Writable {
    private static final Logger LOG = LogManager.getLogger(DiskInfo.class);
    private static final long DEFAULT_CAPACITY_B = 0x10000000000L;
    @SerializedName(value="rootPath")
    private String rootPath;
    @SerializedName(value="totalCapacityB")
    private long totalCapacityB;
    @SerializedName(value="dataUsedCapacityB")
    private long dataUsedCapacityB;
    @SerializedName(value="diskAvailableCapacityB")
    private long diskAvailableCapacityB;
    @SerializedName(value="state")
    private DiskState state;
    private long pathHash = 0L;
    private TStorageMedium storageMedium;

    private DiskInfo() {
    }

    public DiskInfo(String rootPath) {
        this.rootPath = rootPath;
        this.totalCapacityB = 0x10000000000L;
        this.dataUsedCapacityB = 0L;
        this.diskAvailableCapacityB = 0x10000000000L;
        this.state = DiskState.ONLINE;
        this.pathHash = 0L;
        this.storageMedium = TStorageMedium.HDD;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public long getTotalCapacityB() {
        return this.totalCapacityB;
    }

    public void setTotalCapacityB(long totalCapacityB) {
        this.totalCapacityB = totalCapacityB;
    }

    public long getDataUsedCapacityB() {
        return this.dataUsedCapacityB;
    }

    public void setDataUsedCapacityB(long dataUsedCapacityB) {
        this.dataUsedCapacityB = dataUsedCapacityB;
    }

    public long getDiskUsedCapacityB() {
        return this.totalCapacityB - this.diskAvailableCapacityB;
    }

    public long getAvailableCapacityB() {
        return this.diskAvailableCapacityB;
    }

    public void setAvailableCapacityB(long availableCapacityB) {
        this.diskAvailableCapacityB = availableCapacityB;
    }

    public double getUsedPct() {
        return (double)this.getDiskUsedCapacityB() / (double)(this.totalCapacityB <= 0L ? 1L : this.totalCapacityB);
    }

    public DiskState getState() {
        return this.state;
    }

    public boolean setState(DiskState state) {
        if (this.state != state) {
            this.state = state;
            return true;
        }
        return false;
    }

    public long getPathHash() {
        return this.pathHash;
    }

    public void setPathHash(long pathHash) {
        this.pathHash = pathHash;
    }

    public boolean hasPathHash() {
        return this.pathHash != 0L;
    }

    public boolean isStorageMediumMatch(TStorageMedium storageMedium) {
        return this.storageMedium == storageMedium;
    }

    public TStorageMedium getStorageMedium() {
        return this.storageMedium;
    }

    public void setStorageMedium(TStorageMedium storageMedium) {
        this.storageMedium = storageMedium;
    }

    public boolean exceedLimit(boolean floodStage) {
        LOG.debug("flood stage: {}, diskAvailableCapacityB: {}, totalCapacityB: {}", (Object)floodStage, (Object)this.diskAvailableCapacityB, (Object)this.totalCapacityB);
        if (floodStage) {
            return this.diskAvailableCapacityB < Config.storage_flood_stage_left_capacity_bytes && this.getUsedPct() > (double)Config.storage_flood_stage_usage_percent / 100.0;
        }
        return this.diskAvailableCapacityB < Config.storage_min_left_capacity_bytes || this.getUsedPct() > (double)Config.storage_high_watermark_usage_percent / 100.0;
    }

    public String toString() {
        return "DiskInfo [rootPath=" + this.rootPath + "(" + this.pathHash + "), totalCapacityB=" + this.totalCapacityB + ", dataUsedCapacityB=" + this.dataUsedCapacityB + ", diskAvailableCapacityB=" + this.diskAvailableCapacityB + ", state=" + (Object)((Object)this.state) + ", medium: " + this.storageMedium + "]";
    }

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this);
        Text.writeString((DataOutput)out, (String)json);
    }

    public static DiskInfo read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (DiskInfo)GsonUtils.GSON.fromJson(json, DiskInfo.class);
    }

    public static enum DiskState {
        ONLINE,
        OFFLINE;

    }
}

