/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.doris.catalog.IcebergProperty;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.external.iceberg.IcebergCatalog;
import org.apache.doris.external.iceberg.IcebergCatalogMgr;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatabaseProperty
implements Writable {
    private static final Logger LOG = LogManager.getLogger(DatabaseProperty.class);
    public static final String ICEBERG_PROPERTY_PREFIX = "iceberg";
    @SerializedName(value="properties")
    private Map<String, String> properties = Maps.newHashMap();
    private IcebergProperty icebergProperty = new IcebergProperty(Maps.newHashMap());

    public DatabaseProperty() {
    }

    public DatabaseProperty(Map<String, String> properties) {
        this.properties = properties;
    }

    public void put(String key, String val) {
        this.properties.put(key, val);
    }

    public String get(String key) {
        return this.properties.get(key);
    }

    public String getOrDefault(String key, String defaultVal) {
        return this.properties.getOrDefault(key, defaultVal);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public IcebergProperty getIcebergProperty() {
        return this.icebergProperty;
    }

    public DatabaseProperty checkAndBuildProperties() throws DdlException {
        HashMap<String, String> icebergProperties = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (!entry.getKey().startsWith(ICEBERG_PROPERTY_PREFIX)) continue;
            icebergProperties.put(entry.getKey(), entry.getValue());
        }
        if (icebergProperties.size() > 0) {
            this.checkAndBuildIcebergProperty(icebergProperties);
        }
        return this;
    }

    private void checkAndBuildIcebergProperty(Map<String, String> properties) throws DdlException {
        IcebergCatalogMgr.validateProperties(properties, false);
        this.icebergProperty = new IcebergProperty(properties);
        String icebergDb = this.icebergProperty.getDatabase();
        IcebergCatalog icebergCatalog = IcebergCatalogMgr.getCatalog(this.icebergProperty);
        if (!icebergCatalog.databaseExists(icebergDb)) {
            throw new DdlException("Database [" + icebergDb + "] dose not exist in Iceberg.");
        }
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)GsonUtils.GSON.toJson((Object)this));
    }

    public static DatabaseProperty read(DataInput in) throws IOException {
        return (DatabaseProperty)GsonUtils.GSON.fromJson(Text.readString((DataInput)in), DatabaseProperty.class);
    }
}

