/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.common.Config;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.thrift.TStorageMedium;

public class DataProperty
implements Writable {
    public static final DataProperty DEFAULT_DATA_PROPERTY = new DataProperty("SSD".equalsIgnoreCase(Config.default_storage_medium) ? TStorageMedium.SSD : TStorageMedium.HDD);
    public static final long MAX_COOLDOWN_TIME_MS = 253402271999000L;
    @SerializedName(value="storageMedium")
    private TStorageMedium storageMedium;
    @SerializedName(value="cooldownTimeMs")
    private long cooldownTimeMs;

    private DataProperty() {
    }

    public DataProperty(TStorageMedium medium) {
        this.storageMedium = medium;
        if (medium == TStorageMedium.SSD) {
            long currentTimeMs = System.currentTimeMillis();
            this.cooldownTimeMs = currentTimeMs + Config.storage_cooldown_second * 1000L;
        } else {
            this.cooldownTimeMs = 253402271999000L;
        }
    }

    public DataProperty(TStorageMedium medium, long cooldown) {
        this.storageMedium = medium;
        this.cooldownTimeMs = cooldown;
    }

    public TStorageMedium getStorageMedium() {
        return this.storageMedium;
    }

    public long getCooldownTimeMs() {
        return this.cooldownTimeMs;
    }

    public static DataProperty read(DataInput in) throws IOException {
        DataProperty dataProperty = new DataProperty();
        dataProperty.readFields(in);
        return dataProperty;
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.storageMedium.name());
        out.writeLong(this.cooldownTimeMs);
    }

    public void readFields(DataInput in) throws IOException {
        this.storageMedium = TStorageMedium.valueOf((String)Text.readString((DataInput)in));
        this.cooldownTimeMs = in.readLong();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataProperty)) {
            return false;
        }
        DataProperty other = (DataProperty)obj;
        return this.storageMedium == other.storageMedium && this.cooldownTimeMs == other.cooldownTimeMs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Storage medium[").append(this.storageMedium).append("]. ");
        sb.append("cool down[").append(TimeUtils.longToTimeString(this.cooldownTimeMs)).append("].");
        return sb.toString();
    }
}

