/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.common.io.Writable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ColumnStats
implements Writable {
    private static final Logger LOG = LogManager.getLogger(ColumnStats.class);
    @SerializedName(value="avgSerializedSize")
    private float avgSerializedSize;
    @SerializedName(value="maxSize")
    private long maxSize;
    @SerializedName(value="numDistinctValues")
    private long numDistinctValues;
    @SerializedName(value="numNulls")
    private long numNulls;

    public ColumnStats() {
        this.avgSerializedSize = -1.0f;
        this.maxSize = -1L;
        this.numDistinctValues = -1L;
        this.numNulls = -1L;
    }

    public ColumnStats(ColumnStats other) {
        this.avgSerializedSize = other.avgSerializedSize;
        this.maxSize = other.maxSize;
        this.numDistinctValues = other.numDistinctValues;
        this.numNulls = other.numNulls;
    }

    public long getNumDistinctValues() {
        return this.numDistinctValues;
    }

    public void setNumDistinctValues(long numDistinctValues) {
        this.numDistinctValues = numDistinctValues;
    }

    public float getAvgSerializedSize() {
        return this.avgSerializedSize;
    }

    public void setAvgSerializedSize(float avgSize) {
        this.avgSerializedSize = avgSize;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public boolean hasNulls() {
        return this.numNulls > 0L;
    }

    public long getNumNulls() {
        return this.numNulls;
    }

    public void setNumNulls(long numNulls) {
        this.numNulls = numNulls;
    }

    public boolean hasAvgSerializedSize() {
        return this.avgSerializedSize >= 0.0f;
    }

    public boolean hasMaxSize() {
        return this.maxSize >= 0L;
    }

    public boolean hasNumDistinctValues() {
        return this.numDistinctValues >= 0L;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("avgSerializedSize", this.avgSerializedSize).add("maxSize", this.maxSize).add("numDistinct", this.numDistinctValues).add("numNulls", this.numNulls).toString();
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.numDistinctValues);
        out.writeFloat(this.avgSerializedSize);
        out.writeLong(this.maxSize);
        out.writeLong(this.numNulls);
    }

    public void readFields(DataInput in) throws IOException {
        this.numDistinctValues = in.readLong();
        this.avgSerializedSize = in.readFloat();
        this.maxSize = in.readLong();
        this.numNulls = in.readLong();
    }

    public static ColumnStats read(DataInput in) throws IOException {
        ColumnStats columnStats = new ColumnStats();
        columnStats.readFields(in);
        return columnStats;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ColumnStats)) {
            return false;
        }
        ColumnStats stats = (ColumnStats)obj;
        return this.numDistinctValues == stats.numDistinctValues && this.avgSerializedSize == stats.avgSerializedSize && this.maxSize == stats.maxSize && this.numNulls == stats.numNulls;
    }

    public ColumnStats(PrimitiveType colType) {
        this.avgSerializedSize = -1.0f;
        this.maxSize = -1L;
        this.numDistinctValues = -1L;
        this.numNulls = -1L;
        if (colType.isNumericType() || colType.isDateType()) {
            this.avgSerializedSize = colType.getSlotSize();
            this.maxSize = colType.getSlotSize();
        }
    }

    public static ColumnStats fromExpr(Expr expr) {
        Preconditions.checkNotNull((Object)expr);
        Preconditions.checkState((boolean)expr.getType().isValid());
        ColumnStats stats = new ColumnStats(expr.getType().getPrimitiveType());
        stats.setNumDistinctValues(expr.getNumDistinctValues());
        SlotRef slotRef = expr.unwrapSlotRef();
        if (slotRef == null) {
            return stats;
        }
        ColumnStats slotStats = slotRef.getDesc().getStats();
        if (slotStats == null) {
            return stats;
        }
        stats.numNulls = slotStats.getNumNulls();
        stats.avgSerializedSize = slotStats.getAvgSerializedSize();
        stats.maxSize = slotStats.getMaxSize();
        return stats;
    }
}

