/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.DefaultValueExprDef;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.AggregateType;
import org.apache.doris.catalog.ArrayType;
import org.apache.doris.catalog.ColumnStats;
import org.apache.doris.catalog.ColumnType;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.CaseSensibility;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.SqlUtils;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.doris.thrift.TColumn;
import org.apache.doris.thrift.TColumnType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Column
implements Writable {
    private static final Logger LOG = LogManager.getLogger(Column.class);
    public static final String DELETE_SIGN = "__DORIS_DELETE_SIGN__";
    public static final String SEQUENCE_COL = "__DORIS_SEQUENCE_COL__";
    private static final String COLUMN_ARRAY_CHILDREN = "item";
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="type")
    private Type type;
    @SerializedName(value="aggregationType")
    private AggregateType aggregationType;
    @SerializedName(value="isAggregationTypeImplicit")
    private boolean isAggregationTypeImplicit;
    @SerializedName(value="isKey")
    private boolean isKey;
    @SerializedName(value="isAllowNull")
    private boolean isAllowNull;
    @SerializedName(value="defaultValue")
    private String defaultValue;
    @SerializedName(value="comment")
    private String comment;
    @SerializedName(value="stats")
    private ColumnStats stats;
    @SerializedName(value="children")
    private List<Column> children;
    private Expr defineExpr;
    @SerializedName(value="visible")
    private boolean visible;
    @SerializedName(value="defaultValueExprDef")
    private DefaultValueExprDef defaultValueExprDef;

    public Column() {
        this.name = "";
        this.type = Type.NULL;
        this.isAggregationTypeImplicit = false;
        this.isKey = false;
        this.stats = new ColumnStats();
        this.visible = true;
        this.defineExpr = null;
        this.children = new ArrayList<Column>(Type.MAX_NESTING_DEPTH);
    }

    public Column(String name, PrimitiveType dataType) {
        this(name, ScalarType.createType(dataType), false, null, false, null, "");
    }

    public Column(String name, PrimitiveType dataType, boolean isAllowNull) {
        this(name, ScalarType.createType(dataType), false, null, isAllowNull, null, "");
    }

    public Column(String name, Type type) {
        this(name, type, false, null, false, null, "");
    }

    public Column(String name, Type type, boolean isKey, AggregateType aggregateType, String defaultValue, String comment) {
        this(name, type, isKey, aggregateType, false, defaultValue, comment);
    }

    public Column(String name, Type type, boolean isKey, AggregateType aggregateType, boolean isAllowNull, String defaultValue, String comment) {
        this(name, type, isKey, aggregateType, isAllowNull, defaultValue, comment, true, null);
    }

    public Column(String name, Type type, boolean isKey, AggregateType aggregateType, boolean isAllowNull, String defaultValue, String comment, boolean visible, DefaultValueExprDef defaultValueExprDef) {
        this.name = name;
        if (this.name == null) {
            this.name = "";
        }
        this.type = type;
        if (this.type == null) {
            this.type = Type.NULL;
        }
        this.aggregationType = aggregateType;
        this.isAggregationTypeImplicit = false;
        this.isKey = isKey;
        this.isAllowNull = isAllowNull;
        this.defaultValue = defaultValue;
        this.defaultValueExprDef = defaultValueExprDef;
        this.comment = comment;
        this.stats = new ColumnStats();
        this.visible = visible;
        this.children = new ArrayList<Column>(Type.MAX_NESTING_DEPTH);
        this.createChildrenColumn(this.type, this);
    }

    public Column(Column column) {
        this.name = column.getName();
        this.type = column.type;
        this.aggregationType = column.getAggregationType();
        this.isAggregationTypeImplicit = column.isAggregationTypeImplicit();
        this.isKey = column.isKey();
        this.isAllowNull = column.isAllowNull();
        this.defaultValue = column.getDefaultValue();
        this.defaultValueExprDef = column.defaultValueExprDef;
        this.comment = column.getComment();
        this.stats = column.getStats();
        this.visible = column.visible;
        this.children = column.getChildren();
    }

    public void createChildrenColumn(Type type, Column column) {
        if (type.isArrayType()) {
            Column c = new Column(COLUMN_ARRAY_CHILDREN, ((ArrayType)type).getItemType());
            column.addChildrenColumn(c);
        }
    }

    public List<Column> getChildren() {
        return this.children;
    }

    private void addChildrenColumn(Column column) {
        this.children.add(column);
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        if (this.defineExpr == null) {
            return this.name;
        }
        return this.defineExpr.toSql();
    }

    public String getNameWithoutPrefix(String prefix) {
        if (this.isNameWithPrefix(prefix)) {
            return this.name.substring(prefix.length());
        }
        return this.name;
    }

    public boolean isNameWithPrefix(String prefix) {
        return this.name.startsWith(prefix);
    }

    public void setIsKey(boolean isKey) {
        if (isKey) {
            this.setAggregationType(null, false);
        }
        this.isKey = isKey;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setIsVisible(boolean isVisible) {
        this.visible = isVisible;
    }

    public boolean isDeleteSignColumn() {
        return !this.visible && this.aggregationType == AggregateType.REPLACE && this.nameEquals(DELETE_SIGN, true);
    }

    public boolean isSequenceColumn() {
        return !this.visible && this.aggregationType == AggregateType.REPLACE && this.nameEquals(SEQUENCE_COL, true);
    }

    public PrimitiveType getDataType() {
        return this.type.getPrimitiveType();
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getOriginType() {
        return this.type;
    }

    public int getStrLen() {
        return this.type.getLength();
    }

    public int getPrecision() {
        return this.type instanceof ScalarType ? ((ScalarType)this.type).getScalarPrecision() : -1;
    }

    public int getScale() {
        return this.type instanceof ScalarType ? ((ScalarType)this.type).getScalarScale() : -1;
    }

    public AggregateType getAggregationType() {
        return this.aggregationType;
    }

    public boolean isAggregated() {
        return this.aggregationType != null && this.aggregationType != AggregateType.NONE;
    }

    public boolean isAggregationTypeImplicit() {
        return this.isAggregationTypeImplicit;
    }

    public void setAggregationType(AggregateType aggregationType, boolean isAggregationTypeImplicit) {
        this.aggregationType = aggregationType;
        this.isAggregationTypeImplicit = isAggregationTypeImplicit;
    }

    public void setAggregationTypeImplicit(boolean isAggregationTypeImplicit) {
        this.isAggregationTypeImplicit = isAggregationTypeImplicit;
    }

    public boolean isAllowNull() {
        return this.isAllowNull;
    }

    public void setIsAllowNull(boolean isAllowNull) {
        this.isAllowNull = isAllowNull;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Expr getDefaultValueExpr() throws AnalysisException {
        StringLiteral defaultValueLiteral = new StringLiteral(this.defaultValue);
        if (this.getDataType() == PrimitiveType.VARCHAR) {
            return defaultValueLiteral;
        }
        if (this.defaultValueExprDef != null) {
            return this.defaultValueExprDef.getExpr();
        }
        Expr result = defaultValueLiteral.castTo(this.getType());
        result.checkValueValid();
        return result;
    }

    public void setStats(ColumnStats stats) {
        this.stats = stats;
    }

    public ColumnStats getStats() {
        return this.stats;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.getComment(false);
    }

    public String getComment(boolean escapeQuota) {
        if (!escapeQuota) {
            return this.comment;
        }
        return SqlUtils.escapeQuota(this.comment);
    }

    public int getOlapColumnIndexSize() {
        PrimitiveType type = this.getDataType();
        if (type == PrimitiveType.CHAR) {
            return this.getStrLen();
        }
        return type.getOlapColumnIndexSize();
    }

    public TColumn toThrift() {
        TColumn tColumn = new TColumn();
        tColumn.setColumnName(this.name);
        TColumnType tColumnType = new TColumnType();
        tColumnType.setType(this.getDataType().toThrift());
        tColumnType.setLen(this.getStrLen());
        tColumnType.setPrecision(this.getPrecision());
        tColumnType.setScale(this.getScale());
        tColumnType.setIndexLen(this.getOlapColumnIndexSize());
        tColumn.setColumnType(tColumnType);
        if (null != this.aggregationType) {
            tColumn.setAggregationType(this.aggregationType.toThrift());
        }
        tColumn.setIsKey(this.isKey);
        tColumn.setIsAllowNull(this.isAllowNull);
        tColumn.setDefaultValue(this.defaultValue);
        tColumn.setVisible(this.visible);
        tColumn.setChildrenColumn(new ArrayList());
        this.toChildrenThrift(this, tColumn);
        return tColumn;
    }

    private void toChildrenThrift(Column column, TColumn tColumn) {
        if (column.type.isArrayType()) {
            Column children = column.getChildren().get(0);
            TColumn childrenTColumn = new TColumn();
            childrenTColumn.setColumnName(children.name);
            TColumnType childrenTColumnType = new TColumnType();
            childrenTColumnType.setType(children.getDataType().toThrift());
            childrenTColumnType.setType(children.getDataType().toThrift());
            childrenTColumnType.setLen(children.getStrLen());
            childrenTColumnType.setPrecision(children.getPrecision());
            childrenTColumnType.setScale(children.getScale());
            childrenTColumnType.setIndexLen(children.getOlapColumnIndexSize());
            childrenTColumn.setColumnType(childrenTColumnType);
            tColumn.children_column.add(childrenTColumn);
            this.toChildrenThrift(children, childrenTColumn);
        }
    }

    public void checkSchemaChangeAllowed(Column other) throws DdlException {
        if (Strings.isNullOrEmpty((String)other.name)) {
            throw new DdlException("Dest column name is empty");
        }
        if (!ColumnType.isSchemaChangeAllowed(this.type, other.type)) {
            throw new DdlException("Can not change " + (Object)((Object)this.getDataType()) + " to " + (Object)((Object)other.getDataType()));
        }
        if (this.type.isNumericType() && other.type.isStringType()) {
            Integer lSize = this.type.getColumnStringRepSize();
            Integer rSize = other.type.getColumnStringRepSize();
            if (rSize < lSize) {
                throw new DdlException("Can not change from wider type " + this.type.toSql() + " to narrower type " + other.type.toSql());
            }
        }
        if (this.aggregationType != other.aggregationType) {
            throw new DdlException("Can not change aggregation type");
        }
        if (this.isAllowNull && !other.isAllowNull) {
            throw new DdlException("Can not change from nullable to non-nullable");
        }
        if (this.getDefaultValue() == null ? other.getDefaultValue() != null : !this.getDefaultValue().equals(other.getDefaultValue())) {
            throw new DdlException("Can not change default value");
        }
        if ((this.getDataType() == PrimitiveType.VARCHAR && other.getDataType() == PrimitiveType.VARCHAR || this.getDataType() == PrimitiveType.CHAR && other.getDataType() == PrimitiveType.VARCHAR || this.getDataType() == PrimitiveType.CHAR && other.getDataType() == PrimitiveType.CHAR) && this.getStrLen() > other.getStrLen()) {
            throw new DdlException("Cannot shorten string length");
        }
        if (this.getDataType() == PrimitiveType.DECIMALV2 && (other.getDataType() == PrimitiveType.VARCHAR || other.getDataType() == PrimitiveType.STRING)) {
            return;
        }
        if (this.getPrecision() != other.getPrecision()) {
            throw new DdlException("Cannot change precision");
        }
        if (this.getScale() != other.getScale()) {
            throw new DdlException("Cannot change scale");
        }
    }

    public boolean nameEquals(String otherColName, boolean ignorePrefix) {
        if (CaseSensibility.COLUMN.getCaseSensibility()) {
            if (!ignorePrefix) {
                return this.name.equals(otherColName);
            }
            return Column.removeNamePrefix(this.name).equals(Column.removeNamePrefix(otherColName));
        }
        if (!ignorePrefix) {
            return this.name.equalsIgnoreCase(otherColName);
        }
        return Column.removeNamePrefix(this.name).equalsIgnoreCase(Column.removeNamePrefix(otherColName));
    }

    public static String removeNamePrefix(String colName) {
        if (colName.startsWith("__doris_shadow_")) {
            return colName.substring("__doris_shadow_".length());
        }
        return colName;
    }

    public static String getShadowName(String colName) {
        if (Column.isShadowColumn(colName)) {
            return colName;
        }
        return "__doris_shadow_" + colName;
    }

    public static boolean isShadowColumn(String colName) {
        return colName.startsWith("__doris_shadow_");
    }

    public Expr getDefineExpr() {
        return this.defineExpr;
    }

    public void setDefineExpr(Expr expr) {
        this.defineExpr = expr;
    }

    public DefaultValueExprDef getDefaultValueExprDef() {
        return this.defaultValueExprDef;
    }

    public SlotRef getRefColumn() {
        ArrayList slots = new ArrayList();
        if (this.defineExpr == null) {
            return null;
        }
        this.defineExpr.collect(SlotRef.class, slots);
        Preconditions.checkArgument((slots.size() == 1 ? 1 : 0) != 0);
        return (SlotRef)slots.get(0);
    }

    public String toSql() {
        return this.toSql(false);
    }

    public String toSql(boolean isUniqueTable) {
        StringBuilder sb = new StringBuilder();
        sb.append("`").append(this.name).append("` ");
        String typeStr = this.type.toSql();
        sb.append(typeStr).append(" ");
        if (this.aggregationType != null && this.aggregationType != AggregateType.NONE && !isUniqueTable && !this.isAggregationTypeImplicit) {
            sb.append(this.aggregationType.name()).append(" ");
        }
        if (this.isAllowNull) {
            sb.append("NULL ");
        } else {
            sb.append("NOT NULL ");
        }
        if (this.defaultValue != null && this.getDataType() != PrimitiveType.HLL && this.getDataType() != PrimitiveType.BITMAP) {
            sb.append("DEFAULT \"").append(this.defaultValue).append("\" ");
        }
        sb.append("COMMENT \"").append(this.getComment(true)).append("\"");
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Column)) {
            return false;
        }
        Column other = (Column)obj;
        if (!this.name.equalsIgnoreCase(other.getName())) {
            return false;
        }
        if (this.getDataType() != other.getDataType()) {
            return false;
        }
        if (this.aggregationType != other.getAggregationType()) {
            return false;
        }
        if (this.isAggregationTypeImplicit != other.isAggregationTypeImplicit()) {
            return false;
        }
        if (this.isKey != other.isKey()) {
            return false;
        }
        if (this.isAllowNull != other.isAllowNull) {
            return false;
        }
        if (this.getDefaultValue() == null ? other.getDefaultValue() != null : !this.getDefaultValue().equals(other.getDefaultValue())) {
            return false;
        }
        if (this.getStrLen() != other.getStrLen()) {
            return false;
        }
        if (this.getPrecision() != other.getPrecision()) {
            return false;
        }
        if (this.getScale() != other.getScale()) {
            return false;
        }
        if (!this.comment.equals(other.getComment())) {
            return false;
        }
        if (!this.visible == other.visible) {
            return false;
        }
        if (this.children.size() != other.children.size()) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.get(i).equals(other.getChildren().get(i))) continue;
            return false;
        }
        return true;
    }

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this);
        Text.writeString((DataOutput)out, (String)json);
    }

    @Deprecated
    private void readFields(DataInput in) throws IOException {
        this.name = Text.readString((DataInput)in);
        this.type = ColumnType.read(in);
        boolean notNull = in.readBoolean();
        if (notNull) {
            this.aggregationType = AggregateType.valueOf(Text.readString((DataInput)in));
            this.isAggregationTypeImplicit = in.readBoolean();
        }
        this.isKey = in.readBoolean();
        this.isAllowNull = in.readBoolean();
        notNull = in.readBoolean();
        if (notNull) {
            this.defaultValue = Text.readString((DataInput)in);
        }
        this.stats = ColumnStats.read(in);
        this.comment = Text.readString((DataInput)in);
    }

    public static Column read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (Column)GsonUtils.GSON.fromJson(json, Column.class);
    }

    public String getSignatureString(Map<PrimitiveType, String> typeStringMap) {
        PrimitiveType dataType = this.getDataType();
        StringBuilder sb = new StringBuilder(this.name);
        switch (dataType) {
            case CHAR: {
                sb.append(String.format(typeStringMap.get((Object)dataType), this.getStrLen()));
                break;
            }
            case VARCHAR: {
                sb.append(String.format(typeStringMap.get((Object)dataType), this.getStrLen()));
                break;
            }
            case DECIMALV2: {
                sb.append(String.format(typeStringMap.get((Object)dataType), this.getPrecision(), this.getScale()));
                break;
            }
            case ARRAY: {
                sb.append(this.type.toString());
            }
            case MAP: {
                sb.append(this.type.toString());
            }
            case STRUCT: {
                sb.append(this.type.toString());
            }
            default: {
                sb.append(typeStringMap.get((Object)dataType));
            }
        }
        sb.append(this.isKey);
        sb.append(this.isAllowNull);
        sb.append((Object)this.aggregationType);
        sb.append(this.defaultValue == null ? "" : this.defaultValue);
        return sb.toString();
    }
}

