/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.ColocateGroupSchema;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.HashDistributionInfo;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.ColocatePersistInfo;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.doris.resource.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ColocateTableIndex
implements Writable {
    private static final Logger LOG = LogManager.getLogger(ColocateTableIndex.class);
    private Map<String, GroupId> groupName2Id = Maps.newHashMap();
    private Multimap<GroupId, Long> group2Tables = ArrayListMultimap.create();
    private Map<Long, GroupId> table2Group = Maps.newHashMap();
    private Map<GroupId, ColocateGroupSchema> group2Schema = Maps.newHashMap();
    private Table<GroupId, Tag, List<List<Long>>> group2BackendsPerBucketSeq = HashBasedTable.create();
    private Set<GroupId> unstableGroups = Sets.newHashSet();
    private Map<GroupId, String> group2ErrMsgs = Maps.newHashMap();
    private transient ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    private void readLock() {
        this.lock.readLock().lock();
    }

    private void readUnlock() {
        this.lock.readLock().unlock();
    }

    private void writeLock() {
        this.lock.writeLock().lock();
    }

    private void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupId addTableToGroup(long dbId, OlapTable tbl, String groupName, GroupId assignedGroupId) {
        this.writeLock();
        try {
            GroupId groupId = null;
            String fullGroupName = dbId + "_" + groupName;
            if (this.groupName2Id.containsKey(fullGroupName)) {
                groupId = this.groupName2Id.get(fullGroupName);
            } else {
                groupId = assignedGroupId != null ? assignedGroupId : new GroupId(dbId, Catalog.getCurrentCatalog().getNextId());
                HashDistributionInfo distributionInfo = (HashDistributionInfo)tbl.getDefaultDistributionInfo();
                ColocateGroupSchema groupSchema = new ColocateGroupSchema(groupId, distributionInfo.getDistributionColumns(), distributionInfo.getBucketNum(), tbl.getDefaultReplicaAllocation());
                this.groupName2Id.put(fullGroupName, groupId);
                this.group2Schema.put(groupId, groupSchema);
                this.group2ErrMsgs.put(groupId, "");
            }
            this.group2Tables.put((Object)groupId, (Object)tbl.getId());
            this.table2Group.put(tbl.getId(), groupId);
            GroupId groupId2 = groupId;
            return groupId2;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBackendsPerBucketSeq(GroupId groupId, Map<Tag, List<List<Long>>> backendsPerBucketSeq) {
        this.writeLock();
        try {
            for (Map.Entry<Tag, List<List<Long>>> entry : backendsPerBucketSeq.entrySet()) {
                this.group2BackendsPerBucketSeq.put((Object)groupId, (Object)entry.getKey(), entry.getValue());
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBackendsPerBucketSeqByTag(GroupId groupId, Tag tag, List<List<Long>> backendsPerBucketSeq) {
        this.writeLock();
        try {
            this.group2BackendsPerBucketSeq.put((Object)groupId, (Object)tag, backendsPerBucketSeq);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markGroupUnstable(GroupId groupId, String reason, boolean needEditLog) {
        this.writeLock();
        try {
            if (!this.group2Tables.containsKey((Object)groupId)) {
                return;
            }
            if (this.unstableGroups.add(groupId)) {
                this.group2ErrMsgs.put(groupId, Strings.nullToEmpty((String)reason));
                if (needEditLog) {
                    ColocatePersistInfo info = ColocatePersistInfo.createForMarkUnstable(groupId);
                    Catalog.getCurrentCatalog().getEditLog().logColocateMarkUnstable(info);
                }
                LOG.info("mark group {} as unstable", (Object)groupId);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markGroupStable(GroupId groupId, boolean needEditLog) {
        this.writeLock();
        try {
            if (!this.group2Tables.containsKey((Object)groupId)) {
                return;
            }
            if (this.unstableGroups.remove(groupId)) {
                this.group2ErrMsgs.put(groupId, "");
                if (needEditLog) {
                    ColocatePersistInfo info = ColocatePersistInfo.createForMarkStable(groupId);
                    Catalog.getCurrentCatalog().getEditLog().logColocateMarkStable(info);
                }
                LOG.info("mark group {} as stable", (Object)groupId);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTable(long tableId) {
        this.writeLock();
        try {
            if (!this.table2Group.containsKey(tableId)) {
                boolean bl = false;
                return bl;
            }
            GroupId groupId = this.table2Group.remove(tableId);
            this.group2Tables.remove((Object)groupId, (Object)tableId);
            if (!this.group2Tables.containsKey((Object)groupId)) {
                this.group2BackendsPerBucketSeq.rowMap().remove(groupId);
                this.group2Schema.remove(groupId);
                this.group2ErrMsgs.remove(groupId);
                this.unstableGroups.remove(groupId);
                String fullGroupName = null;
                for (Map.Entry<String, GroupId> entry : this.groupName2Id.entrySet()) {
                    if (!entry.getValue().equals(groupId)) continue;
                    fullGroupName = entry.getKey();
                    break;
                }
                if (fullGroupName != null) {
                    this.groupName2Id.remove(fullGroupName);
                }
            }
        }
        finally {
            this.writeUnlock();
        }
        return true;
    }

    public boolean isGroupUnstable(GroupId groupId) {
        this.readLock();
        try {
            boolean bl = this.unstableGroups.contains(groupId);
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isColocateTable(long tableId) {
        this.readLock();
        try {
            boolean bl = this.table2Group.containsKey(tableId);
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    public boolean isGroupExist(GroupId groupId) {
        this.readLock();
        try {
            boolean bl = this.group2Schema.containsKey(groupId);
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSameGroup(long table1, long table2) {
        this.readLock();
        try {
            if (this.table2Group.containsKey(table1) && this.table2Group.containsKey(table2)) {
                boolean bl = this.table2Group.get(table1).equals(this.table2Group.get(table2));
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    public Set<GroupId> getUnstableGroupIds() {
        this.readLock();
        try {
            HashSet hashSet = Sets.newHashSet(this.unstableGroups);
            return hashSet;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupId getGroup(long tableId) {
        this.readLock();
        try {
            Preconditions.checkState((boolean)this.table2Group.containsKey(tableId));
            GroupId groupId = this.table2Group.get(tableId);
            return groupId;
        }
        finally {
            this.readUnlock();
        }
    }

    public Set<GroupId> getAllGroupIds() {
        this.readLock();
        try {
            Set set = this.group2Tables.keySet();
            return set;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Long> getBackendsByGroup(GroupId groupId, Tag tag) {
        this.readLock();
        try {
            HashSet allBackends = new HashSet();
            List backendsPerBucketSeq = (List)this.group2BackendsPerBucketSeq.get((Object)groupId, (Object)tag);
            if (backendsPerBucketSeq != null) {
                for (List bes : backendsPerBucketSeq) {
                    allBackends.addAll(bes);
                }
            }
            HashSet hashSet = allBackends;
            return hashSet;
        }
        finally {
            this.readUnlock();
        }
    }

    public List<Long> getAllTableIds(GroupId groupId) {
        this.readLock();
        try {
            if (!this.group2Tables.containsKey((Object)groupId)) {
                ArrayList arrayList = Lists.newArrayList();
                return arrayList;
            }
            ArrayList arrayList = Lists.newArrayList((Iterable)this.group2Tables.get((Object)groupId));
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Tag, List<List<Long>>> getBackendsPerBucketSeq(GroupId groupId) {
        this.readLock();
        try {
            Map backendsPerBucketSeq = this.group2BackendsPerBucketSeq.row((Object)groupId);
            if (backendsPerBucketSeq == null) {
                HashMap hashMap = Maps.newHashMap();
                return hashMap;
            }
            Map map = backendsPerBucketSeq;
            return map;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<Long>> getBackendsPerBucketSeqByTag(GroupId groupId, Tag tag) {
        this.readLock();
        try {
            List backendsPerBucketSeq = (List)this.group2BackendsPerBucketSeq.get((Object)groupId, (Object)tag);
            if (backendsPerBucketSeq == null) {
                ArrayList arrayList = Lists.newArrayList();
                return arrayList;
            }
            List list = backendsPerBucketSeq;
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Long> getBackendIdsExceptForTag(GroupId groupId, Tag tag) {
        HashSet beIds = Sets.newHashSet();
        this.readLock();
        try {
            Map backendsPerBucketSeq = this.group2BackendsPerBucketSeq.row((Object)groupId);
            if (backendsPerBucketSeq == null) {
                HashSet hashSet = beIds;
                return hashSet;
            }
            for (Map.Entry entry : backendsPerBucketSeq.entrySet()) {
                if (((Tag)entry.getKey()).equals(tag)) continue;
                for (List list : (List)entry.getValue()) {
                    beIds.addAll(list);
                }
            }
            HashSet hashSet = beIds;
            return hashSet;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Set<Long>> getBackendsPerBucketSeqSet(GroupId groupId) {
        this.readLock();
        try {
            Map backendsPerBucketSeqMap = this.group2BackendsPerBucketSeq.row((Object)groupId);
            if (backendsPerBucketSeqMap == null) {
                ArrayList arrayList = Lists.newArrayList();
                return arrayList;
            }
            ArrayList list = Lists.newArrayList();
            for (Map.Entry backendsPerBucketSeq : backendsPerBucketSeqMap.entrySet()) {
                for (int i = 0; i < ((List)backendsPerBucketSeq.getValue()).size(); ++i) {
                    if (list.size() == i) {
                        list.add(Sets.newHashSet());
                    }
                    ((Set)list.get(i)).addAll((Collection)((List)backendsPerBucketSeq.getValue()).get(i));
                }
            }
            ArrayList arrayList = list;
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Long> getTabletBackendsByGroup(GroupId groupId, int tabletOrderIdx) {
        this.readLock();
        try {
            Map backendsPerBucketSeqMap = this.group2BackendsPerBucketSeq.row((Object)groupId);
            if (backendsPerBucketSeqMap == null) {
                HashSet hashSet = Sets.newHashSet();
                return hashSet;
            }
            HashSet beIds = Sets.newHashSet();
            for (Map.Entry backendsPerBucketSeq : backendsPerBucketSeqMap.entrySet()) {
                if (tabletOrderIdx >= ((List)backendsPerBucketSeq.getValue()).size()) {
                    HashSet hashSet = Sets.newHashSet();
                    return hashSet;
                }
                beIds.addAll((Collection)((List)backendsPerBucketSeq.getValue()).get(tabletOrderIdx));
            }
            HashSet hashSet = beIds;
            return hashSet;
        }
        finally {
            this.readUnlock();
        }
    }

    public ColocateGroupSchema getGroupSchema(String fullGroupName) {
        this.readLock();
        try {
            if (!this.groupName2Id.containsKey(fullGroupName)) {
                ColocateGroupSchema colocateGroupSchema = null;
                return colocateGroupSchema;
            }
            ColocateGroupSchema colocateGroupSchema = this.group2Schema.get(this.groupName2Id.get(fullGroupName));
            return colocateGroupSchema;
        }
        finally {
            this.readUnlock();
        }
    }

    public ColocateGroupSchema getGroupSchema(GroupId groupId) {
        this.readLock();
        try {
            ColocateGroupSchema colocateGroupSchema = this.group2Schema.get(groupId);
            return colocateGroupSchema;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTableIdByGroup(String fullGroupName) {
        this.readLock();
        try {
            if (this.groupName2Id.containsKey(fullGroupName)) {
                GroupId groupId = this.groupName2Id.get(fullGroupName);
                Optional tblId = this.group2Tables.get((Object)groupId).stream().findFirst();
                long l = tblId.isPresent() ? (Long)tblId.get() : -1L;
                return l;
            }
        }
        finally {
            this.readUnlock();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupId changeGroup(long dbId, OlapTable tbl, String oldGroup, String newGroup, GroupId assignedGroupId) {
        this.writeLock();
        try {
            if (!Strings.isNullOrEmpty((String)oldGroup)) {
                this.removeTable(tbl.getId());
            }
            GroupId groupId = this.addTableToGroup(dbId, tbl, newGroup, assignedGroupId);
            return groupId;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayAddTableToGroup(ColocatePersistInfo info) throws MetaNotFoundException {
        Database db = Catalog.getCurrentCatalog().getDbOrMetaException(info.getGroupId().dbId);
        OlapTable tbl = (OlapTable)db.getTableOrMetaException(info.getTableId(), Table.TableType.OLAP);
        this.writeLock();
        try {
            Map<Tag, List<List<Long>>> map = info.getBackendsPerBucketSeq();
            for (Map.Entry<Tag, List<List<Long>>> entry : map.entrySet()) {
                this.group2BackendsPerBucketSeq.put((Object)info.getGroupId(), (Object)entry.getKey(), entry.getValue());
            }
            this.addTableToGroup(info.getGroupId().dbId, tbl, tbl.getColocateGroup(), info.getGroupId());
        }
        finally {
            this.writeUnlock();
        }
    }

    public void replayAddBackendsPerBucketSeq(ColocatePersistInfo info) {
        this.addBackendsPerBucketSeq(info.getGroupId(), info.getBackendsPerBucketSeq());
    }

    public void replayMarkGroupUnstable(ColocatePersistInfo info) {
        this.markGroupUnstable(info.getGroupId(), "replay mark group unstable", false);
    }

    public void replayMarkGroupStable(ColocatePersistInfo info) {
        this.markGroupStable(info.getGroupId(), false);
    }

    public void replayRemoveTable(ColocatePersistInfo info) {
        this.removeTable(info.getTableId());
    }

    public void clear() {
        this.writeLock();
        try {
            this.group2Tables.clear();
            this.table2Group.clear();
            this.group2BackendsPerBucketSeq.clear();
            this.group2Schema.clear();
            this.unstableGroups.clear();
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> getInfos() {
        ArrayList infos = Lists.newArrayList();
        this.readLock();
        try {
            for (Map.Entry<String, GroupId> entry : this.groupName2Id.entrySet()) {
                ArrayList info = Lists.newArrayList();
                GroupId groupId = entry.getValue();
                info.add(groupId.toString());
                info.add(entry.getKey());
                info.add(Joiner.on((String)", ").join((Iterable)this.group2Tables.get((Object)groupId)));
                ColocateGroupSchema groupSchema = this.group2Schema.get(groupId);
                info.add(String.valueOf(groupSchema.getBucketsNum()));
                info.add(String.valueOf(groupSchema.getReplicaAlloc().toCreateStmt()));
                List cols = groupSchema.getDistributionColTypes().stream().map(e -> e.toSql()).collect(Collectors.toList());
                info.add(Joiner.on((String)", ").join(cols));
                info.add(String.valueOf(!this.unstableGroups.contains(groupId)));
                info.add(Strings.nullToEmpty((String)this.group2ErrMsgs.get(groupId)));
                infos.add(info);
            }
        }
        finally {
            this.readUnlock();
        }
        return infos;
    }

    public void write(DataOutput out) throws IOException {
        int size = this.groupName2Id.size();
        out.writeInt(size);
        for (Map.Entry<String, GroupId> entry : this.groupName2Id.entrySet()) {
            Text.writeString((DataOutput)out, (String)entry.getKey());
            entry.getValue().write(out);
            Collection tableIds = this.group2Tables.get((Object)entry.getValue());
            out.writeInt(tableIds.size());
            for (Long tblId : tableIds) {
                out.writeLong(tblId);
            }
            ColocateGroupSchema groupSchema = this.group2Schema.get(entry.getValue());
            groupSchema.write(out);
            Map backendsPerBucketSeq = this.group2BackendsPerBucketSeq.row((Object)entry.getValue());
            out.writeInt(backendsPerBucketSeq.size());
            for (Map.Entry tag2Bucket2BEs : backendsPerBucketSeq.entrySet()) {
                ((Tag)tag2Bucket2BEs.getKey()).write(out);
                out.writeInt(((List)tag2Bucket2BEs.getValue()).size());
                for (List beIds : (List)tag2Bucket2BEs.getValue()) {
                    out.writeInt(beIds.size());
                    for (Long be : beIds) {
                        out.writeLong(be);
                    }
                }
            }
        }
        size = this.unstableGroups.size();
        out.writeInt(size);
        for (GroupId groupId : this.unstableGroups) {
            groupId.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int i;
        int size = in.readInt();
        for (i = 0; i < size; ++i) {
            int k;
            String fullGrpName = Text.readString((DataInput)in);
            GroupId grpId = GroupId.read(in);
            this.groupName2Id.put(fullGrpName, grpId);
            int tableSize = in.readInt();
            for (int j = 0; j < tableSize; ++j) {
                long tblId = in.readLong();
                this.group2Tables.put((Object)grpId, (Object)tblId);
                this.table2Group.put(tblId, grpId);
            }
            ColocateGroupSchema groupSchema = ColocateGroupSchema.read(in);
            this.group2Schema.put(grpId, groupSchema);
            if (Catalog.getCurrentCatalogJournalVersion() < 105) {
                ArrayList bucketsSeq = Lists.newArrayList();
                int beSize = in.readInt();
                for (int j = 0; j < beSize; ++j) {
                    int seqSize = in.readInt();
                    ArrayList seq = Lists.newArrayList();
                    for (k = 0; k < seqSize; ++k) {
                        long beId = in.readLong();
                        seq.add(beId);
                    }
                    bucketsSeq.add(seq);
                }
                this.group2BackendsPerBucketSeq.put((Object)grpId, (Object)Tag.DEFAULT_BACKEND_TAG, (Object)bucketsSeq);
                continue;
            }
            int tagSize = in.readInt();
            for (int j = 0; j < tagSize; ++j) {
                Tag tag = Tag.read(in);
                int bucketSize = in.readInt();
                ArrayList bucketsSeq = Lists.newArrayList();
                for (k = 0; k < bucketSize; ++k) {
                    ArrayList beIds = Lists.newArrayList();
                    int beSize = in.readInt();
                    for (int l = 0; l < beSize; ++l) {
                        beIds.add(in.readLong());
                    }
                    bucketsSeq.add(beIds);
                }
                this.group2BackendsPerBucketSeq.put((Object)grpId, (Object)tag, (Object)bucketsSeq);
            }
        }
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            this.unstableGroups.add(GroupId.read(in));
        }
    }

    public void setErrMsgForGroup(GroupId groupId, String message) {
        this.group2ErrMsgs.put(groupId, message);
    }

    public Map<Long, GroupId> getTable2Group() {
        return this.table2Group;
    }

    public static class GroupId
    implements Writable {
        @SerializedName(value="dbId")
        public Long dbId;
        @SerializedName(value="grpId")
        public Long grpId;

        private GroupId() {
        }

        public GroupId(long dbId, long grpId) {
            this.dbId = dbId;
            this.grpId = grpId;
        }

        public static GroupId read(DataInput in) throws IOException {
            if (Catalog.getCurrentCatalogJournalVersion() < 105) {
                GroupId groupId = new GroupId();
                groupId.readFields(in);
                return groupId;
            }
            String json = Text.readString((DataInput)in);
            return (GroupId)GsonUtils.GSON.fromJson(json, GroupId.class);
        }

        public void write(DataOutput out) throws IOException {
            Text.writeString((DataOutput)out, (String)GsonUtils.GSON.toJson((Object)this));
        }

        @Deprecated
        private void readFields(DataInput in) throws IOException {
            this.dbId = in.readLong();
            this.grpId = in.readLong();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof GroupId)) {
                return false;
            }
            GroupId other = (GroupId)obj;
            return this.dbId.equals(other.dbId) && this.grpId.equals(other.grpId);
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.dbId.hashCode();
            result = 31 * result + this.grpId.hashCode();
            return result;
        }

        public String toString() {
            return this.dbId + "." + this.grpId;
        }
    }
}

