/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.ColocateTableIndex;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ColumnType;
import org.apache.doris.catalog.DistributionInfo;
import org.apache.doris.catalog.HashDistributionInfo;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.PartitionInfo;
import org.apache.doris.catalog.ReplicaAllocation;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.io.Writable;

public class ColocateGroupSchema
implements Writable {
    private ColocateTableIndex.GroupId groupId;
    private List<Type> distributionColTypes = Lists.newArrayList();
    private int bucketsNum;
    private ReplicaAllocation replicaAlloc;

    private ColocateGroupSchema() {
    }

    public ColocateGroupSchema(ColocateTableIndex.GroupId groupId, List<Column> distributionCols, int bucketsNum, ReplicaAllocation replicaAlloc) {
        this.groupId = groupId;
        this.distributionColTypes = distributionCols.stream().map(c -> c.getType()).collect(Collectors.toList());
        this.bucketsNum = bucketsNum;
        this.replicaAlloc = replicaAlloc;
    }

    public ColocateTableIndex.GroupId getGroupId() {
        return this.groupId;
    }

    public int getBucketsNum() {
        return this.bucketsNum;
    }

    public ReplicaAllocation getReplicaAlloc() {
        return this.replicaAlloc;
    }

    public List<Type> getDistributionColTypes() {
        return this.distributionColTypes;
    }

    public void checkColocateSchema(OlapTable tbl) throws DdlException {
        this.checkDistribution(tbl.getDefaultDistributionInfo());
        this.checkReplicaAllocation(tbl.getPartitionInfo());
    }

    public void checkDistribution(DistributionInfo distributionInfo) throws DdlException {
        if (distributionInfo instanceof HashDistributionInfo) {
            HashDistributionInfo info = (HashDistributionInfo)distributionInfo;
            if (info.getBucketNum() != this.bucketsNum) {
                ErrorReport.reportDdlException(ErrorCode.ERR_COLOCATE_TABLE_MUST_HAS_SAME_BUCKET_NUM, this.bucketsNum);
            }
            if (info.getDistributionColumns().size() != this.distributionColTypes.size()) {
                ErrorReport.reportDdlException(ErrorCode.ERR_COLOCATE_TABLE_MUST_HAS_SAME_DISTRIBUTION_COLUMN_SIZE, this.distributionColTypes.size());
            }
            for (int i = 0; i < this.distributionColTypes.size(); ++i) {
                Type targetColType = this.distributionColTypes.get(i);
                if (targetColType.equals(info.getDistributionColumns().get(i).getType())) continue;
                ErrorReport.reportDdlException(ErrorCode.ERR_COLOCATE_TABLE_MUST_HAS_SAME_DISTRIBUTION_COLUMN_TYPE, info.getDistributionColumns().get(i).getName(), targetColType);
            }
        }
    }

    public void checkReplicaAllocation(PartitionInfo partitionInfo) throws DdlException {
        for (ReplicaAllocation replicaAlloc : partitionInfo.idToReplicaAllocation.values()) {
            if (replicaAlloc.equals(this.replicaAlloc)) continue;
            ErrorReport.reportDdlException(ErrorCode.ERR_COLOCATE_TABLE_MUST_HAS_SAME_REPLICATION_ALLOCATION, this.replicaAlloc);
        }
    }

    public void checkReplicaAllocation(ReplicaAllocation replicaAlloc) throws DdlException {
        if (!replicaAlloc.equals(this.replicaAlloc)) {
            ErrorReport.reportDdlException(ErrorCode.ERR_COLOCATE_TABLE_MUST_HAS_SAME_REPLICATION_ALLOCATION, this.replicaAlloc);
        }
    }

    public static ColocateGroupSchema read(DataInput in) throws IOException {
        ColocateGroupSchema schema = new ColocateGroupSchema();
        schema.readFields(in);
        return schema;
    }

    public void write(DataOutput out) throws IOException {
        this.groupId.write(out);
        out.writeInt(this.distributionColTypes.size());
        for (Type type : this.distributionColTypes) {
            ColumnType.write(out, type);
        }
        out.writeInt(this.bucketsNum);
        this.replicaAlloc.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.groupId = ColocateTableIndex.GroupId.read(in);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.distributionColTypes.add(ColumnType.read(in));
        }
        this.bucketsNum = in.readInt();
        if (Catalog.getCurrentCatalogJournalVersion() < 105) {
            short replicationNum = in.readShort();
            this.replicaAlloc = new ReplicaAllocation(replicationNum);
        } else {
            this.replicaAlloc = ReplicaAllocation.read(in);
        }
    }
}

