/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.DataProperty;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.ListPartitionItem;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.PartitionInfo;
import org.apache.doris.catalog.PartitionItem;
import org.apache.doris.catalog.PartitionKey;
import org.apache.doris.catalog.PartitionType;
import org.apache.doris.catalog.RangePartitionItem;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.ReplicaAllocation;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.catalog.TabletInvertedIndex;
import org.apache.doris.catalog.TabletMeta;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.MasterDaemon;
import org.apache.doris.common.util.RangeUtils;
import org.apache.doris.persist.RecoverInfo;
import org.apache.doris.thrift.TStorageMedium;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CatalogRecycleBin
extends MasterDaemon
implements Writable {
    private static final Logger LOG = LogManager.getLogger(CatalogRecycleBin.class);
    private static final long minEraseLatency = 600000L;
    private Map<Long, RecycleDatabaseInfo> idToDatabase = Maps.newHashMap();
    private Map<Long, RecycleTableInfo> idToTable = Maps.newHashMap();
    private Map<Long, RecyclePartitionInfo> idToPartition = Maps.newHashMap();
    private Map<Long, Long> idToRecycleTime = Maps.newHashMap();

    public CatalogRecycleBin() {
        super("recycle bin");
    }

    public synchronized boolean recycleDatabase(Database db, Set<String> tableNames) {
        if (this.idToDatabase.containsKey(db.getId())) {
            LOG.error("db[{}] already in recycle bin.", (Object)db.getId());
            return false;
        }
        Preconditions.checkState((boolean)db.getTables().isEmpty());
        this.eraseDatabaseWithSameName(db.getFullName());
        RecycleDatabaseInfo databaseInfo = new RecycleDatabaseInfo(db, tableNames);
        this.idToDatabase.put(db.getId(), databaseInfo);
        this.idToRecycleTime.put(db.getId(), System.currentTimeMillis());
        LOG.info("recycle db[{}-{}]", (Object)db.getId(), (Object)db.getFullName());
        return true;
    }

    public synchronized boolean recycleTable(long dbId, Table table, boolean isReplay) {
        if (this.idToTable.containsKey(table.getId())) {
            LOG.error("table[{}] already in recycle bin.", (Object)table.getId());
            return false;
        }
        this.eraseTableWithSameName(dbId, table.getName(), isReplay);
        RecycleTableInfo tableInfo = new RecycleTableInfo(dbId, table);
        this.idToRecycleTime.put(table.getId(), System.currentTimeMillis());
        this.idToTable.put(table.getId(), tableInfo);
        LOG.info("recycle table[{}-{}]", (Object)table.getId(), (Object)table.getName());
        return true;
    }

    public synchronized boolean recyclePartition(long dbId, long tableId, Partition partition, Range<PartitionKey> range, PartitionItem listPartitionItem, DataProperty dataProperty, ReplicaAllocation replicaAlloc, boolean isInMemory) {
        if (this.idToPartition.containsKey(partition.getId())) {
            LOG.error("partition[{}] already in recycle bin.", (Object)partition.getId());
            return false;
        }
        this.erasePartitionWithSameName(dbId, tableId, partition.getName());
        RecyclePartitionInfo partitionInfo = new RecyclePartitionInfo(dbId, tableId, partition, range, listPartitionItem, dataProperty, replicaAlloc, isInMemory);
        this.idToRecycleTime.put(partition.getId(), System.currentTimeMillis());
        this.idToPartition.put(partition.getId(), partitionInfo);
        LOG.info("recycle partition[{}-{}]", (Object)partition.getId(), (Object)partition.getName());
        return true;
    }

    private synchronized boolean isExpire(long id, long currentTimeMs) {
        long latency = currentTimeMs - this.idToRecycleTime.get(id);
        return latency > 600000L && latency > Config.catalog_trash_expire_second * 1000L;
    }

    private synchronized void eraseDatabase(long currentTimeMs) {
        Iterator<Map.Entry<Long, RecycleDatabaseInfo>> dbIter = this.idToDatabase.entrySet().iterator();
        while (dbIter.hasNext()) {
            Map.Entry<Long, RecycleDatabaseInfo> entry = dbIter.next();
            RecycleDatabaseInfo dbInfo = entry.getValue();
            Database db = dbInfo.getDb();
            if (!this.isExpire(db.getId(), currentTimeMs)) continue;
            dbIter.remove();
            this.idToRecycleTime.remove(entry.getKey());
            Catalog.getCurrentCatalog().eraseDatabase(db.getId(), true);
            LOG.info("erase db[{}]", (Object)db.getId());
        }
    }

    private synchronized void eraseDatabaseWithSameName(String dbName) {
        Iterator<Map.Entry<Long, RecycleDatabaseInfo>> iterator = this.idToDatabase.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, RecycleDatabaseInfo> entry = iterator.next();
            RecycleDatabaseInfo dbInfo = entry.getValue();
            Database db = dbInfo.getDb();
            if (!db.getFullName().equals(dbName)) continue;
            iterator.remove();
            this.idToRecycleTime.remove(entry.getKey());
            Catalog.getCurrentCatalog().getGlobalTransactionMgr().removeDatabaseTransactionMgr(db.getId());
            LOG.info("erase database[{}] name: {}", (Object)db.getId(), (Object)dbName);
        }
    }

    public synchronized void replayEraseDatabase(long dbId) {
        this.idToDatabase.remove(dbId);
        this.idToRecycleTime.remove(dbId);
        Catalog.getCurrentCatalog().eraseDatabase(dbId, false);
        LOG.info("replay erase db[{}]", (Object)dbId);
    }

    private synchronized void eraseTable(long currentTimeMs) {
        Iterator<Map.Entry<Long, RecycleTableInfo>> tableIter = this.idToTable.entrySet().iterator();
        while (tableIter.hasNext()) {
            Map.Entry<Long, RecycleTableInfo> entry = tableIter.next();
            RecycleTableInfo tableInfo = entry.getValue();
            Table table = tableInfo.getTable();
            long tableId = table.getId();
            if (!this.isExpire(tableId, currentTimeMs)) continue;
            if (table.getType() == Table.TableType.OLAP) {
                Catalog.getCurrentCatalog().onEraseOlapTable((OlapTable)table, false);
            }
            tableIter.remove();
            this.idToRecycleTime.remove(tableId);
            Catalog.getCurrentCatalog().getEditLog().logEraseTable(tableId);
            LOG.info("erase table[{}]", (Object)tableId);
        }
    }

    private synchronized void eraseTableWithSameName(long dbId, String tableName, boolean isReplay) {
        Iterator<Map.Entry<Long, RecycleTableInfo>> iterator = this.idToTable.entrySet().iterator();
        while (iterator.hasNext()) {
            Table table;
            Map.Entry<Long, RecycleTableInfo> entry = iterator.next();
            RecycleTableInfo tableInfo = entry.getValue();
            if (tableInfo.getDbId() != dbId || !(table = tableInfo.getTable()).getName().equals(tableName)) continue;
            if (table.getType() == Table.TableType.OLAP) {
                Catalog.getCurrentCatalog().onEraseOlapTable((OlapTable)table, isReplay);
            }
            iterator.remove();
            this.idToRecycleTime.remove(table.getId());
            LOG.info("erase table[{}] name: {}", (Object)table.getId(), (Object)tableName);
        }
    }

    public synchronized void replayEraseTable(long tableId) {
        RecycleTableInfo tableInfo = this.idToTable.remove(tableId);
        this.idToRecycleTime.remove(tableId);
        Table table = tableInfo.getTable();
        if (table.getType() == Table.TableType.OLAP && !Catalog.isCheckpointThread()) {
            Catalog.getCurrentCatalog().onEraseOlapTable((OlapTable)table, true);
        }
        LOG.info("replay erase table[{}]", (Object)tableId);
    }

    private synchronized void erasePartition(long currentTimeMs) {
        Iterator<Map.Entry<Long, RecyclePartitionInfo>> iterator = this.idToPartition.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, RecyclePartitionInfo> entry = iterator.next();
            RecyclePartitionInfo partitionInfo = entry.getValue();
            Partition partition = partitionInfo.getPartition();
            long partitionId = entry.getKey();
            if (!this.isExpire(partitionId, currentTimeMs)) continue;
            Catalog.getCurrentCatalog().onErasePartition(partition);
            iterator.remove();
            this.idToRecycleTime.remove(partitionId);
            Catalog.getCurrentCatalog().getEditLog().logErasePartition(partitionId);
            LOG.info("erase partition[{}]", (Object)partitionId);
        }
    }

    private synchronized void erasePartitionWithSameName(long dbId, long tableId, String partitionName) {
        Iterator<Map.Entry<Long, RecyclePartitionInfo>> iterator = this.idToPartition.entrySet().iterator();
        while (iterator.hasNext()) {
            Partition partition;
            Map.Entry<Long, RecyclePartitionInfo> entry = iterator.next();
            RecyclePartitionInfo partitionInfo = entry.getValue();
            if (partitionInfo.getDbId() != dbId || partitionInfo.getTableId() != tableId || !(partition = partitionInfo.getPartition()).getName().equals(partitionName)) continue;
            Catalog.getCurrentCatalog().onErasePartition(partition);
            iterator.remove();
            this.idToRecycleTime.remove(entry.getKey());
            LOG.info("erase partition[{}] name: {}", (Object)partition.getId(), (Object)partitionName);
        }
    }

    public synchronized void replayErasePartition(long partitionId) {
        RecyclePartitionInfo partitionInfo = this.idToPartition.remove(partitionId);
        this.idToRecycleTime.remove(partitionId);
        Partition partition = partitionInfo.getPartition();
        if (!Catalog.isCheckpointThread()) {
            Catalog.getCurrentCatalog().onErasePartition(partition);
        }
        LOG.info("replay erase partition[{}]", (Object)partitionId);
    }

    public synchronized Database recoverDatabase(String dbName) throws DdlException {
        RecycleDatabaseInfo dbInfo = null;
        for (Map.Entry<Long, RecycleDatabaseInfo> entry : this.idToDatabase.entrySet()) {
            if (!dbName.equals(entry.getValue().getDb().getFullName())) continue;
            dbInfo = entry.getValue();
            break;
        }
        if (dbInfo == null) {
            ErrorReport.reportDdlException(ErrorCode.ERR_BAD_DB_ERROR, dbName);
        }
        this.recoverAllTables(dbInfo);
        Database db = dbInfo.getDb();
        this.idToDatabase.remove(db.getId());
        this.idToRecycleTime.remove(db.getId());
        return db;
    }

    public synchronized Database replayRecoverDatabase(long dbId) {
        RecycleDatabaseInfo dbInfo = this.idToDatabase.get(dbId);
        try {
            this.recoverAllTables(dbInfo);
        }
        catch (DdlException e) {
            LOG.error("failed replay recover database: {}", (Object)dbId, (Object)e);
        }
        this.idToDatabase.remove(dbId);
        this.idToRecycleTime.remove(dbId);
        return dbInfo.getDb();
    }

    private void recoverAllTables(RecycleDatabaseInfo dbInfo) throws DdlException {
        Database db = dbInfo.getDb();
        HashSet tableNames = Sets.newHashSet(dbInfo.getTableNames());
        long dbId = db.getId();
        Iterator<Map.Entry<Long, RecycleTableInfo>> iterator = this.idToTable.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, RecycleTableInfo> entry = iterator.next();
            RecycleTableInfo tableInfo = entry.getValue();
            if (tableInfo.getDbId() != dbId || !tableNames.contains(tableInfo.getTable().getName())) continue;
            Table table = tableInfo.getTable();
            db.createTable(table);
            LOG.info("recover db[{}] with table[{}]: {}", (Object)dbId, (Object)table.getId(), (Object)table.getName());
            iterator.remove();
            this.idToRecycleTime.remove(table.getId());
            tableNames.remove(table.getName());
        }
        if (!tableNames.isEmpty()) {
            throw new DdlException("Tables[" + tableNames + "] is missing. Can not recover db");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean recoverTable(Database db, String tableName) {
        long dbId = db.getId();
        Iterator<Map.Entry<Long, RecycleTableInfo>> iterator = this.idToTable.entrySet().iterator();
        while (iterator.hasNext()) {
            Table table;
            Map.Entry<Long, RecycleTableInfo> entry = iterator.next();
            RecycleTableInfo tableInfo = entry.getValue();
            if (tableInfo.getDbId() != dbId || !(table = tableInfo.getTable()).getName().equals(tableName)) continue;
            table.writeLock();
            try {
                db.createTable(table);
                iterator.remove();
                this.idToRecycleTime.remove(table.getId());
                RecoverInfo recoverInfo = new RecoverInfo(dbId, table.getId(), -1L);
                Catalog.getCurrentCatalog().getEditLog().logRecoverTable(recoverInfo);
            }
            finally {
                table.writeUnlock();
            }
            LOG.info("recover db[{}] with table[{}]: {}", (Object)dbId, (Object)table.getId(), (Object)table.getName());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void replayRecoverTable(Database db, long tableId) {
        Iterator<Map.Entry<Long, RecycleTableInfo>> iterator = this.idToTable.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, RecycleTableInfo> entry = iterator.next();
            RecycleTableInfo tableInfo = entry.getValue();
            if (tableInfo.getTable().getId() != tableId) continue;
            Preconditions.checkState((tableInfo.getDbId() == db.getId() ? 1 : 0) != 0);
            Table table = tableInfo.getTable();
            table.writeLock();
            try {
                db.createTable(tableInfo.getTable());
                iterator.remove();
                this.idToRecycleTime.remove(tableInfo.getTable().getId());
                LOG.info("replay recover table[{}]", (Object)tableId);
                break;
            }
            finally {
                table.writeUnlock();
            }
        }
    }

    public synchronized void recoverPartition(long dbId, OlapTable table, String partitionName) throws DdlException {
        RecyclePartitionInfo recoverPartitionInfo = null;
        for (Map.Entry<Long, RecyclePartitionInfo> entry : this.idToPartition.entrySet()) {
            RecyclePartitionInfo partitionInfo = entry.getValue();
            if (partitionInfo.getTableId() != table.getId() || !partitionInfo.getPartition().getName().equalsIgnoreCase(partitionName)) continue;
            recoverPartitionInfo = partitionInfo;
            break;
        }
        if (recoverPartitionInfo == null) {
            throw new DdlException("No partition named " + partitionName + " in table " + table.getName());
        }
        PartitionInfo partitionInfo = table.getPartitionInfo();
        Range<PartitionKey> recoverRange = recoverPartitionInfo.getRange();
        PartitionItem recoverItem = null;
        if (partitionInfo.getType() == PartitionType.RANGE) {
            recoverItem = new RangePartitionItem(recoverRange);
        } else if (partitionInfo.getType() == PartitionType.LIST) {
            recoverItem = recoverPartitionInfo.getListPartitionItem();
        }
        if (partitionInfo.getAnyIntersectItem(recoverItem, false) != null) {
            throw new DdlException("Can not recover partition[" + partitionName + "]. Partition item conflict.");
        }
        Partition recoverPartition = recoverPartitionInfo.getPartition();
        Preconditions.checkState((boolean)recoverPartition.getName().equalsIgnoreCase(partitionName));
        table.addPartition(recoverPartition);
        long partitionId = recoverPartition.getId();
        partitionInfo.setItem(partitionId, false, recoverItem);
        partitionInfo.setDataProperty(partitionId, recoverPartitionInfo.getDataProperty());
        partitionInfo.setReplicaAllocation(partitionId, recoverPartitionInfo.getReplicaAlloc());
        partitionInfo.setIsInMemory(partitionId, recoverPartitionInfo.isInMemory());
        this.idToPartition.remove(partitionId);
        this.idToRecycleTime.remove(partitionId);
        RecoverInfo recoverInfo = new RecoverInfo(dbId, table.getId(), partitionId);
        Catalog.getCurrentCatalog().getEditLog().logRecoverPartition(recoverInfo);
        LOG.info("recover partition[{}]", (Object)partitionId);
    }

    public synchronized void replayRecoverPartition(OlapTable table, long partitionId) {
        Iterator<Map.Entry<Long, RecyclePartitionInfo>> iterator = this.idToPartition.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, RecyclePartitionInfo> entry = iterator.next();
            RecyclePartitionInfo recyclePartitionInfo = entry.getValue();
            if (recyclePartitionInfo.getPartition().getId() != partitionId) continue;
            Preconditions.checkState((recyclePartitionInfo.getTableId() == table.getId() ? 1 : 0) != 0);
            table.addPartition(recyclePartitionInfo.getPartition());
            PartitionInfo partitionInfo = table.getPartitionInfo();
            PartitionItem recoverItem = null;
            if (partitionInfo.getType() == PartitionType.RANGE) {
                recoverItem = new RangePartitionItem(recyclePartitionInfo.getRange());
            } else if (partitionInfo.getType() == PartitionType.LIST) {
                recoverItem = recyclePartitionInfo.getListPartitionItem();
            }
            partitionInfo.setItem(partitionId, false, recoverItem);
            partitionInfo.setDataProperty(partitionId, recyclePartitionInfo.getDataProperty());
            partitionInfo.setReplicaAllocation(partitionId, recyclePartitionInfo.getReplicaAlloc());
            partitionInfo.setIsInMemory(partitionId, recyclePartitionInfo.isInMemory());
            iterator.remove();
            this.idToRecycleTime.remove(partitionId);
            LOG.info("replay recover partition[{}]", (Object)partitionId);
            break;
        }
    }

    public void addTabletToInvertedIndex() {
        TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
        for (RecycleTableInfo tableInfo : this.idToTable.values()) {
            Table table = tableInfo.getTable();
            if (table.getType() != Table.TableType.OLAP) continue;
            long dbId = tableInfo.getDbId();
            OlapTable olapTable = (OlapTable)table;
            long tableId = olapTable.getId();
            for (Partition partition : olapTable.getAllPartitions()) {
                long partitionId = partition.getId();
                TStorageMedium medium = olapTable.getPartitionInfo().getDataProperty(partitionId).getStorageMedium();
                for (MaterializedIndex index : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL)) {
                    long indexId = index.getId();
                    int schemaHash = olapTable.getSchemaHashByIndexId(indexId);
                    TabletMeta tabletMeta = new TabletMeta(dbId, tableId, partitionId, indexId, schemaHash, medium);
                    for (Tablet tablet : index.getTablets()) {
                        long tabletId = tablet.getId();
                        invertedIndex.addTablet(tabletId, tabletMeta);
                        for (Replica replica : tablet.getReplicas()) {
                            invertedIndex.addReplica(tabletId, replica);
                        }
                    }
                }
            }
        }
        for (RecyclePartitionInfo partitionInfo : this.idToPartition.values()) {
            long dbId = partitionInfo.getDbId();
            long tableId = partitionInfo.getTableId();
            Partition partition = partitionInfo.getPartition();
            long partitionId = partition.getId();
            OlapTable olapTable = null;
            Database db = Catalog.getCurrentCatalog().getDbNullable(dbId);
            if (db == null) {
                if (!this.idToDatabase.containsKey(dbId)) {
                    LOG.error("db[{}] is neither in catalog nor in recycle bin when rebuilding inverted index from recycle bin, partition[{}]", (Object)dbId, (Object)partitionId);
                    continue;
                }
            } else {
                olapTable = (OlapTable)db.getTableNullable(tableId);
            }
            if (olapTable == null) {
                if (!this.idToTable.containsKey(tableId)) {
                    LOG.error("table[{}] is neither in catalog nor in recycle bin when rebuilding inverted index from recycle bin, partition[{}]", (Object)tableId, (Object)partitionId);
                    continue;
                }
                RecycleTableInfo tableInfo = this.idToTable.get(tableId);
                olapTable = (OlapTable)tableInfo.getTable();
            }
            Preconditions.checkNotNull((Object)olapTable);
            TStorageMedium medium = partitionInfo.getDataProperty().getStorageMedium();
            for (MaterializedIndex index : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL)) {
                long indexId = index.getId();
                int schemaHash = olapTable.getSchemaHashByIndexId(indexId);
                TabletMeta tabletMeta = new TabletMeta(dbId, tableId, partitionId, indexId, schemaHash, medium);
                for (Tablet tablet : index.getTablets()) {
                    long tabletId = tablet.getId();
                    invertedIndex.addTablet(tabletId, tabletMeta);
                    for (Replica replica : tablet.getReplicas()) {
                        invertedIndex.addReplica(tabletId, replica);
                    }
                }
            }
        }
    }

    @Override
    protected void runAfterCatalogReady() {
        long currentTimeMs = System.currentTimeMillis();
        this.erasePartition(currentTimeMs);
        this.eraseTable(currentTimeMs);
        this.eraseDatabase(currentTimeMs);
    }

    public void write(DataOutput out) throws IOException {
        int count = this.idToDatabase.size();
        out.writeInt(count);
        for (Map.Entry<Long, RecycleDatabaseInfo> entry : this.idToDatabase.entrySet()) {
            out.writeLong(entry.getKey());
            entry.getValue().write(out);
        }
        count = this.idToTable.size();
        out.writeInt(count);
        for (Map.Entry<Long, Object> entry : this.idToTable.entrySet()) {
            out.writeLong(entry.getKey());
            ((RecycleTableInfo)entry.getValue()).write(out);
        }
        count = this.idToPartition.size();
        out.writeInt(count);
        for (Map.Entry<Long, Object> entry : this.idToPartition.entrySet()) {
            out.writeLong(entry.getKey());
            ((RecyclePartitionInfo)entry.getValue()).write(out);
        }
        count = this.idToRecycleTime.size();
        out.writeInt(count);
        for (Map.Entry<Long, Object> entry : this.idToRecycleTime.entrySet()) {
            out.writeLong(entry.getKey());
            out.writeLong((Long)entry.getValue());
        }
    }

    public void readFields(DataInput in) throws IOException {
        long id;
        int i;
        int count = in.readInt();
        for (i = 0; i < count; ++i) {
            id = in.readLong();
            RecycleDatabaseInfo dbInfo = new RecycleDatabaseInfo();
            dbInfo.readFields(in);
            this.idToDatabase.put(id, dbInfo);
        }
        count = in.readInt();
        for (i = 0; i < count; ++i) {
            id = in.readLong();
            RecycleTableInfo tableInfo = new RecycleTableInfo();
            tableInfo.readFields(in);
            this.idToTable.put(id, tableInfo);
        }
        count = in.readInt();
        for (i = 0; i < count; ++i) {
            id = in.readLong();
            RecyclePartitionInfo partitionInfo = new RecyclePartitionInfo();
            partitionInfo.readFields(in);
            this.idToPartition.put(id, partitionInfo);
        }
        count = in.readInt();
        for (i = 0; i < count; ++i) {
            id = in.readLong();
            long time = in.readLong();
            this.idToRecycleTime.put(id, time);
        }
    }

    public List<Long> getAllDbIds() {
        return Lists.newArrayList(this.idToDatabase.keySet());
    }

    public class RecyclePartitionInfo
    implements Writable {
        private long dbId;
        private long tableId;
        private Partition partition;
        private Range<PartitionKey> range;
        private PartitionItem listPartitionItem;
        private DataProperty dataProperty;
        private ReplicaAllocation replicaAlloc;
        private boolean isInMemory;

        public RecyclePartitionInfo() {
        }

        public RecyclePartitionInfo(long dbId, long tableId, Partition partition, Range<PartitionKey> range, PartitionItem listPartitionItem, DataProperty dataProperty, ReplicaAllocation replicaAlloc, boolean isInMemory) {
            this.dbId = dbId;
            this.tableId = tableId;
            this.partition = partition;
            this.range = range;
            this.listPartitionItem = listPartitionItem;
            this.dataProperty = dataProperty;
            this.replicaAlloc = replicaAlloc;
            this.isInMemory = isInMemory;
        }

        public long getDbId() {
            return this.dbId;
        }

        public long getTableId() {
            return this.tableId;
        }

        public Partition getPartition() {
            return this.partition;
        }

        public Range<PartitionKey> getRange() {
            return this.range;
        }

        public PartitionItem getListPartitionItem() {
            return this.listPartitionItem;
        }

        public DataProperty getDataProperty() {
            return this.dataProperty;
        }

        public ReplicaAllocation getReplicaAlloc() {
            return this.replicaAlloc;
        }

        public boolean isInMemory() {
            return this.isInMemory;
        }

        public void write(DataOutput out) throws IOException {
            out.writeLong(this.dbId);
            out.writeLong(this.tableId);
            this.partition.write(out);
            RangeUtils.writeRange(out, this.range);
            this.listPartitionItem.write(out);
            this.dataProperty.write(out);
            this.replicaAlloc.write(out);
            out.writeBoolean(this.isInMemory);
        }

        public void readFields(DataInput in) throws IOException {
            this.dbId = in.readLong();
            this.tableId = in.readLong();
            this.partition = Partition.read(in);
            this.range = RangeUtils.readRange(in);
            this.listPartitionItem = ListPartitionItem.read(in);
            this.dataProperty = DataProperty.read(in);
            if (Catalog.getCurrentCatalogJournalVersion() < 105) {
                short replicationNum = in.readShort();
                this.replicaAlloc = new ReplicaAllocation(replicationNum);
            } else {
                this.replicaAlloc = ReplicaAllocation.read(in);
            }
            this.isInMemory = in.readBoolean();
        }
    }

    public class RecycleTableInfo
    implements Writable {
        private long dbId;
        private Table table;

        public RecycleTableInfo() {
        }

        public RecycleTableInfo(long dbId, Table table) {
            this.dbId = dbId;
            this.table = table;
        }

        public long getDbId() {
            return this.dbId;
        }

        public Table getTable() {
            return this.table;
        }

        public void write(DataOutput out) throws IOException {
            out.writeLong(this.dbId);
            this.table.write(out);
        }

        public void readFields(DataInput in) throws IOException {
            this.dbId = in.readLong();
            this.table = Table.read(in);
        }
    }

    public class RecycleDatabaseInfo
    implements Writable {
        private Database db;
        private Set<String> tableNames;

        public RecycleDatabaseInfo() {
            this.tableNames = Sets.newHashSet();
        }

        public RecycleDatabaseInfo(Database db, Set<String> tableNames) {
            this.db = db;
            this.tableNames = tableNames;
        }

        public Database getDb() {
            return this.db;
        }

        public Set<String> getTableNames() {
            return this.tableNames;
        }

        public void write(DataOutput out) throws IOException {
            this.db.write(out);
            int count = this.tableNames.size();
            out.writeInt(count);
            for (String tableName : this.tableNames) {
                Text.writeString((DataOutput)out, (String)tableName);
            }
        }

        public void readFields(DataInput in) throws IOException {
            this.db = Database.read(in);
            int count = in.readInt();
            for (int i = 0; i < count; ++i) {
                String tableName = Text.readString((DataInput)in);
                this.tableNames.add(tableName);
            }
        }
    }
}

