/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import org.apache.doris.persist.EditLog;

public class CatalogIdGenerator {
    private static final int BATCH_ID_INTERVAL = 1000;
    private long nextId;
    private long batchEndId;
    private EditLog editLog;

    public CatalogIdGenerator(long initValue) {
        this.nextId = initValue + 1L;
        this.batchEndId = initValue;
    }

    public void setEditLog(EditLog editLog) {
        this.editLog = editLog;
    }

    public synchronized long getNextId() {
        if (this.nextId < this.batchEndId) {
            return this.nextId++;
        }
        this.batchEndId += 1000L;
        if (this.editLog != null) {
            this.editLog.logSaveNextId(this.batchEndId);
        }
        return this.nextId++;
    }

    public synchronized void setId(long id) {
        if (id > this.batchEndId) {
            this.batchEndId = id;
            this.nextId = id;
        }
    }

    public long getBatchEndId() {
        return this.batchEndId;
    }
}

