/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Queues;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.sleepycat.je.rep.InsufficientLogException;
import com.sleepycat.je.rep.NetworkRestore;
import com.sleepycat.je.rep.NetworkRestoreConfig;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.doris.alter.Alter;
import org.apache.doris.alter.AlterJobV2;
import org.apache.doris.alter.DecommissionType;
import org.apache.doris.alter.MaterializedViewHandler;
import org.apache.doris.alter.SchemaChangeHandler;
import org.apache.doris.alter.SystemHandler;
import org.apache.doris.analysis.AddPartitionClause;
import org.apache.doris.analysis.AddRollupClause;
import org.apache.doris.analysis.AdminCheckTabletsStmt;
import org.apache.doris.analysis.AdminCleanTrashStmt;
import org.apache.doris.analysis.AdminCompactTableStmt;
import org.apache.doris.analysis.AdminSetConfigStmt;
import org.apache.doris.analysis.AdminSetReplicaStatusStmt;
import org.apache.doris.analysis.AlterClause;
import org.apache.doris.analysis.AlterClusterStmt;
import org.apache.doris.analysis.AlterDatabaseQuotaStmt;
import org.apache.doris.analysis.AlterDatabaseRename;
import org.apache.doris.analysis.AlterSystemStmt;
import org.apache.doris.analysis.AlterTableStmt;
import org.apache.doris.analysis.AlterViewStmt;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BackupStmt;
import org.apache.doris.analysis.CancelAlterSystemStmt;
import org.apache.doris.analysis.CancelAlterTableStmt;
import org.apache.doris.analysis.CancelBackupStmt;
import org.apache.doris.analysis.ColumnDef;
import org.apache.doris.analysis.ColumnRenameClause;
import org.apache.doris.analysis.CreateClusterStmt;
import org.apache.doris.analysis.CreateDbStmt;
import org.apache.doris.analysis.CreateFunctionStmt;
import org.apache.doris.analysis.CreateMaterializedViewStmt;
import org.apache.doris.analysis.CreateTableAsSelectStmt;
import org.apache.doris.analysis.CreateTableLikeStmt;
import org.apache.doris.analysis.CreateTableStmt;
import org.apache.doris.analysis.CreateUserStmt;
import org.apache.doris.analysis.CreateViewStmt;
import org.apache.doris.analysis.DataSortInfo;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.DecommissionBackendClause;
import org.apache.doris.analysis.DistributionDesc;
import org.apache.doris.analysis.DropClusterStmt;
import org.apache.doris.analysis.DropDbStmt;
import org.apache.doris.analysis.DropFunctionStmt;
import org.apache.doris.analysis.DropMaterializedViewStmt;
import org.apache.doris.analysis.DropPartitionClause;
import org.apache.doris.analysis.DropTableStmt;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FunctionName;
import org.apache.doris.analysis.HashDistributionDesc;
import org.apache.doris.analysis.InstallPluginStmt;
import org.apache.doris.analysis.KeysDesc;
import org.apache.doris.analysis.LinkDbStmt;
import org.apache.doris.analysis.MigrateDbStmt;
import org.apache.doris.analysis.ModifyDistributionClause;
import org.apache.doris.analysis.PartitionDesc;
import org.apache.doris.analysis.PartitionRenameClause;
import org.apache.doris.analysis.QueryStmt;
import org.apache.doris.analysis.RecoverDbStmt;
import org.apache.doris.analysis.RecoverPartitionStmt;
import org.apache.doris.analysis.RecoverTableStmt;
import org.apache.doris.analysis.ReplacePartitionClause;
import org.apache.doris.analysis.RestoreStmt;
import org.apache.doris.analysis.RollupRenameClause;
import org.apache.doris.analysis.ShowAlterStmt;
import org.apache.doris.analysis.SinglePartitionDesc;
import org.apache.doris.analysis.TableName;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.analysis.TableRenameClause;
import org.apache.doris.analysis.TruncateTableStmt;
import org.apache.doris.analysis.TypeDef;
import org.apache.doris.analysis.UninstallPluginStmt;
import org.apache.doris.analysis.UserDesc;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.backup.BackupHandler;
import org.apache.doris.blockrule.SqlBlockRuleMgr;
import org.apache.doris.catalog.AggregateType;
import org.apache.doris.catalog.BrokerMgr;
import org.apache.doris.catalog.BrokerTable;
import org.apache.doris.catalog.CatalogIdGenerator;
import org.apache.doris.catalog.CatalogRecycleBin;
import org.apache.doris.catalog.ColocateGroupSchema;
import org.apache.doris.catalog.ColocateTableIndex;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.DataProperty;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.DatabaseProperty;
import org.apache.doris.catalog.DistributionInfo;
import org.apache.doris.catalog.DomainResolver;
import org.apache.doris.catalog.EsTable;
import org.apache.doris.catalog.FsBroker;
import org.apache.doris.catalog.Function;
import org.apache.doris.catalog.FunctionSearchDesc;
import org.apache.doris.catalog.FunctionSet;
import org.apache.doris.catalog.HashDistributionInfo;
import org.apache.doris.catalog.HiveMetaStoreClientHelper;
import org.apache.doris.catalog.HiveTable;
import org.apache.doris.catalog.IcebergTable;
import org.apache.doris.catalog.Index;
import org.apache.doris.catalog.InfoSchemaDb;
import org.apache.doris.catalog.KeysType;
import org.apache.doris.catalog.ListPartitionItem;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.MaterializedIndexMeta;
import org.apache.doris.catalog.MetaReplayState;
import org.apache.doris.catalog.MysqlTable;
import org.apache.doris.catalog.OdbcTable;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.PartitionInfo;
import org.apache.doris.catalog.PartitionItem;
import org.apache.doris.catalog.PartitionKey;
import org.apache.doris.catalog.PartitionType;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.RangePartitionInfo;
import org.apache.doris.catalog.RangePartitionItem;
import org.apache.doris.catalog.RefreshManager;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.ReplicaAllocation;
import org.apache.doris.catalog.ResourceMgr;
import org.apache.doris.catalog.SinglePartitionInfo;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.TableIndexes;
import org.apache.doris.catalog.TableProperty;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.catalog.TabletInvertedIndex;
import org.apache.doris.catalog.TabletMeta;
import org.apache.doris.catalog.TabletStatMgr;
import org.apache.doris.catalog.Type;
import org.apache.doris.catalog.View;
import org.apache.doris.clone.ColocateTableCheckerAndBalancer;
import org.apache.doris.clone.DynamicPartitionScheduler;
import org.apache.doris.clone.TabletChecker;
import org.apache.doris.clone.TabletScheduler;
import org.apache.doris.clone.TabletSchedulerStat;
import org.apache.doris.cluster.BaseParam;
import org.apache.doris.cluster.Cluster;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ClientPool;
import org.apache.doris.common.Config;
import org.apache.doris.common.ConfigBase;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.FeNameFormat;
import org.apache.doris.common.MarkedCountDownLatch;
import org.apache.doris.common.MetaHeader;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.MetaReader;
import org.apache.doris.common.MetaWriter;
import org.apache.doris.common.Pair;
import org.apache.doris.common.ThreadPoolManager;
import org.apache.doris.common.UserException;
import org.apache.doris.common.io.CountingDataOutputStream;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.util.Daemon;
import org.apache.doris.common.util.DynamicPartitionUtil;
import org.apache.doris.common.util.MasterDaemon;
import org.apache.doris.common.util.MetaLockUtils;
import org.apache.doris.common.util.PrintableMap;
import org.apache.doris.common.util.PropertyAnalyzer;
import org.apache.doris.common.util.QueryableReentrantLock;
import org.apache.doris.common.util.SmallFileMgr;
import org.apache.doris.common.util.SqlParserUtils;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.common.util.Util;
import org.apache.doris.consistency.ConsistencyChecker;
import org.apache.doris.deploy.DeployManager;
import org.apache.doris.deploy.impl.AmbariDeployManager;
import org.apache.doris.deploy.impl.K8sDeployManager;
import org.apache.doris.deploy.impl.LocalFileDeployManager;
import org.apache.doris.external.elasticsearch.EsRepository;
import org.apache.doris.external.iceberg.IcebergCatalogMgr;
import org.apache.doris.external.iceberg.IcebergTableCreationRecordMgr;
import org.apache.doris.ha.BDBHA;
import org.apache.doris.ha.FrontendNodeType;
import org.apache.doris.ha.HAProtocol;
import org.apache.doris.ha.MasterInfo;
import org.apache.doris.journal.JournalCursor;
import org.apache.doris.journal.JournalEntity;
import org.apache.doris.journal.bdbje.Timestamp;
import org.apache.doris.load.DeleteHandler;
import org.apache.doris.load.EtlJobType;
import org.apache.doris.load.ExportChecker;
import org.apache.doris.load.ExportJob;
import org.apache.doris.load.ExportMgr;
import org.apache.doris.load.Load;
import org.apache.doris.load.LoadChecker;
import org.apache.doris.load.LoadErrorHub;
import org.apache.doris.load.LoadJob;
import org.apache.doris.load.StreamLoadRecordMgr;
import org.apache.doris.load.loadv2.LoadEtlChecker;
import org.apache.doris.load.loadv2.LoadJobScheduler;
import org.apache.doris.load.loadv2.LoadLoadingChecker;
import org.apache.doris.load.loadv2.LoadManager;
import org.apache.doris.load.routineload.RoutineLoadManager;
import org.apache.doris.load.routineload.RoutineLoadScheduler;
import org.apache.doris.load.routineload.RoutineLoadTaskScheduler;
import org.apache.doris.load.sync.SyncChecker;
import org.apache.doris.load.sync.SyncJobManager;
import org.apache.doris.load.update.UpdateManager;
import org.apache.doris.master.Checkpoint;
import org.apache.doris.master.MetaHelper;
import org.apache.doris.master.PartitionInMemoryInfoCollector;
import org.apache.doris.meta.MetaContext;
import org.apache.doris.metric.MetricRepo;
import org.apache.doris.mysql.privilege.PaloAuth;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.persist.BackendIdsUpdateInfo;
import org.apache.doris.persist.BackendReplicasInfo;
import org.apache.doris.persist.BackendTabletsInfo;
import org.apache.doris.persist.ClusterInfo;
import org.apache.doris.persist.ColocatePersistInfo;
import org.apache.doris.persist.DatabaseInfo;
import org.apache.doris.persist.DropDbInfo;
import org.apache.doris.persist.DropInfo;
import org.apache.doris.persist.DropLinkDbAndUpdateDbInfo;
import org.apache.doris.persist.DropPartitionInfo;
import org.apache.doris.persist.EditLog;
import org.apache.doris.persist.GlobalVarPersistInfo;
import org.apache.doris.persist.ModifyPartitionInfo;
import org.apache.doris.persist.ModifyTableDefaultDistributionBucketNumOperationLog;
import org.apache.doris.persist.ModifyTablePropertyOperationLog;
import org.apache.doris.persist.PartitionPersistInfo;
import org.apache.doris.persist.RecoverInfo;
import org.apache.doris.persist.RefreshExternalTableInfo;
import org.apache.doris.persist.ReplacePartitionOperationLog;
import org.apache.doris.persist.ReplicaPersistInfo;
import org.apache.doris.persist.SetReplicaStatusOperationLog;
import org.apache.doris.persist.Storage;
import org.apache.doris.persist.StorageInfo;
import org.apache.doris.persist.StorageInfoV2;
import org.apache.doris.persist.TableInfo;
import org.apache.doris.persist.TablePropertyInfo;
import org.apache.doris.persist.TruncateTableInfo;
import org.apache.doris.plugin.PluginInfo;
import org.apache.doris.plugin.PluginMgr;
import org.apache.doris.qe.AuditEventProcessor;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.GlobalVariable;
import org.apache.doris.qe.JournalObservable;
import org.apache.doris.qe.VariableMgr;
import org.apache.doris.resource.Tag;
import org.apache.doris.service.FrontendOptions;
import org.apache.doris.statistics.StatisticsJobManager;
import org.apache.doris.statistics.StatisticsJobScheduler;
import org.apache.doris.statistics.StatisticsManager;
import org.apache.doris.statistics.StatisticsTaskScheduler;
import org.apache.doris.system.Backend;
import org.apache.doris.system.Frontend;
import org.apache.doris.system.HeartbeatMgr;
import org.apache.doris.system.SystemInfoService;
import org.apache.doris.task.AgentBatchTask;
import org.apache.doris.task.AgentTaskExecutor;
import org.apache.doris.task.AgentTaskQueue;
import org.apache.doris.task.CompactionTask;
import org.apache.doris.task.CreateReplicaTask;
import org.apache.doris.task.DropReplicaTask;
import org.apache.doris.task.MasterTaskExecutor;
import org.apache.doris.thrift.BackendService;
import org.apache.doris.thrift.TCompressionType;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TStorageFormat;
import org.apache.doris.thrift.TStorageMedium;
import org.apache.doris.thrift.TStorageType;
import org.apache.doris.thrift.TTabletType;
import org.apache.doris.thrift.TTaskType;
import org.apache.doris.transaction.DbUsedDataQuotaInfoCollector;
import org.apache.doris.transaction.GlobalTransactionMgr;
import org.apache.doris.transaction.PublishVersionDaemon;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public class Catalog {
    private static final Logger LOG = LogManager.getLogger(Catalog.class);
    public static final long NEXT_ID_INIT_VALUE = 10000L;
    private static final int HTTP_TIMEOUT_SECOND = 5;
    private static final int STATE_CHANGE_CHECK_INTERVAL_MS = 100;
    private static final int REPLAY_INTERVAL_MS = 1;
    private static final String BDB_DIR = "/bdb";
    private static final String IMAGE_DIR = "/image";
    private String metaDir;
    private String bdbDir;
    private String imageDir;
    private MetaContext metaContext;
    private long epoch = 0L;
    private QueryableReentrantLock lock;
    private ConcurrentHashMap<Long, Database> idToDb;
    private ConcurrentHashMap<String, Database> fullNameToDb;
    private ConcurrentHashMap<Long, Cluster> idToCluster;
    private ConcurrentHashMap<String, Cluster> nameToCluster;
    private Load load;
    private LoadManager loadManager;
    private StreamLoadRecordMgr streamLoadRecordMgr;
    private IcebergTableCreationRecordMgr icebergTableCreationRecordMgr;
    private RoutineLoadManager routineLoadManager;
    private SqlBlockRuleMgr sqlBlockRuleMgr;
    private ExportMgr exportMgr;
    private SyncJobManager syncJobManager;
    private Alter alter;
    private ConsistencyChecker consistencyChecker;
    private BackupHandler backupHandler;
    private PublishVersionDaemon publishVersionDaemon;
    private UpdateManager updateManager;
    private DeleteHandler deleteHandler;
    private DbUsedDataQuotaInfoCollector dbUsedDataQuotaInfoCollector;
    private PartitionInMemoryInfoCollector partitionInMemoryInfoCollector;
    private MasterDaemon labelCleaner;
    private MasterDaemon txnCleaner;
    private Daemon replayer;
    private Daemon timePrinter;
    private Daemon listener;
    private EsRepository esRepository;
    private boolean isFirstTimeStartUp = false;
    private boolean isElectable = false;
    private AtomicBoolean isReady = new AtomicBoolean(false);
    private AtomicBoolean canRead = new AtomicBoolean(false);
    private BlockingQueue<FrontendNodeType> typeTransferQueue;
    private boolean isDefaultClusterCreated = false;
    private String nodeName;
    private FrontendNodeType role;
    private FrontendNodeType feType;
    private long synchronizedTimeMs = 0L;
    private int masterRpcPort = 0;
    private int masterHttpPort = 0;
    private String masterIp = "";
    private CatalogIdGenerator idGenerator = new CatalogIdGenerator(10000L);
    private EditLog editLog;
    private int clusterId;
    private String token;
    private AtomicLong replayedJournalId;
    private static Catalog CHECKPOINT = null;
    private static long checkpointThreadId = -1L;
    private Checkpoint checkpointer;
    private List<Pair<String, Integer>> helperNodes = Lists.newArrayList();
    private Pair<String, Integer> selfNode = null;
    private ConcurrentHashMap<String, Frontend> frontends;
    private ConcurrentLinkedQueue<String> removedFrontends;
    private HAProtocol haProtocol = null;
    private JournalObservable journalObservable;
    private SystemInfoService systemInfo;
    private HeartbeatMgr heartbeatMgr;
    private TabletInvertedIndex tabletInvertedIndex;
    private ColocateTableIndex colocateTableIndex;
    private CatalogRecycleBin recycleBin;
    private FunctionSet functionSet;
    private MetaReplayState metaReplayState;
    private BrokerMgr brokerMgr;
    private ResourceMgr resourceMgr;
    private GlobalTransactionMgr globalTransactionMgr;
    private DeployManager deployManager;
    private TabletStatMgr tabletStatMgr;
    private StatisticsManager statisticsManager;
    private StatisticsJobManager statisticsJobManager;
    private StatisticsJobScheduler statisticsJobScheduler;
    private StatisticsTaskScheduler statisticsTaskScheduler;
    private PaloAuth auth;
    private DomainResolver domainResolver;
    private TabletSchedulerStat stat;
    private TabletScheduler tabletScheduler;
    private TabletChecker tabletChecker;
    private MasterTaskExecutor pendingLoadTaskScheduler;
    private MasterTaskExecutor loadingLoadTaskScheduler;
    private LoadJobScheduler loadJobScheduler;
    private LoadEtlChecker loadEtlChecker;
    private LoadLoadingChecker loadLoadingChecker;
    private RoutineLoadScheduler routineLoadScheduler;
    private RoutineLoadTaskScheduler routineLoadTaskScheduler;
    private SyncChecker syncChecker;
    private SmallFileMgr smallFileMgr;
    private DynamicPartitionScheduler dynamicPartitionScheduler;
    private PluginMgr pluginMgr;
    private AuditEventProcessor auditEventProcessor;
    private RefreshManager refreshManager;

    public List<Frontend> getFrontends(FrontendNodeType nodeType) {
        if (nodeType == null) {
            return Lists.newArrayList(this.frontends.values());
        }
        ArrayList result = Lists.newArrayList();
        for (Frontend frontend : this.frontends.values()) {
            if (frontend.getRole() != nodeType) continue;
            result.add(frontend);
        }
        return result;
    }

    public List<String> getRemovedFrontendNames() {
        return Lists.newArrayList(this.removedFrontends);
    }

    public JournalObservable getJournalObservable() {
        return this.journalObservable;
    }

    private SystemInfoService getClusterInfo() {
        return this.systemInfo;
    }

    private HeartbeatMgr getHeartbeatMgr() {
        return this.heartbeatMgr;
    }

    public TabletInvertedIndex getTabletInvertedIndex() {
        return this.tabletInvertedIndex;
    }

    public void setColocateTableIndex(ColocateTableIndex colocateTableIndex) {
        this.colocateTableIndex = colocateTableIndex;
    }

    public ColocateTableIndex getColocateTableIndex() {
        return this.colocateTableIndex;
    }

    private CatalogRecycleBin getRecycleBin() {
        return this.recycleBin;
    }

    public MetaReplayState getMetaReplayState() {
        return this.metaReplayState;
    }

    public DynamicPartitionScheduler getDynamicPartitionScheduler() {
        return this.dynamicPartitionScheduler;
    }

    private Catalog() {
        this(false);
    }

    private Catalog(boolean isCheckpointCatalog) {
        this.idToDb = new ConcurrentHashMap();
        this.fullNameToDb = new ConcurrentHashMap();
        this.load = new Load();
        this.routineLoadManager = new RoutineLoadManager();
        this.sqlBlockRuleMgr = new SqlBlockRuleMgr();
        this.exportMgr = new ExportMgr();
        this.syncJobManager = new SyncJobManager();
        this.alter = new Alter();
        this.consistencyChecker = new ConsistencyChecker();
        this.lock = new QueryableReentrantLock(true);
        this.backupHandler = new BackupHandler(this);
        this.metaDir = Config.meta_dir;
        this.publishVersionDaemon = new PublishVersionDaemon();
        this.updateManager = new UpdateManager();
        this.deleteHandler = new DeleteHandler();
        this.dbUsedDataQuotaInfoCollector = new DbUsedDataQuotaInfoCollector();
        this.partitionInMemoryInfoCollector = new PartitionInMemoryInfoCollector();
        this.replayedJournalId = new AtomicLong(0L);
        this.feType = FrontendNodeType.INIT;
        this.typeTransferQueue = Queues.newLinkedBlockingDeque();
        this.role = FrontendNodeType.UNKNOWN;
        this.frontends = new ConcurrentHashMap();
        this.removedFrontends = new ConcurrentLinkedQueue();
        this.journalObservable = new JournalObservable();
        this.systemInfo = new SystemInfoService();
        this.heartbeatMgr = new HeartbeatMgr(this.systemInfo, !isCheckpointCatalog);
        this.tabletInvertedIndex = new TabletInvertedIndex();
        this.colocateTableIndex = new ColocateTableIndex();
        this.recycleBin = new CatalogRecycleBin();
        this.functionSet = new FunctionSet();
        this.functionSet.init();
        this.metaReplayState = new MetaReplayState();
        this.idToCluster = new ConcurrentHashMap();
        this.nameToCluster = new ConcurrentHashMap();
        this.isDefaultClusterCreated = false;
        this.brokerMgr = new BrokerMgr();
        this.resourceMgr = new ResourceMgr();
        this.globalTransactionMgr = new GlobalTransactionMgr(this);
        this.tabletStatMgr = new TabletStatMgr();
        this.statisticsManager = new StatisticsManager();
        this.statisticsJobManager = new StatisticsJobManager();
        this.statisticsJobScheduler = new StatisticsJobScheduler();
        this.statisticsTaskScheduler = new StatisticsTaskScheduler();
        this.auth = new PaloAuth();
        this.domainResolver = new DomainResolver(this.auth);
        this.esRepository = new EsRepository();
        this.metaContext = new MetaContext();
        this.metaContext.setThreadLocalInfo();
        this.stat = new TabletSchedulerStat();
        this.tabletScheduler = new TabletScheduler(this, this.systemInfo, this.tabletInvertedIndex, this.stat, Config.tablet_rebalancer_type);
        this.tabletChecker = new TabletChecker(this, this.systemInfo, this.tabletScheduler, this.stat);
        this.pendingLoadTaskScheduler = new MasterTaskExecutor("pending_load_task_scheduler", Config.async_pending_load_task_pool_size, Config.desired_max_waiting_jobs, !isCheckpointCatalog);
        this.loadingLoadTaskScheduler = new MasterTaskExecutor("loading_load_task_scheduler", Config.async_loading_load_task_pool_size, Integer.MAX_VALUE, !isCheckpointCatalog);
        this.loadJobScheduler = new LoadJobScheduler();
        this.loadManager = new LoadManager(this.loadJobScheduler);
        this.streamLoadRecordMgr = new StreamLoadRecordMgr("stream_load_record_manager", Config.fetch_stream_load_record_interval_second * 1000);
        this.icebergTableCreationRecordMgr = new IcebergTableCreationRecordMgr();
        this.loadEtlChecker = new LoadEtlChecker(this.loadManager);
        this.loadLoadingChecker = new LoadLoadingChecker(this.loadManager);
        this.routineLoadScheduler = new RoutineLoadScheduler(this.routineLoadManager);
        this.routineLoadTaskScheduler = new RoutineLoadTaskScheduler(this.routineLoadManager);
        this.syncChecker = new SyncChecker(this.syncJobManager);
        this.smallFileMgr = new SmallFileMgr();
        this.dynamicPartitionScheduler = new DynamicPartitionScheduler("DynamicPartitionScheduler", Config.dynamic_partition_check_interval_seconds * 1000L);
        this.metaDir = Config.meta_dir;
        this.bdbDir = this.metaDir + BDB_DIR;
        this.imageDir = this.metaDir + IMAGE_DIR;
        this.pluginMgr = new PluginMgr();
        this.auditEventProcessor = new AuditEventProcessor(this.pluginMgr);
        this.refreshManager = new RefreshManager();
    }

    public static void destroyCheckpoint() {
        if (CHECKPOINT != null) {
            CHECKPOINT = null;
        }
    }

    public static Catalog getCurrentCatalog() {
        if (Catalog.isCheckpointThread()) {
            if (CHECKPOINT == null) {
                CHECKPOINT = new Catalog(true);
            }
            return CHECKPOINT;
        }
        return SingletonHolder.INSTANCE;
    }

    public static Catalog getServingCatalog() {
        return SingletonHolder.INSTANCE;
    }

    public BrokerMgr getBrokerMgr() {
        return this.brokerMgr;
    }

    public ResourceMgr getResourceMgr() {
        return this.resourceMgr;
    }

    public static GlobalTransactionMgr getCurrentGlobalTransactionMgr() {
        return Catalog.getCurrentCatalog().globalTransactionMgr;
    }

    public GlobalTransactionMgr getGlobalTransactionMgr() {
        return this.globalTransactionMgr;
    }

    public PluginMgr getPluginMgr() {
        return this.pluginMgr;
    }

    public PaloAuth getAuth() {
        return this.auth;
    }

    public TabletScheduler getTabletScheduler() {
        return this.tabletScheduler;
    }

    public TabletChecker getTabletChecker() {
        return this.tabletChecker;
    }

    public ConcurrentHashMap<String, Database> getFullNameToDb() {
        return this.fullNameToDb;
    }

    public AuditEventProcessor getAuditEventProcessor() {
        return this.auditEventProcessor;
    }

    public static SystemInfoService getCurrentSystemInfo() {
        return Catalog.getCurrentCatalog().getClusterInfo();
    }

    public static HeartbeatMgr getCurrentHeartbeatMgr() {
        return Catalog.getCurrentCatalog().getHeartbeatMgr();
    }

    public static TabletInvertedIndex getCurrentInvertedIndex() {
        return Catalog.getCurrentCatalog().getTabletInvertedIndex();
    }

    public static ColocateTableIndex getCurrentColocateIndex() {
        return Catalog.getCurrentCatalog().getColocateTableIndex();
    }

    public static CatalogRecycleBin getCurrentRecycleBin() {
        return Catalog.getCurrentCatalog().getRecycleBin();
    }

    public static int getCurrentCatalogJournalVersion() {
        return MetaContext.get().getMetaVersion();
    }

    public static final boolean isCheckpointThread() {
        return Thread.currentThread().getId() == checkpointThreadId;
    }

    public static PluginMgr getCurrentPluginMgr() {
        return Catalog.getCurrentCatalog().getPluginMgr();
    }

    public static AuditEventProcessor getCurrentAuditEventProcessor() {
        return Catalog.getCurrentCatalog().getAuditEventProcessor();
    }

    public Checkpoint getCheckpointer() {
        return this.checkpointer;
    }

    public StatisticsManager getStatisticsManager() {
        return this.statisticsManager;
    }

    public StatisticsJobManager getStatisticsJobManager() {
        return this.statisticsJobManager;
    }

    public StatisticsJobScheduler getStatisticsJobScheduler() {
        return this.statisticsJobScheduler;
    }

    public StatisticsTaskScheduler getStatisticsTaskScheduler() {
        return this.statisticsTaskScheduler;
    }

    private boolean tryLock(boolean mustLock) {
        while (true) {
            try {
                while (!this.lock.tryLock(Config.catalog_try_lock_timeout_ms, TimeUnit.MILLISECONDS)) {
                    Thread owner;
                    if (LOG.isDebugEnabled() && (owner = this.lock.getOwner()) != null) {
                        LOG.debug("catalog lock is held by: {}", (Object)Util.dumpThread(owner, 10));
                    }
                    if (mustLock) continue;
                    return false;
                }
                return true;
            }
            catch (InterruptedException e) {
                LOG.warn("got exception while getting catalog lock", (Throwable)e);
                if (mustLock) continue;
                return this.lock.isHeldByCurrentThread();
            }
            break;
        }
    }

    private void unlock() {
        if (this.lock.isHeldByCurrentThread()) {
            this.lock.unlock();
        }
    }

    public String getBdbDir() {
        return this.bdbDir;
    }

    public String getImageDir() {
        return this.imageDir;
    }

    public void initialize(String[] args) throws Exception {
        this.metaDir = Config.meta_dir;
        this.bdbDir = this.metaDir + BDB_DIR;
        this.imageDir = this.metaDir + IMAGE_DIR;
        this.getSelfHostPort();
        this.getHelperNodes(args);
        File meta = new File(this.metaDir);
        if (!meta.exists()) {
            LOG.warn("Doris' meta dir {} does not exist. You need to create it before starting FE", (Object)meta.getAbsolutePath());
            throw new Exception(meta.getAbsolutePath() + " does not exist, will exit");
        }
        if (Config.edit_log_type.equalsIgnoreCase("bdb")) {
            File imageDir;
            File bdbDir = new File(this.bdbDir);
            if (!bdbDir.exists()) {
                bdbDir.mkdirs();
            }
            if (!(imageDir = new File(this.imageDir)).exists()) {
                imageDir.mkdirs();
            }
        } else {
            throw new Exception("Invalid edit log type: " + Config.edit_log_type);
        }
        this.pluginMgr.init();
        this.auditEventProcessor.start();
        this.getClusterIdAndRole();
        this.editLog = new EditLog(this.nodeName);
        this.loadImage(this.imageDir);
        this.editLog.open();
        this.globalTransactionMgr.setEditLog(this.editLog);
        this.idGenerator.setEditLog(this.editLog);
        this.createLabelCleaner();
        this.createTxnCleaner();
        this.createStateListener();
        this.listener.start();
    }

    public void waitForReady() throws InterruptedException {
        while (true) {
            if (this.isReady()) break;
            Thread.sleep(2000L);
            LOG.info("wait catalog to be ready. FE type: {}. is ready: {}", (Object)this.feType, (Object)this.isReady.get());
        }
        LOG.info("catalog is ready. FE type: {}", (Object)this.feType);
    }

    public boolean isReady() {
        return this.isReady.get();
    }

    private void getClusterIdAndRole() throws IOException {
        File roleFile = new File(this.imageDir, "ROLE");
        File versionFile = new File(this.imageDir, "VERSION");
        if (this.isMyself() || roleFile.exists() && versionFile.exists()) {
            if (!this.isMyself()) {
                LOG.info("find ROLE and VERSION file in local, ignore helper nodes: {}", this.helperNodes);
            }
            if (roleFile.exists() && !versionFile.exists() || !roleFile.exists() && versionFile.exists()) {
                throw new IOException("role file and version file must both exist or both not exist. please specific one helper node to recover. will exit.");
            }
            Storage storage = new Storage(this.imageDir);
            if (!roleFile.exists()) {
                this.role = FrontendNodeType.FOLLOWER;
                this.nodeName = Catalog.genFeNodeName((String)this.selfNode.first, (Integer)this.selfNode.second, false);
                storage.writeFrontendRoleAndNodeName(this.role, this.nodeName);
                LOG.info("very first time to start this node. role: {}, node name: {}", (Object)this.role.name(), (Object)this.nodeName);
            } else {
                this.role = storage.getRole();
                if (this.role == FrontendNodeType.REPLICA) {
                    this.role = FrontendNodeType.FOLLOWER;
                }
                this.nodeName = storage.getNodeName();
                if (Strings.isNullOrEmpty((String)this.nodeName)) {
                    this.nodeName = Catalog.genFeNodeName((String)this.selfNode.first, (Integer)this.selfNode.second, true);
                    storage.writeFrontendRoleAndNodeName(this.role, this.nodeName);
                    LOG.info("forward compatibility. role: {}, node name: {}", (Object)this.role.name(), (Object)this.nodeName);
                } else {
                    String[] split = this.nodeName.split("_");
                    if (Config.metadata_failure_recovery.equals("false") && !((String)this.selfNode.first).equalsIgnoreCase(split[0])) {
                        throw new IOException("the self host " + (String)this.selfNode.first + " does not equal to the host in ROLE file " + split[0] + ". You need to set 'priority_networks' config in fe.conf to match the host " + split[0]);
                    }
                }
            }
            Preconditions.checkNotNull((Object)((Object)this.role));
            Preconditions.checkNotNull((Object)this.nodeName);
            if (!versionFile.exists()) {
                this.clusterId = Config.cluster_id == -1 ? Storage.newClusterID() : Config.cluster_id;
                this.token = Strings.isNullOrEmpty((String)Config.auth_token) ? Storage.newToken() : Config.auth_token;
                storage = new Storage(this.clusterId, this.token, this.imageDir);
                storage.writeClusterIdAndToken();
                this.isFirstTimeStartUp = true;
                Frontend self = new Frontend(this.role, this.nodeName, (String)this.selfNode.first, (Integer)this.selfNode.second);
                this.frontends.put(this.nodeName, self);
            } else {
                this.clusterId = storage.getClusterID();
                if (storage.getToken() == null) {
                    this.token = Strings.isNullOrEmpty((String)Config.auth_token) ? Storage.newToken() : Config.auth_token;
                    LOG.info("new token={}", (Object)this.token);
                    storage.setToken(this.token);
                    storage.writeClusterIdAndToken();
                } else {
                    this.token = storage.getToken();
                }
                this.isFirstTimeStartUp = false;
            }
        } else {
            while (!this.getFeNodeTypeAndNameFromHelpers()) {
                LOG.warn("current node is not added to the group. please add it first. sleep 5 seconds and retry, current helper nodes: {}", this.helperNodes);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    System.exit(-1);
                    break;
                }
            }
            if (this.role == FrontendNodeType.REPLICA) {
                this.role = FrontendNodeType.FOLLOWER;
            }
            Preconditions.checkState((this.helperNodes.size() == 1 ? 1 : 0) != 0);
            Preconditions.checkNotNull((Object)((Object)this.role));
            Preconditions.checkNotNull((Object)this.nodeName);
            Pair<String, Integer> rightHelperNode = this.helperNodes.get(0);
            Storage storage = new Storage(this.imageDir);
            if (roleFile.exists() && (this.role != storage.getRole() || !this.nodeName.equals(storage.getNodeName())) || !roleFile.exists()) {
                storage.writeFrontendRoleAndNodeName(this.role, this.nodeName);
            }
            if (!versionFile.exists()) {
                if (!this.getVersionFileFromHelper(rightHelperNode)) {
                    throw new IOException("fail to download version file from " + (String)rightHelperNode.first + " will exit.");
                }
                storage = new Storage(this.imageDir);
                this.clusterId = storage.getClusterID();
                this.token = storage.getToken();
                if (Strings.isNullOrEmpty((String)this.token)) {
                    this.token = Config.auth_token;
                }
            } else {
                this.clusterId = storage.getClusterID();
                this.token = storage.getToken();
                try {
                    URL idURL = new URL("http://" + (String)rightHelperNode.first + ":" + Config.http_port + "/check");
                    HttpURLConnection conn = null;
                    conn = (HttpURLConnection)idURL.openConnection();
                    conn.setConnectTimeout(2000);
                    conn.setReadTimeout(2000);
                    String clusterIdString = conn.getHeaderField("cluster_id");
                    int remoteClusterId = Integer.parseInt(clusterIdString);
                    if (remoteClusterId != this.clusterId) {
                        LOG.error("cluster id is not equal with helper node {}. will exit.", rightHelperNode.first);
                        System.exit(-1);
                    }
                    String remoteToken = conn.getHeaderField("token");
                    if (this.token == null && remoteToken != null) {
                        LOG.info("get token from helper node. token={}.", (Object)remoteToken);
                        this.token = remoteToken;
                        storage.writeClusterIdAndToken();
                        storage.reload();
                    }
                    if (Config.enable_token_check) {
                        Preconditions.checkNotNull((Object)this.token);
                        Preconditions.checkNotNull((Object)remoteToken);
                        if (!this.token.equals(remoteToken)) {
                            throw new IOException("token is not equal with helper node " + (String)rightHelperNode.first + ". will exit.");
                        }
                    }
                }
                catch (Exception e) {
                    throw new IOException("fail to check cluster_id and token with helper node.", e);
                }
            }
            this.getNewImage(rightHelperNode);
        }
        if (Config.cluster_id != -1 && this.clusterId != Config.cluster_id) {
            throw new IOException("cluster id is not equal with config item cluster_id. will exit.");
        }
        this.isElectable = this.role.equals((Object)FrontendNodeType.FOLLOWER);
        Preconditions.checkState((this.helperNodes.size() == 1 ? 1 : 0) != 0);
        LOG.info("finished to get cluster id: {}, role: {} and node name: {}", (Object)this.clusterId, (Object)this.role.name(), (Object)this.nodeName);
    }

    public static String genFeNodeName(String host, int port, boolean isOldStyle) {
        String name = host + "_" + port;
        if (isOldStyle) {
            return name;
        }
        return name + "_" + System.currentTimeMillis();
    }

    private boolean getFeNodeTypeAndNameFromHelpers() {
        Pair<String, Integer> rightHelperNode = null;
        for (Pair<String, Integer> helperNode : this.helperNodes) {
            block7: {
                try {
                    URL url = new URL("http://" + (String)helperNode.first + ":" + Config.http_port + "/role?host=" + (String)this.selfNode.first + "&port=" + this.selfNode.second);
                    HttpURLConnection conn = null;
                    conn = (HttpURLConnection)url.openConnection();
                    if (conn.getResponseCode() != 200) {
                        LOG.warn("failed to get fe node type from helper node: {}. response code: {}", helperNode, (Object)conn.getResponseCode());
                        continue;
                    }
                    String type = conn.getHeaderField("role");
                    if (type == null) {
                        LOG.warn("failed to get fe node type from helper node: {}.", helperNode);
                        continue;
                    }
                    this.role = FrontendNodeType.valueOf(type);
                    this.nodeName = conn.getHeaderField("name");
                    if (this.role == FrontendNodeType.UNKNOWN) {
                        LOG.warn("frontend {} is not added to cluster yet. role UNKNOWN", this.selfNode);
                        return false;
                    }
                    if (!Strings.isNullOrEmpty((String)this.nodeName)) break block7;
                    this.nodeName = Catalog.genFeNodeName((String)this.selfNode.first, (Integer)this.selfNode.second, true);
                }
                catch (Exception e) {
                    LOG.warn("failed to get fe node type from helper node: {}.", helperNode, (Object)e);
                    continue;
                }
            }
            LOG.info("get fe node type {}, name {} from {}:{}", (Object)this.role, (Object)this.nodeName, helperNode.first, (Object)Config.http_port);
            rightHelperNode = helperNode;
            break;
        }
        if (rightHelperNode == null) {
            return false;
        }
        this.helperNodes.clear();
        this.helperNodes.add(rightHelperNode);
        return true;
    }

    private void getSelfHostPort() {
        this.selfNode = new Pair<String, Integer>(FrontendOptions.getLocalHostAddress(), Config.edit_log_port);
        LOG.debug("get self node: {}", this.selfNode);
    }

    private void getHelperNodes(String[] args) throws Exception {
        String helpers = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase("-helper")) continue;
            if (i + 1 >= args.length) {
                throw new AnalysisException("-helper need parameter host:port,host:port");
            }
            helpers = args[i + 1];
            break;
        }
        if (!Config.enable_deploy_manager.equalsIgnoreCase("disable")) {
            if (Config.enable_deploy_manager.equalsIgnoreCase("k8s")) {
                this.deployManager = new K8sDeployManager(this, 5000L);
            } else if (Config.enable_deploy_manager.equalsIgnoreCase("ambari")) {
                this.deployManager = new AmbariDeployManager(this, 5000L);
            } else if (Config.enable_deploy_manager.equalsIgnoreCase("local")) {
                this.deployManager = new LocalFileDeployManager(this, 5000L);
            } else {
                throw new AnalysisException("Unknow deploy manager: " + Config.enable_deploy_manager);
            }
            this.getHelperNodeFromDeployManager();
        } else if (helpers != null) {
            String[] splittedHelpers;
            for (String helper : splittedHelpers = helpers.split(",")) {
                Pair<String, Integer> helperHostPort = SystemInfoService.validateHostAndPort(helper);
                if (helperHostPort.equals(this.selfNode)) {
                    throw new AnalysisException("Do not specify the helper node to FE itself. Please specify it to the existing running Master or Follower FE");
                }
                this.helperNodes.add(helperHostPort);
            }
        } else {
            this.helperNodes.add(Pair.create((String)this.selfNode.first, Config.edit_log_port));
        }
        LOG.info("get helper nodes: {}", this.helperNodes);
    }

    private void getHelperNodeFromDeployManager() throws Exception {
        Preconditions.checkNotNull((Object)this.deployManager);
        File roleFile = new File(this.imageDir, "ROLE");
        File versionFile = new File(this.imageDir, "VERSION");
        if (roleFile.exists() && !versionFile.exists() || !roleFile.exists() && versionFile.exists()) {
            throw new Exception("role file and version file must both exist or both not exist. please specific one helper node to recover. will exit.");
        }
        if (roleFile.exists()) {
            LOG.info("role file exist. this is not the first time to start up");
            this.helperNodes = Lists.newArrayList((Object[])new Pair[]{Pair.create((String)this.selfNode.first, Config.edit_log_port)});
            return;
        }
        this.helperNodes = this.deployManager.getHelperNodes();
        if (this.helperNodes == null || this.helperNodes.isEmpty()) {
            throw new Exception("failed to get helper node from deploy manager. exit");
        }
    }

    private void transferToMaster() {
        if (this.replayer != null) {
            this.replayer.exit();
            try {
                this.replayer.join();
            }
            catch (InterruptedException e) {
                LOG.warn("got exception when stopping the replayer thread", (Throwable)e);
            }
            this.replayer = null;
        }
        this.isReady.set(false);
        this.canRead.set(false);
        this.editLog.open();
        if (!this.haProtocol.fencing()) {
            LOG.error("fencing failed. will exit.");
            System.exit(-1);
        }
        long replayStartTime = System.currentTimeMillis();
        this.replayJournal(-1L);
        long replayEndTime = System.currentTimeMillis();
        LOG.info("finish replay in " + (replayEndTime - replayStartTime) + " msec");
        this.checkCurrentNodeExist();
        this.editLog.rollEditLog();
        long journalVersion = MetaContext.get().getMetaVersion();
        if (journalVersion < (long)FeConstants.meta_version) {
            this.editLog.logMetaVersion(FeConstants.meta_version);
            MetaContext.get().setMetaVersion(FeConstants.meta_version);
        }
        if (this.isFirstTimeStartUp) {
            Frontend self = this.frontends.get(this.nodeName);
            Preconditions.checkNotNull((Object)self);
            this.editLog.logAddFirstFrontend(self);
            this.initLowerCaseTableNames();
        }
        if (!this.isDefaultClusterCreated) {
            this.initDefaultCluster();
        }
        this.masterIp = FrontendOptions.getLocalHostAddress();
        this.masterRpcPort = Config.rpc_port;
        this.masterHttpPort = Config.http_port;
        MasterInfo info = new MasterInfo(this.masterIp, this.masterHttpPort, this.masterRpcPort);
        this.editLog.logMasterInfo(info);
        this.fixBugAfterMetadataReplayed(false);
        this.startMasterOnlyDaemonThreads();
        this.startNonMasterDaemonThreads();
        MetricRepo.init();
        this.canRead.set(true);
        this.isReady.set(true);
        this.checkLowerCaseTableNames();
        String msg = "master finished to replay journal, can write now.";
        Util.stdoutWithTime(msg);
        LOG.info(msg);
        ThreadPoolManager.registerAllThreadPoolMetric();
    }

    public void fixBugAfterMetadataReplayed(boolean waitCatalogReady) {
        if (waitCatalogReady) {
            while (!this.isReady()) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void startMasterOnlyDaemonThreads() {
        this.checkpointer = new Checkpoint(this.editLog);
        this.checkpointer.setMetaContext(this.metaContext);
        checkpointThreadId = this.checkpointer.getId();
        this.checkpointer.start();
        LOG.info("checkpointer thread started. thread id is {}", (Object)checkpointThreadId);
        this.heartbeatMgr.setMaster(this.clusterId, this.token, this.epoch);
        this.heartbeatMgr.start();
        LoadChecker.init((long)Config.load_checker_interval_second * 1000L);
        LoadChecker.startAll();
        this.pendingLoadTaskScheduler.start();
        this.loadingLoadTaskScheduler.start();
        this.loadManager.prepareJobs();
        this.loadJobScheduler.start();
        this.loadEtlChecker.start();
        this.loadLoadingChecker.start();
        ExportChecker.init((long)Config.export_checker_interval_second * 1000L);
        ExportChecker.startAll();
        this.tabletChecker.start();
        this.tabletScheduler.start();
        ColocateTableCheckerAndBalancer.getInstance().start();
        this.publishVersionDaemon.start();
        this.txnCleaner.start();
        this.getAlterInstance().start();
        this.getConsistencyChecker().start();
        this.getBackupHandler().start();
        this.getRecycleBin().start();
        this.createTimePrinter();
        this.timePrinter.start();
        if (!Config.enable_deploy_manager.equalsIgnoreCase("disable")) {
            LOG.info("deploy manager {} start", (Object)this.deployManager.getName());
            this.deployManager.start();
        }
        this.routineLoadScheduler.start();
        this.routineLoadTaskScheduler.start();
        this.syncChecker.start();
        this.dynamicPartitionScheduler.start();
        this.dbUsedDataQuotaInfoCollector.start();
        this.partitionInMemoryInfoCollector.start();
        this.streamLoadRecordMgr.start();
        this.icebergTableCreationRecordMgr.start();
    }

    private void startNonMasterDaemonThreads() {
        this.tabletStatMgr.start();
        this.labelCleaner.start();
        this.esRepository.start();
        this.domainResolver.start();
    }

    private void transferToNonMaster(FrontendNodeType newType) {
        this.isReady.set(false);
        if (this.feType == FrontendNodeType.OBSERVER || this.feType == FrontendNodeType.FOLLOWER) {
            Preconditions.checkState((newType == FrontendNodeType.UNKNOWN ? 1 : 0) != 0);
            LOG.warn("{} to UNKNOWN, still offer read service", (Object)this.feType.name());
            this.metaReplayState.setTransferToUnknown();
            return;
        }
        if (Config.edit_log_type.equalsIgnoreCase("BDB")) {
            for (Frontend fe : this.frontends.values()) {
                if (fe.getRole() != FrontendNodeType.FOLLOWER && fe.getRole() != FrontendNodeType.REPLICA) continue;
                ((BDBHA)this.getHaProtocol()).addHelperSocket(fe.getHost(), fe.getEditLogPort());
            }
        }
        if (this.replayer == null) {
            this.createReplayer();
            this.replayer.start();
        }
        this.fixBugAfterMetadataReplayed(true);
        this.checkLowerCaseTableNames();
        this.startNonMasterDaemonThreads();
        MetricRepo.init();
    }

    private void initLowerCaseTableNames() {
        if (Config.lower_case_table_names > 2 || Config.lower_case_table_names < 0) {
            LOG.error("Unsupported configuration value of lower_case_table_names: " + Config.lower_case_table_names);
            System.exit(-1);
        }
        try {
            VariableMgr.setLowerCaseTableNames(Config.lower_case_table_names);
        }
        catch (Exception e) {
            LOG.error("Initialization of lower_case_table_names failed.", (Throwable)e);
            System.exit(-1);
        }
        LOG.info("Finish initializing lower_case_table_names, value is {}", (Object)GlobalVariable.lowerCaseTableNames);
    }

    private void checkLowerCaseTableNames() {
        while (!this.isReady()) {
            try {
                LOG.info("Waiting for 'lower_case_table_names' initialization.");
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e) {
                LOG.error("Sleep got exception while waiting for lower_case_table_names initialization. ", (Throwable)e);
            }
        }
        if (Config.lower_case_table_names != GlobalVariable.lowerCaseTableNames) {
            LOG.error("The configuration of 'lower_case_table_names' does not support modification, the expected value is {}, but the actual value is {}", (Object)GlobalVariable.lowerCaseTableNames, (Object)Config.lower_case_table_names);
            System.exit(-1);
        }
        LOG.info("lower_case_table_names is {}", (Object)GlobalVariable.lowerCaseTableNames);
    }

    private void checkCurrentNodeExist() {
        if (Config.metadata_failure_recovery.equals("true")) {
            return;
        }
        Frontend fe = this.checkFeExist((String)this.selfNode.first, (Integer)this.selfNode.second);
        if (fe == null) {
            LOG.error("current node {}:{} is not added to the cluster, will exit. Your FE IP maybe changed, please set 'priority_networks' config in fe.conf properly.", this.selfNode.first, this.selfNode.second);
            System.exit(-1);
        } else if (fe.getRole() != this.role) {
            LOG.error("current node role is {} not match with frontend recorded role {}. will exit", (Object)this.role, (Object)fe.getRole());
            System.exit(-1);
        }
    }

    private boolean getVersionFileFromHelper(Pair<String, Integer> helperNode) throws IOException {
        try {
            String url = "http://" + (String)helperNode.first + ":" + Config.http_port + "/version";
            File dir = new File(this.imageDir);
            MetaHelper.getRemoteFile(url, 5000, MetaHelper.getOutputStream("VERSION", dir));
            MetaHelper.complete("VERSION", dir);
            return true;
        }
        catch (Exception e) {
            LOG.warn((Object)e);
            return false;
        }
    }

    private void getNewImage(Pair<String, Integer> helperNode) throws IOException {
        long localImageVersion = 0L;
        Storage storage = new Storage(this.imageDir);
        localImageVersion = storage.getLatestImageSeq();
        try {
            URL infoUrl = new URL("http://" + (String)helperNode.first + ":" + Config.http_port + "/info");
            StorageInfo info = this.getStorageInfo(infoUrl);
            long version = info.getImageSeq();
            if (version > localImageVersion) {
                String url = "http://" + (String)helperNode.first + ":" + Config.http_port + "/image?version=" + version;
                String filename = "image." + version;
                File dir = new File(this.imageDir);
                MetaHelper.getRemoteFile(url, 5000, MetaHelper.getOutputStream(filename, dir));
                MetaHelper.complete(filename, dir);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private boolean isMyself() {
        Preconditions.checkNotNull(this.selfNode);
        Preconditions.checkNotNull(this.helperNodes);
        LOG.debug("self: {}. helpers: {}", this.selfNode, this.helperNodes);
        boolean containSelf = false;
        for (Pair<String, Integer> helperNode : this.helperNodes) {
            if (!this.selfNode.equals(helperNode)) continue;
            containSelf = true;
        }
        if (containSelf) {
            this.helperNodes.clear();
            this.helperNodes.add(this.selfNode);
        }
        return containSelf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StorageInfo getStorageInfo(URL url) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        HttpURLConnection connection = null;
        try {
            String response;
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            try (Object bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = ((BufferedReader)bufferedReader).readLine()) != null) {
                    sb.append(line);
                }
                response = sb.toString();
            }
            try {
                bufferedReader = (StorageInfo)mapper.readValue(response, StorageInfo.class);
                return bufferedReader;
            }
            catch (Exception e) {
                StorageInfo storageInfo = ((StorageInfoV2)mapper.readValue((String)response, StorageInfoV2.class)).data;
                if (connection != null) {
                    connection.disconnect();
                }
                return storageInfo;
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public boolean hasReplayer() {
        return this.replayer != null;
    }

    public void loadImage(String imageDir) throws IOException, DdlException {
        Storage storage = new Storage(imageDir);
        this.clusterId = storage.getClusterID();
        File curFile = storage.getCurrentImageFile();
        if (!curFile.exists()) {
            LOG.info("image does not exist: {}", (Object)curFile.getAbsolutePath());
            return;
        }
        this.replayedJournalId.set(storage.getLatestImageSeq());
        MetaReader.read(curFile, this);
    }

    public void recreateTabletInvertIndex() {
        if (Catalog.isCheckpointThread()) {
            return;
        }
        TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
        for (Database db : this.fullNameToDb.values()) {
            long dbId = db.getId();
            for (Table table : db.getTables()) {
                if (table.getType() != Table.TableType.OLAP) continue;
                OlapTable olapTable = (OlapTable)table;
                long tableId = olapTable.getId();
                Collection<Partition> allPartitions = olapTable.getAllPartitions();
                for (Partition partition : allPartitions) {
                    long partitionId = partition.getId();
                    TStorageMedium medium = olapTable.getPartitionInfo().getDataProperty(partitionId).getStorageMedium();
                    for (MaterializedIndex index : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL)) {
                        long indexId = index.getId();
                        int schemaHash = olapTable.getSchemaHashByIndexId(indexId);
                        TabletMeta tabletMeta = new TabletMeta(dbId, tableId, partitionId, indexId, schemaHash, medium);
                        for (Tablet tablet : index.getTablets()) {
                            long tabletId = tablet.getId();
                            invertedIndex.addTablet(tabletId, tabletMeta);
                            for (Replica replica : tablet.getReplicas()) {
                                invertedIndex.addReplica(tabletId, replica);
                            }
                        }
                    }
                }
            }
        }
    }

    public long loadHeader(DataInputStream dis, MetaHeader metaHeader, long checksum) throws IOException, DdlException {
        switch (metaHeader.getMetaFormat()) {
            case COR1: {
                return this.loadHeaderCOR1(dis, checksum);
            }
        }
        throw new DdlException("unsupported image format.");
    }

    public long loadHeaderCOR1(DataInputStream dis, long checksum) throws IOException {
        int journalVersion = dis.readInt();
        long newChecksum = checksum ^ (long)journalVersion;
        MetaContext.get().setMetaVersion(journalVersion);
        long replayedJournalId = dis.readLong();
        newChecksum ^= replayedJournalId;
        long catalogId = dis.readLong();
        this.idGenerator.setId(catalogId);
        this.isDefaultClusterCreated = dis.readBoolean();
        LOG.info("finished replay header from image");
        return newChecksum ^= catalogId;
    }

    public long loadMasterInfo(DataInputStream dis, long checksum) throws IOException {
        this.masterIp = Text.readString((DataInput)dis);
        this.masterRpcPort = dis.readInt();
        long newChecksum = checksum ^ (long)this.masterRpcPort;
        this.masterHttpPort = dis.readInt();
        LOG.info("finished replay masterInfo from image");
        return newChecksum ^= (long)this.masterHttpPort;
    }

    public long loadFrontends(DataInputStream dis, long checksum) throws IOException {
        int i;
        int size = dis.readInt();
        long newChecksum = checksum ^ (long)size;
        for (i = 0; i < size; ++i) {
            Frontend fe = Frontend.read(dis);
            this.replayAddFrontend(fe);
        }
        size = dis.readInt();
        newChecksum ^= (long)size;
        for (i = 0; i < size; ++i) {
            this.removedFrontends.add(Text.readString((DataInput)dis));
        }
        LOG.info("finished replay frontends from image");
        return newChecksum;
    }

    public long loadDb(DataInputStream dis, long checksum) throws IOException, DdlException {
        int dbCount = dis.readInt();
        long newChecksum = checksum ^ (long)dbCount;
        for (long i = 0L; i < (long)dbCount; ++i) {
            Database db = new Database();
            db.readFields(dis);
            newChecksum ^= db.getId();
            this.idToDb.put(db.getId(), db);
            this.fullNameToDb.put(db.getFullName(), db);
            if (db.getDbState() == Database.DbState.LINK) {
                this.fullNameToDb.put(db.getAttachDb(), db);
            }
            this.globalTransactionMgr.addDatabaseTransactionMgr(db.getId());
        }
        LOG.info("finished replay databases from image");
        return newChecksum;
    }

    public long loadLoadJob(DataInputStream dis, long checksum) throws IOException, DdlException {
        int jobSize = dis.readInt();
        long newChecksum = checksum ^ (long)jobSize;
        for (int i = 0; i < jobSize; ++i) {
            long dbId = dis.readLong();
            newChecksum ^= dbId;
            int loadJobCount = dis.readInt();
            newChecksum ^= (long)loadJobCount;
            long currentTimeMs = System.currentTimeMillis();
            for (int j = 0; j < loadJobCount; ++j) {
                LoadJob job = new LoadJob();
                job.readFields(dis);
                if (job.isExpired(currentTimeMs)) continue;
                if (job.getEtlJobType() != EtlJobType.HADOOP) {
                    LOG.warn("job {} with type is deprecated, skip it", (Object)job.getId(), (Object)job.getEtlJobType());
                    continue;
                }
                this.load.unprotectAddLoadJob(job, true);
            }
        }
        jobSize = dis.readInt();
        Preconditions.checkState((jobSize == 0 ? 1 : 0) != 0, (Object)jobSize);
        newChecksum ^= (long)jobSize;
        LoadErrorHub.Param param = new LoadErrorHub.Param();
        param.readFields(dis);
        this.load.setLoadErrorHubInfo(param);
        int deleteJobSize = dis.readInt();
        Preconditions.checkState((deleteJobSize == 0 ? 1 : 0) != 0, (Object)deleteJobSize);
        LOG.info("finished replay loadJob from image");
        return newChecksum ^= (long)deleteJobSize;
    }

    public long loadExportJob(DataInputStream dis, long checksum) throws IOException, DdlException {
        long curTime = System.currentTimeMillis();
        long newChecksum = checksum;
        int size = dis.readInt();
        newChecksum = checksum ^ (long)size;
        for (int i = 0; i < size; ++i) {
            long jobId = dis.readLong();
            newChecksum ^= jobId;
            ExportJob job = ExportJob.read(dis);
            if (job.isExpired(curTime)) continue;
            this.exportMgr.unprotectAddJob(job);
        }
        LOG.info("finished replay exportJob from image");
        return newChecksum;
    }

    public long loadSyncJobs(DataInputStream dis, long checksum) throws IOException, DdlException {
        if (Catalog.getCurrentCatalogJournalVersion() >= 103) {
            this.syncJobManager.readField(dis);
        }
        LOG.info("finished replay syncJobMgr from image");
        return checksum;
    }

    public long loadAlterJob(DataInputStream dis, long checksum) throws IOException {
        long newChecksum = checksum;
        for (AlterJobV2.JobType type : AlterJobV2.JobType.values()) {
            newChecksum = this.loadAlterJob(dis, newChecksum, type);
        }
        LOG.info("finished replay alterJob from image");
        return newChecksum;
    }

    public long loadAlterJob(DataInputStream dis, long checksum, AlterJobV2.JobType type) throws IOException {
        int size = dis.readInt();
        long newChecksum = checksum ^ (long)size;
        if (size > 0) {
            throw new IOException("There are [" + size + "] old alter jobs. Please downgrade FE to an older version and handle residual jobs");
        }
        size = dis.readInt();
        newChecksum ^= (long)size;
        if (size > 0) {
            throw new IOException("There are [" + size + "] old finished or cancelled alter jobs. Please downgrade FE to an older version and handle residual jobs");
        }
        size = dis.readInt();
        newChecksum ^= (long)size;
        for (int i = 0; i < size; ++i) {
            AlterJobV2 alterJobV2 = AlterJobV2.read(dis);
            if (type == AlterJobV2.JobType.ROLLUP || type == AlterJobV2.JobType.SCHEMA_CHANGE) {
                if (type == AlterJobV2.JobType.ROLLUP) {
                    this.getMaterializedViewHandler().addAlterJobV2(alterJobV2);
                } else {
                    this.getSchemaChangeHandler().addAlterJobV2(alterJobV2);
                }
                if (alterJobV2.getJobState() != AlterJobV2.JobState.PENDING) continue;
                alterJobV2.replay(alterJobV2);
                LOG.info("replay pending alter job when load alter job {} ", (Object)alterJobV2.getJobId());
                continue;
            }
            throw new IOException("Invalid alter job type: " + type.name());
        }
        return newChecksum;
    }

    public long loadBackupHandler(DataInputStream dis, long checksum) throws IOException {
        this.getBackupHandler().readFields(dis);
        this.getBackupHandler().setCatalog(this);
        LOG.info("finished replay backupHandler from image");
        return checksum;
    }

    public long loadDeleteHandler(DataInputStream dis, long checksum) throws IOException {
        this.deleteHandler = DeleteHandler.read(dis);
        LOG.info("finished replay deleteHandler from image");
        return checksum;
    }

    public long loadPaloAuth(DataInputStream dis, long checksum) throws IOException {
        this.auth.readFields(dis);
        LOG.info("finished replay paloAuth from image");
        return checksum;
    }

    public long loadTransactionState(DataInputStream dis, long checksum) throws IOException {
        int size = dis.readInt();
        long newChecksum = checksum ^ (long)size;
        this.globalTransactionMgr.readFields(dis);
        LOG.info("finished replay transactionState from image");
        return newChecksum;
    }

    public long loadRecycleBin(DataInputStream dis, long checksum) throws IOException {
        this.recycleBin.readFields(dis);
        if (!Catalog.isCheckpointThread()) {
            this.recycleBin.addTabletToInvertedIndex();
        }
        for (Long dbId : this.recycleBin.getAllDbIds()) {
            this.globalTransactionMgr.addDatabaseTransactionMgr(dbId);
        }
        LOG.info("finished replay recycleBin from image");
        return checksum;
    }

    public long loadGlobalVariable(DataInputStream in, long checksum) throws IOException, DdlException {
        VariableMgr.read(in);
        LOG.info("finished replay globalVariable from image");
        return checksum;
    }

    public long loadColocateTableIndex(DataInputStream dis, long checksum) throws IOException {
        Catalog.getCurrentColocateIndex().readFields(dis);
        LOG.info("finished replay colocateTableIndex from image");
        return checksum;
    }

    public long loadRoutineLoadJobs(DataInputStream dis, long checksum) throws IOException {
        Catalog.getCurrentCatalog().getRoutineLoadManager().readFields(dis);
        LOG.info("finished replay routineLoadJobs from image");
        return checksum;
    }

    public long loadLoadJobsV2(DataInputStream in, long checksum) throws IOException {
        this.loadManager.readFields(in);
        LOG.info("finished replay loadJobsV2 from image");
        return checksum;
    }

    public long loadResources(DataInputStream in, long checksum) throws IOException {
        this.resourceMgr = ResourceMgr.read(in);
        LOG.info("finished replay resources from image");
        return checksum;
    }

    public long loadSmallFiles(DataInputStream in, long checksum) throws IOException {
        this.smallFileMgr.readFields(in);
        LOG.info("finished replay smallFiles from image");
        return checksum;
    }

    public long loadSqlBlockRule(DataInputStream in, long checksum) throws IOException {
        if (Catalog.getCurrentCatalogJournalVersion() >= 104) {
            this.sqlBlockRuleMgr = SqlBlockRuleMgr.read(in);
        }
        LOG.info("finished replay sqlBlockRule from image");
        return checksum;
    }

    public String saveImage() throws IOException {
        Storage storage = new Storage(this.imageDir);
        File curFile = storage.getImageFile(this.replayedJournalId.get());
        File ckpt = new File(this.imageDir, "image.ckpt");
        this.saveImage(ckpt, this.replayedJournalId.get());
        LOG.info("Move " + ckpt.getAbsolutePath() + " to " + curFile.getAbsolutePath());
        if (!ckpt.renameTo(curFile)) {
            curFile.delete();
            throw new IOException();
        }
        return curFile.getAbsolutePath();
    }

    public void saveImage(File curFile, long replayedJournalId) throws IOException {
        if (curFile.exists() && !curFile.delete()) {
            throw new IOException(curFile.getName() + " can not be deleted.");
        }
        if (!curFile.createNewFile()) {
            throw new IOException(curFile.getName() + " can not be created.");
        }
        MetaWriter.write(curFile, this);
    }

    public long saveHeader(CountingDataOutputStream dos, long replayedJournalId, long checksum) throws IOException {
        checksum ^= (long)FeConstants.meta_version;
        dos.writeInt(FeConstants.meta_version);
        checksum ^= replayedJournalId;
        dos.writeLong(replayedJournalId);
        long id = this.idGenerator.getBatchEndId();
        dos.writeLong(id);
        dos.writeBoolean(this.isDefaultClusterCreated);
        return checksum ^= id;
    }

    public long saveMasterInfo(CountingDataOutputStream dos, long checksum) throws IOException {
        Text.writeString((DataOutput)dos, (String)this.masterIp);
        checksum ^= (long)this.masterRpcPort;
        dos.writeInt(this.masterRpcPort);
        dos.writeInt(this.masterHttpPort);
        return checksum ^= (long)this.masterHttpPort;
    }

    public long saveFrontends(CountingDataOutputStream dos, long checksum) throws IOException {
        int size = this.frontends.size();
        checksum ^= (long)size;
        dos.writeInt(size);
        for (Frontend fe : this.frontends.values()) {
            fe.write((DataOutput)dos);
        }
        size = this.removedFrontends.size();
        checksum ^= (long)size;
        dos.writeInt(size);
        for (String feName : this.removedFrontends) {
            Text.writeString((DataOutput)dos, (String)feName);
        }
        return checksum;
    }

    public long saveDb(CountingDataOutputStream dos, long checksum) throws IOException {
        int dbCount = this.idToDb.size() - ((ConcurrentHashMap.CollectionView)((Object)this.nameToCluster.keySet())).size();
        checksum ^= (long)dbCount;
        dos.writeInt(dbCount);
        for (Map.Entry<Long, Database> entry : this.idToDb.entrySet()) {
            Database db = entry.getValue();
            String dbName = db.getFullName();
            if (InfoSchemaDb.isInfoSchemaDb(dbName)) continue;
            checksum ^= entry.getKey().longValue();
            db.write((DataOutput)dos);
        }
        return checksum;
    }

    public long saveLoadJob(CountingDataOutputStream dos, long checksum) throws IOException {
        Map<Long, List<LoadJob>> dbToLoadJob = this.load.getDbToLoadJobs();
        int jobSize = dbToLoadJob.size();
        checksum ^= (long)jobSize;
        dos.writeInt(jobSize);
        for (Map.Entry<Long, List<LoadJob>> entry : dbToLoadJob.entrySet()) {
            long dbId = entry.getKey();
            checksum ^= dbId;
            dos.writeLong(dbId);
            List<LoadJob> loadJobs = entry.getValue();
            int loadJobCount = loadJobs.size();
            checksum ^= (long)loadJobCount;
            dos.writeInt(loadJobCount);
            for (LoadJob job : loadJobs) {
                job.write((DataOutput)dos);
            }
        }
        jobSize = 0;
        checksum ^= (long)jobSize;
        dos.writeInt(jobSize);
        LoadErrorHub.Param param = this.load.getLoadErrorHubInfo();
        param.write((DataOutput)dos);
        int deleteJobSize = 0;
        dos.writeInt(deleteJobSize);
        return checksum ^= (long)deleteJobSize;
    }

    public long saveExportJob(CountingDataOutputStream dos, long checksum) throws IOException {
        long curTime = System.currentTimeMillis();
        List jobs = this.exportMgr.getJobs().stream().filter(t -> !t.isExpired(curTime)).collect(Collectors.toList());
        int size = jobs.size();
        checksum ^= (long)size;
        dos.writeInt(size);
        for (ExportJob job : jobs) {
            long jobId = job.getId();
            checksum ^= jobId;
            dos.writeLong(jobId);
            job.write((DataOutput)dos);
        }
        return checksum;
    }

    public long saveSyncJobs(CountingDataOutputStream dos, long checksum) throws IOException {
        this.syncJobManager.write((DataOutput)dos);
        return checksum;
    }

    public long saveAlterJob(CountingDataOutputStream dos, long checksum) throws IOException {
        for (AlterJobV2.JobType type : AlterJobV2.JobType.values()) {
            checksum = this.saveAlterJob(dos, checksum, type);
        }
        return checksum;
    }

    public long saveAlterJob(CountingDataOutputStream dos, long checksum, AlterJobV2.JobType type) throws IOException {
        HashMap alterJobsV2;
        if (type == AlterJobV2.JobType.ROLLUP) {
            alterJobsV2 = this.getMaterializedViewHandler().getAlterJobsV2();
        } else if (type == AlterJobV2.JobType.SCHEMA_CHANGE) {
            alterJobsV2 = this.getSchemaChangeHandler().getAlterJobsV2();
        } else if (type == AlterJobV2.JobType.DECOMMISSION_BACKEND) {
            alterJobsV2 = Maps.newHashMap();
        } else {
            throw new IOException("Invalid alter job type: " + type.name());
        }
        int size = 0;
        checksum ^= (long)size;
        dos.writeInt(size);
        size = 0;
        checksum ^= (long)size;
        dos.writeInt(size);
        size = alterJobsV2.size();
        checksum ^= (long)size;
        dos.writeInt(size);
        for (AlterJobV2 alterJobV2 : alterJobsV2.values()) {
            alterJobV2.write((DataOutput)dos);
        }
        return checksum;
    }

    public long saveBackupHandler(CountingDataOutputStream dos, long checksum) throws IOException {
        this.getBackupHandler().write((DataOutput)dos);
        return checksum;
    }

    public long saveDeleteHandler(CountingDataOutputStream dos, long checksum) throws IOException {
        this.getDeleteHandler().write((DataOutput)dos);
        return checksum;
    }

    public long savePaloAuth(CountingDataOutputStream dos, long checksum) throws IOException {
        this.auth.write((DataOutput)dos);
        return checksum;
    }

    public long saveTransactionState(CountingDataOutputStream dos, long checksum) throws IOException {
        int size = this.globalTransactionMgr.getTransactionNum();
        dos.writeInt(size);
        this.globalTransactionMgr.write((DataOutput)dos);
        return checksum ^= (long)size;
    }

    public long saveRecycleBin(CountingDataOutputStream dos, long checksum) throws IOException {
        CatalogRecycleBin recycleBin = Catalog.getCurrentRecycleBin();
        recycleBin.write((DataOutput)dos);
        return checksum;
    }

    public long saveColocateTableIndex(CountingDataOutputStream dos, long checksum) throws IOException {
        Catalog.getCurrentColocateIndex().write((DataOutput)dos);
        return checksum;
    }

    public long saveRoutineLoadJobs(CountingDataOutputStream dos, long checksum) throws IOException {
        Catalog.getCurrentCatalog().getRoutineLoadManager().write((DataOutput)dos);
        return checksum;
    }

    public long saveGlobalVariable(CountingDataOutputStream dos, long checksum) throws IOException {
        VariableMgr.write((DataOutputStream)dos);
        return checksum;
    }

    public void replayGlobalVariableV2(GlobalVarPersistInfo info) throws IOException, DdlException {
        VariableMgr.replayGlobalVariableV2(info);
    }

    public long saveLoadJobsV2(CountingDataOutputStream dos, long checksum) throws IOException {
        Catalog.getCurrentCatalog().getLoadManager().write((DataOutput)dos);
        return checksum;
    }

    public long saveResources(CountingDataOutputStream dos, long checksum) throws IOException {
        Catalog.getCurrentCatalog().getResourceMgr().write((DataOutput)dos);
        return checksum;
    }

    public long saveSmallFiles(CountingDataOutputStream dos, long checksum) throws IOException {
        this.smallFileMgr.write((DataOutput)dos);
        return checksum;
    }

    public long saveSqlBlockRule(CountingDataOutputStream out, long checksum) throws IOException {
        Catalog.getCurrentCatalog().getSqlBlockRuleMgr().write((DataOutput)out);
        return checksum;
    }

    public void createLabelCleaner() {
        this.labelCleaner = new MasterDaemon("LoadLabelCleaner", (long)Config.label_clean_interval_second * 1000L){

            @Override
            protected void runAfterCatalogReady() {
                Catalog.this.load.removeOldLoadJobs();
                Catalog.this.loadManager.removeOldLoadJob();
                Catalog.this.exportMgr.removeOldExportJobs();
                Catalog.this.deleteHandler.removeOldDeleteInfos();
            }
        };
    }

    public void createTxnCleaner() {
        this.txnCleaner = new MasterDaemon("txnCleaner", (long)Config.transaction_clean_interval_second * 1000L){

            @Override
            protected void runAfterCatalogReady() {
                Catalog.this.globalTransactionMgr.removeExpiredAndTimeoutTxns();
            }
        };
    }

    public void createReplayer() {
        this.replayer = new Daemon("replayer", 1L){

            @Override
            protected void runOneCycle() {
                boolean err = false;
                boolean hasLog = false;
                try {
                    hasLog = Catalog.this.replayJournal(-1L);
                    Catalog.this.metaReplayState.setOk();
                }
                catch (InsufficientLogException insufficientLogEx) {
                    LOG.error("catch insufficient log exception. please restart.", (Throwable)insufficientLogEx);
                    NetworkRestore restore = new NetworkRestore();
                    NetworkRestoreConfig config = new NetworkRestoreConfig();
                    config.setRetainLogFiles(false);
                    restore.execute(insufficientLogEx, config);
                    System.exit(-1);
                }
                catch (Throwable e) {
                    LOG.error("replayer thread catch an exception when replay journal.", e);
                    Catalog.this.metaReplayState.setException(e);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {
                        LOG.error("sleep got exception. ", e);
                    }
                    err = true;
                }
                Catalog.this.setCanRead(hasLog, err);
            }
        };
        this.replayer.setMetaContext(this.metaContext);
    }

    private void setCanRead(boolean hasLog, boolean err) {
        if (err) {
            this.canRead.set(false);
            this.isReady.set(false);
            return;
        }
        if (Config.ignore_meta_check) {
            this.canRead.set(true);
            this.isReady.set(false);
            return;
        }
        long currentTimeMs = System.currentTimeMillis();
        if (currentTimeMs - this.synchronizedTimeMs > (long)(Config.meta_delay_toleration_second * 1000)) {
            LOG.warn("meta out of date. current time: {}, synchronized time: {}, has log: {}, fe type: {}", (Object)currentTimeMs, (Object)this.synchronizedTimeMs, (Object)hasLog, (Object)this.feType);
            if (hasLog || this.feType == FrontendNodeType.UNKNOWN) {
                this.metaReplayState.setOutOfDate(currentTimeMs, this.synchronizedTimeMs);
                this.canRead.set(false);
                this.isReady.set(false);
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                LOG.error("unhandled exception when sleep", (Throwable)e);
            }
        } else {
            this.canRead.set(true);
            this.isReady.set(true);
        }
    }

    public void notifyNewFETypeTransfer(FrontendNodeType newType) {
        try {
            String msg = "notify new FE type transfer: " + (Object)((Object)newType);
            LOG.warn(msg);
            Util.stdoutWithTime(msg);
            this.typeTransferQueue.put(newType);
        }
        catch (InterruptedException e) {
            LOG.error("failed to put new FE type: {}", (Object)newType, (Object)e);
        }
    }

    public void createStateListener() {
        this.listener = new Daemon("stateListener", 100L){

            @Override
            protected synchronized void runOneCycle() {
                while (true) {
                    FrontendNodeType newType = null;
                    try {
                        newType = (FrontendNodeType)((Object)Catalog.this.typeTransferQueue.take());
                    }
                    catch (InterruptedException e) {
                        LOG.error("got exception when take FE type from queue", (Throwable)e);
                        Util.stdoutWithTime("got exception when take FE type from queue. " + e.getMessage());
                        System.exit(-1);
                    }
                    Preconditions.checkNotNull((Object)((Object)newType));
                    LOG.info("begin to transfer FE type from {} to {}", (Object)Catalog.this.feType, (Object)newType);
                    if (Catalog.this.feType == newType) {
                        return;
                    }
                    block1 : switch (Catalog.this.feType) {
                        case INIT: {
                            switch (newType) {
                                case MASTER: {
                                    Catalog.this.transferToMaster();
                                    break block1;
                                }
                                case FOLLOWER: 
                                case OBSERVER: {
                                    Catalog.this.transferToNonMaster(newType);
                                    break block1;
                                }
                                case UNKNOWN: {
                                    break block1;
                                }
                            }
                            break;
                        }
                        case UNKNOWN: {
                            switch (newType) {
                                case MASTER: {
                                    Catalog.this.transferToMaster();
                                    break block1;
                                }
                                case FOLLOWER: 
                                case OBSERVER: {
                                    Catalog.this.transferToNonMaster(newType);
                                    break block1;
                                }
                            }
                            break;
                        }
                        case FOLLOWER: {
                            switch (newType) {
                                case MASTER: {
                                    Catalog.this.transferToMaster();
                                    break block1;
                                }
                                case UNKNOWN: {
                                    Catalog.this.transferToNonMaster(newType);
                                    break block1;
                                }
                            }
                            break;
                        }
                        case OBSERVER: {
                            switch (newType) {
                                case UNKNOWN: {
                                    Catalog.this.transferToNonMaster(newType);
                                    break block1;
                                }
                            }
                            break;
                        }
                        case MASTER: {
                            String msg = "transfer FE type from MASTER to " + newType.name() + ". exit";
                            LOG.error(msg);
                            Util.stdoutWithTime(msg);
                            System.exit(-1);
                        }
                    }
                    Catalog.this.feType = newType;
                    LOG.info("finished to transfer FE type to {}", (Object)Catalog.this.feType);
                }
            }
        };
        this.listener.setMetaContext(this.metaContext);
    }

    public synchronized boolean replayJournal(long toJournalId) {
        JournalEntity entity;
        long newToJournalId = toJournalId;
        if (newToJournalId == -1L) {
            newToJournalId = this.getMaxJournalId();
        }
        if (newToJournalId <= this.replayedJournalId.get()) {
            return false;
        }
        LOG.info("replayed journal id is {}, replay to journal id is {}", (Object)this.replayedJournalId, (Object)newToJournalId);
        JournalCursor cursor = this.editLog.read(this.replayedJournalId.get() + 1L, newToJournalId);
        if (cursor == null) {
            LOG.warn("failed to get cursor from {} to {}", (Object)(this.replayedJournalId.get() + 1L), (Object)newToJournalId);
            return false;
        }
        long startTime = System.currentTimeMillis();
        boolean hasLog = false;
        while ((entity = cursor.next()) != null) {
            hasLog = true;
            EditLog.loadJournal(this, entity);
            this.replayedJournalId.incrementAndGet();
            LOG.debug("journal {} replayed.", (Object)this.replayedJournalId);
            if (this.feType != FrontendNodeType.MASTER) {
                this.journalObservable.notifyObservers(this.replayedJournalId.get());
            }
            if (!MetricRepo.isInit) continue;
            MetricRepo.COUNTER_EDIT_LOG_READ.increase(1L);
        }
        long cost = System.currentTimeMillis() - startTime;
        if (cost >= 1000L) {
            LOG.warn("replay journal cost too much time: {} replayedJournalId: {}", (Object)cost, (Object)this.replayedJournalId);
        }
        return hasLog;
    }

    public void createTimePrinter() {
        this.timePrinter = new MasterDaemon("timePrinter", 10000L){

            @Override
            protected void runAfterCatalogReady() {
                Timestamp stamp = new Timestamp();
                Catalog.this.editLog.logTimestamp(stamp);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFrontend(FrontendNodeType role, String host, int editLogPort) throws DdlException {
        if (!this.tryLock(false)) {
            throw new DdlException("Failed to acquire catalog lock. Try again");
        }
        try {
            Frontend fe = this.checkFeExist(host, editLogPort);
            if (fe != null) {
                throw new DdlException("frontend already exists " + fe);
            }
            String nodeName = Catalog.genFeNodeName(host, editLogPort, false);
            if (this.removedFrontends.contains(nodeName)) {
                throw new DdlException("frontend name already exists " + nodeName + ". Try again");
            }
            fe = new Frontend(role, nodeName, host, editLogPort);
            this.frontends.put(nodeName, fe);
            if (role == FrontendNodeType.FOLLOWER || role == FrontendNodeType.REPLICA) {
                ((BDBHA)this.getHaProtocol()).addHelperSocket(host, editLogPort);
                this.helperNodes.add(Pair.create(host, editLogPort));
            }
            this.editLog.logAddFrontend(fe);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropFrontend(FrontendNodeType role, String host, int port) throws DdlException {
        if (host.equals(this.selfNode.first) && port == (Integer)this.selfNode.second && this.feType == FrontendNodeType.MASTER) {
            throw new DdlException("can not drop current master node.");
        }
        if (!this.tryLock(false)) {
            throw new DdlException("Failed to acquire catalog lock. Try again");
        }
        try {
            Frontend fe = this.checkFeExist(host, port);
            if (fe == null) {
                throw new DdlException("frontend does not exist[" + host + ":" + port + "]");
            }
            if (fe.getRole() != role) {
                throw new DdlException(role.toString() + " does not exist[" + host + ":" + port + "]");
            }
            this.frontends.remove(fe.getNodeName());
            this.removedFrontends.add(fe.getNodeName());
            if (fe.getRole() == FrontendNodeType.FOLLOWER || fe.getRole() == FrontendNodeType.REPLICA) {
                this.haProtocol.removeElectableNode(fe.getNodeName());
                this.helperNodes.remove(Pair.create(host, port));
            }
            this.editLog.logRemoveFrontend(fe);
        }
        finally {
            this.unlock();
        }
    }

    public Frontend checkFeExist(String host, int port) {
        for (Frontend fe : this.frontends.values()) {
            if (!fe.getHost().equals(host) || fe.getEditLogPort() != port) continue;
            return fe;
        }
        return null;
    }

    public Frontend getFeByHost(String host) {
        for (Frontend fe : this.frontends.values()) {
            if (!fe.getHost().equals(host)) continue;
            return fe;
        }
        return null;
    }

    public Frontend getFeByName(String name) {
        for (Frontend fe : this.frontends.values()) {
            if (!fe.getNodeName().equals(name)) continue;
            return fe;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDb(CreateDbStmt stmt) throws DdlException {
        String clusterName = stmt.getClusterName();
        String fullDbName = stmt.getFullDbName();
        Map<String, String> properties = stmt.getProperties();
        long id = this.getNextId();
        Database db = new Database(id, fullDbName);
        db.setClusterName(clusterName);
        db.setDbProperties(new DatabaseProperty(properties).checkAndBuildProperties());
        if (!this.tryLock(false)) {
            throw new DdlException("Failed to acquire catalog lock. Try again");
        }
        try {
            if (!this.nameToCluster.containsKey(clusterName)) {
                ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_NO_SELECT_CLUSTER, clusterName);
            }
            if (this.fullNameToDb.containsKey(fullDbName)) {
                if (stmt.isSetIfNotExists()) {
                    LOG.info("create database[{}] which already exists", (Object)fullDbName);
                    return;
                }
                ErrorReport.reportDdlException(ErrorCode.ERR_DB_CREATE_EXISTS, fullDbName);
            } else {
                this.unprotectCreateDb(db);
                this.editLog.logCreateDb(db);
            }
        }
        finally {
            this.unlock();
        }
        LOG.info("createDb dbName = " + fullDbName + ", id = " + id);
        if (db.getDbProperties().getIcebergProperty().isExist()) {
            this.icebergTableCreationRecordMgr.registerDb(db);
        }
    }

    public void unprotectCreateDb(Database db) {
        this.idToDb.put(db.getId(), db);
        this.fullNameToDb.put(db.getFullName(), db);
        Cluster cluster = this.nameToCluster.get(db.getClusterName());
        cluster.addDb(db.getFullName(), db.getId());
        this.globalTransactionMgr.addDatabaseTransactionMgr(db.getId());
    }

    public void addCluster(Cluster cluster) {
        this.nameToCluster.put(cluster.getName(), cluster);
        this.idToCluster.put(cluster.getId(), cluster);
    }

    public void replayCreateDb(Database db) {
        this.tryLock(true);
        try {
            this.unprotectCreateDb(db);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dropDb(DropDbStmt stmt) throws DdlException {
        String dbName = stmt.getDbName();
        if (!this.tryLock(false)) {
            throw new DdlException("Failed to acquire catalog lock. Try again");
        }
        try {
            if (!this.fullNameToDb.containsKey(dbName)) {
                if (stmt.isSetIfExists()) {
                    LOG.info("drop database[{}] which does not exist", (Object)dbName);
                    return;
                }
                ErrorReport.reportDdlException(ErrorCode.ERR_DB_DROP_EXISTS, dbName);
            }
            Database db = this.fullNameToDb.get(dbName);
            db.writeLock();
            try {
                if (!stmt.isForceDrop() && Catalog.getCurrentCatalog().getGlobalTransactionMgr().existCommittedTxns(db.getId(), null, null)) {
                    throw new DdlException("There are still some transactions in the COMMITTED state waiting to be completed. The database [" + dbName + "] cannot be dropped. If you want to forcibly drop(cannot be recovered), please use \"DROP database FORCE\".");
                }
                if (db.getDbState() == Database.DbState.LINK && dbName.equals(db.getAttachDb())) {
                    DropLinkDbAndUpdateDbInfo info = new DropLinkDbAndUpdateDbInfo();
                    this.fullNameToDb.remove(db.getAttachDb());
                    db.setDbState(Database.DbState.NORMAL);
                    info.setUpdateDbState(Database.DbState.NORMAL);
                    Cluster cluster = this.nameToCluster.get(ClusterNamespace.getClusterNameFromFullName(db.getAttachDb()));
                    BaseParam param = new BaseParam();
                    param.addStringParam(db.getAttachDb());
                    param.addLongParam(db.getId());
                    cluster.removeLinkDb(param);
                    info.setDropDbCluster(cluster.getName());
                    info.setDropDbId(db.getId());
                    info.setDropDbName(db.getAttachDb());
                    this.editLog.logDropLinkDb(info);
                    return;
                }
                if (db.getDbState() == Database.DbState.LINK && dbName.equals(db.getFullName())) {
                    ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_DB_STATE_LINK_OR_MIGRATE, ClusterNamespace.getNameFromFullName(dbName));
                    return;
                }
                if (dbName.equals(db.getAttachDb()) && db.getDbState() == Database.DbState.MOVE) {
                    ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_DB_STATE_LINK_OR_MIGRATE, ClusterNamespace.getNameFromFullName(dbName));
                    return;
                }
                Set<String> tableNames = db.getTableNamesWithLock();
                List<Table> tableList = db.getTablesOnIdOrder();
                MetaLockUtils.writeLockTables(tableList);
                try {
                    if (!stmt.isForceDrop()) {
                        for (Table table : tableList) {
                            OlapTable olapTable;
                            if (table.getType() != Table.TableType.OLAP || (olapTable = (OlapTable)table).getState() == OlapTable.OlapTableState.NORMAL) continue;
                            throw new DdlException("The table [" + (Object)((Object)olapTable.getState()) + "]'s state is " + (Object)((Object)olapTable.getState()) + ", cannot be dropped. please cancel the operation on olap table firstly. If you want to forcibly drop(cannot be recovered), please use \"DROP table FORCE\".");
                        }
                    }
                    this.unprotectDropDb(db, stmt.isForceDrop(), false);
                }
                finally {
                    MetaLockUtils.writeUnlockTables(tableList);
                }
                if (!stmt.isForceDrop()) {
                    Catalog.getCurrentRecycleBin().recycleDatabase(db, tableNames);
                } else {
                    Catalog.getCurrentCatalog().eraseDatabase(db.getId(), false);
                }
            }
            finally {
                db.writeUnlock();
            }
            this.idToDb.remove(db.getId());
            this.fullNameToDb.remove(db.getFullName());
            Cluster cluster = this.nameToCluster.get(db.getClusterName());
            cluster.removeDb(dbName, db.getId());
            DropDbInfo info = new DropDbInfo(dbName, stmt.isForceDrop());
            this.editLog.logDropDb(info);
        }
        finally {
            this.unlock();
        }
        LOG.info("finish drop database[{}], is force : {}", (Object)dbName, (Object)stmt.isForceDrop());
    }

    public void unprotectDropDb(Database db, boolean isForeDrop, boolean isReplay) {
        if (db.getDbProperties().getIcebergProperty().isExist()) {
            this.icebergTableCreationRecordMgr.deregisterDb(db);
        }
        for (Table table : db.getTables()) {
            this.unprotectDropTable(db, table, isForeDrop, isReplay);
        }
        db.markDropped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayDropLinkDb(DropLinkDbAndUpdateDbInfo info) {
        this.tryLock(true);
        try {
            Database db = this.fullNameToDb.remove(info.getDropDbName());
            db.setDbState(info.getUpdateDbState());
            Cluster cluster = this.nameToCluster.get(info.getDropDbCluster());
            BaseParam param = new BaseParam();
            param.addStringParam(db.getAttachDb());
            param.addLongParam(db.getId());
            cluster.removeLinkDb(param);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayDropDb(String dbName, boolean isForceDrop) throws DdlException {
        this.tryLock(true);
        try {
            Database db = this.fullNameToDb.get(dbName);
            db.writeLock();
            try {
                Set<String> tableNames = db.getTableNamesWithLock();
                List<Table> tableList = db.getTablesOnIdOrder();
                MetaLockUtils.writeLockTables(tableList);
                try {
                    this.unprotectDropDb(db, isForceDrop, true);
                }
                finally {
                    MetaLockUtils.writeUnlockTables(tableList);
                }
                if (!isForceDrop) {
                    Catalog.getCurrentRecycleBin().recycleDatabase(db, tableNames);
                } else {
                    Catalog.getCurrentCatalog().eraseDatabase(db.getId(), false);
                }
            }
            finally {
                db.writeUnlock();
            }
            this.fullNameToDb.remove(dbName);
            this.idToDb.remove(db.getId());
            Cluster cluster = this.nameToCluster.get(db.getClusterName());
            cluster.removeDb(dbName, db.getId());
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverDatabase(RecoverDbStmt recoverStmt) throws DdlException {
        if (this.getDb(recoverStmt.getDbName()).isPresent()) {
            throw new DdlException("Database[" + recoverStmt.getDbName() + "] already exist.");
        }
        Database db = Catalog.getCurrentRecycleBin().recoverDatabase(recoverStmt.getDbName());
        if (!this.tryLock(false)) {
            throw new DdlException("Failed to acquire catalog lock. Try again");
        }
        db.writeLock();
        List<Table> tableList = db.getTablesOnIdOrder();
        MetaLockUtils.writeLockTables(tableList);
        try {
            if (this.fullNameToDb.containsKey(db.getFullName())) {
                throw new DdlException("Database[" + db.getFullName() + "] already exist.");
            }
            this.fullNameToDb.put(db.getFullName(), db);
            this.idToDb.put(db.getId(), db);
            Cluster cluster = this.nameToCluster.get(db.getClusterName());
            cluster.addDb(db.getFullName(), db.getId());
            RecoverInfo recoverInfo = new RecoverInfo(db.getId(), -1L, -1L);
            this.editLog.logRecoverDb(recoverInfo);
            db.unmarkDropped();
        }
        finally {
            MetaLockUtils.writeUnlockTables(tableList);
            db.writeUnlock();
            this.unlock();
        }
        LOG.info("recover database[{}]", (Object)db.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverTable(RecoverTableStmt recoverStmt) throws DdlException {
        String dbName = recoverStmt.getDbName();
        String tableName = recoverStmt.getTableName();
        Database db = this.getDbOrDdlException(dbName);
        db.writeLockOrDdlException();
        try {
            if (db.getTable(tableName).isPresent()) {
                ErrorReport.reportDdlException(ErrorCode.ERR_TABLE_EXISTS_ERROR, tableName);
            }
            if (!Catalog.getCurrentRecycleBin().recoverTable(db, tableName)) {
                ErrorReport.reportDdlException(ErrorCode.ERR_UNKNOWN_TABLE, tableName, dbName);
            }
        }
        finally {
            db.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverPartition(RecoverPartitionStmt recoverStmt) throws DdlException {
        String dbName = recoverStmt.getDbName();
        String tableName = recoverStmt.getTableName();
        Database db = this.getDbOrDdlException(dbName);
        OlapTable olapTable = db.getOlapTableOrDdlException(tableName);
        olapTable.writeLockOrDdlException();
        try {
            String partitionName = recoverStmt.getPartitionName();
            if (olapTable.getPartition(partitionName) != null) {
                throw new DdlException("partition[" + partitionName + "] already exist in table[" + tableName + "]");
            }
            Catalog.getCurrentRecycleBin().recoverPartition(db.getId(), olapTable, partitionName);
        }
        finally {
            olapTable.writeUnlock();
        }
    }

    public void replayEraseDatabase(long dbId) throws DdlException {
        Catalog.getCurrentRecycleBin().replayEraseDatabase(dbId);
    }

    public void replayRecoverDatabase(RecoverInfo info) {
        long dbId = info.getDbId();
        Database db = Catalog.getCurrentRecycleBin().replayRecoverDatabase(dbId);
        this.replayCreateDb(db);
        LOG.info("replay recover db[{}]", (Object)dbId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterDatabaseQuota(AlterDatabaseQuotaStmt stmt) throws DdlException {
        String dbName = stmt.getDbName();
        Database db = this.getDbOrDdlException(dbName);
        AlterDatabaseQuotaStmt.QuotaType quotaType = stmt.getQuotaType();
        db.writeLockOrDdlException();
        try {
            if (quotaType == AlterDatabaseQuotaStmt.QuotaType.DATA) {
                db.setDataQuota(stmt.getQuota());
            } else if (quotaType == AlterDatabaseQuotaStmt.QuotaType.REPLICA) {
                db.setReplicaQuota(stmt.getQuota());
            }
            long quota = stmt.getQuota();
            DatabaseInfo dbInfo = new DatabaseInfo(dbName, "", quota, quotaType);
            this.editLog.logAlterDb(dbInfo);
        }
        finally {
            db.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayAlterDatabaseQuota(String dbName, long quota, AlterDatabaseQuotaStmt.QuotaType quotaType) throws MetaNotFoundException {
        Database db = this.getDbOrMetaException(dbName);
        db.writeLock();
        try {
            if (quotaType == AlterDatabaseQuotaStmt.QuotaType.DATA) {
                db.setDataQuota(quota);
            } else if (quotaType == AlterDatabaseQuotaStmt.QuotaType.REPLICA) {
                db.setReplicaQuota(quota);
            }
        }
        finally {
            db.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameDatabase(AlterDatabaseRename stmt) throws DdlException {
        String fullDbName = stmt.getDbName();
        String newFullDbName = stmt.getNewDbName();
        String clusterName = stmt.getClusterName();
        if (fullDbName.equals(newFullDbName)) {
            throw new DdlException("Same database name");
        }
        Database db = null;
        Cluster cluster = null;
        if (!this.tryLock(false)) {
            throw new DdlException("Failed to acquire catalog lock. Try again");
        }
        try {
            cluster = this.nameToCluster.get(clusterName);
            if (cluster == null) {
                ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_NO_EXISTS, clusterName);
            }
            if ((db = this.fullNameToDb.get(fullDbName)) == null) {
                ErrorReport.reportDdlException(ErrorCode.ERR_BAD_DB_ERROR, fullDbName);
            }
            if (db.getDbState() == Database.DbState.LINK || db.getDbState() == Database.DbState.MOVE) {
                ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_RENAME_DB_ERR, fullDbName);
            }
            if (this.fullNameToDb.get(newFullDbName) != null) {
                throw new DdlException("Database name[" + newFullDbName + "] is already used");
            }
            cluster.removeDb(db.getFullName(), db.getId());
            cluster.addDb(newFullDbName, db.getId());
            db.setNameWithLock(newFullDbName);
            this.fullNameToDb.remove(fullDbName);
            this.fullNameToDb.put(newFullDbName, db);
            DatabaseInfo dbInfo = new DatabaseInfo(fullDbName, newFullDbName, -1L, AlterDatabaseQuotaStmt.QuotaType.NONE);
            this.editLog.logDatabaseRename(dbInfo);
        }
        finally {
            this.unlock();
        }
        LOG.info("rename database[{}] to [{}]", (Object)fullDbName, (Object)newFullDbName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayRenameDatabase(String dbName, String newDbName) {
        this.tryLock(true);
        try {
            Database db = this.fullNameToDb.get(dbName);
            Cluster cluster = this.nameToCluster.get(db.getClusterName());
            cluster.removeDb(db.getFullName(), db.getId());
            db.setName(newDbName);
            cluster.addDb(newDbName, db.getId());
            this.fullNameToDb.remove(dbName);
            this.fullNameToDb.put(newDbName, db);
        }
        finally {
            this.unlock();
        }
        LOG.info("replay rename database {} to {}", (Object)dbName, (Object)newDbName);
    }

    public void createTable(CreateTableStmt stmt) throws UserException {
        String engineName = stmt.getEngineName();
        String dbName = stmt.getDbName();
        String tableName = stmt.getTableName();
        Database db = this.getDbOrDdlException(dbName);
        if (!stmt.isExternal()) {
            Catalog.getCurrentSystemInfo().checkClusterCapacity(stmt.getClusterName());
            db.checkQuota();
        }
        if (db.getTable(tableName).isPresent()) {
            if (stmt.isSetIfNotExists()) {
                LOG.info("create table[{}] which already exists", (Object)tableName);
                return;
            }
            ErrorReport.reportDdlException(ErrorCode.ERR_TABLE_EXISTS_ERROR, tableName);
        }
        if (engineName.equals("olap")) {
            this.createOlapTable(db, stmt);
            return;
        }
        if (engineName.equals("odbc")) {
            this.createOdbcTable(db, stmt);
            return;
        }
        if (engineName.equals("mysql")) {
            this.createMysqlTable(db, stmt);
            return;
        }
        if (engineName.equals("broker")) {
            this.createBrokerTable(db, stmt);
            return;
        }
        if (engineName.equalsIgnoreCase("elasticsearch") || engineName.equalsIgnoreCase("es")) {
            this.createEsTable(db, stmt);
            return;
        }
        if (engineName.equalsIgnoreCase("hive")) {
            this.createHiveTable(db, stmt);
            return;
        }
        if (engineName.equalsIgnoreCase("iceberg")) {
            IcebergCatalogMgr.createIcebergTable(db, stmt);
            return;
        }
        ErrorReport.reportDdlException(ErrorCode.ERR_UNKNOWN_STORAGE_ENGINE, engineName);
        Preconditions.checkState((boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTableLike(CreateTableLikeStmt stmt) throws DdlException {
        try {
            Database db = Catalog.getCurrentCatalog().getDbOrDdlException(stmt.getExistedDbName());
            Table table = db.getTableOrDdlException(stmt.getExistedTableName());
            if (table.getType() == Table.TableType.VIEW) {
                throw new DdlException("Not support create table from a View");
            }
            ArrayList createTableStmt = Lists.newArrayList();
            table.readLock();
            try {
                if (table.getType() == Table.TableType.OLAP) {
                    if (!CollectionUtils.isEmpty(stmt.getRollupNames())) {
                        OlapTable olapTable = (OlapTable)table;
                        for (String rollupIndexName : stmt.getRollupNames()) {
                            if (olapTable.hasMaterializedIndex(rollupIndexName)) continue;
                            throw new DdlException("Rollup index[" + rollupIndexName + "] not exists in Table[" + olapTable.getName() + "]");
                        }
                    }
                } else if (!CollectionUtils.isEmpty(stmt.getRollupNames()) || stmt.isWithAllRollup()) {
                    throw new DdlException("Table[" + table.getName() + "] is external, not support rollup copy");
                }
                Catalog.getDdlStmt(stmt, stmt.getDbName(), table, createTableStmt, null, null, false, false, true);
                if (createTableStmt.isEmpty()) {
                    ErrorReport.reportDdlException(ErrorCode.ERROR_CREATE_TABLE_LIKE_EMPTY, "CREATE");
                }
            }
            finally {
                table.readUnlock();
            }
            CreateTableStmt parsedCreateTableStmt = (CreateTableStmt)SqlParserUtils.parseAndAnalyzeStmt((String)createTableStmt.get(0), ConnectContext.get());
            parsedCreateTableStmt.setTableName(stmt.getTableName());
            parsedCreateTableStmt.setIfNotExists(stmt.isIfNotExists());
            this.createTable(parsedCreateTableStmt);
        }
        catch (UserException e) {
            throw new DdlException("Failed to execute CREATE TABLE LIKE " + stmt.getExistedTableName() + ". Reason: " + e.getMessage());
        }
    }

    public void createTableAsSelect(CreateTableAsSelectStmt stmt) throws DdlException {
        try {
            List<String> columnNames = stmt.getColumnNames();
            CreateTableStmt createTableStmt = stmt.getCreateTableStmt();
            QueryStmt queryStmt = stmt.getQueryStmt();
            List resultExprs = queryStmt.getResultExprs();
            List colLabels = queryStmt.getColLabels();
            int size = ((ArrayList)resultExprs).size();
            int colNameIndex = 0;
            for (int i = 0; i < size; ++i) {
                String name = columnNames != null ? columnNames.get(i) : (String)((ArrayList)colLabels).get(i);
                try {
                    FeNameFormat.checkColumnName(name);
                }
                catch (AnalysisException exception) {
                    name = "_col" + colNameIndex++;
                }
                Expr resultExpr = (Expr)((ArrayList)resultExprs).get(i);
                TypeDef typeDef = resultExpr.getType().isStringType() && resultExpr.getType().getLength() < 0 ? new TypeDef(Type.STRING) : new TypeDef(resultExpr.getType());
                createTableStmt.addColumnDef(new ColumnDef(name, typeDef, false, null, true, new ColumnDef.DefaultValue(false, null), ""));
                if (createTableStmt.getDistributionDesc() != null || i != 0) continue;
                createTableStmt.setDistributionDesc(new HashDistributionDesc(10, Lists.newArrayList((Object[])new String[]{name})));
            }
            Analyzer dummyRootAnalyzer = new Analyzer(this, ConnectContext.get());
            createTableStmt.analyze(dummyRootAnalyzer);
            this.createTable(createTableStmt);
        }
        catch (UserException e) {
            throw new DdlException("Failed to execute CTAS Reason: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPartition(Database db, String tableName, AddPartitionClause addPartitionClause) throws DdlException {
        Set<String> bfColumns;
        Map<Long, MaterializedIndexMeta> indexIdToMeta;
        DistributionInfo distributionInfo;
        OlapTable table;
        SinglePartitionDesc singlePartitionDesc = addPartitionClause.getSingeRangePartitionDesc();
        DistributionDesc distributionDesc = addPartitionClause.getDistributionDesc();
        boolean isTempPartition = addPartitionClause.isTempPartition();
        String partitionName = singlePartitionDesc.getPartitionName();
        OlapTable olapTable = table = db.getOlapTableOrDdlException(tableName);
        olapTable.readLock();
        try {
            if (olapTable.getState() != OlapTable.OlapTableState.NORMAL) {
                throw new DdlException("Table[" + tableName + "]'s state is not NORMAL");
            }
            PartitionInfo partitionInfo = olapTable.getPartitionInfo();
            if (partitionInfo.getType() != PartitionType.RANGE && partitionInfo.getType() != PartitionType.LIST) {
                throw new DdlException("Only support adding partition to range and list partitioned table");
            }
            if (olapTable.checkPartitionNameExist(partitionName)) {
                if (singlePartitionDesc.isSetIfNotExists()) {
                    LOG.info("add partition[{}] which already exists", (Object)partitionName);
                    return;
                }
                ErrorReport.reportDdlException(ErrorCode.ERR_SAME_NAME_PARTITION, partitionName);
            }
            Map<String, String> properties = singlePartitionDesc.getProperties();
            ReplicaAllocation replicaAlloc = olapTable.getDefaultReplicaAllocation();
            if (!properties.containsKey("replication_num") && !properties.containsKey("replication_allocation")) {
                properties.put("replication_allocation", replicaAlloc.toCreateStmt());
            }
            if (!properties.containsKey("in_memory")) {
                properties.put("in_memory", olapTable.isInMemory().toString());
            }
            singlePartitionDesc.analyze(partitionInfo.getPartitionColumns().size(), properties);
            partitionInfo.createAndCheckPartitionItem(singlePartitionDesc, isTempPartition);
            List<Column> baseSchema = olapTable.getBaseSchema();
            DistributionInfo defaultDistributionInfo = olapTable.getDefaultDistributionInfo();
            if (distributionDesc != null) {
                distributionInfo = distributionDesc.toDistributionInfo(baseSchema);
                if (distributionInfo.getType() != defaultDistributionInfo.getType()) {
                    throw new DdlException("Cannot assign different distribution type. default is: " + (Object)((Object)defaultDistributionInfo.getType()));
                }
                if (distributionInfo.getType() == DistributionInfo.DistributionInfoType.HASH) {
                    List<Column> defaultDistriCols;
                    HashDistributionInfo hashDistributionInfo = (HashDistributionInfo)distributionInfo;
                    List<Column> newDistriCols = hashDistributionInfo.getDistributionColumns();
                    if (!newDistriCols.equals(defaultDistriCols = ((HashDistributionInfo)defaultDistributionInfo).getDistributionColumns())) {
                        throw new DdlException("Cannot assign hash distribution with different distribution cols. default is: " + defaultDistriCols);
                    }
                    if (hashDistributionInfo.getBucketNum() <= 0) {
                        throw new DdlException("Cannot assign hash distribution buckets less than 1");
                    }
                }
            } else {
                distributionInfo = defaultDistributionInfo.toDistributionDesc().toDistributionInfo(baseSchema);
            }
            if (Catalog.getCurrentColocateIndex().isColocateTable(olapTable.getId())) {
                String fullGroupName = db.getId() + "_" + olapTable.getColocateGroup();
                ColocateGroupSchema groupSchema = this.colocateTableIndex.getGroupSchema(fullGroupName);
                Preconditions.checkNotNull((Object)groupSchema);
                groupSchema.checkDistribution(distributionInfo);
                groupSchema.checkReplicaAllocation(singlePartitionDesc.getReplicaAlloc());
            }
            indexIdToMeta = olapTable.getCopiedIndexIdToMeta();
            bfColumns = olapTable.getCopiedBfColumns();
        }
        catch (AnalysisException e) {
            throw new DdlException(e.getMessage());
        }
        finally {
            olapTable.readUnlock();
        }
        Preconditions.checkNotNull((Object)distributionInfo);
        Preconditions.checkNotNull((Object)olapTable);
        Preconditions.checkNotNull(indexIdToMeta);
        DataProperty dataProperty = singlePartitionDesc.getPartitionDataProperty();
        Preconditions.checkNotNull((Object)dataProperty);
        long indexNum = indexIdToMeta.size();
        long bucketNum = distributionInfo.getBucketNum();
        long replicaNum = singlePartitionDesc.getReplicaAlloc().getTotalReplicaNum();
        long totalReplicaNum = indexNum * bucketNum * replicaNum;
        if (totalReplicaNum >= db.getReplicaQuotaLeftWithLock()) {
            throw new DdlException("Database " + db.getFullName() + " table " + tableName + " add partition increasing " + totalReplicaNum + " of replica exceeds quota[" + db.getReplicaQuota() + "]");
        }
        HashSet<Long> tabletIdSet = new HashSet<Long>();
        try {
            long partitionId = this.getNextId();
            Partition partition = this.createPartitionWithIndices(db.getClusterName(), db.getId(), olapTable.getId(), olapTable.getBaseIndexId(), partitionId, partitionName, indexIdToMeta, distributionInfo, dataProperty.getStorageMedium(), singlePartitionDesc.getReplicaAlloc(), singlePartitionDesc.getVersionInfo(), bfColumns, olapTable.getBfFpp(), tabletIdSet, olapTable.getCopiedIndexes(), singlePartitionDesc.isInMemory(), olapTable.getStorageFormat(), singlePartitionDesc.getTabletType(), olapTable.getCompressionType(), olapTable.getDataSortInfo());
            table = db.getOlapTableOrDdlException(tableName);
            table.writeLockOrDdlException();
            try {
                olapTable = table;
                if (olapTable.getState() != OlapTable.OlapTableState.NORMAL) {
                    throw new DdlException("Table[" + tableName + "]'s state is not NORMAL");
                }
                if (olapTable.checkPartitionNameExist(partitionName)) {
                    if (singlePartitionDesc.isSetIfNotExists()) {
                        LOG.info("add partition[{}] which already exists", (Object)partitionName);
                        return;
                    }
                    ErrorReport.reportDdlException(ErrorCode.ERR_SAME_NAME_PARTITION, partitionName);
                }
                boolean metaChanged = false;
                if (olapTable.getIndexNameToId().size() != indexIdToMeta.size()) {
                    metaChanged = true;
                } else {
                    for (Map.Entry<Long, MaterializedIndexMeta> entry : olapTable.getIndexIdToMeta().entrySet()) {
                        long indexId = entry.getKey();
                        if (!indexIdToMeta.containsKey(indexId)) {
                            metaChanged = true;
                            break;
                        }
                        if (indexIdToMeta.get(indexId).getSchemaHash() == entry.getValue().getSchemaHash()) continue;
                        metaChanged = true;
                        break;
                    }
                }
                if (metaChanged) {
                    throw new DdlException("Table[" + tableName + "]'s meta has been changed. try again.");
                }
                PartitionInfo partitionInfo = olapTable.getPartitionInfo();
                if (partitionInfo.getType() != PartitionType.RANGE && partitionInfo.getType() != PartitionType.LIST) {
                    throw new DdlException("Only support adding partition to range and list partitioned table");
                }
                partitionInfo.handleNewSinglePartitionDesc(singlePartitionDesc, partitionId, isTempPartition);
                if (isTempPartition) {
                    olapTable.addTempPartition(partition);
                } else {
                    olapTable.addPartition(partition);
                }
                PartitionPersistInfo info = null;
                if (partitionInfo.getType() == PartitionType.RANGE) {
                    info = new PartitionPersistInfo(db.getId(), olapTable.getId(), partition, (Range<PartitionKey>)((Range)partitionInfo.getItem(partitionId).getItems()), ListPartitionItem.DUMMY_ITEM, dataProperty, partitionInfo.getReplicaAllocation(partitionId), partitionInfo.getIsInMemory(partitionId), isTempPartition);
                } else if (partitionInfo.getType() == PartitionType.LIST) {
                    info = new PartitionPersistInfo(db.getId(), olapTable.getId(), partition, RangePartitionItem.DUMMY_ITEM, partitionInfo.getItem(partitionId), dataProperty, partitionInfo.getReplicaAllocation(partitionId), partitionInfo.getIsInMemory(partitionId), isTempPartition);
                }
                this.editLog.logAddPartition(info);
                LOG.info("succeed in creating partition[{}], temp: {}", (Object)partitionId, (Object)isTempPartition);
            }
            finally {
                table.writeUnlock();
            }
        }
        catch (DdlException e) {
            for (Long tabletId : tabletIdSet) {
                Catalog.getCurrentInvertedIndex().deleteTablet(tabletId);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayAddPartition(PartitionPersistInfo info) throws MetaNotFoundException {
        Database db = this.getDbOrMetaException(info.getDbId());
        OlapTable olapTable = (OlapTable)db.getTableOrMetaException(info.getTableId(), Table.TableType.OLAP);
        olapTable.writeLock();
        try {
            Partition partition = info.getPartition();
            PartitionInfo partitionInfo = olapTable.getPartitionInfo();
            if (info.isTempPartition()) {
                olapTable.addTempPartition(partition);
            } else {
                olapTable.addPartition(partition);
            }
            PartitionItem partitionItem = null;
            if (partitionInfo.getType() == PartitionType.RANGE) {
                partitionItem = new RangePartitionItem(info.getRange());
            } else if (partitionInfo.getType() == PartitionType.LIST) {
                partitionItem = info.getListPartitionItem();
            }
            partitionInfo.unprotectHandleNewSinglePartitionDesc(partition.getId(), info.isTempPartition(), partitionItem, info.getDataProperty(), info.getReplicaAlloc(), info.isInMemory());
            if (!Catalog.isCheckpointThread()) {
                TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
                for (MaterializedIndex index : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL)) {
                    long indexId = index.getId();
                    int schemaHash = olapTable.getSchemaHashByIndexId(indexId);
                    TabletMeta tabletMeta = new TabletMeta(info.getDbId(), info.getTableId(), partition.getId(), index.getId(), schemaHash, info.getDataProperty().getStorageMedium());
                    for (Tablet tablet : index.getTablets()) {
                        long tabletId = tablet.getId();
                        invertedIndex.addTablet(tabletId, tabletMeta);
                        for (Replica replica : tablet.getReplicas()) {
                            invertedIndex.addReplica(tabletId, replica);
                        }
                    }
                }
            }
        }
        finally {
            olapTable.writeUnlock();
        }
    }

    public void dropPartition(Database db, OlapTable olapTable, DropPartitionClause clause) throws DdlException {
        PartitionInfo partitionInfo;
        Preconditions.checkArgument((boolean)olapTable.isWriteLockHeldByCurrentThread());
        String partitionName = clause.getPartitionName();
        boolean isTempPartition = clause.isTempPartition();
        if (olapTable.getState() != OlapTable.OlapTableState.NORMAL) {
            throw new DdlException("Table[" + olapTable.getName() + "]'s state is not NORMAL");
        }
        if (!olapTable.checkPartitionNameExist(partitionName, isTempPartition)) {
            if (clause.isSetIfExists()) {
                LOG.info("drop partition[{}] which does not exist", (Object)partitionName);
                return;
            }
            ErrorReport.reportDdlException(ErrorCode.ERR_DROP_PARTITION_NON_EXISTENT, partitionName);
        }
        if ((partitionInfo = olapTable.getPartitionInfo()).getType() != PartitionType.RANGE && partitionInfo.getType() != PartitionType.LIST) {
            throw new DdlException("Alter table [" + olapTable.getName() + "] failed. Not a partitioned table");
        }
        if (isTempPartition) {
            olapTable.dropTempPartition(partitionName, true);
        } else {
            Partition partition;
            if (!clause.isForceDrop() && (partition = olapTable.getPartition(partitionName)) != null && Catalog.getCurrentCatalog().getGlobalTransactionMgr().existCommittedTxns(db.getId(), olapTable.getId(), partition.getId())) {
                throw new DdlException("There are still some transactions in the COMMITTED state waiting to be completed. The partition [" + partitionName + "] cannot be dropped. If you want to forcibly drop(cannot be recovered), please use \"DROP partition FORCE\".");
            }
            olapTable.dropPartition(db.getId(), partitionName, clause.isForceDrop());
        }
        DropPartitionInfo info = new DropPartitionInfo(db.getId(), olapTable.getId(), partitionName, isTempPartition, clause.isForceDrop());
        this.editLog.logDropPartition(info);
        LOG.info("succeed in dropping partition[{}], is temp : {}, is force : {}", (Object)partitionName, (Object)isTempPartition, (Object)clause.isForceDrop());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayDropPartition(DropPartitionInfo info) throws MetaNotFoundException {
        Database db = this.getDbOrMetaException(info.getDbId());
        OlapTable olapTable = (OlapTable)db.getTableOrMetaException(info.getTableId(), Table.TableType.OLAP);
        olapTable.writeLock();
        try {
            if (info.isTempPartition()) {
                olapTable.dropTempPartition(info.getPartitionName(), true);
            } else {
                olapTable.dropPartition(info.getDbId(), info.getPartitionName(), info.isForceDrop());
            }
        }
        finally {
            olapTable.writeUnlock();
        }
    }

    public void replayErasePartition(long partitionId) {
        Catalog.getCurrentRecycleBin().replayErasePartition(partitionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayRecoverPartition(RecoverInfo info) throws MetaNotFoundException {
        Database db = this.getDbOrMetaException(info.getDbId());
        OlapTable olapTable = (OlapTable)db.getTableOrMetaException(info.getTableId(), Table.TableType.OLAP);
        olapTable.writeLock();
        try {
            Catalog.getCurrentRecycleBin().replayRecoverPartition(olapTable, info.getPartitionId());
        }
        finally {
            olapTable.writeUnlock();
        }
    }

    private Partition createPartitionWithIndices(String clusterName, long dbId, long tableId, long baseIndexId, long partitionId, String partitionName, Map<Long, MaterializedIndexMeta> indexIdToMeta, DistributionInfo distributionInfo, TStorageMedium storageMedium, ReplicaAllocation replicaAlloc, Long versionInfo, Set<String> bfColumns, double bfFpp, Set<Long> tabletIdSet, List<Index> indexes, boolean isInMemory, TStorageFormat storageFormat, TTabletType tabletType, TCompressionType compressionType, DataSortInfo dataSortInfo) throws DdlException {
        Preconditions.checkArgument((baseIndexId != -1L ? 1 : 0) != 0);
        MaterializedIndex baseIndex = new MaterializedIndex(baseIndexId, MaterializedIndex.IndexState.NORMAL);
        Partition partition = new Partition(partitionId, partitionName, baseIndex, distributionInfo);
        HashMap<Long, MaterializedIndex> indexMap = new HashMap<Long, MaterializedIndex>();
        indexMap.put(baseIndexId, baseIndex);
        for (long indexId : indexIdToMeta.keySet()) {
            if (indexId == baseIndexId) continue;
            MaterializedIndex rollup = new MaterializedIndex(indexId, MaterializedIndex.IndexState.NORMAL);
            indexMap.put(indexId, rollup);
        }
        if (versionInfo != null) {
            partition.updateVisibleVersion(versionInfo);
        }
        long version = partition.getVisibleVersion();
        short totalReplicaNum = replicaAlloc.getTotalReplicaNum();
        for (Map.Entry entry : indexMap.entrySet()) {
            long indexId = (Long)entry.getKey();
            MaterializedIndex index = (MaterializedIndex)entry.getValue();
            MaterializedIndexMeta indexMeta = indexIdToMeta.get(indexId);
            int schemaHash = indexMeta.getSchemaHash();
            TabletMeta tabletMeta = new TabletMeta(dbId, tableId, partitionId, indexId, schemaHash, storageMedium);
            this.createTablets(clusterName, index, Replica.ReplicaState.NORMAL, distributionInfo, version, replicaAlloc, tabletMeta, tabletIdSet);
            boolean ok = false;
            String errMsg = null;
            short shortKeyColumnCount = indexMeta.getShortKeyColumnCount();
            TStorageType storageType = indexMeta.getStorageType();
            List<Column> schema = indexMeta.getSchema();
            KeysType keysType = indexMeta.getKeysType();
            int totalTaskNum = index.getTablets().size() * totalReplicaNum;
            MarkedCountDownLatch<Long, Long> countDownLatch = new MarkedCountDownLatch<Long, Long>(totalTaskNum);
            AgentBatchTask batchTask = new AgentBatchTask();
            for (Tablet tablet : index.getTablets()) {
                long tabletId = tablet.getId();
                for (Replica replica : tablet.getReplicas()) {
                    long backendId = replica.getBackendId();
                    countDownLatch.addMark(backendId, tabletId);
                    CreateReplicaTask task = new CreateReplicaTask(backendId, dbId, tableId, partitionId, indexId, tabletId, shortKeyColumnCount, schemaHash, version, keysType, storageType, storageMedium, schema, bfColumns, bfFpp, countDownLatch, indexes, isInMemory, tabletType, dataSortInfo, compressionType);
                    task.setStorageFormat(storageFormat);
                    batchTask.addTask(task);
                    AgentTaskQueue.addTask(task);
                }
            }
            AgentTaskExecutor.submit(batchTask);
            long timeout = (long)Config.tablet_create_timeout_second * 1000L * (long)totalTaskNum;
            timeout = Math.min(timeout, (long)(Config.max_create_table_timeout_second * 1000));
            try {
                ok = countDownLatch.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOG.warn("InterruptedException: ", (Throwable)e);
                ok = false;
            }
            if (!ok || !countDownLatch.getStatus().ok()) {
                errMsg = "Failed to create partition[" + partitionName + "]. Timeout.";
                AgentTaskQueue.removeBatchTask(batchTask, TTaskType.CREATE);
                if (!countDownLatch.getStatus().ok()) {
                    errMsg = errMsg + " Error: " + countDownLatch.getStatus().getErrorMsg();
                } else {
                    List unfinishedMarks = countDownLatch.getLeftMarks();
                    List subList = unfinishedMarks.subList(0, Math.min(unfinishedMarks.size(), 3));
                    if (!subList.isEmpty()) {
                        errMsg = errMsg + " Unfinished mark: " + Joiner.on((String)", ").join(subList);
                    }
                }
                LOG.warn(errMsg);
                throw new DdlException(errMsg);
            }
            if (index.getId() == baseIndexId) continue;
            partition.createRollupIndex(index);
        }
        return partition;
    }

    private void createOlapTable(Database db, CreateTableStmt stmt) throws UserException {
        TTabletType tabletType;
        String tableName = stmt.getTableName();
        LOG.debug("begin create olap table: {}", (Object)tableName);
        List<Column> baseSchema = stmt.getColumns();
        this.validateColumns(baseSchema);
        PartitionDesc partitionDesc = stmt.getPartitionDesc();
        PartitionInfo partitionInfo = null;
        HashMap partitionNameToId = Maps.newHashMap();
        if (partitionDesc != null) {
            PartitionDesc partDesc = partitionDesc;
            for (SinglePartitionDesc desc : partDesc.getSinglePartitionDescs()) {
                long partitionId = this.getNextId();
                partitionNameToId.put(desc.getPartitionName(), partitionId);
            }
            partitionInfo = partitionDesc.toPartitionInfo(baseSchema, partitionNameToId, false);
        } else {
            if (DynamicPartitionUtil.checkDynamicPartitionPropertiesExist(stmt.getProperties())) {
                throw new DdlException("Only support dynamic partition properties on range partition table");
            }
            long partitionId = this.getNextId();
            partitionNameToId.put(tableName, partitionId);
            partitionInfo = new SinglePartitionInfo();
        }
        KeysDesc keysDesc = stmt.getKeysDesc();
        Preconditions.checkNotNull((Object)keysDesc);
        KeysType keysType = keysDesc.getKeysType();
        DistributionDesc distributionDesc = stmt.getDistributionDesc();
        Preconditions.checkNotNull((Object)distributionDesc);
        DistributionInfo defaultDistributionInfo = distributionDesc.toDistributionInfo(baseSchema);
        short shortKeyColumnCount = Catalog.calcShortKeyColumnCount(baseSchema, stmt.getProperties());
        LOG.debug("create table[{}] short key column count: {}", (Object)tableName, (Object)shortKeyColumnCount);
        TableIndexes indexes = new TableIndexes(stmt.getIndexes());
        long tableId = Catalog.getCurrentCatalog().getNextId();
        OlapTable olapTable = new OlapTable(tableId, tableName, baseSchema, keysType, partitionInfo, defaultDistributionInfo, indexes);
        olapTable.setComment(stmt.getComment());
        long baseIndexId = this.getNextId();
        olapTable.setBaseIndexId(baseIndexId);
        Map<String, String> properties = stmt.getProperties();
        TStorageFormat storageFormat = TStorageFormat.V2;
        try {
            storageFormat = PropertyAnalyzer.analyzeStorageFormat(properties);
        }
        catch (AnalysisException e) {
            throw new DdlException(e.getMessage());
        }
        olapTable.setStorageFormat(storageFormat);
        TCompressionType compressionType = TCompressionType.LZ4;
        try {
            compressionType = PropertyAnalyzer.analyzeCompressionType(properties);
        }
        catch (AnalysisException e) {
            throw new DdlException(e.getMessage());
        }
        olapTable.setCompressionType(compressionType);
        DataSortInfo dataSortInfo = PropertyAnalyzer.analyzeDataSortInfo(properties, keysType, keysDesc.keysColumnSize(), storageFormat);
        olapTable.setDataSortInfo(dataSortInfo);
        Set<String> bfColumns = null;
        double bfFpp = 0.0;
        try {
            bfColumns = PropertyAnalyzer.analyzeBloomFilterColumns(properties, baseSchema, keysType);
            if (bfColumns != null && bfColumns.isEmpty()) {
                bfColumns = null;
            }
            bfFpp = PropertyAnalyzer.analyzeBloomFilterFpp(properties);
            if (bfColumns != null && bfFpp == 0.0) {
                bfFpp = FeConstants.default_bloom_filter_fpp;
            } else if (bfColumns == null) {
                bfFpp = 0.0;
            }
            olapTable.setBloomFilterInfo(bfColumns, bfFpp);
        }
        catch (AnalysisException e) {
            throw new DdlException(e.getMessage());
        }
        ReplicaAllocation replicaAlloc = PropertyAnalyzer.analyzeReplicaAllocation(properties, "");
        if (replicaAlloc.isNotSet()) {
            replicaAlloc = ReplicaAllocation.DEFAULT_ALLOCATION;
        }
        olapTable.setReplicationAllocation(replicaAlloc);
        boolean isInMemory = PropertyAnalyzer.analyzeBooleanProp(properties, "in_memory", false);
        olapTable.setIsInMemory(isInMemory);
        try {
            tabletType = PropertyAnalyzer.analyzeTabletType(properties);
        }
        catch (AnalysisException e) {
            throw new DdlException(e.getMessage());
        }
        if (partitionInfo.getType() == PartitionType.UNPARTITIONED) {
            long partitionId = (Long)partitionNameToId.get(tableName);
            DataProperty dataProperty = null;
            try {
                dataProperty = PropertyAnalyzer.analyzeDataProperty(stmt.getProperties(), DataProperty.DEFAULT_DATA_PROPERTY);
            }
            catch (AnalysisException e) {
                throw new DdlException(e.getMessage());
            }
            Preconditions.checkNotNull((Object)dataProperty);
            partitionInfo.setDataProperty(partitionId, dataProperty);
            partitionInfo.setReplicaAllocation(partitionId, replicaAlloc);
            partitionInfo.setIsInMemory(partitionId, isInMemory);
            partitionInfo.setTabletType(partitionId, tabletType);
        }
        try {
            String colocateGroup = PropertyAnalyzer.analyzeColocate(properties);
            if (colocateGroup != null) {
                if (defaultDistributionInfo.getType() == DistributionInfo.DistributionInfoType.RANDOM) {
                    throw new AnalysisException("Random distribution for colocate table is unsupported");
                }
                String fullGroupName = db.getId() + "_" + colocateGroup;
                ColocateGroupSchema groupSchema = this.colocateTableIndex.getGroupSchema(fullGroupName);
                if (groupSchema != null) {
                    groupSchema.checkColocateSchema(olapTable);
                }
                this.getColocateTableIndex().addTableToGroup(db.getId(), olapTable, colocateGroup, null);
                olapTable.setColocateGroup(colocateGroup);
            }
        }
        catch (AnalysisException e) {
            throw new DdlException(e.getMessage());
        }
        TStorageType baseIndexStorageType = null;
        try {
            baseIndexStorageType = PropertyAnalyzer.analyzeStorageType(properties);
        }
        catch (AnalysisException e) {
            throw new DdlException(e.getMessage());
        }
        Preconditions.checkNotNull((Object)baseIndexStorageType);
        int schemaVersion = 0;
        try {
            schemaVersion = PropertyAnalyzer.analyzeSchemaVersion(properties);
        }
        catch (AnalysisException e) {
            throw new DdlException(e.getMessage());
        }
        int schemaHash = Util.generateSchemaHash();
        olapTable.setIndexMeta(baseIndexId, tableName, baseSchema, schemaVersion, schemaHash, shortKeyColumnCount, baseIndexStorageType, keysType);
        for (AlterClause alterClause : stmt.getRollupAlterClauseList()) {
            AddRollupClause addRollupClause = (AddRollupClause)alterClause;
            Long baseRollupIndex = olapTable.getIndexIdByName(tableName);
            TStorageType rollupIndexStorageType = null;
            try {
                rollupIndexStorageType = PropertyAnalyzer.analyzeStorageType(addRollupClause.getProperties());
            }
            catch (AnalysisException e) {
                throw new DdlException(e.getMessage());
            }
            Preconditions.checkNotNull((Object)rollupIndexStorageType);
            List<Column> rollupColumns = this.getMaterializedViewHandler().checkAndPrepareMaterializedView(addRollupClause, olapTable, baseRollupIndex, false);
            short rollupShortKeyColumnCount = Catalog.calcShortKeyColumnCount(rollupColumns, alterClause.getProperties());
            int rollupSchemaHash = Util.generateSchemaHash();
            long rollupIndexId = Catalog.getCurrentCatalog().getNextId();
            olapTable.setIndexMeta(rollupIndexId, addRollupClause.getRollupName(), rollupColumns, schemaVersion, rollupSchemaHash, rollupShortKeyColumnCount, rollupIndexStorageType, keysType);
        }
        Type sequenceColType = null;
        try {
            sequenceColType = PropertyAnalyzer.analyzeSequenceType(properties, olapTable.getKeysType());
            if (sequenceColType != null) {
                olapTable.setSequenceInfo(sequenceColType);
            }
        }
        catch (Exception e) {
            throw new DdlException(e.getMessage());
        }
        Long versionInfo = null;
        try {
            versionInfo = PropertyAnalyzer.analyzeVersionInfo(properties);
        }
        catch (AnalysisException e) {
            throw new DdlException(e.getMessage());
        }
        Preconditions.checkNotNull((Object)versionInfo);
        HashSet<Long> tabletIdSet = new HashSet<Long>();
        try {
            long replicaNum;
            if (partitionInfo.getType() == PartitionType.UNPARTITIONED) {
                long bucketNum;
                DistributionInfo partitionDistributionInfo = distributionDesc.toDistributionInfo(baseSchema);
                String partitionName = tableName;
                long partitionId = (Long)partitionNameToId.get(partitionName);
                long indexNum = olapTable.getIndexIdToMeta().size();
                long totalReplicaNum = indexNum * (bucketNum = (long)partitionDistributionInfo.getBucketNum()) * (replicaNum = (long)partitionInfo.getReplicaAllocation(partitionId).getTotalReplicaNum());
                if (totalReplicaNum >= db.getReplicaQuotaLeftWithLock()) {
                    throw new DdlException("Database " + db.getFullName() + " create unpartitioned table " + tableName + " increasing " + totalReplicaNum + " of replica exceeds quota[" + db.getReplicaQuota() + "]");
                }
                Partition partition = this.createPartitionWithIndices(db.getClusterName(), db.getId(), olapTable.getId(), olapTable.getBaseIndexId(), partitionId, partitionName, olapTable.getIndexIdToMeta(), partitionDistributionInfo, partitionInfo.getDataProperty(partitionId).getStorageMedium(), partitionInfo.getReplicaAllocation(partitionId), versionInfo, bfColumns, bfFpp, tabletIdSet, olapTable.getCopiedIndexes(), isInMemory, storageFormat, tabletType, compressionType, olapTable.getDataSortInfo());
                olapTable.addPartition(partition);
            } else if (partitionInfo.getType() == PartitionType.RANGE || partitionInfo.getType() == PartitionType.LIST) {
                try {
                    PropertyAnalyzer.analyzeDataProperty(stmt.getProperties(), DataProperty.DEFAULT_DATA_PROPERTY);
                    if (partitionInfo.getType() == PartitionType.RANGE) {
                        DynamicPartitionUtil.checkAndSetDynamicPartitionProperty(olapTable, properties);
                    } else if (partitionInfo.getType() == PartitionType.LIST && DynamicPartitionUtil.checkDynamicPartitionPropertiesExist(properties)) {
                        throw new DdlException("Only support dynamic partition properties on range partition table");
                    }
                    if (properties != null && !properties.isEmpty()) {
                        throw new DdlException("Unknown properties: " + properties);
                    }
                }
                catch (AnalysisException e) {
                    throw new DdlException(e.getMessage());
                }
                long totalReplicaNum = 0L;
                for (Map.Entry entry : partitionNameToId.entrySet()) {
                    long indexNum = olapTable.getIndexIdToMeta().size();
                    long bucketNum = defaultDistributionInfo.getBucketNum();
                    replicaNum = partitionInfo.getReplicaAllocation((Long)entry.getValue()).getTotalReplicaNum();
                    totalReplicaNum += indexNum * bucketNum * replicaNum;
                }
                if (totalReplicaNum >= db.getReplicaQuotaLeftWithLock()) {
                    throw new DdlException("Database " + db.getFullName() + " create table " + tableName + " increasing " + totalReplicaNum + " of replica exceeds quota[" + db.getReplicaQuota() + "]");
                }
                for (Map.Entry entry : partitionNameToId.entrySet()) {
                    DataProperty dataProperty = partitionInfo.getDataProperty((Long)entry.getValue());
                    DistributionInfo partitionDistributionInfo = distributionDesc.toDistributionInfo(baseSchema);
                    Partition partition = this.createPartitionWithIndices(db.getClusterName(), db.getId(), olapTable.getId(), olapTable.getBaseIndexId(), (Long)entry.getValue(), (String)entry.getKey(), olapTable.getIndexIdToMeta(), partitionDistributionInfo, dataProperty.getStorageMedium(), partitionInfo.getReplicaAllocation((Long)entry.getValue()), versionInfo, bfColumns, bfFpp, tabletIdSet, olapTable.getCopiedIndexes(), isInMemory, storageFormat, partitionInfo.getTabletType((Long)entry.getValue()), compressionType, olapTable.getDataSortInfo());
                    olapTable.addPartition(partition);
                }
            } else {
                throw new DdlException("Unsupported partition method: " + partitionInfo.getType().name());
            }
            Pair<Boolean, Boolean> result = db.createTableWithLock(olapTable, false, stmt.isSetIfNotExists());
            if (!((Boolean)result.first).booleanValue()) {
                ErrorReport.reportDdlException(ErrorCode.ERR_TABLE_EXISTS_ERROR, tableName);
            }
            if (((Boolean)result.second).booleanValue()) {
                if (this.getColocateTableIndex().isColocateTable(tableId)) {
                    this.getColocateTableIndex().removeTable(tableId);
                }
                for (Long tabletId : tabletIdSet) {
                    Catalog.getCurrentInvertedIndex().deleteTablet(tabletId);
                }
                LOG.info("duplicate create table[{};{}], skip next steps", (Object)tableName, (Object)tableId);
            } else {
                if (this.getColocateTableIndex().isColocateTable(tableId)) {
                    ColocateTableIndex.GroupId groupId = this.getColocateTableIndex().getGroup(tableId);
                    Map<Tag, List<List<Long>>> backendsPerBucketSeq = this.getColocateTableIndex().getBackendsPerBucketSeq(groupId);
                    ColocatePersistInfo info = ColocatePersistInfo.createForAddTable(groupId, tableId, backendsPerBucketSeq);
                    this.editLog.logColocateAddTable(info);
                }
                LOG.info("successfully create table[{};{}]", (Object)tableName, (Object)tableId);
                DynamicPartitionUtil.registerOrRemoveDynamicPartitionTable(db.getId(), olapTable, false);
                this.dynamicPartitionScheduler.createOrUpdateRuntimeInfo(tableId, "lastUpdateTime", TimeUtils.getCurrentFormatTime());
            }
        }
        catch (DdlException e) {
            for (Long tabletId : tabletIdSet) {
                Catalog.getCurrentInvertedIndex().deleteTablet(tabletId);
            }
            if (this.getColocateTableIndex().isColocateTable(tableId)) {
                this.getColocateTableIndex().removeTable(tableId);
            }
            throw e;
        }
    }

    private void createMysqlTable(Database db, CreateTableStmt stmt) throws DdlException {
        String tableName = stmt.getTableName();
        List<Column> columns = stmt.getColumns();
        long tableId = Catalog.getCurrentCatalog().getNextId();
        MysqlTable mysqlTable = new MysqlTable(tableId, tableName, columns, stmt.getProperties());
        mysqlTable.setComment(stmt.getComment());
        if (!((Boolean)db.createTableWithLock((Table)mysqlTable, (boolean)false, (boolean)stmt.isSetIfNotExists()).first).booleanValue()) {
            ErrorReport.reportDdlException(ErrorCode.ERR_TABLE_EXISTS_ERROR, tableName);
        }
        LOG.info("successfully create table[{}-{}]", (Object)tableName, (Object)tableId);
    }

    private void createOdbcTable(Database db, CreateTableStmt stmt) throws DdlException {
        String tableName = stmt.getTableName();
        List<Column> columns = stmt.getColumns();
        long tableId = Catalog.getCurrentCatalog().getNextId();
        OdbcTable odbcTable = new OdbcTable(tableId, tableName, columns, stmt.getProperties());
        odbcTable.setComment(stmt.getComment());
        if (!((Boolean)db.createTableWithLock((Table)odbcTable, (boolean)false, (boolean)stmt.isSetIfNotExists()).first).booleanValue()) {
            ErrorReport.reportDdlException(ErrorCode.ERR_TABLE_EXISTS_ERROR, tableName);
        }
        LOG.info("successfully create table[{}-{}]", (Object)tableName, (Object)tableId);
    }

    private Table createEsTable(Database db, CreateTableStmt stmt) throws DdlException {
        String tableName = stmt.getTableName();
        List<Column> baseSchema = stmt.getColumns();
        this.validateColumns(baseSchema);
        PartitionDesc partitionDesc = stmt.getPartitionDesc();
        PartitionInfo partitionInfo = null;
        HashMap partitionNameToId = Maps.newHashMap();
        if (partitionDesc != null) {
            partitionInfo = partitionDesc.toPartitionInfo(baseSchema, partitionNameToId, false);
        } else {
            long partitionId = this.getNextId();
            partitionNameToId.put(tableName, partitionId);
            partitionInfo = new SinglePartitionInfo();
        }
        long tableId = Catalog.getCurrentCatalog().getNextId();
        EsTable esTable = new EsTable(tableId, tableName, baseSchema, stmt.getProperties(), partitionInfo);
        esTable.setComment(stmt.getComment());
        if (!((Boolean)db.createTableWithLock((Table)esTable, (boolean)false, (boolean)stmt.isSetIfNotExists()).first).booleanValue()) {
            ErrorReport.reportDdlException(ErrorCode.ERR_TABLE_EXISTS_ERROR, tableName);
        }
        LOG.info("successfully create table{} with id {}", (Object)tableName, (Object)tableId);
        return esTable;
    }

    private void createBrokerTable(Database db, CreateTableStmt stmt) throws DdlException {
        String tableName = stmt.getTableName();
        List<Column> columns = stmt.getColumns();
        long tableId = Catalog.getCurrentCatalog().getNextId();
        BrokerTable brokerTable = new BrokerTable(tableId, tableName, columns, stmt.getProperties());
        brokerTable.setComment(stmt.getComment());
        brokerTable.setBrokerProperties(stmt.getExtProperties());
        if (!((Boolean)db.createTableWithLock((Table)brokerTable, (boolean)false, (boolean)stmt.isSetIfNotExists()).first).booleanValue()) {
            ErrorReport.reportDdlException(ErrorCode.ERR_TABLE_EXISTS_ERROR, tableName);
        }
        LOG.info("successfully create table[{}-{}]", (Object)tableName, (Object)tableId);
    }

    private void createHiveTable(Database db, CreateTableStmt stmt) throws DdlException {
        String tableName = stmt.getTableName();
        List<Column> columns = stmt.getColumns();
        long tableId = this.getNextId();
        HiveTable hiveTable = new HiveTable(tableId, tableName, columns, stmt.getProperties());
        hiveTable.setComment(stmt.getComment());
        HiveMetaStoreClient hiveMetaStoreClient = HiveMetaStoreClientHelper.getClient(hiveTable.getHiveProperties().get("hive.metastore.uris"));
        if (!HiveMetaStoreClientHelper.tableExists(hiveMetaStoreClient, hiveTable.getHiveDb(), hiveTable.getHiveTable())) {
            throw new DdlException(String.format("Table [%s] dose not exist in Hive.", hiveTable.getHiveDbTable()));
        }
        if (!((Boolean)db.createTableWithLock((Table)hiveTable, (boolean)false, (boolean)stmt.isSetIfNotExists()).first).booleanValue()) {
            ErrorReport.reportDdlException(ErrorCode.ERR_TABLE_EXISTS_ERROR, tableName);
        }
        LOG.info("successfully create table[{}-{}]", (Object)tableName, (Object)tableId);
    }

    public static void getDdlStmt(Table table, List<String> createTableStmt, List<String> addPartitionStmt, List<String> createRollupStmt, boolean separatePartition, boolean hidePassword) {
        Catalog.getDdlStmt(null, null, table, createTableStmt, addPartitionStmt, createRollupStmt, separatePartition, hidePassword, false);
    }

    public static void getDdlStmt(DdlStmt ddlStmt, String dbName, Table table, List<String> createTableStmt, List<String> addPartitionStmt, List<String> createRollupStmt, boolean separatePartition, boolean hidePassword, boolean getDdlForLike) {
        OlapTable olapTable;
        StringBuilder sb = new StringBuilder();
        if (table.getType() == Table.TableType.VIEW) {
            View view = (View)table;
            sb.append("CREATE VIEW `").append(table.getName()).append("` AS ").append(view.getInlineViewDef());
            sb.append(";");
            createTableStmt.add(sb.toString());
            return;
        }
        sb.append("CREATE ");
        if (table.getType() == Table.TableType.ODBC || table.getType() == Table.TableType.MYSQL || table.getType() == Table.TableType.ELASTICSEARCH || table.getType() == Table.TableType.BROKER || table.getType() == Table.TableType.HIVE) {
            sb.append("EXTERNAL ");
        }
        sb.append("TABLE ");
        if (!Strings.isNullOrEmpty((String)dbName)) {
            sb.append("`").append(dbName).append("`.");
        }
        sb.append("`").append(table.getName()).append("` (\n");
        int idx = 0;
        List<Column> columns = getDdlForLike ? table.getBaseSchema(false) : table.getBaseSchema();
        for (Column column : columns) {
            if (idx++ != 0) {
                sb.append(",\n");
            }
            if (table.getType() == Table.TableType.OLAP) {
                sb.append("  ").append(column.toSql(((OlapTable)table).getKeysType() == KeysType.UNIQUE_KEYS));
                continue;
            }
            sb.append("  ").append(column.toSql());
        }
        if (table.getType() == Table.TableType.OLAP && CollectionUtils.isNotEmpty((olapTable = (OlapTable)table).getIndexes())) {
            for (Index index : olapTable.getIndexes()) {
                sb.append(",\n");
                sb.append("  ").append(index.toSql());
            }
        }
        sb.append("\n) ENGINE=");
        sb.append(table.getType().name());
        if (table.getType() == Table.TableType.OLAP) {
            String colocateTable;
            olapTable = (OlapTable)table;
            sb.append("\n").append(olapTable.getKeysType().toSql()).append("(");
            ArrayList arrayList = Lists.newArrayList();
            for (Column column : olapTable.getBaseSchema()) {
                if (!column.isKey()) continue;
                arrayList.add("`" + column.getName() + "`");
            }
            sb.append(Joiner.on((String)", ").join((Iterable)arrayList)).append(")");
            if (!Strings.isNullOrEmpty((String)table.getComment())) {
                sb.append("\nCOMMENT \"").append(table.getComment(true)).append("\"");
            }
            PartitionInfo partitionInfo = olapTable.getPartitionInfo();
            Iterator<Map.Entry<Long, PartitionItem>> partitionId = null;
            if (separatePartition) {
                partitionId = Lists.newArrayList();
            }
            if (partitionInfo.getType() == PartitionType.RANGE || partitionInfo.getType() == PartitionType.LIST) {
                sb.append("\n").append(partitionInfo.toSql(olapTable, (List<Long>)((Object)partitionId)));
            }
            DistributionInfo distributionInfo = olapTable.getDefaultDistributionInfo();
            sb.append("\n").append(distributionInfo.toSql());
            if (ddlStmt instanceof CreateTableLikeStmt) {
                CreateTableLikeStmt stmt = (CreateTableLikeStmt)ddlStmt;
                ArrayList<String> rollupNames = stmt.getRollupNames();
                boolean withAllRollup = stmt.isWithAllRollup();
                List<Object> addIndexIdList = Lists.newArrayList();
                if (!CollectionUtils.isEmpty(rollupNames)) {
                    for (String rollupName : rollupNames) {
                        addIndexIdList.add(olapTable.getIndexIdByName(rollupName));
                    }
                } else if (withAllRollup) {
                    addIndexIdList = olapTable.getIndexIdListExceptBaseIndex();
                }
                if (!addIndexIdList.isEmpty()) {
                    sb.append("\n").append("rollup (");
                }
                int size = addIndexIdList.size();
                int index = 1;
                Iterator<Object> iterator = addIndexIdList.iterator();
                while (iterator.hasNext()) {
                    long indexId = (Long)iterator.next();
                    String indexName = olapTable.getIndexNameById(indexId);
                    sb.append("\n").append(indexName).append("(");
                    List<Column> indexSchema = olapTable.getSchemaByIndexId(indexId, false);
                    for (int i = 0; i < indexSchema.size(); ++i) {
                        Column column = indexSchema.get(i);
                        sb.append(column.getName());
                        if (i == indexSchema.size() - 1) continue;
                        sb.append(", ");
                    }
                    if (index != size) {
                        sb.append("),");
                    } else {
                        sb.append(")");
                        sb.append("\n)");
                    }
                    ++index;
                }
            }
            sb.append("\nPROPERTIES (\n");
            ReplicaAllocation replicaAlloc = olapTable.getDefaultReplicaAllocation();
            sb.append("\"").append("replication_allocation").append("\" = \"");
            sb.append(replicaAlloc.toCreateStmt()).append("\"");
            Set<String> bfColumnNames = olapTable.getCopiedBfColumns();
            if (bfColumnNames != null) {
                sb.append(",\n\"").append("bloom_filter_columns").append("\" = \"");
                sb.append(Joiner.on((String)", ").join(olapTable.getCopiedBfColumns())).append("\"");
            }
            if (separatePartition) {
                sb.append(",\n\"").append("version_info").append("\" = \"");
                Partition partition = null;
                if (olapTable.getPartitionInfo().getType() == PartitionType.UNPARTITIONED) {
                    partition = olapTable.getPartition(olapTable.getName());
                } else {
                    Preconditions.checkState((partitionId.size() == 1 ? 1 : 0) != 0);
                    partition = olapTable.getPartition((Long)partitionId.get(0));
                }
                sb.append(partition.getVisibleVersion()).append("\"");
            }
            if ((colocateTable = olapTable.getColocateGroup()) != null) {
                sb.append(",\n\"").append("colocate_with").append("\" = \"");
                sb.append(colocateTable).append("\"");
            }
            if (olapTable.dynamicPartitionExists()) {
                sb.append(olapTable.getTableProperty().getDynamicPartitionProperty().getProperties(replicaAlloc));
            }
            if (olapTable.isZOrderSort()) {
                sb.append(olapTable.getDataSortInfo().toSql());
            }
            sb.append(",\n\"").append("in_memory").append("\" = \"");
            sb.append(olapTable.isInMemory()).append("\"");
            sb.append(",\n\"").append("storage_format").append("\" = \"");
            sb.append(olapTable.getStorageFormat()).append("\"");
            if (olapTable.getCompressionType() != TCompressionType.LZ4F) {
                sb.append(",\n\"").append("compression").append("\" = \"");
                sb.append(olapTable.getCompressionType()).append("\"");
            }
            sb.append("\n)");
        } else if (table.getType() == Table.TableType.MYSQL) {
            MysqlTable mysqlTable = (MysqlTable)table;
            if (!Strings.isNullOrEmpty((String)table.getComment())) {
                sb.append("\nCOMMENT \"").append(table.getComment(true)).append("\"");
            }
            sb.append("\nPROPERTIES (\n");
            if (mysqlTable.getOdbcCatalogResourceName() == null) {
                sb.append("\"host\" = \"").append(mysqlTable.getHost()).append("\",\n");
                sb.append("\"port\" = \"").append(mysqlTable.getPort()).append("\",\n");
                sb.append("\"user\" = \"").append(mysqlTable.getUserName()).append("\",\n");
                sb.append("\"password\" = \"").append(hidePassword ? "" : mysqlTable.getPasswd()).append("\",\n");
            } else {
                sb.append("\"odbc_catalog_resource\" = \"").append(mysqlTable.getOdbcCatalogResourceName()).append("\",\n");
            }
            sb.append("\"database\" = \"").append(mysqlTable.getMysqlDatabaseName()).append("\",\n");
            sb.append("\"table\" = \"").append(mysqlTable.getMysqlTableName()).append("\"\n");
            sb.append(")");
        } else if (table.getType() == Table.TableType.ODBC) {
            OdbcTable odbcTable = (OdbcTable)table;
            if (!Strings.isNullOrEmpty((String)table.getComment())) {
                sb.append("\nCOMMENT \"").append(table.getComment(true)).append("\"");
            }
            sb.append("\nPROPERTIES (\n");
            if (odbcTable.getOdbcCatalogResourceName() == null) {
                sb.append("\"host\" = \"").append(odbcTable.getHost()).append("\",\n");
                sb.append("\"port\" = \"").append(odbcTable.getPort()).append("\",\n");
                sb.append("\"user\" = \"").append(odbcTable.getUserName()).append("\",\n");
                sb.append("\"password\" = \"").append(hidePassword ? "" : odbcTable.getPasswd()).append("\",\n");
                sb.append("\"driver\" = \"").append(odbcTable.getOdbcDriver()).append("\",\n");
                sb.append("\"odbc_type\" = \"").append(odbcTable.getOdbcTableTypeName()).append("\",\n");
            } else {
                sb.append("\"odbc_catalog_resource\" = \"").append(odbcTable.getOdbcCatalogResourceName()).append("\",\n");
            }
            sb.append("\"database\" = \"").append(odbcTable.getOdbcDatabaseName()).append("\",\n");
            sb.append("\"table\" = \"").append(odbcTable.getOdbcTableName()).append("\"\n");
            sb.append(")");
        } else if (table.getType() == Table.TableType.BROKER) {
            BrokerTable brokerTable = (BrokerTable)table;
            if (!Strings.isNullOrEmpty((String)table.getComment())) {
                sb.append("\nCOMMENT \"").append(table.getComment(true)).append("\"");
            }
            sb.append("\nPROPERTIES (\n");
            sb.append("\"broker_name\" = \"").append(brokerTable.getBrokerName()).append("\",\n");
            sb.append("\"path\" = \"").append(Joiner.on((String)",").join(brokerTable.getEncodedPaths())).append("\",\n");
            sb.append("\"column_separator\" = \"").append(brokerTable.getReadableColumnSeparator()).append("\",\n");
            sb.append("\"line_delimiter\" = \"").append(brokerTable.getReadableLineDelimiter()).append("\",\n");
            sb.append(")");
            if (!brokerTable.getBrokerProperties().isEmpty()) {
                sb.append("\nBROKER PROPERTIES (\n");
                sb.append(new PrintableMap<String, String>(brokerTable.getBrokerProperties(), " = ", true, true, hidePassword).toString());
                sb.append("\n)");
            }
        } else if (table.getType() == Table.TableType.ELASTICSEARCH) {
            PartitionInfo partitionInfo;
            EsTable esTable = (EsTable)table;
            if (!Strings.isNullOrEmpty((String)table.getComment())) {
                sb.append("\nCOMMENT \"").append(table.getComment(true)).append("\"");
            }
            if ((partitionInfo = esTable.getPartitionInfo()).getType() == PartitionType.RANGE) {
                sb.append("\n");
                sb.append("PARTITION BY RANGE(");
                RangePartitionInfo rangePartitionInfo = (RangePartitionInfo)partitionInfo;
                for (Column column : rangePartitionInfo.getPartitionColumns()) {
                    sb.append("`").append(column.getName()).append("`");
                }
                sb.append(")\n()");
            }
            sb.append("\nPROPERTIES (\n");
            sb.append("\"hosts\" = \"").append(esTable.getHosts()).append("\",\n");
            sb.append("\"user\" = \"").append(esTable.getUserName()).append("\",\n");
            sb.append("\"password\" = \"").append(hidePassword ? "" : esTable.getPasswd()).append("\",\n");
            sb.append("\"index\" = \"").append(esTable.getIndexName()).append("\",\n");
            if (esTable.getMappingType() != null) {
                sb.append("\"type\" = \"").append(esTable.getMappingType()).append("\",\n");
            }
            sb.append("\"transport\" = \"").append(esTable.getTransport()).append("\",\n");
            sb.append("\"enable_docvalue_scan\" = \"").append(esTable.isDocValueScanEnable()).append("\",\n");
            sb.append("\"max_docvalue_fields\" = \"").append(esTable.maxDocValueFields()).append("\",\n");
            sb.append("\"enable_keyword_sniff\" = \"").append(esTable.isKeywordSniffEnable()).append("\",\n");
            sb.append("\"nodes_discovery\" = \"").append(esTable.isNodesDiscovery()).append("\",\n");
            sb.append("\"http_ssl_enabled\" = \"").append(esTable.isHttpSslEnabled()).append("\"\n");
            sb.append(")");
        } else if (table.getType() == Table.TableType.HIVE) {
            HiveTable hiveTable = (HiveTable)table;
            if (!Strings.isNullOrEmpty((String)table.getComment())) {
                sb.append("\nCOMMENT \"").append(table.getComment(true)).append("\"");
            }
            sb.append("\nPROPERTIES (\n");
            sb.append("\"database\" = \"").append(hiveTable.getHiveDb()).append("\",\n");
            sb.append("\"table\" = \"").append(hiveTable.getHiveTable()).append("\",\n");
            sb.append(new PrintableMap<String, String>(hiveTable.getHiveProperties(), " = ", true, true, false).toString());
            sb.append("\n)");
        } else if (table.getType() == Table.TableType.ICEBERG) {
            IcebergTable icebergTable = (IcebergTable)table;
            if (!Strings.isNullOrEmpty((String)table.getComment())) {
                sb.append("\nCOMMENT \"").append(table.getComment(true)).append("\"");
            }
            sb.append("\nPROPERTIES (\n");
            sb.append("\"iceberg.database\" = \"").append(icebergTable.getIcebergDb()).append("\",\n");
            sb.append("\"iceberg.table\" = \"").append(icebergTable.getIcebergTbl()).append("\",\n");
            sb.append(new PrintableMap<String, String>(icebergTable.getIcebergProperties(), " = ", true, true, false).toString());
            sb.append("\n)");
        }
        createTableStmt.add(sb.toString());
        if (separatePartition && table instanceof OlapTable && ((OlapTable)table).getPartitions().size() > 1 && (((OlapTable)table).getPartitionInfo().getType() == PartitionType.RANGE || ((OlapTable)table).getPartitionInfo().getType() == PartitionType.LIST)) {
            olapTable = (OlapTable)table;
            PartitionInfo partitionInfo = olapTable.getPartitionInfo();
            boolean bl = true;
            for (Map.Entry<Long, PartitionItem> entry : partitionInfo.getPartitionItemEntryList(false, true)) {
                boolean bl2;
                if (bl2) {
                    bl2 = false;
                    continue;
                }
                sb = new StringBuilder();
                Partition partition = olapTable.getPartition(entry.getKey());
                sb.append("ALTER TABLE ").append(table.getName());
                sb.append(" ADD PARTITION ").append(partition.getName()).append(" VALUES ");
                if (partitionInfo.getType() == PartitionType.RANGE) {
                    sb.append("[");
                    sb.append(((PartitionKey)((RangePartitionItem)entry.getValue()).getItems().lowerEndpoint()).toSql());
                    sb.append(", ");
                    sb.append(((PartitionKey)((RangePartitionItem)entry.getValue()).getItems().upperEndpoint()).toSql());
                    sb.append(")");
                } else if (partitionInfo.getType() == PartitionType.LIST) {
                    sb.append("IN (");
                    sb.append(((ListPartitionItem)entry.getValue()).toSql());
                    sb.append(")");
                }
                sb.append("(\"version_info\" = \"");
                sb.append(partition.getVisibleVersion()).append("\"");
                sb.append(");");
                addPartitionStmt.add(sb.toString());
            }
        }
        if (createRollupStmt != null && table instanceof OlapTable) {
            olapTable = (OlapTable)table;
            for (Map.Entry<Long, MaterializedIndexMeta> entry : olapTable.getIndexIdToMeta().entrySet()) {
                if (entry.getKey().longValue() == olapTable.getBaseIndexId()) continue;
                MaterializedIndexMeta materializedIndexMeta = entry.getValue();
                sb = new StringBuilder();
                String indexName = olapTable.getIndexNameById(entry.getKey());
                sb.append("ALTER TABLE ").append(table.getName()).append(" ADD ROLLUP ").append(indexName);
                sb.append("(");
                List<Column> indexSchema = materializedIndexMeta.getSchema();
                for (int i = 0; i < indexSchema.size(); ++i) {
                    Column column = indexSchema.get(i);
                    sb.append(column.getName());
                    if (i == indexSchema.size() - 1) continue;
                    sb.append(", ");
                }
                sb.append(");");
                createRollupStmt.add(sb.toString());
            }
        }
    }

    public void replayCreateTable(String dbName, Table table) throws MetaNotFoundException {
        Database db = this.fullNameToDb.get(dbName);
        try {
            db.createTableWithLock(table, true, false);
        }
        catch (DdlException e) {
            throw new MetaNotFoundException(e.getMessage());
        }
        if (!Catalog.isCheckpointThread() && table.getType() == Table.TableType.OLAP) {
            TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
            OlapTable olapTable = (OlapTable)table;
            long dbId = db.getId();
            long tableId = table.getId();
            for (Partition partition : olapTable.getAllPartitions()) {
                long partitionId = partition.getId();
                TStorageMedium medium = olapTable.getPartitionInfo().getDataProperty(partitionId).getStorageMedium();
                for (MaterializedIndex mIndex : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL)) {
                    long indexId = mIndex.getId();
                    int schemaHash = olapTable.getSchemaHashByIndexId(indexId);
                    TabletMeta tabletMeta = new TabletMeta(dbId, tableId, partitionId, indexId, schemaHash, medium);
                    for (Tablet tablet : mIndex.getTablets()) {
                        long tabletId = tablet.getId();
                        invertedIndex.addTablet(tabletId, tabletMeta);
                        for (Replica replica : tablet.getReplicas()) {
                            invertedIndex.addReplica(tabletId, replica);
                        }
                    }
                }
            }
            DynamicPartitionUtil.registerOrRemoveDynamicPartitionTable(dbId, olapTable, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayAlterExternalTableSchema(String dbName, String tableName, List<Column> newSchema) throws MetaNotFoundException {
        Database db = this.getDbOrMetaException(dbName);
        Table table = db.getTableOrMetaException(tableName);
        table.writeLock();
        try {
            table.setNewFullSchema(newSchema);
        }
        finally {
            table.writeUnlock();
        }
    }

    private void createTablets(String clusterName, MaterializedIndex index, Replica.ReplicaState replicaState, DistributionInfo distributionInfo, long version, ReplicaAllocation replicaAlloc, TabletMeta tabletMeta, Set<Long> tabletIdSet) throws DdlException {
        boolean chooseBackendsArbitrary;
        ColocateTableIndex colocateIndex = Catalog.getCurrentColocateIndex();
        Map<Tag, List<List<Long>>> backendsPerBucketSeq = null;
        ColocateTableIndex.GroupId groupId = null;
        if (colocateIndex.isColocateTable(tabletMeta.getTableId())) {
            if (distributionInfo.getType() == DistributionInfo.DistributionInfoType.RANDOM) {
                throw new DdlException("Random distribution for colocate table is unsupported");
            }
            groupId = colocateIndex.getGroup(tabletMeta.getTableId());
            backendsPerBucketSeq = colocateIndex.getBackendsPerBucketSeq(groupId);
        }
        boolean bl = chooseBackendsArbitrary = backendsPerBucketSeq == null || backendsPerBucketSeq.isEmpty();
        if (chooseBackendsArbitrary) {
            backendsPerBucketSeq = Maps.newHashMap();
        }
        for (int i = 0; i < distributionInfo.getBucketNum(); ++i) {
            Map<Object, Object> chosenBackendIds;
            Tablet tablet = new Tablet(this.getNextId());
            index.addTablet(tablet, tabletMeta);
            tabletIdSet.add(tablet.getId());
            if (chooseBackendsArbitrary) {
                chosenBackendIds = !Config.disable_storage_medium_check ? Catalog.getCurrentSystemInfo().selectBackendIdsForReplicaCreation(replicaAlloc, clusterName, tabletMeta.getStorageMedium()) : Catalog.getCurrentSystemInfo().selectBackendIdsForReplicaCreation(replicaAlloc, clusterName, null);
                for (Map.Entry<Object, Object> entry : chosenBackendIds.entrySet()) {
                    backendsPerBucketSeq.putIfAbsent((Tag)entry.getKey(), Lists.newArrayList());
                    backendsPerBucketSeq.get(entry.getKey()).add((List)entry.getValue());
                }
            } else {
                chosenBackendIds = Maps.newHashMap();
                for (Map.Entry<Tag, List<List<Long>>> entry : backendsPerBucketSeq.entrySet()) {
                    chosenBackendIds.put(entry.getKey(), entry.getValue().get(i));
                }
            }
            short totalReplicaNum = 0;
            for (List list : chosenBackendIds.values()) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    long backendId = (Long)iterator.next();
                    long replicaId = this.getNextId();
                    Replica replica = new Replica(replicaId, backendId, replicaState, version, tabletMeta.getOldSchemaHash());
                    tablet.addReplica(replica);
                    totalReplicaNum = (short)(totalReplicaNum + 1);
                }
            }
            Preconditions.checkState((totalReplicaNum == replicaAlloc.getTotalReplicaNum() ? 1 : 0) != 0, (Object)(totalReplicaNum + " vs. " + replicaAlloc.getTotalReplicaNum()));
        }
        if (groupId != null && chooseBackendsArbitrary) {
            colocateIndex.addBackendsPerBucketSeq(groupId, backendsPerBucketSeq);
            ColocatePersistInfo info = ColocatePersistInfo.createForBackendsPerBucketSeq(groupId, backendsPerBucketSeq);
            this.editLog.logColocateBackendsPerBucketSeq(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTable(DropTableStmt stmt) throws DdlException {
        String dbName = stmt.getDbName();
        String tableName = stmt.getTableName();
        Database db = this.getDbOrDdlException(dbName);
        db.writeLockOrDdlException();
        try {
            Table table = db.getTableNullable(tableName);
            if (table == null) {
                if (stmt.isSetIfExists()) {
                    LOG.info("drop table[{}] which does not exist", (Object)tableName);
                    return;
                }
                ErrorReport.reportDdlException(ErrorCode.ERR_UNKNOWN_TABLE, tableName, dbName);
            }
            if (stmt.isView()) {
                if (!(table instanceof View)) {
                    ErrorReport.reportDdlException(ErrorCode.ERR_WRONG_OBJECT, dbName, tableName, "VIEW");
                }
            } else if (table instanceof View) {
                ErrorReport.reportDdlException(ErrorCode.ERR_WRONG_OBJECT, dbName, tableName, "TABLE");
            }
            if (!stmt.isForceDrop() && Catalog.getCurrentCatalog().getGlobalTransactionMgr().existCommittedTxns(db.getId(), table.getId(), null)) {
                throw new DdlException("There are still some transactions in the COMMITTED state waiting to be completed. The table [" + tableName + "] cannot be dropped. If you want to forcibly drop(cannot be recovered), please use \"DROP table FORCE\".");
            }
            DropInfo info = new DropInfo(db.getId(), table.getId(), -1L, stmt.isForceDrop());
            table.writeLock();
            try {
                OlapTable olapTable;
                if (table instanceof OlapTable && !stmt.isForceDrop() && (olapTable = (OlapTable)table).getState() != OlapTable.OlapTableState.NORMAL) {
                    throw new DdlException("The table [" + tableName + "]'s state is " + (Object)((Object)olapTable.getState()) + ", cannot be dropped. please cancel the operation on olap table firstly. If you want to forcibly drop(cannot be recovered), please use \"DROP table FORCE\".");
                }
                this.unprotectDropTable(db, table, stmt.isForceDrop(), false);
            }
            finally {
                table.writeUnlock();
            }
            this.editLog.logDropTable(info);
        }
        finally {
            db.writeUnlock();
        }
        LOG.info("finished dropping table: {} from db: {}, is force: {}", (Object)tableName, (Object)dbName, (Object)stmt.isForceDrop());
    }

    public boolean unprotectDropTable(Database db, Table table, boolean isForceDrop, boolean isReplay) {
        if (table.getType() == Table.TableType.ELASTICSEARCH) {
            this.esRepository.deRegisterTable(table.getId());
        } else if (table.getType() == Table.TableType.OLAP) {
            ((OlapTable)table).dropAllTempPartitions();
        } else if (table.getType() == Table.TableType.ICEBERG) {
            this.icebergTableCreationRecordMgr.deregisterTable(db, (IcebergTable)table);
        }
        db.dropTable(table.getName());
        if (!isForceDrop) {
            Catalog.getCurrentRecycleBin().recycleTable(db.getId(), table, isReplay);
        } else if (table.getType() == Table.TableType.OLAP) {
            Catalog.getCurrentCatalog().onEraseOlapTable((OlapTable)table, isReplay);
        }
        LOG.info("finished dropping table[{}] in db[{}]", (Object)table.getName(), (Object)db.getFullName());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayDropTable(Database db, long tableId, boolean isForceDrop) throws MetaNotFoundException {
        Table table = db.getTableOrMetaException(tableId);
        db.writeLock();
        table.writeLock();
        try {
            this.unprotectDropTable(db, table, isForceDrop, true);
        }
        finally {
            table.writeUnlock();
            db.writeUnlock();
        }
    }

    public void replayEraseTable(long tableId) {
        Catalog.getCurrentRecycleBin().replayEraseTable(tableId);
    }

    public void replayRecoverTable(RecoverInfo info) throws MetaNotFoundException {
        Database db = this.getDbOrMetaException(info.getDbId());
        db.writeLock();
        try {
            Catalog.getCurrentRecycleBin().replayRecoverTable(db, info.getTableId());
        }
        finally {
            db.writeUnlock();
        }
    }

    private void unprotectAddReplica(OlapTable olapTable, ReplicaPersistInfo info) {
        LOG.debug("replay add a replica {}", (Object)info);
        Partition partition = olapTable.getPartition(info.getPartitionId());
        MaterializedIndex materializedIndex = partition.getIndex(info.getIndexId());
        Tablet tablet = materializedIndex.getTablet(info.getTabletId());
        int schemaHash = info.getSchemaHash();
        if (schemaHash == -1) {
            schemaHash = olapTable.getSchemaHashByIndexId(info.getIndexId());
        }
        Replica replica = new Replica(info.getReplicaId(), info.getBackendId(), info.getVersion(), schemaHash, info.getDataSize(), info.getRowCount(), Replica.ReplicaState.NORMAL, info.getLastFailedVersion(), info.getLastSuccessVersion());
        tablet.addReplica(replica);
    }

    private void unprotectUpdateReplica(OlapTable olapTable, ReplicaPersistInfo info) {
        LOG.debug("replay update a replica {}", (Object)info);
        Partition partition = olapTable.getPartition(info.getPartitionId());
        MaterializedIndex materializedIndex = partition.getIndex(info.getIndexId());
        Tablet tablet = materializedIndex.getTablet(info.getTabletId());
        Replica replica = tablet.getReplicaByBackendId(info.getBackendId());
        Preconditions.checkNotNull((Object)replica, (Object)info);
        replica.updateVersionInfo(info.getVersion(), info.getDataSize(), info.getRowCount());
        replica.setBad(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayAddReplica(ReplicaPersistInfo info) throws MetaNotFoundException {
        Database db = this.getDbOrMetaException(info.getDbId());
        OlapTable olapTable = (OlapTable)db.getTableOrMetaException(info.getTableId(), Table.TableType.OLAP);
        olapTable.writeLock();
        try {
            this.unprotectAddReplica(olapTable, info);
        }
        finally {
            olapTable.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayUpdateReplica(ReplicaPersistInfo info) throws MetaNotFoundException {
        Database db = this.getDbOrMetaException(info.getDbId());
        OlapTable olapTable = (OlapTable)db.getTableOrMetaException(info.getTableId(), Table.TableType.OLAP);
        olapTable.writeLock();
        try {
            this.unprotectUpdateReplica(olapTable, info);
        }
        finally {
            olapTable.writeUnlock();
        }
    }

    public void unprotectDeleteReplica(OlapTable olapTable, ReplicaPersistInfo info) {
        Partition partition = olapTable.getPartition(info.getPartitionId());
        MaterializedIndex materializedIndex = partition.getIndex(info.getIndexId());
        Tablet tablet = materializedIndex.getTablet(info.getTabletId());
        tablet.deleteReplicaByBackendId(info.getBackendId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayDeleteReplica(ReplicaPersistInfo info) throws MetaNotFoundException {
        Database db = this.getDbOrMetaException(info.getDbId());
        OlapTable olapTable = (OlapTable)db.getTableOrMetaException(info.getTableId(), Table.TableType.OLAP);
        olapTable.writeLock();
        try {
            this.unprotectDeleteReplica(olapTable, info);
        }
        finally {
            olapTable.writeUnlock();
        }
    }

    public void replayAddFrontend(Frontend fe) {
        this.tryLock(true);
        try {
            Frontend existFe = this.checkFeExist(fe.getHost(), fe.getEditLogPort());
            if (existFe != null) {
                LOG.warn("fe {} already exist.", (Object)existFe);
                if (existFe.getRole() != fe.getRole()) {
                    System.err.println("Try to add an already exist FE with different role" + (Object)((Object)fe.getRole()));
                    System.exit(-1);
                }
                return;
            }
            this.frontends.put(fe.getNodeName(), fe);
            if (fe.getRole() == FrontendNodeType.FOLLOWER || fe.getRole() == FrontendNodeType.REPLICA) {
                this.helperNodes.add(Pair.create(fe.getHost(), fe.getEditLogPort()));
            }
        }
        finally {
            this.unlock();
        }
    }

    public void replayDropFrontend(Frontend frontend) {
        this.tryLock(true);
        try {
            Frontend removedFe = this.frontends.remove(frontend.getNodeName());
            if (removedFe == null) {
                LOG.error(frontend.toString() + " does not exist.");
                return;
            }
            if (removedFe.getRole() == FrontendNodeType.FOLLOWER || removedFe.getRole() == FrontendNodeType.REPLICA) {
                this.helperNodes.remove(Pair.create(removedFe.getHost(), removedFe.getEditLogPort()));
            }
            this.removedFrontends.add(removedFe.getNodeName());
        }
        finally {
            this.unlock();
        }
    }

    public int getClusterId() {
        return this.clusterId;
    }

    public String getToken() {
        return this.token;
    }

    @Nullable
    public Database getDbNullable(String dbName) {
        if (this.fullNameToDb.containsKey(dbName)) {
            return this.fullNameToDb.get(dbName);
        }
        String fullName = ClusterNamespace.getNameFromFullName(dbName);
        if (fullName.equalsIgnoreCase("information_schema")) {
            String clusterName = ClusterNamespace.getClusterNameFromFullName(dbName);
            fullName = ClusterNamespace.getFullName(clusterName, fullName.toLowerCase());
            return this.fullNameToDb.get(fullName);
        }
        return null;
    }

    @Nullable
    public Database getDbNullable(long dbId) {
        return this.idToDb.get(dbId);
    }

    public Optional<Database> getDb(String dbName) {
        return Optional.ofNullable(this.getDbNullable(dbName));
    }

    public Optional<Database> getDb(long dbId) {
        return Optional.ofNullable(this.getDbNullable(dbId));
    }

    public <E extends Exception> Database getDbOrException(String dbName, java.util.function.Function<String, E> e) throws E {
        Database db = this.getDbNullable(dbName);
        if (db == null) {
            throw (Exception)e.apply(dbName);
        }
        return db;
    }

    public <E extends Exception> Database getDbOrException(long dbId, java.util.function.Function<Long, E> e) throws E {
        Database db = this.getDbNullable(dbId);
        if (db == null) {
            throw (Exception)e.apply(dbId);
        }
        return db;
    }

    public Database getDbOrMetaException(String dbName) throws MetaNotFoundException {
        return this.getDbOrException(dbName, (String s) -> new MetaNotFoundException("unknown databases, dbName=" + s, ErrorCode.ERR_BAD_DB_ERROR));
    }

    public Database getDbOrMetaException(long dbId) throws MetaNotFoundException {
        return this.getDbOrException(dbId, (Long s) -> new MetaNotFoundException("unknown databases, dbId=" + s, ErrorCode.ERR_BAD_DB_ERROR));
    }

    public Database getDbOrDdlException(String dbName) throws DdlException {
        return this.getDbOrException(dbName, (String s) -> new DdlException(ErrorCode.ERR_BAD_DB_ERROR.formatErrorMsg(s), ErrorCode.ERR_BAD_DB_ERROR));
    }

    public Database getDbOrDdlException(long dbId) throws DdlException {
        return this.getDbOrException(dbId, (Long s) -> new DdlException(ErrorCode.ERR_BAD_DB_ERROR.formatErrorMsg(s), ErrorCode.ERR_BAD_DB_ERROR));
    }

    public Database getDbOrAnalysisException(String dbName) throws AnalysisException {
        return this.getDbOrException(dbName, (String s) -> new AnalysisException(ErrorCode.ERR_BAD_DB_ERROR.formatErrorMsg(s), ErrorCode.ERR_BAD_DB_ERROR));
    }

    public Database getDbOrAnalysisException(long dbId) throws AnalysisException {
        return this.getDbOrException(dbId, (Long s) -> new AnalysisException(ErrorCode.ERR_BAD_DB_ERROR.formatErrorMsg(s), ErrorCode.ERR_BAD_DB_ERROR));
    }

    public EditLog getEditLog() {
        return this.editLog;
    }

    public long getNextId() {
        return this.idGenerator.getNextId();
    }

    public List<String> getDbNames() {
        return Lists.newArrayList((Iterable)this.fullNameToDb.keySet());
    }

    public List<String> getClusterDbNames(String clusterName) throws AnalysisException {
        Cluster cluster = this.nameToCluster.get(clusterName);
        if (cluster == null) {
            throw new AnalysisException("No cluster selected");
        }
        return Lists.newArrayList(cluster.getDbNames());
    }

    public List<Long> getDbIds() {
        return Lists.newArrayList((Iterable)this.idToDb.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<Long, TStorageMedium> getPartitionIdToStorageMediumMap() {
        HashMap<Long, TStorageMedium> storageMediumMap = new HashMap<Long, TStorageMedium>();
        HashMap<Long, Multimap> changedPartitionsMap = new HashMap<Long, Multimap>();
        long currentTimeMs = System.currentTimeMillis();
        List<Long> dbIds = this.getDbIds();
        for (long dbId : dbIds) {
            Database db = this.getDbNullable(dbId);
            if (db == null) {
                LOG.warn("db {} does not exist while doing backend report", (Object)dbId);
                continue;
            }
            List<Table> tableList = db.getTables();
            for (Table table : tableList) {
                if (table.getType() != Table.TableType.OLAP) continue;
                long tableId = table.getId();
                OlapTable olapTable = (OlapTable)table;
                olapTable.readLock();
                try {
                    PartitionInfo partitionInfo = olapTable.getPartitionInfo();
                    for (Partition partition : olapTable.getAllPartitions()) {
                        long partitionId = partition.getId();
                        DataProperty dataProperty = partitionInfo.getDataProperty(partition.getId());
                        Preconditions.checkNotNull((Object)dataProperty, (Object)(partition.getName() + ", pId:" + partitionId + ", db: " + dbId + ", tbl: " + tableId));
                        if (dataProperty.getStorageMedium() == TStorageMedium.SSD && dataProperty.getCooldownTimeMs() < currentTimeMs) {
                            Multimap multimap = (Multimap)changedPartitionsMap.get(dbId);
                            if (multimap == null) {
                                multimap = HashMultimap.create();
                                changedPartitionsMap.put(dbId, multimap);
                            }
                            multimap.put((Object)tableId, (Object)partitionId);
                            continue;
                        }
                        storageMediumMap.put(partitionId, dataProperty.getStorageMedium());
                    }
                }
                finally {
                    olapTable.readUnlock();
                }
            }
        }
        for (Long dbId : changedPartitionsMap.keySet()) {
            Database db = this.getDbNullable(dbId);
            if (db == null) {
                LOG.warn("db {} does not exist while checking backend storage medium", (Object)dbId);
                continue;
            }
            Multimap tableIdToPartitionIds = (Multimap)changedPartitionsMap.get(dbId);
            for (Long tableId : tableIdToPartitionIds.keySet()) {
                Table table;
                table = db.getTableNullable(tableId);
                if (table == null) continue;
                OlapTable olapTable = (OlapTable)table;
                if (!olapTable.tryWriteLockIfExist(100L, TimeUnit.MILLISECONDS)) {
                    LOG.warn("try get table {} writelock but failed when checking backend storage medium", (Object)table.getName());
                    continue;
                }
                Preconditions.checkState((boolean)olapTable.isWriteLockHeldByCurrentThread());
                try {
                    PartitionInfo partitionInfo = olapTable.getPartitionInfo();
                    Collection partitionIds = tableIdToPartitionIds.get((Object)tableId);
                    for (Long partitionId : partitionIds) {
                        DataProperty dataProperty;
                        Partition partition;
                        partition = olapTable.getPartition(partitionId);
                        if (partition == null || (dataProperty = partitionInfo.getDataProperty(partition.getId())).getStorageMedium() != TStorageMedium.SSD || dataProperty.getCooldownTimeMs() >= currentTimeMs) continue;
                        DataProperty hddProperty = new DataProperty(TStorageMedium.HDD);
                        partitionInfo.setDataProperty(partition.getId(), hddProperty);
                        storageMediumMap.put(partitionId, TStorageMedium.HDD);
                        LOG.debug("partition[{}-{}-{}] storage medium changed from SSD to HDD", (Object)dbId, (Object)tableId, (Object)partitionId);
                        ModifyPartitionInfo info = new ModifyPartitionInfo(db.getId(), olapTable.getId(), partition.getId(), hddProperty, ReplicaAllocation.NOT_SET, partitionInfo.getIsInMemory(partition.getId()));
                        this.editLog.logModifyPartition(info);
                    }
                }
                finally {
                    olapTable.writeUnlock();
                }
            }
        }
        return storageMediumMap;
    }

    public ConsistencyChecker getConsistencyChecker() {
        return this.consistencyChecker;
    }

    public Alter getAlterInstance() {
        return this.alter;
    }

    public SchemaChangeHandler getSchemaChangeHandler() {
        return (SchemaChangeHandler)this.alter.getSchemaChangeHandler();
    }

    public MaterializedViewHandler getMaterializedViewHandler() {
        return (MaterializedViewHandler)this.alter.getMaterializedViewHandler();
    }

    public SystemHandler getClusterHandler() {
        return (SystemHandler)this.alter.getClusterHandler();
    }

    public BackupHandler getBackupHandler() {
        return this.backupHandler;
    }

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    public DeleteHandler getDeleteHandler() {
        return this.deleteHandler;
    }

    public Load getLoadInstance() {
        return this.load;
    }

    public LoadManager getLoadManager() {
        return this.loadManager;
    }

    public StreamLoadRecordMgr getStreamLoadRecordMgr() {
        return this.streamLoadRecordMgr;
    }

    public IcebergTableCreationRecordMgr getIcebergTableCreationRecordMgr() {
        return this.icebergTableCreationRecordMgr;
    }

    public MasterTaskExecutor getPendingLoadTaskScheduler() {
        return this.pendingLoadTaskScheduler;
    }

    public MasterTaskExecutor getLoadingLoadTaskScheduler() {
        return this.loadingLoadTaskScheduler;
    }

    public RoutineLoadManager getRoutineLoadManager() {
        return this.routineLoadManager;
    }

    public SqlBlockRuleMgr getSqlBlockRuleMgr() {
        return this.sqlBlockRuleMgr;
    }

    public RoutineLoadTaskScheduler getRoutineLoadTaskScheduler() {
        return this.routineLoadTaskScheduler;
    }

    public ExportMgr getExportMgr() {
        return this.exportMgr;
    }

    public SyncJobManager getSyncJobManager() {
        return this.syncJobManager;
    }

    public SmallFileMgr getSmallFileMgr() {
        return this.smallFileMgr;
    }

    public RefreshManager getRefreshManager() {
        return this.refreshManager;
    }

    public long getReplayedJournalId() {
        return this.replayedJournalId.get();
    }

    public HAProtocol getHaProtocol() {
        return this.haProtocol;
    }

    public Long getMaxJournalId() {
        return this.editLog.getMaxJournalId();
    }

    public long getEpoch() {
        return this.epoch;
    }

    public void setEpoch(long epoch) {
        this.epoch = epoch;
    }

    public FrontendNodeType getRole() {
        return this.role;
    }

    public Pair<String, Integer> getHelperNode() {
        Preconditions.checkState((this.helperNodes.size() >= 1 ? 1 : 0) != 0);
        return this.helperNodes.get(0);
    }

    public List<Pair<String, Integer>> getHelperNodes() {
        return Lists.newArrayList(this.helperNodes);
    }

    public Pair<String, Integer> getSelfNode() {
        return this.selfNode;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public FrontendNodeType getFeType() {
        return this.feType;
    }

    public int getMasterRpcPort() {
        if (!this.isReady()) {
            return 0;
        }
        return this.masterRpcPort;
    }

    public int getMasterHttpPort() {
        if (!this.isReady()) {
            return 0;
        }
        return this.masterHttpPort;
    }

    public String getMasterIp() {
        if (!this.isReady()) {
            return "";
        }
        return this.masterIp;
    }

    public EsRepository getEsRepository() {
        return this.esRepository;
    }

    public void setMaster(MasterInfo info) {
        this.masterIp = info.getIp();
        this.masterHttpPort = info.getHttpPort();
        this.masterRpcPort = info.getRpcPort();
    }

    public boolean canRead() {
        return this.canRead.get();
    }

    public boolean isElectable() {
        return this.isElectable;
    }

    public boolean isMaster() {
        return this.feType == FrontendNodeType.MASTER;
    }

    public void setSynchronizedTime(long time) {
        this.synchronizedTimeMs = time;
    }

    public void setEditLog(EditLog editLog) {
        this.editLog = editLog;
    }

    public void setNextId(long id) {
        this.idGenerator.setId(id);
    }

    public void setHaProtocol(HAProtocol protocol) {
        this.haProtocol = protocol;
    }

    public static short calcShortKeyColumnCount(List<Column> columns, Map<String, String> properties) throws DdlException {
        ArrayList<Column> indexColumns = new ArrayList<Column>();
        for (Column column : columns) {
            if (!column.isKey()) continue;
            indexColumns.add(column);
        }
        LOG.debug("index column size: {}", (Object)indexColumns.size());
        Preconditions.checkArgument((indexColumns.size() > 0 ? 1 : 0) != 0);
        int shortKeyColumnCount = -1;
        try {
            shortKeyColumnCount = PropertyAnalyzer.analyzeShortKeyColumnCount(properties);
        }
        catch (AnalysisException e) {
            throw new DdlException(e.getMessage());
        }
        if (shortKeyColumnCount != -1) {
            if (shortKeyColumnCount <= 0) {
                throw new DdlException("Invalid short key: " + shortKeyColumnCount);
            }
            if (shortKeyColumnCount > indexColumns.size()) {
                throw new DdlException("Short key is too large. should less than: " + indexColumns.size());
            }
            for (int pos = 0; pos < shortKeyColumnCount; ++pos) {
                if (((Column)indexColumns.get(pos)).getDataType() != PrimitiveType.VARCHAR || pos == shortKeyColumnCount - 1) continue;
                throw new DdlException("Varchar should not in the middle of short keys.");
            }
        } else {
            shortKeyColumnCount = 0;
            int shortKeySizeByte = 0;
            int maxShortKeyColumnCount = Math.min(indexColumns.size(), FeConstants.shortkey_max_column_count);
            for (int i = 0; i < maxShortKeyColumnCount; ++i) {
                Column column = (Column)indexColumns.get(i);
                if ((shortKeySizeByte += column.getOlapColumnIndexSize()) > FeConstants.shortkey_maxsize_bytes) {
                    if (!column.getDataType().isCharFamily()) break;
                    shortKeyColumnCount = (short)(shortKeyColumnCount + 1);
                    break;
                }
                if (column.getType().isFloatingPointType()) break;
                if (column.getDataType() == PrimitiveType.VARCHAR) {
                    shortKeyColumnCount = (short)(shortKeyColumnCount + 1);
                    break;
                }
                shortKeyColumnCount = (short)(shortKeyColumnCount + 1);
            }
            if (shortKeyColumnCount == 0) {
                throw new DdlException("The first column could not be float or double type, use decimal instead");
            }
        }
        return (short)shortKeyColumnCount;
    }

    public void alterTable(AlterTableStmt stmt) throws UserException {
        this.alter.processAlterTable(stmt);
    }

    public void alterView(AlterViewStmt stmt) throws UserException {
        this.alter.processAlterView(stmt, ConnectContext.get());
    }

    public void createMaterializedView(CreateMaterializedViewStmt stmt) throws AnalysisException, DdlException, MetaNotFoundException {
        this.alter.processCreateMaterializedView(stmt);
    }

    public void dropMaterializedView(DropMaterializedViewStmt stmt) throws DdlException, MetaNotFoundException {
        this.alter.processDropMaterializedView(stmt);
    }

    public void cancelAlter(CancelAlterTableStmt stmt) throws DdlException {
        if (stmt.getAlterType() == ShowAlterStmt.AlterType.ROLLUP) {
            this.getMaterializedViewHandler().cancel(stmt);
        } else if (stmt.getAlterType() == ShowAlterStmt.AlterType.COLUMN) {
            this.getSchemaChangeHandler().cancel(stmt);
        } else {
            throw new DdlException("Cancel " + (Object)((Object)stmt.getAlterType()) + " does not implement yet");
        }
    }

    public void backup(BackupStmt stmt) throws DdlException {
        this.getBackupHandler().process(stmt);
    }

    public void restore(RestoreStmt stmt) throws DdlException {
        this.getBackupHandler().process(stmt);
    }

    public void cancelBackup(CancelBackupStmt stmt) throws DdlException {
        this.getBackupHandler().cancel(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameTable(Database db, Table table, TableRenameClause tableRenameClause) throws DdlException {
        db.writeLockOrDdlException();
        try {
            table.writeLockOrDdlException();
            try {
                String newTableName;
                OlapTable olapTable;
                if (table instanceof OlapTable && (olapTable = (OlapTable)table).getState() != OlapTable.OlapTableState.NORMAL) {
                    throw new DdlException("Table[" + olapTable.getName() + "] is under " + (Object)((Object)olapTable.getState()));
                }
                String oldTableName = table.getName();
                if (oldTableName.equals(newTableName = tableRenameClause.getNewTableName())) {
                    throw new DdlException("Same table name");
                }
                if (db.getTable(newTableName).isPresent()) {
                    throw new DdlException("Table name[" + newTableName + "] is already used");
                }
                if (table.getType() == Table.TableType.OLAP) {
                    ((OlapTable)table).checkAndSetName(newTableName, false);
                } else {
                    table.setName(newTableName);
                }
                db.dropTable(oldTableName);
                db.createTable(table);
                TableInfo tableInfo = TableInfo.createForTableRename(db.getId(), table.getId(), newTableName);
                this.editLog.logTableRename(tableInfo);
                LOG.info("rename table[{}] to {}", (Object)oldTableName, (Object)newTableName);
            }
            finally {
                table.writeUnlock();
            }
        }
        finally {
            db.writeUnlock();
        }
    }

    public void refreshExternalTableSchema(Database db, Table table, List<Column> newSchema) {
        RefreshExternalTableInfo refreshExternalTableInfo = new RefreshExternalTableInfo(db.getFullName(), table.getName(), newSchema);
        this.editLog.logRefreshExternalTableSchema(refreshExternalTableInfo);
        LOG.info("refresh db[{}] table[{}] for schema change", (Object)db.getFullName(), (Object)table.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayRenameTable(TableInfo tableInfo) throws MetaNotFoundException {
        long dbId = tableInfo.getDbId();
        long tableId = tableInfo.getTableId();
        String newTableName = tableInfo.getNewTableName();
        Database db = this.getDbOrMetaException(dbId);
        db.writeLock();
        try {
            Table table = db.getTableOrMetaException(tableId);
            table.writeLock();
            try {
                String tableName = table.getName();
                db.dropTable(tableName);
                table.setName(newTableName);
                db.createTable(table);
                LOG.info("replay rename table[{}] to {}", (Object)tableName, (Object)newTableName);
            }
            finally {
                table.writeUnlock();
            }
        }
        finally {
            db.writeUnlock();
        }
    }

    public void modifyTableColocate(Database db, OlapTable table, String colocateGroup, boolean isReplay, ColocateTableIndex.GroupId assignedGroupId) throws DdlException {
        String fullGroupName;
        String oldGroup = table.getColocateGroup();
        ColocateTableIndex.GroupId groupId = null;
        if (!Strings.isNullOrEmpty((String)colocateGroup)) {
            String oldFullGroupName;
            fullGroupName = db.getId() + "_" + colocateGroup;
            if (!Strings.isNullOrEmpty((String)oldGroup) && (oldFullGroupName = db.getId() + "_" + oldGroup).equals(fullGroupName)) {
                LOG.warn("modify table[{}] group name same as old group name,skip.", (Object)table.getName());
                return;
            }
            ColocateGroupSchema groupSchema = this.colocateTableIndex.getGroupSchema(fullGroupName);
            if (groupSchema == null) {
                PartitionInfo partitionInfo = table.getPartitionInfo();
                if (partitionInfo.getType() == PartitionType.RANGE || partitionInfo.getType() == PartitionType.LIST) {
                    int bucketsNum = -1;
                    ReplicaAllocation replicaAlloc = null;
                    for (Partition partition : table.getPartitions()) {
                        if (bucketsNum == -1) {
                            bucketsNum = partition.getDistributionInfo().getBucketNum();
                        } else if (bucketsNum != partition.getDistributionInfo().getBucketNum()) {
                            throw new DdlException("Partitions in table " + table.getName() + " have different buckets number");
                        }
                        if (replicaAlloc == null) {
                            replicaAlloc = partitionInfo.getReplicaAllocation(partition.getId());
                            continue;
                        }
                        if (replicaAlloc.equals(partitionInfo.getReplicaAllocation(partition.getId()))) continue;
                        throw new DdlException("Partitions in table " + table.getName() + " have different replica allocation.");
                    }
                }
            } else {
                groupSchema.checkColocateSchema(table);
            }
            Map<Tag, List<List<Long>>> backendsPerBucketSeq = null;
            if (groupSchema == null) {
                backendsPerBucketSeq = table.getArbitraryTabletBucketsSeq();
            }
            groupId = this.colocateTableIndex.changeGroup(db.getId(), table, oldGroup, colocateGroup, assignedGroupId);
            if (groupSchema == null) {
                Preconditions.checkNotNull(backendsPerBucketSeq);
                this.colocateTableIndex.addBackendsPerBucketSeq(groupId, backendsPerBucketSeq);
            }
            this.colocateTableIndex.markGroupUnstable(groupId, "Colocation group modified by user", false);
            table.setColocateGroup(colocateGroup);
        } else {
            if (Strings.isNullOrEmpty((String)oldGroup)) {
                return;
            }
            fullGroupName = db.getId() + "_" + oldGroup;
            groupId = this.colocateTableIndex.getGroupSchema(fullGroupName).getGroupId();
            this.colocateTableIndex.removeTable(table.getId());
            table.setColocateGroup(null);
        }
        if (!isReplay) {
            HashMap properties = Maps.newHashMapWithExpectedSize((int)1);
            properties.put("colocate_with", colocateGroup);
            TablePropertyInfo info = new TablePropertyInfo(table.getId(), groupId, properties);
            this.editLog.logModifyTableColocate(info);
        }
        LOG.info("finished modify table's colocation property. table: {}, is replay: {}", (Object)table.getName(), (Object)isReplay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayModifyTableColocate(TablePropertyInfo info) throws MetaNotFoundException {
        long dbId = info.getGroupId().dbId;
        long tableId = info.getTableId();
        Map<String, String> properties = info.getPropertyMap();
        Database db = this.getDbOrMetaException(dbId);
        OlapTable olapTable = (OlapTable)db.getTableOrMetaException(tableId, Table.TableType.OLAP);
        olapTable.writeLock();
        try {
            this.modifyTableColocate(db, olapTable, properties.get("colocate_with"), true, info.getGroupId());
        }
        catch (DdlException e) {
            LOG.warn("failed to replay modify table colocate", (Throwable)e);
        }
        finally {
            olapTable.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameRollup(Database db, OlapTable table, RollupRenameClause renameClause) throws DdlException {
        table.writeLockOrDdlException();
        try {
            if (table.getState() != OlapTable.OlapTableState.NORMAL) {
                throw new DdlException("Table[" + table.getName() + "] is under " + (Object)((Object)table.getState()));
            }
            String rollupName = renameClause.getRollupName();
            if (rollupName.equals(table.getName())) {
                throw new DdlException("Using ALTER TABLE RENAME to change table name");
            }
            String newRollupName = renameClause.getNewRollupName();
            if (rollupName.equals(newRollupName)) {
                throw new DdlException("Same rollup name");
            }
            Map<String, Long> indexNameToIdMap = table.getIndexNameToId();
            if (indexNameToIdMap.get(rollupName) == null) {
                throw new DdlException("Rollup index[" + rollupName + "] does not exists");
            }
            if (indexNameToIdMap.get(newRollupName) != null) {
                throw new DdlException("Rollup name[" + newRollupName + "] is already used");
            }
            long indexId = indexNameToIdMap.remove(rollupName);
            indexNameToIdMap.put(newRollupName, indexId);
            TableInfo tableInfo = TableInfo.createForRollupRename(db.getId(), table.getId(), indexId, newRollupName);
            this.editLog.logRollupRename(tableInfo);
            LOG.info("rename rollup[{}] to {}", (Object)rollupName, (Object)newRollupName);
        }
        finally {
            table.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayRenameRollup(TableInfo tableInfo) throws MetaNotFoundException {
        long dbId = tableInfo.getDbId();
        long tableId = tableInfo.getTableId();
        long indexId = tableInfo.getIndexId();
        String newRollupName = tableInfo.getNewRollupName();
        Database db = this.getDbOrMetaException(dbId);
        OlapTable olapTable = (OlapTable)db.getTableOrMetaException(tableId, Table.TableType.OLAP);
        olapTable.writeLock();
        try {
            String rollupName = olapTable.getIndexNameById(indexId);
            Map<String, Long> indexNameToIdMap = olapTable.getIndexNameToId();
            indexNameToIdMap.remove(rollupName);
            indexNameToIdMap.put(newRollupName, indexId);
            LOG.info("replay rename rollup[{}] to {}", (Object)rollupName, (Object)newRollupName);
        }
        finally {
            olapTable.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renamePartition(Database db, OlapTable table, PartitionRenameClause renameClause) throws DdlException {
        table.writeLockOrDdlException();
        try {
            String newPartitionName;
            if (table.getState() != OlapTable.OlapTableState.NORMAL) {
                throw new DdlException("Table[" + table.getName() + "] is under " + (Object)((Object)table.getState()));
            }
            if (table.getPartitionInfo().getType() != PartitionType.RANGE && table.getPartitionInfo().getType() != PartitionType.LIST) {
                throw new DdlException("Table[" + table.getName() + "] is single partitioned. no need to rename partition name.");
            }
            String partitionName = renameClause.getPartitionName();
            if (partitionName.equalsIgnoreCase(newPartitionName = renameClause.getNewPartitionName())) {
                throw new DdlException("Same partition name");
            }
            Partition partition = table.getPartition(partitionName);
            if (partition == null) {
                throw new DdlException("Partition[" + partitionName + "] does not exists");
            }
            if (table.checkPartitionNameExist(newPartitionName)) {
                throw new DdlException("Partition name[" + newPartitionName + "] is already used");
            }
            table.renamePartition(partitionName, newPartitionName);
            TableInfo tableInfo = TableInfo.createForPartitionRename(db.getId(), table.getId(), partition.getId(), newPartitionName);
            this.editLog.logPartitionRename(tableInfo);
            LOG.info("rename partition[{}] to {}", (Object)partitionName, (Object)newPartitionName);
        }
        finally {
            table.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayRenamePartition(TableInfo tableInfo) throws MetaNotFoundException {
        long dbId = tableInfo.getDbId();
        long tableId = tableInfo.getTableId();
        long partitionId = tableInfo.getPartitionId();
        String newPartitionName = tableInfo.getNewPartitionName();
        Database db = this.getDbOrMetaException(dbId);
        OlapTable olapTable = (OlapTable)db.getTableOrMetaException(tableId, Table.TableType.OLAP);
        olapTable.writeLock();
        try {
            Partition partition = olapTable.getPartition(partitionId);
            olapTable.renamePartition(partition.getName(), newPartitionName);
            LOG.info("replay rename partition[{}] to {}", (Object)partition.getName(), (Object)newPartitionName);
        }
        finally {
            olapTable.writeUnlock();
        }
    }

    public void renameColumn(Database db, OlapTable table, ColumnRenameClause renameClause) throws DdlException {
        throw new DdlException("not implemented");
    }

    public void replayRenameColumn(TableInfo tableInfo) throws DdlException {
        throw new DdlException("not implemented");
    }

    public void modifyTableDynamicPartition(Database db, OlapTable table, Map<String, String> properties) throws UserException {
        this.convertDynamicPartitionReplicaNumToReplicaAllocation(properties);
        HashMap<String, String> logProperties = new HashMap<String, String>(properties);
        TableProperty tableProperty = table.getTableProperty();
        if (tableProperty == null) {
            DynamicPartitionUtil.checkAndSetDynamicPartitionProperty(table, properties);
        } else {
            Map<String, String> origDynamicProperties = tableProperty.getOriginDynamicPartitionProperty();
            origDynamicProperties.putAll(properties);
            Map<String, String> analyzedDynamicPartition = DynamicPartitionUtil.analyzeDynamicPartition(origDynamicProperties, table.getPartitionInfo());
            tableProperty.modifyTableProperties(analyzedDynamicPartition);
            tableProperty.buildDynamicProperty();
        }
        DynamicPartitionUtil.registerOrRemoveDynamicPartitionTable(db.getId(), table, false);
        this.dynamicPartitionScheduler.createOrUpdateRuntimeInfo(table.getId(), "lastUpdateTime", TimeUtils.getCurrentFormatTime());
        ModifyTablePropertyOperationLog info = new ModifyTablePropertyOperationLog(db.getId(), table.getId(), logProperties);
        this.editLog.logDynamicPartition(info);
    }

    private void convertDynamicPartitionReplicaNumToReplicaAllocation(Map<String, String> properties) {
        if (properties.containsKey("dynamic_partition.replication_num")) {
            Short repNum = Short.valueOf(properties.remove("dynamic_partition.replication_num"));
            ReplicaAllocation replicaAlloc = new ReplicaAllocation(repNum);
            properties.put("dynamic_partition.replication_allocation", replicaAlloc.toCreateStmt());
        }
    }

    public void modifyTableReplicaAllocation(Database db, OlapTable table, Map<String, String> properties) throws UserException {
        Preconditions.checkArgument((boolean)table.isWriteLockHeldByCurrentThread());
        String defaultReplicationNumName = "default.replication_num";
        PartitionInfo partitionInfo = table.getPartitionInfo();
        if (partitionInfo.getType() == PartitionType.RANGE || partitionInfo.getType() == PartitionType.LIST) {
            throw new DdlException("This is a partitioned table, you should specify partitions with MODIFY PARTITION clause. If you want to set default replication number, please use '" + defaultReplicationNumName + "' instead of '" + "replication_num" + "' to escape misleading.");
        }
        String partitionName = table.getName();
        Partition partition = table.getPartition(partitionName);
        if (partition == null) {
            throw new DdlException("Partition does not exist. name: " + partitionName);
        }
        ReplicaAllocation replicaAlloc = PropertyAnalyzer.analyzeReplicaAllocation(properties, "");
        Catalog.getCurrentSystemInfo().checkReplicaAllocation(db.getClusterName(), replicaAlloc);
        Preconditions.checkState((!replicaAlloc.isNotSet() ? 1 : 0) != 0);
        boolean isInMemory = partitionInfo.getIsInMemory(partition.getId());
        DataProperty newDataProperty = partitionInfo.getDataProperty(partition.getId());
        partitionInfo.setReplicaAllocation(partition.getId(), replicaAlloc);
        ModifyPartitionInfo info = new ModifyPartitionInfo(db.getId(), table.getId(), partition.getId(), newDataProperty, replicaAlloc, isInMemory);
        this.editLog.logModifyPartition(info);
        LOG.debug("modify partition[{}-{}-{}] replica allocation to {}", (Object)db.getId(), (Object)table.getId(), (Object)partition.getName(), (Object)replicaAlloc.toCreateStmt());
    }

    public void modifyTableDefaultReplicaAllocation(Database db, OlapTable table, Map<String, String> properties) {
        Preconditions.checkArgument((boolean)table.isWriteLockHeldByCurrentThread());
        TableProperty tableProperty = table.getTableProperty();
        if (tableProperty == null) {
            tableProperty = new TableProperty(properties);
            table.setTableProperty(tableProperty);
        } else {
            tableProperty.modifyTableProperties(properties);
        }
        tableProperty.buildReplicaAllocation();
        ModifyTablePropertyOperationLog info = new ModifyTablePropertyOperationLog(db.getId(), table.getId(), properties);
        this.editLog.logModifyReplicationNum(info);
        LOG.debug("modify table[{}] replication num to {}", (Object)table.getName(), (Object)properties.get("replication_num"));
    }

    public void modifyTableInMemoryMeta(Database db, OlapTable table, Map<String, String> properties) {
        Preconditions.checkArgument((boolean)table.isWriteLockHeldByCurrentThread());
        TableProperty tableProperty = table.getTableProperty();
        if (tableProperty == null) {
            tableProperty = new TableProperty(properties);
        } else {
            tableProperty.modifyTableProperties(properties);
        }
        tableProperty.buildInMemory();
        for (Partition partition : table.getPartitions()) {
            table.getPartitionInfo().setIsInMemory(partition.getId(), tableProperty.isInMemory());
        }
        ModifyTablePropertyOperationLog info = new ModifyTablePropertyOperationLog(db.getId(), table.getId(), properties);
        this.editLog.logModifyInMemory(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayModifyTableProperty(short opCode, ModifyTablePropertyOperationLog info) throws MetaNotFoundException {
        long dbId = info.getDbId();
        long tableId = info.getTableId();
        Map<String, String> properties = info.getProperties();
        Database db = this.getDbOrMetaException(dbId);
        OlapTable olapTable = (OlapTable)db.getTableOrMetaException(tableId, Table.TableType.OLAP);
        olapTable.writeLock();
        try {
            TableProperty tableProperty = olapTable.getTableProperty();
            if (tableProperty == null) {
                tableProperty = new TableProperty(properties).buildProperty(opCode);
                olapTable.setTableProperty(tableProperty);
            } else {
                tableProperty.modifyTableProperties(properties);
                tableProperty.buildProperty(opCode);
            }
            if (opCode == 267) {
                for (Partition partition : olapTable.getPartitions()) {
                    olapTable.getPartitionInfo().setIsInMemory(partition.getId(), tableProperty.isInMemory());
                }
            }
        }
        finally {
            olapTable.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyDefaultDistributionBucketNum(Database db, OlapTable olapTable, ModifyDistributionClause modifyDistributionClause) throws DdlException {
        olapTable.writeLockOrDdlException();
        try {
            if (olapTable.isColocateTable()) {
                throw new DdlException("Cannot change default bucket number of colocate table.");
            }
            if (olapTable.getPartitionInfo().getType() != PartitionType.RANGE) {
                throw new DdlException("Only support change partitioned table's distribution.");
            }
            DistributionDesc distributionDesc = modifyDistributionClause.getDistributionDesc();
            if (distributionDesc != null) {
                List<Column> defaultDistriCols;
                HashDistributionInfo hashDistributionInfo;
                List<Column> newDistriCols;
                DistributionInfo defaultDistributionInfo = olapTable.getDefaultDistributionInfo();
                List<Column> baseSchema = olapTable.getBaseSchema();
                DistributionInfo distributionInfo = distributionDesc.toDistributionInfo(baseSchema);
                if (distributionInfo.getType() != defaultDistributionInfo.getType()) {
                    throw new DdlException("Cannot change distribution type when modify default distribution bucket num");
                }
                if (distributionInfo.getType() == DistributionInfo.DistributionInfoType.HASH && !(newDistriCols = (hashDistributionInfo = (HashDistributionInfo)distributionInfo).getDistributionColumns()).equals(defaultDistriCols = ((HashDistributionInfo)defaultDistributionInfo).getDistributionColumns())) {
                    throw new DdlException("Cannot assign hash distribution with different distribution cols. default is: " + defaultDistriCols);
                }
                int bucketNum = distributionInfo.getBucketNum();
                if (bucketNum <= 0) {
                    throw new DdlException("Cannot assign hash distribution buckets less than 1");
                }
                defaultDistributionInfo.setBucketNum(bucketNum);
                ModifyTableDefaultDistributionBucketNumOperationLog info = new ModifyTableDefaultDistributionBucketNumOperationLog(db.getId(), olapTable.getId(), bucketNum);
                this.editLog.logModifyDefaultDistributionBucketNum(info);
                LOG.info("modify table[{}] default bucket num to {}", (Object)olapTable.getName(), (Object)bucketNum);
            }
        }
        finally {
            olapTable.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayModifyTableDefaultDistributionBucketNum(ModifyTableDefaultDistributionBucketNumOperationLog info) throws MetaNotFoundException {
        long dbId = info.getDbId();
        long tableId = info.getTableId();
        int bucketNum = info.getBucketNum();
        Database db = this.getDbOrMetaException(dbId);
        OlapTable olapTable = (OlapTable)db.getTableOrMetaException(tableId, Table.TableType.OLAP);
        olapTable.writeLock();
        try {
            DistributionInfo defaultDistributionInfo = olapTable.getDefaultDistributionInfo();
            defaultDistributionInfo.setBucketNum(bucketNum);
        }
        finally {
            olapTable.writeUnlock();
        }
    }

    public void alterCluster(AlterSystemStmt stmt) throws DdlException, UserException {
        this.alter.processAlterCluster(stmt);
    }

    public void cancelAlterCluster(CancelAlterSystemStmt stmt) throws DdlException {
        this.alter.getClusterHandler().cancel(stmt);
    }

    private void validateColumns(List<Column> columns) throws DdlException {
        if (columns.isEmpty()) {
            ErrorReport.reportDdlException(ErrorCode.ERR_TABLE_MUST_HAVE_COLUMNS, new Object[0]);
        }
        boolean encounterValue = false;
        boolean hasKey = false;
        for (Column column : columns) {
            if (column.isKey()) {
                if (encounterValue) {
                    ErrorReport.reportDdlException(ErrorCode.ERR_OLAP_KEY_MUST_BEFORE_VALUE, new Object[0]);
                }
                hasKey = true;
                continue;
            }
            encounterValue = true;
        }
        if (!hasKey) {
            ErrorReport.reportDdlException(ErrorCode.ERR_TABLE_MUST_HAVE_KEYS, new Object[0]);
        }
    }

    public void changeDb(ConnectContext ctx, String qualifiedDb) throws DdlException {
        if (!this.auth.checkDbPriv(ctx, qualifiedDb, PrivPredicate.SHOW)) {
            ErrorReport.reportDdlException(ErrorCode.ERR_DBACCESS_DENIED_ERROR, ctx.getQualifiedUser(), qualifiedDb);
        }
        this.getDbOrDdlException(qualifiedDb);
        ctx.setDatabase(qualifiedDb);
    }

    public void clear() {
        if (SingletonHolder.INSTANCE.idToDb != null) {
            SingletonHolder.INSTANCE.idToDb.clear();
        }
        if (SingletonHolder.INSTANCE.fullNameToDb != null) {
            SingletonHolder.INSTANCE.fullNameToDb.clear();
        }
        if (this.load.getIdToLoadJob() != null) {
            this.load.getIdToLoadJob().clear();
        }
        System.gc();
    }

    public void createView(CreateViewStmt stmt) throws DdlException {
        String dbName = stmt.getDbName();
        String tableName = stmt.getTable();
        Database db = this.getDbOrDdlException(dbName);
        if (db.getTable(tableName).isPresent()) {
            if (stmt.isSetIfNotExists()) {
                LOG.info("create view[{}] which already exists", (Object)tableName);
                return;
            }
            ErrorReport.reportDdlException(ErrorCode.ERR_TABLE_EXISTS_ERROR, tableName);
        }
        List<Column> columns = stmt.getColumns();
        long tableId = Catalog.getCurrentCatalog().getNextId();
        View newView = new View(tableId, tableName, columns);
        newView.setComment(stmt.getComment());
        newView.setInlineViewDefWithSqlMode(stmt.getInlineViewDef(), ConnectContext.get().getSessionVariable().getSqlMode());
        try {
            newView.init();
        }
        catch (UserException e) {
            throw new DdlException("failed to init view stmt", e);
        }
        if (!((Boolean)db.createTableWithLock((Table)newView, (boolean)false, (boolean)stmt.isSetIfNotExists()).first).booleanValue()) {
            throw new DdlException("Failed to create view[" + tableName + "].");
        }
        LOG.info("successfully create view[" + tableName + "-" + newView.getId() + "]");
    }

    public Function getFunction(Function desc, Function.CompareMode mode) {
        return this.functionSet.getFunction(desc, mode);
    }

    public List<Function> getBuiltinFunctions() {
        return this.functionSet.getBulitinFunctions();
    }

    public Function getTableFunction(Function desc, Function.CompareMode mode) {
        return this.functionSet.getFunction(desc, mode, true);
    }

    public boolean isNondeterministicFunction(String funcName) {
        return this.functionSet.isNondeterministicFunction(funcName);
    }

    public boolean isNullResultWithOneNullParamFunction(String funcName) {
        return this.functionSet.isNullResultWithOneNullParamFunctions(funcName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCluster(CreateClusterStmt stmt) throws DdlException {
        String clusterName = stmt.getClusterName();
        if (!this.tryLock(false)) {
            throw new DdlException("Failed to acquire catalog lock. Try again");
        }
        try {
            if (this.nameToCluster.containsKey(clusterName)) {
                ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_HAS_EXIST, clusterName);
            } else {
                List<Long> backendList = this.systemInfo.createCluster(clusterName, stmt.getInstanceNum());
                if (backendList != null || stmt.getInstanceNum() == 0) {
                    long id = this.getNextId();
                    Cluster cluster = new Cluster(clusterName, id);
                    cluster.setBackendIdList(backendList);
                    this.unprotectCreateCluster(cluster);
                    if (clusterName.equals("default_cluster")) {
                        for (Database db : this.idToDb.values()) {
                            if (!db.getClusterName().equals("default_cluster")) continue;
                            cluster.addDb(db.getFullName(), db.getId());
                        }
                    }
                    this.editLog.logCreateCluster(cluster);
                    LOG.info("finish to create cluster: {}", (Object)clusterName);
                } else {
                    ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_BE_NOT_ENOUGH, new Object[0]);
                }
            }
        }
        finally {
            this.unlock();
        }
        UserIdentity adminUser = new UserIdentity("admin", "%");
        try {
            adminUser.analyze(stmt.getClusterName());
        }
        catch (AnalysisException e) {
            LOG.error("should not happen", (Throwable)e);
        }
        this.auth.createUser(new CreateUserStmt(new UserDesc(adminUser, "", true)));
    }

    private void unprotectCreateCluster(Cluster cluster) {
        for (Long id : cluster.getBackendIdList()) {
            Backend backend = this.systemInfo.getBackend(id);
            backend.setOwnerClusterName(cluster.getName());
            backend.setBackendState(Backend.BackendState.using);
        }
        this.idToCluster.put(cluster.getId(), cluster);
        this.nameToCluster.put(cluster.getName(), cluster);
        InfoSchemaDb infoDb = new InfoSchemaDb(cluster.getName());
        infoDb.setClusterName(cluster.getName());
        this.unprotectCreateDb(infoDb);
        if (cluster.getName().equalsIgnoreCase("default_cluster")) {
            this.isDefaultClusterCreated = true;
        }
    }

    public void replayCreateCluster(Cluster cluster) {
        this.tryLock(true);
        try {
            this.unprotectCreateCluster(cluster);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropCluster(DropClusterStmt stmt) throws DdlException {
        if (!this.tryLock(false)) {
            throw new DdlException("Failed to acquire catalog lock. Try again");
        }
        try {
            String clusterName = stmt.getClusterName();
            Cluster cluster = this.nameToCluster.get(clusterName);
            if (cluster == null) {
                ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_NO_EXISTS, clusterName);
            }
            List<Backend> backends = this.systemInfo.getClusterBackends(clusterName);
            for (Backend backend : backends) {
                if (!backend.isDecommissioned()) continue;
                ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_ALTER_BE_IN_DECOMMISSION, clusterName);
            }
            if (cluster.getDbNames().size() > 1) {
                ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_DELETE_DB_EXIST, clusterName);
            }
            this.systemInfo.releaseBackends(clusterName, false);
            ClusterInfo info = new ClusterInfo(clusterName, cluster.getId());
            this.unprotectDropCluster(info, false);
            this.editLog.logDropCluster(info);
        }
        finally {
            this.unlock();
        }
        this.auth.dropUserOfCluster(stmt.getClusterName(), true);
    }

    private void unprotectDropCluster(ClusterInfo info, boolean isReplay) {
        this.systemInfo.releaseBackends(info.getClusterName(), isReplay);
        this.idToCluster.remove(info.getClusterId());
        this.nameToCluster.remove(info.getClusterName());
        Database infoSchemaDb = this.fullNameToDb.get(InfoSchemaDb.getFullInfoSchemaDbName(info.getClusterName()));
        this.fullNameToDb.remove(infoSchemaDb.getFullName());
        this.idToDb.remove(infoSchemaDb.getId());
    }

    public void replayDropCluster(ClusterInfo info) throws DdlException {
        this.tryLock(true);
        try {
            this.unprotectDropCluster(info, true);
        }
        finally {
            this.unlock();
        }
        this.auth.dropUserOfCluster(info.getClusterName(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayExpandCluster(ClusterInfo info) {
        this.tryLock(true);
        try {
            Cluster cluster = this.nameToCluster.get(info.getClusterName());
            cluster.addBackends(info.getBackendIdList());
            for (Long beId : info.getBackendIdList()) {
                Backend be = Catalog.getCurrentSystemInfo().getBackend(beId);
                if (be == null) continue;
                be.setOwnerClusterName(info.getClusterName());
                be.setBackendState(Backend.BackendState.using);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processModifyCluster(AlterClusterStmt stmt) throws UserException {
        String clusterName = stmt.getAlterClusterName();
        int newInstanceNum = stmt.getInstanceNum();
        if (!this.tryLock(false)) {
            throw new DdlException("Failed to acquire catalog lock. Try again");
        }
        try {
            Cluster cluster = this.nameToCluster.get(clusterName);
            if (cluster == null) {
                ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_NO_EXISTS, clusterName);
            }
            List<Long> backendIdsInCluster = cluster.getBackendIdList();
            for (Long beId : backendIdsInCluster) {
                Backend be = this.systemInfo.getBackend(beId);
                if (!be.isDecommissioned()) continue;
                ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_ALTER_BE_IN_DECOMMISSION, clusterName);
            }
            int oldInstanceNum = backendIdsInCluster.size();
            if (newInstanceNum > oldInstanceNum) {
                List<Long> expandBackendIds = this.systemInfo.calculateExpansionBackends(clusterName, newInstanceNum - oldInstanceNum);
                if (expandBackendIds == null) {
                    ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_BE_NOT_ENOUGH, new Object[0]);
                }
                cluster.addBackends(expandBackendIds);
                ClusterInfo info = new ClusterInfo(clusterName, cluster.getId(), expandBackendIds);
                this.editLog.logExpandCluster(info);
            } else if (newInstanceNum < oldInstanceNum) {
                List<Long> decomBackendIds = this.systemInfo.calculateDecommissionBackends(clusterName, oldInstanceNum - newInstanceNum);
                if (decomBackendIds == null || decomBackendIds.size() == 0) {
                    ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_BACKEND_ERROR, new Object[0]);
                }
                ArrayList hostPortList = Lists.newArrayList();
                for (Long id : decomBackendIds) {
                    Backend backend = this.systemInfo.getBackend(id);
                    hostPortList.add(backend.getHost() + ":" + backend.getHeartbeatPort());
                }
                DecommissionBackendClause clause = new DecommissionBackendClause(hostPortList);
                try {
                    clause.analyze(null);
                    clause.setType(DecommissionType.ClusterDecommission);
                    AlterSystemStmt alterStmt = new AlterSystemStmt(clause);
                    alterStmt.setClusterName(clusterName);
                    this.alter.processAlterCluster(alterStmt);
                }
                catch (AnalysisException e) {
                    Preconditions.checkState((boolean)false, (Object)("should not happened: " + e.getMessage()));
                }
            } else {
                ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_ALTER_BE_NO_CHANGE, newInstanceNum);
            }
        }
        finally {
            this.unlock();
        }
    }

    public void changeCluster(ConnectContext ctx, String clusterName) throws DdlException {
        if (!Catalog.getCurrentCatalog().getAuth().checkCanEnterCluster(ConnectContext.get(), clusterName)) {
            ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_NO_AUTHORITY, ConnectContext.get().getQualifiedUser(), "enter");
        }
        if (!this.nameToCluster.containsKey(clusterName)) {
            ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_NO_EXISTS, clusterName);
        }
        ctx.setCluster(clusterName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrateDb(MigrateDbStmt stmt) throws DdlException {
        block15: {
            String srcClusterName = stmt.getSrcCluster();
            String destClusterName = stmt.getDestCluster();
            String srcDbName = stmt.getSrcDb();
            String destDbName = stmt.getDestDb();
            if (!this.tryLock(false)) {
                throw new DdlException("Failed to acquire catalog lock. Try again");
            }
            try {
                Database db;
                int maxReplicationNum;
                Cluster destCluster;
                Cluster srcCluster;
                if (!this.nameToCluster.containsKey(srcClusterName)) {
                    ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_SRC_CLUSTER_NOT_EXIST, srcClusterName);
                }
                if (!this.nameToCluster.containsKey(destClusterName)) {
                    ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_DEST_CLUSTER_NOT_EXIST, destClusterName);
                }
                if (srcClusterName.equals(destClusterName)) {
                    ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_MIGRATE_SAME_CLUSTER, new Object[0]);
                }
                if (!(srcCluster = this.nameToCluster.get(srcClusterName)).containDb(srcDbName)) {
                    ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_SRC_DB_NOT_EXIST, srcDbName);
                }
                if (!(destCluster = this.nameToCluster.get(destClusterName)).containLink(destDbName, srcDbName)) {
                    ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_MIGRATION_NO_LINK, srcDbName, destDbName);
                }
                if ((maxReplicationNum = (db = this.fullNameToDb.get(srcDbName)).getMaxReplicationNum()) > destCluster.getBackendIdList().size()) {
                    ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_MIGRATE_BE_NOT_ENOUGH, destClusterName);
                }
                if (db.getDbState() == Database.DbState.LINK) {
                    BaseParam param = new BaseParam();
                    param.addStringParam(destDbName);
                    param.addLongParam(db.getId());
                    param.addStringParam(srcDbName);
                    param.addStringParam(destClusterName);
                    param.addStringParam(srcClusterName);
                    this.fullNameToDb.remove(db.getFullName());
                    srcCluster.removeDb(db.getFullName(), db.getId());
                    destCluster.removeLinkDb(param);
                    destCluster.addDb(destDbName, db.getId());
                    db.writeLock();
                    try {
                        db.setDbState(Database.DbState.MOVE);
                        db.setClusterName(destClusterName);
                        db.setName(destDbName);
                        db.setAttachDb(srcDbName);
                    }
                    finally {
                        db.writeUnlock();
                    }
                    this.editLog.logMigrateCluster(param);
                    break block15;
                }
                ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_MIGRATION_NO_LINK, srcDbName, destDbName);
            }
            finally {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayMigrateDb(BaseParam param) {
        String desDbName = param.getStringParam();
        String srcDbName = param.getStringParam(1);
        String desClusterName = param.getStringParam(2);
        String srcClusterName = param.getStringParam(3);
        this.tryLock(true);
        try {
            Cluster desCluster = this.nameToCluster.get(desClusterName);
            Cluster srcCluster = this.nameToCluster.get(srcClusterName);
            Database db = this.fullNameToDb.get(srcDbName);
            if (db.getDbState() == Database.DbState.LINK) {
                this.fullNameToDb.remove(db.getFullName());
                srcCluster.removeDb(db.getFullName(), db.getId());
                desCluster.removeLinkDb(param);
                desCluster.addDb(param.getStringParam(), db.getId());
                db.writeLock();
                db.setName(desDbName);
                db.setAttachDb(srcDbName);
                db.setDbState(Database.DbState.MOVE);
                db.setClusterName(desClusterName);
                db.writeUnlock();
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayLinkDb(BaseParam param) {
        String desClusterName = param.getStringParam(2);
        String srcDbName = param.getStringParam(1);
        String desDbName = param.getStringParam();
        this.tryLock(true);
        try {
            Cluster desCluster = this.nameToCluster.get(desClusterName);
            Database srcDb = this.fullNameToDb.get(srcDbName);
            srcDb.writeLock();
            srcDb.setDbState(Database.DbState.LINK);
            srcDb.setAttachDb(desDbName);
            srcDb.writeUnlock();
            desCluster.addLinkDb(param);
            this.fullNameToDb.put(desDbName, srcDb);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkDb(LinkDbStmt stmt) throws DdlException {
        String srcClusterName = stmt.getSrcCluster();
        String destClusterName = stmt.getDestCluster();
        String srcDbName = stmt.getSrcDb();
        String destDbName = stmt.getDestDb();
        if (!this.tryLock(false)) {
            throw new DdlException("Failed to acquire catalog lock. Try again");
        }
        try {
            Database srcDb;
            if (!this.nameToCluster.containsKey(srcClusterName)) {
                ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_SRC_CLUSTER_NOT_EXIST, srcClusterName);
            }
            if (!this.nameToCluster.containsKey(destClusterName)) {
                ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_DEST_CLUSTER_NOT_EXIST, destClusterName);
            }
            if (srcClusterName.equals(destClusterName)) {
                ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_MIGRATE_SAME_CLUSTER, new Object[0]);
            }
            if (this.fullNameToDb.containsKey(destDbName)) {
                ErrorReport.reportDdlException(ErrorCode.ERR_DB_CREATE_EXISTS, destDbName);
            }
            Cluster srcCluster = this.nameToCluster.get(srcClusterName);
            Cluster destCluster = this.nameToCluster.get(destClusterName);
            if (!srcCluster.containDb(srcDbName)) {
                ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_SRC_DB_NOT_EXIST, srcDbName);
            }
            if ((srcDb = this.fullNameToDb.get(srcDbName)).getDbState() != Database.DbState.NORMAL) {
                ErrorReport.reportDdlException(ErrorCode.ERR_CLUSTER_DB_STATE_LINK_OR_MIGRATE, ClusterNamespace.getNameFromFullName(srcDbName));
            }
            srcDb.writeLock();
            try {
                srcDb.setDbState(Database.DbState.LINK);
                srcDb.setAttachDb(destDbName);
            }
            finally {
                srcDb.writeUnlock();
            }
            long id = this.getNextId();
            BaseParam param = new BaseParam();
            param.addStringParam(destDbName);
            param.addStringParam(srcDbName);
            param.addLongParam(id);
            param.addLongParam(srcDb.getId());
            param.addStringParam(destClusterName);
            param.addStringParam(srcClusterName);
            destCluster.addLinkDb(param);
            this.fullNameToDb.put(destDbName, srcDb);
            this.editLog.logLinkCluster(param);
        }
        finally {
            this.unlock();
        }
    }

    public Cluster getCluster(String clusterName) {
        return this.nameToCluster.get(clusterName);
    }

    public List<String> getClusterNames() {
        return new ArrayList<String>(this.nameToCluster.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<BaseParam> getMigrations() {
        HashSet infos = Sets.newHashSet();
        for (Database db : this.fullNameToDb.values()) {
            db.readLock();
            try {
                if (db.getDbState() != Database.DbState.MOVE) continue;
                int tabletTotal = 0;
                int tabletQuorum = 0;
                HashSet beIds = Sets.newHashSet(this.systemInfo.getClusterBackendIds(db.getClusterName()));
                Set<String> tableNames = db.getTableNamesWithLock();
                for (String tableName : tableNames) {
                    Table table = db.getTableNullable(tableName);
                    if (table == null || table.getType() != Table.TableType.OLAP) continue;
                    OlapTable olapTable = (OlapTable)table;
                    olapTable.readLock();
                    try {
                        for (Partition partition : olapTable.getPartitions()) {
                            ReplicaAllocation replicaAlloc = olapTable.getPartitionInfo().getReplicaAllocation(partition.getId());
                            short totalReplicaNum = replicaAlloc.getTotalReplicaNum();
                            for (MaterializedIndex materializedIndex : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL)) {
                                if (materializedIndex.getState() != MaterializedIndex.IndexState.NORMAL) continue;
                                for (Tablet tablet : materializedIndex.getTablets()) {
                                    int replicaNum = 0;
                                    int quorum = totalReplicaNum / 2 + 1;
                                    for (Replica replica : tablet.getReplicas()) {
                                        if (replica.getState() == Replica.ReplicaState.CLONE || !beIds.contains(replica.getBackendId())) continue;
                                        ++replicaNum;
                                    }
                                    if (replicaNum > quorum) {
                                        replicaNum = quorum;
                                    }
                                    tabletQuorum += replicaNum;
                                    tabletTotal += quorum;
                                }
                            }
                        }
                    }
                    finally {
                        olapTable.readUnlock();
                    }
                }
                BaseParam info = new BaseParam();
                info.addStringParam(db.getClusterName());
                info.addStringParam(db.getAttachDb());
                info.addStringParam(db.getFullName());
                float percentage = tabletTotal > 0 ? (float)tabletQuorum / (float)tabletTotal : 0.0f;
                info.addFloatParam(percentage);
                infos.add(info);
            }
            finally {
                db.readUnlock();
            }
        }
        return infos;
    }

    public long loadCluster(DataInputStream dis, long checksum) throws IOException, DdlException {
        int clusterCount = dis.readInt();
        checksum ^= (long)clusterCount;
        for (long i = 0L; i < (long)clusterCount; ++i) {
            InfoSchemaDb db;
            Cluster cluster = Cluster.read(dis);
            checksum ^= cluster.getId().longValue();
            List<Long> latestBackendIds = this.systemInfo.getClusterBackendIds(cluster.getName());
            if (latestBackendIds.size() != cluster.getBackendIdList().size()) {
                LOG.warn("Cluster:" + cluster.getName() + ", backends in Cluster is " + cluster.getBackendIdList().size() + ", backends in SystemInfoService is " + cluster.getBackendIdList().size());
            }
            cluster.setBackendIdList(latestBackendIds);
            String dbName = InfoSchemaDb.getFullInfoSchemaDbName(cluster.getName());
            if (Catalog.getServingCatalog().getFullNameToDb().containsKey(dbName)) {
                db = (InfoSchemaDb)Catalog.getServingCatalog().getFullNameToDb().get(dbName);
            } else {
                db = new InfoSchemaDb(cluster.getName());
                db.setClusterName(cluster.getName());
            }
            String errMsg = "InfoSchemaDb id shouldn't larger than 10000, please restart your FE server";
            Preconditions.checkState((db.getId() < 10000L ? 1 : 0) != 0, (Object)errMsg);
            this.idToDb.put(db.getId(), db);
            this.fullNameToDb.put(db.getFullName(), db);
            cluster.addDb(dbName, db.getId());
            this.idToCluster.put(cluster.getId(), cluster);
            this.nameToCluster.put(cluster.getName(), cluster);
        }
        LOG.info("finished replay cluster from image");
        return checksum;
    }

    public void initDefaultCluster() {
        ArrayList backendList = Lists.newArrayList();
        List<Backend> defaultClusterBackends = this.systemInfo.getClusterBackends("default_cluster");
        for (Backend backend : defaultClusterBackends) {
            backendList.add(backend.getId());
        }
        long id = this.getNextId();
        Cluster cluster = new Cluster("default_cluster", id);
        HashSet beHost = Sets.newHashSet();
        for (Backend be : defaultClusterBackends) {
            if (beHost.contains(be.getHost())) {
                LOG.error("found more than one backends in same host: {}", (Object)be.getHost());
                System.exit(-1);
                continue;
            }
            beHost.add(be.getHost());
        }
        cluster.setBackendIdList(backendList);
        this.unprotectCreateCluster(cluster);
        for (Database db : this.idToDb.values()) {
            db.setClusterName("default_cluster");
            cluster.addDb(db.getFullName(), db.getId());
        }
        this.isDefaultClusterCreated = true;
        this.editLog.logCreateCluster(cluster);
    }

    public void replayUpdateDb(DatabaseInfo info) {
        Database db = this.fullNameToDb.get(info.getDbName());
        db.setClusterName(info.getClusterName());
        db.setDbState(info.getDbState());
    }

    public long saveCluster(CountingDataOutputStream dos, long checksum) throws IOException {
        int clusterCount = this.idToCluster.size();
        checksum ^= (long)clusterCount;
        dos.writeInt(clusterCount);
        for (Map.Entry<Long, Cluster> entry : this.idToCluster.entrySet()) {
            long clusterId = entry.getKey();
            if (clusterId < 10000L) continue;
            checksum ^= clusterId;
            Cluster cluster = entry.getValue();
            cluster.write((DataOutput)dos);
        }
        return checksum;
    }

    public long saveBrokers(CountingDataOutputStream dos, long checksum) throws IOException {
        Map<String, List<FsBroker>> addressListMap = this.brokerMgr.getBrokerListMap();
        int size = addressListMap.size();
        checksum ^= (long)size;
        dos.writeInt(size);
        for (Map.Entry<String, List<FsBroker>> entry : addressListMap.entrySet()) {
            Text.writeString((DataOutput)dos, (String)entry.getKey());
            List<FsBroker> addrs = entry.getValue();
            size = addrs.size();
            checksum ^= (long)size;
            dos.writeInt(size);
            for (FsBroker addr : addrs) {
                addr.write((DataOutput)dos);
            }
        }
        return checksum;
    }

    public long loadBrokers(DataInputStream dis, long checksum) throws IOException, DdlException {
        int count = dis.readInt();
        checksum ^= (long)count;
        for (long i = 0L; i < (long)count; ++i) {
            String brokerName = Text.readString((DataInput)dis);
            int size = dis.readInt();
            checksum ^= (long)size;
            ArrayList addrs = Lists.newArrayList();
            for (int j = 0; j < size; ++j) {
                FsBroker addr = FsBroker.readIn(dis);
                addrs.add(addr);
            }
            this.brokerMgr.replayAddBrokers(brokerName, addrs);
        }
        LOG.info("finished replay brokerMgr from image");
        return checksum;
    }

    public void replayUpdateClusterAndBackends(BackendIdsUpdateInfo info) {
        for (long id : info.getBackendList()) {
            Backend backend = this.systemInfo.getBackend(id);
            Cluster cluster = this.nameToCluster.get(backend.getOwnerClusterName());
            cluster.removeBackend(id);
            backend.setDecommissioned(false);
            backend.clearClusterName();
            backend.setBackendState(Backend.BackendState.free);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpImage() {
        String dumpFilePath;
        LOG.info("begin to dump meta data");
        ArrayList databases = Lists.newArrayList();
        ArrayList tableLists = Lists.newArrayList();
        this.tryLock(true);
        try {
            for (long dbId : this.getDbIds()) {
                Database db = this.getDbNullable(dbId);
                databases.add(db);
            }
            databases.sort(Comparator.comparing(Database::getId));
            MetaLockUtils.readLockDatabases(databases);
            LOG.info("acquired all the dbs' read lock.");
            for (Database db : databases) {
                List<Table> tableList = db.getTablesOnIdOrder();
                MetaLockUtils.readLockTables(tableList);
                tableLists.add(tableList);
            }
            LOG.info("acquired all the tables' read lock.");
            this.load.readLock();
            LOG.info("acquired all jobs' read lock.");
            long journalId = this.getMaxJournalId();
            File dumpFile = new File(Config.meta_dir, "image." + journalId);
            dumpFilePath = dumpFile.getAbsolutePath();
            try {
                LOG.info("begin to dump {}", (Object)dumpFilePath);
                this.saveImage(dumpFile, journalId);
            }
            catch (IOException e) {
                LOG.error("failed to dump image to {}", (Object)dumpFilePath, (Object)e);
            }
        }
        finally {
            this.load.readUnlock();
            for (int i = databases.size() - 1; i >= 0; --i) {
                MetaLockUtils.readUnlockTables((List)tableLists.get(i));
            }
            MetaLockUtils.readUnlockDatabases(databases);
            this.unlock();
        }
        LOG.info("finished dumping image to {}", (Object)dumpFilePath);
        return dumpFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateTable(TruncateTableStmt truncateTableStmt) throws DdlException {
        OlapTable copiedTbl;
        TableRef tblRef = truncateTableStmt.getTblRef();
        TableName dbTbl = tblRef.getName();
        HashMap origPartitions = Maps.newHashMap();
        HashMap partitionsDistributionInfo = Maps.newHashMap();
        boolean truncateEntireTable = tblRef.getPartitionNames() == null;
        Database db = this.getDbOrDdlException(dbTbl.getDb());
        OlapTable olapTable = db.getOlapTableOrDdlException(dbTbl.getTbl());
        olapTable.readLock();
        try {
            if (olapTable.getState() != OlapTable.OlapTableState.NORMAL) {
                throw new DdlException("Table' state is not NORMAL: " + (Object)((Object)olapTable.getState()));
            }
            if (!truncateEntireTable) {
                for (String partName : tblRef.getPartitionNames().getPartitionNames()) {
                    Partition partition = olapTable.getPartition(partName);
                    if (partition == null) {
                        throw new DdlException("Partition " + partName + " does not exist");
                    }
                    origPartitions.put(partName, partition.getId());
                    partitionsDistributionInfo.put(partition.getId(), partition.getDistributionInfo());
                }
            } else {
                for (Partition partition : olapTable.getPartitions()) {
                    origPartitions.put(partition.getName(), partition.getId());
                    partitionsDistributionInfo.put(partition.getId(), partition.getDistributionInfo());
                }
            }
            copiedTbl = olapTable.selectiveCopy(origPartitions.keySet(), MaterializedIndex.IndexExtState.VISIBLE, false);
        }
        finally {
            olapTable.readUnlock();
        }
        ArrayList newPartitions = Lists.newArrayList();
        HashSet tabletIdSet = Sets.newHashSet();
        try {
            for (Map.Entry entry : origPartitions.entrySet()) {
                long oldPartitionId = (Long)entry.getValue();
                long newPartitionId = this.getNextId();
                Partition newPartition = this.createPartitionWithIndices(db.getClusterName(), db.getId(), copiedTbl.getId(), copiedTbl.getBaseIndexId(), newPartitionId, (String)entry.getKey(), copiedTbl.getIndexIdToMeta(), (DistributionInfo)partitionsDistributionInfo.get(oldPartitionId), copiedTbl.getPartitionInfo().getDataProperty(oldPartitionId).getStorageMedium(), copiedTbl.getPartitionInfo().getReplicaAllocation(oldPartitionId), null, copiedTbl.getCopiedBfColumns(), copiedTbl.getBfFpp(), tabletIdSet, copiedTbl.getCopiedIndexes(), copiedTbl.isInMemory(), copiedTbl.getStorageFormat(), copiedTbl.getPartitionInfo().getTabletType(oldPartitionId), copiedTbl.getCompressionType(), copiedTbl.getDataSortInfo());
                newPartitions.add(newPartition);
            }
        }
        catch (DdlException e) {
            for (Long tabletId : tabletIdSet) {
                Catalog.getCurrentInvertedIndex().deleteTablet(tabletId);
            }
            throw e;
        }
        Preconditions.checkState((origPartitions.size() == newPartitions.size() ? 1 : 0) != 0);
        olapTable = (OlapTable)db.getTableOrDdlException(copiedTbl.getId());
        olapTable.writeLockOrDdlException();
        try {
            if (olapTable.getState() != OlapTable.OlapTableState.NORMAL) {
                throw new DdlException("Table' state is not NORMAL: " + (Object)((Object)olapTable.getState()));
            }
            for (Map.Entry entry : origPartitions.entrySet()) {
                Partition partition = copiedTbl.getPartition((Long)entry.getValue());
                if (partition != null && partition.getName().equalsIgnoreCase((String)entry.getKey())) continue;
                throw new DdlException("Partition [" + (String)entry.getKey() + "] is changed");
            }
            boolean metaChanged = false;
            if (olapTable.getIndexNameToId().size() != copiedTbl.getIndexNameToId().size()) {
                metaChanged = true;
            } else {
                Map<Long, Integer> copiedIndexIdToSchemaHash = copiedTbl.getIndexIdToSchemaHash();
                for (Map.Entry<Long, Integer> entry : olapTable.getIndexIdToSchemaHash().entrySet()) {
                    long indexId = entry.getKey();
                    if (!copiedIndexIdToSchemaHash.containsKey(indexId)) {
                        metaChanged = true;
                        break;
                    }
                    if (copiedIndexIdToSchemaHash.get(indexId).equals(entry.getValue())) continue;
                    metaChanged = true;
                    break;
                }
            }
            if (metaChanged) {
                throw new DdlException("Table[" + copiedTbl.getName() + "]'s meta has been changed. try again.");
            }
            this.truncateTableInternal(olapTable, newPartitions, truncateEntireTable);
            TruncateTableInfo info = new TruncateTableInfo(db.getId(), olapTable.getId(), newPartitions, truncateEntireTable);
            this.editLog.logTruncateTable(info);
        }
        finally {
            olapTable.writeUnlock();
        }
        LOG.info("finished to truncate table {}, partitions: {}", (Object)tblRef.getName().toSql(), (Object)tblRef.getPartitionNames());
    }

    private void truncateTableInternal(OlapTable olapTable, List<Partition> newPartitions, boolean isEntireTable) {
        HashSet oldTabletIds = Sets.newHashSet();
        for (Partition newPartition : newPartitions) {
            Partition oldPartition = olapTable.replacePartition(newPartition);
            for (MaterializedIndex index : oldPartition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL)) {
                index.getTablets().stream().forEach(t -> oldTabletIds.add(t.getId()));
            }
        }
        if (isEntireTable) {
            olapTable.dropAllTempPartitions();
        }
        for (Long tabletId : oldTabletIds) {
            Catalog.getCurrentInvertedIndex().deleteTablet(tabletId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayTruncateTable(TruncateTableInfo info) throws MetaNotFoundException {
        Database db = this.getDbOrMetaException(info.getDbId());
        OlapTable olapTable = (OlapTable)db.getTableOrMetaException(info.getTblId(), Table.TableType.OLAP);
        olapTable.writeLock();
        try {
            this.truncateTableInternal(olapTable, info.getPartitions(), info.isEntireTable());
            if (!Catalog.isCheckpointThread()) {
                TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
                for (Partition partition : info.getPartitions()) {
                    long partitionId = partition.getId();
                    TStorageMedium medium = olapTable.getPartitionInfo().getDataProperty(partitionId).getStorageMedium();
                    for (MaterializedIndex mIndex : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL)) {
                        long indexId = mIndex.getId();
                        int schemaHash = olapTable.getSchemaHashByIndexId(indexId);
                        TabletMeta tabletMeta = new TabletMeta(db.getId(), olapTable.getId(), partitionId, indexId, schemaHash, medium);
                        for (Tablet tablet : mIndex.getTablets()) {
                            long tabletId = tablet.getId();
                            invertedIndex.addTablet(tabletId, tabletMeta);
                            for (Replica replica : tablet.getReplicas()) {
                                invertedIndex.addReplica(tabletId, replica);
                            }
                        }
                    }
                }
            }
        }
        finally {
            olapTable.writeUnlock();
        }
    }

    public void createFunction(CreateFunctionStmt stmt) throws UserException {
        FunctionName name = stmt.getFunctionName();
        Database db = this.getDbOrDdlException(name.getDb());
        db.addFunction(stmt.getFunction());
    }

    public void replayCreateFunction(Function function) throws MetaNotFoundException {
        String dbName = function.getFunctionName().getDb();
        Database db = this.getDbOrMetaException(dbName);
        db.replayAddFunction(function);
    }

    public void dropFunction(DropFunctionStmt stmt) throws UserException {
        FunctionName name = stmt.getFunctionName();
        Database db = this.getDbOrDdlException(name.getDb());
        db.dropFunction(stmt.getFunction());
    }

    public void replayDropFunction(FunctionSearchDesc functionSearchDesc) throws MetaNotFoundException {
        String dbName = functionSearchDesc.getName().getDb();
        Database db = this.getDbOrMetaException(dbName);
        db.replayDropFunction(functionSearchDesc);
    }

    public void setConfig(AdminSetConfigStmt stmt) throws DdlException {
        Map<String, String> configs = stmt.getConfigs();
        Preconditions.checkState((configs.size() == 1 ? 1 : 0) != 0);
        for (Map.Entry<String, String> entry : configs.entrySet()) {
            ConfigBase.setMutableConfig(entry.getKey(), entry.getValue());
        }
    }

    public void replayBackendReplicasInfo(BackendReplicasInfo backendReplicasInfo) {
        long backendId = backendReplicasInfo.getBackendId();
        List<BackendReplicasInfo.ReplicaReportInfo> replicaInfos = backendReplicasInfo.getReplicaReportInfos();
        for (BackendReplicasInfo.ReplicaReportInfo info : replicaInfos) {
            if (this.tabletInvertedIndex.getTabletMeta(info.tabletId) == null) continue;
            Replica replica = this.tabletInvertedIndex.getReplica(info.tabletId, backendId);
            if (replica == null) {
                LOG.warn("failed to find replica of tablet {} on backend {} when replaying backend report info", (Object)info.tabletId, (Object)backendId);
                continue;
            }
            switch (info.type) {
                case BAD: {
                    replica.setBad(true);
                    break;
                }
                case MISSING_VERSION: {
                    replica.updateLastFailedVersion(info.lastFailedVersion);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void replayBackendTabletsInfo(BackendTabletsInfo backendTabletsInfo) {
        List<Pair<Long, Integer>> tabletsWithSchemaHash = backendTabletsInfo.getTabletSchemaHash();
        if (!tabletsWithSchemaHash.isEmpty()) {
            for (Pair<Long, Integer> tabletInfo : tabletsWithSchemaHash) {
                LOG.warn("find an old backendTabletsInfo for tablet {}, ignore it", tabletInfo.first);
            }
            return;
        }
        List<ReplicaPersistInfo> replicaPersistInfos = backendTabletsInfo.getReplicaPersistInfos();
        for (ReplicaPersistInfo info : replicaPersistInfos) {
            OlapTable olapTable = this.getDb(info.getDbId()).flatMap(db -> db.getTable(info.getTableId())).filter(t -> t.getType() == Table.TableType.OLAP).orElse(null);
            if (olapTable == null) continue;
            olapTable.writeLock();
            try {
                Replica replica;
                Tablet tablet;
                MaterializedIndex mindex;
                Partition partition = olapTable.getPartition(info.getPartitionId());
                if (partition == null || (mindex = partition.getIndex(info.getIndexId())) == null || (tablet = mindex.getTablet(info.getTabletId())) == null || (replica = tablet.getReplicaById(info.getReplicaId())) == null) continue;
                replica.setBad(true);
                LOG.debug("get replica {} of tablet {} on backend {} to bad when replaying", (Object)info.getReplicaId(), (Object)info.getTabletId(), (Object)info.getBackendId());
            }
            finally {
                olapTable.writeUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertDistributionType(Database db, OlapTable tbl) throws DdlException {
        tbl.writeLockOrDdlException();
        try {
            if (tbl.isColocateTable()) {
                throw new DdlException("Cannot change distribution type of colocate table.");
            }
            if (tbl.getKeysType() == KeysType.UNIQUE_KEYS) {
                throw new DdlException("Cannot change distribution type of unique keys table.");
            }
            if (tbl.getKeysType() == KeysType.AGG_KEYS) {
                for (Column column : tbl.getBaseSchema()) {
                    if (column.getAggregationType() != AggregateType.REPLACE && column.getAggregationType() != AggregateType.REPLACE_IF_NOT_NULL) continue;
                    throw new DdlException("Cannot change distribution type of aggregate keys table which has value columns with " + (Object)((Object)column.getAggregationType()) + " type.");
                }
            }
            if (!tbl.convertHashDistributionToRandomDistribution()) {
                throw new DdlException("Table " + tbl.getName() + " is not hash distributed");
            }
            TableInfo tableInfo = TableInfo.createForModifyDistribution(db.getId(), tbl.getId());
            this.editLog.logModifyDistributionType(tableInfo);
            LOG.info("finished to modify distribution type of table from hash to random : " + tbl.getName());
        }
        finally {
            tbl.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayConvertDistributionType(TableInfo info) throws MetaNotFoundException {
        Database db = this.getDbOrMetaException(info.getDbId());
        OlapTable olapTable = (OlapTable)db.getTableOrMetaException(info.getTableId(), Table.TableType.OLAP);
        olapTable.writeLock();
        try {
            olapTable.convertHashDistributionToRandomDistribution();
            LOG.info("replay modify distribution type of table from hash to random : " + olapTable.getName());
        }
        finally {
            olapTable.writeUnlock();
        }
    }

    public void replaceTempPartition(Database db, OlapTable olapTable, ReplacePartitionClause clause) throws DdlException {
        Preconditions.checkState((boolean)olapTable.isWriteLockHeldByCurrentThread());
        List<String> partitionNames = clause.getPartitionNames();
        List<String> tempPartitionNames = clause.getTempPartitionNames();
        boolean isStrictRange = clause.isStrictRange();
        boolean useTempPartitionName = clause.useTempPartitionName();
        for (String partName : partitionNames) {
            if (olapTable.checkPartitionNameExist(partName, false)) continue;
            throw new DdlException("Partition[" + partName + "] does not exist");
        }
        for (String partName : tempPartitionNames) {
            if (olapTable.checkPartitionNameExist(partName, true)) continue;
            throw new DdlException("Temp partition[" + partName + "] does not exist");
        }
        olapTable.replaceTempPartitions(partitionNames, tempPartitionNames, isStrictRange, useTempPartitionName);
        ReplacePartitionOperationLog info = new ReplacePartitionOperationLog(db.getId(), olapTable.getId(), partitionNames, tempPartitionNames, isStrictRange, useTempPartitionName);
        this.editLog.logReplaceTempPartition(info);
        LOG.info("finished to replace partitions {} with temp partitions {} from table: {}", clause.getPartitionNames(), clause.getTempPartitionNames(), (Object)olapTable.getName());
    }

    public void replayReplaceTempPartition(ReplacePartitionOperationLog replaceTempPartitionLog) throws MetaNotFoundException {
        long dbId = replaceTempPartitionLog.getDbId();
        long tableId = replaceTempPartitionLog.getTblId();
        Database db = this.getDbOrMetaException(dbId);
        OlapTable olapTable = (OlapTable)db.getTableOrMetaException(tableId, Table.TableType.OLAP);
        olapTable.writeLock();
        try {
            olapTable.replaceTempPartitions(replaceTempPartitionLog.getPartitions(), replaceTempPartitionLog.getTempPartitions(), replaceTempPartitionLog.isStrictRange(), replaceTempPartitionLog.useTempPartitionName());
        }
        catch (DdlException e) {
            throw new MetaNotFoundException(e);
        }
        finally {
            olapTable.writeUnlock();
        }
    }

    public void installPlugin(InstallPluginStmt stmt) throws UserException, IOException {
        this.pluginMgr.installPlugin(stmt);
    }

    public long savePlugins(DataOutputStream dos, long checksum) throws IOException {
        Catalog.getCurrentPluginMgr().write(dos);
        return checksum;
    }

    public long loadPlugins(DataInputStream dis, long checksum) throws IOException {
        Catalog.getCurrentPluginMgr().readFields(dis);
        LOG.info("finished replay plugins from image");
        return checksum;
    }

    public void replayInstallPlugin(PluginInfo pluginInfo) throws MetaNotFoundException {
        try {
            this.pluginMgr.replayLoadDynamicPlugin(pluginInfo);
        }
        catch (Exception e) {
            throw new MetaNotFoundException(e);
        }
    }

    public void uninstallPlugin(UninstallPluginStmt stmt) throws IOException, UserException {
        PluginInfo info = this.pluginMgr.uninstallPlugin(stmt.getPluginName());
        if (null != info) {
            this.editLog.logUninstallPlugin(info);
        }
        LOG.info("uninstall plugin = " + stmt.getPluginName());
    }

    public void replayUninstallPlugin(PluginInfo pluginInfo) throws MetaNotFoundException {
        try {
            this.pluginMgr.uninstallPlugin(pluginInfo.getName());
        }
        catch (Exception e) {
            throw new MetaNotFoundException(e);
        }
    }

    public void checkTablets(AdminCheckTabletsStmt stmt) {
        AdminCheckTabletsStmt.CheckType type = stmt.getType();
        switch (type) {
            case CONSISTENCY: {
                this.consistencyChecker.addTabletsToCheck(stmt.getTabletIds());
                break;
            }
        }
    }

    public void setReplicaStatus(AdminSetReplicaStatusStmt stmt) throws MetaNotFoundException {
        long tabletId = stmt.getTabletId();
        long backendId = stmt.getBackendId();
        Replica.ReplicaStatus status = stmt.getStatus();
        this.setReplicaStatusInternal(tabletId, backendId, status, false);
    }

    public void setReplicaStatus(long tabletId, long backendId, Replica.ReplicaStatus status) throws MetaNotFoundException {
        this.setReplicaStatusInternal(tabletId, backendId, status, false);
    }

    public void replaySetReplicaStatus(SetReplicaStatusOperationLog log) throws MetaNotFoundException {
        this.setReplicaStatusInternal(log.getTabletId(), log.getBackendId(), log.getReplicaStatus(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setReplicaStatusInternal(long tabletId, long backendId, Replica.ReplicaStatus status, boolean isReplay) throws MetaNotFoundException {
        try {
            TabletMeta meta = this.tabletInvertedIndex.getTabletMeta(tabletId);
            if (meta == null) {
                throw new MetaNotFoundException("tablet does not exist");
            }
            Database db = this.getDbOrMetaException(meta.getDbId());
            Table table = db.getTableOrMetaException(meta.getTableId());
            table.writeLockOrMetaException();
            try {
                Replica replica = this.tabletInvertedIndex.getReplica(tabletId, backendId);
                if (replica == null) {
                    throw new MetaNotFoundException("replica does not exist on backend, beId=" + backendId);
                }
                if ((status == Replica.ReplicaStatus.BAD || status == Replica.ReplicaStatus.OK) && replica.setBad(status == Replica.ReplicaStatus.BAD)) {
                    if (!isReplay) {
                        SetReplicaStatusOperationLog log = new SetReplicaStatusOperationLog(backendId, tabletId, status);
                        this.getEditLog().logSetReplicaStatus(log);
                    }
                    LOG.info("set replica {} of tablet {} on backend {} as {}. is replay: {}", (Object)replica.getId(), (Object)tabletId, (Object)backendId, (Object)status, (Object)isReplay);
                }
            }
            finally {
                table.writeUnlock();
            }
        }
        catch (MetaNotFoundException e) {
            throw new MetaNotFoundException("set replica status failed, tabletId=" + tabletId, e);
        }
    }

    public void eraseDatabase(long dbId, boolean needEditLog) {
        Catalog.getCurrentCatalog().getLoadInstance().removeDbLoadJob(dbId);
        Catalog.getCurrentCatalog().getGlobalTransactionMgr().removeDatabaseTransactionMgr(dbId);
        if (needEditLog) {
            Catalog.getCurrentCatalog().getEditLog().logEraseDb(dbId);
        }
    }

    public void onEraseOlapTable(OlapTable olapTable, boolean isReplay) {
        TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
        Collection<Partition> allPartitions = olapTable.getAllPartitions();
        for (Partition partition : allPartitions) {
            for (MaterializedIndex index : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL)) {
                for (Tablet tablet : index.getTablets()) {
                    invertedIndex.deleteTablet(tablet.getId());
                }
            }
        }
        if (!isReplay) {
            AgentBatchTask batchTask = new AgentBatchTask();
            for (Partition partition : olapTable.getAllPartitions()) {
                List<MaterializedIndex> allIndices = partition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL);
                for (MaterializedIndex materializedIndex : allIndices) {
                    long indexId = materializedIndex.getId();
                    int schemaHash = olapTable.getSchemaHashByIndexId(indexId);
                    for (Tablet tablet : materializedIndex.getTablets()) {
                        long tabletId = tablet.getId();
                        List<Replica> replicas = tablet.getReplicas();
                        for (Replica replica : replicas) {
                            long backendId = replica.getBackendId();
                            DropReplicaTask dropTask = new DropReplicaTask(backendId, tabletId, schemaHash);
                            batchTask.addTask(dropTask);
                        }
                    }
                }
            }
            AgentTaskExecutor.submit(batchTask);
        }
        Catalog.getCurrentColocateIndex().removeTable(olapTable.getId());
    }

    public void onErasePartition(Partition partition) {
        TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
        for (MaterializedIndex index : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL)) {
            for (Tablet tablet : index.getTablets()) {
                invertedIndex.deleteTablet(tablet.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanTrash(AdminCleanTrashStmt stmt) {
        List<Backend> backends = stmt.getBackends();
        for (Backend backend : backends) {
            BackendService.Client client = null;
            TNetworkAddress address = null;
            boolean ok = false;
            try {
                address = new TNetworkAddress(backend.getHost(), backend.getBePort());
                client = ClientPool.backendPool.borrowObject(address);
                client.cleanTrash();
                ok = true;
                if (ok) {
                    ClientPool.backendPool.returnObject(address, client);
                    continue;
                }
                ClientPool.backendPool.invalidateObject(address, client);
            }
            catch (Exception e) {
                try {
                    LOG.warn("trash clean exec error. backend[{}]", (Object)backend.getId(), (Object)e);
                    if (ok) {
                        ClientPool.backendPool.returnObject(address, client);
                        continue;
                    }
                    ClientPool.backendPool.invalidateObject(address, client);
                }
                catch (Throwable throwable) {
                    if (ok) {
                        ClientPool.backendPool.returnObject(address, client);
                    } else {
                        ClientPool.backendPool.invalidateObject(address, client);
                    }
                    throw throwable;
                }
            }
        }
    }

    public static boolean isStoredTableNamesLowerCase() {
        return GlobalVariable.lowerCaseTableNames == 1;
    }

    public static boolean isTableNamesCaseInsensitive() {
        return GlobalVariable.lowerCaseTableNames == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactTable(AdminCompactTableStmt stmt) throws DdlException {
        String dbName = stmt.getDbName();
        String tableName = stmt.getTblName();
        String type = stmt.getCompactionType();
        Database db = this.getDbOrDdlException(dbName);
        OlapTable olapTable = db.getOlapTableOrDdlException(tableName);
        AgentBatchTask batchTask = new AgentBatchTask();
        olapTable.readLock();
        try {
            List<String> partitionNames = stmt.getPartitions();
            LOG.info("Table compaction. database: {}, table: {}, partition: {}, type: {}", (Object)dbName, (Object)tableName, (Object)Joiner.on((String)", ").join(partitionNames), (Object)type);
            for (String parName : partitionNames) {
                Partition partition = olapTable.getPartition(parName);
                if (partition == null) {
                    throw new DdlException("partition[" + parName + "] not exist in table[" + tableName + "]");
                }
                for (MaterializedIndex idx : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.VISIBLE)) {
                    for (Tablet tablet : idx.getTablets()) {
                        for (Replica replica : tablet.getReplicas()) {
                            CompactionTask compactionTask = new CompactionTask(replica.getBackendId(), db.getId(), olapTable.getId(), partition.getId(), idx.getId(), tablet.getId(), olapTable.getSchemaHashByIndexId(idx.getId()), type);
                            batchTask.addTask(compactionTask);
                        }
                    }
                }
            }
        }
        finally {
            olapTable.readUnlock();
        }
        AgentTaskExecutor.submit(batchTask);
    }

    private static class SingletonHolder {
        private static final Catalog INSTANCE = new Catalog();

        private SingletonHolder() {
        }
    }
}

