/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.io.Text;
import org.apache.doris.thrift.TBrokerTable;
import org.apache.doris.thrift.TTableDescriptor;
import org.apache.doris.thrift.TTableType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrokerTable
extends Table {
    private static final Logger LOG = LogManager.getLogger(BrokerTable.class);
    private static final String BROKER_NAME = "broker_name";
    private static final String PATH = "path";
    private static final String COLUMN_SEPARATOR = "column_separator";
    private static final String LINE_DELIMITER = "line_delimiter";
    private static final String FILE_FORMAT = "format";
    private String brokerName;
    private List<String> paths;
    private String columnSeparator;
    private String lineDelimiter;
    private String fileFormat;
    private Map<String, String> brokerProperties;

    public BrokerTable() {
        super(Table.TableType.BROKER);
    }

    public BrokerTable(long id, String name, List<Column> schema, Map<String, String> properties) throws DdlException {
        super(id, name, Table.TableType.BROKER, schema);
        this.validate(properties);
    }

    public void setBrokerProperties(Map<String, String> brokerProperties) {
        this.brokerProperties = brokerProperties;
        if (this.brokerProperties == null) {
            this.brokerProperties = Maps.newHashMap();
        }
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public List<String> getEncodedPaths() {
        ArrayList encodedPath = Lists.newArrayList();
        for (String path : this.paths) {
            encodedPath.add(path.replaceAll(",", "%2c").replaceAll("%", "%25"));
        }
        return encodedPath;
    }

    public String getColumnSeparator() {
        return this.columnSeparator;
    }

    public String getReadableColumnSeparator() {
        return StringEscapeUtils.escapeJava((String)this.columnSeparator);
    }

    public String getLineDelimiter() {
        return this.lineDelimiter;
    }

    public String getReadableLineDelimiter() {
        return StringEscapeUtils.escapeJava((String)this.lineDelimiter);
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public Map<String, String> getBrokerProperties() {
        return this.brokerProperties;
    }

    public boolean isWritable() {
        for (String path : this.paths) {
            if (!path.endsWith("/*")) continue;
            return true;
        }
        return false;
    }

    public String getWritablePath() {
        for (String path : this.paths) {
            if (!path.endsWith("/*")) continue;
            return path.substring(0, path.lastIndexOf("*"));
        }
        return null;
    }

    private void validate(Map<String, String> properties) throws DdlException {
        if (properties == null) {
            throw new DdlException("Please set properties of broker table, they are: broker_name, path, column_delimiter, line_delimiter and format.");
        }
        HashMap copiedProps = Maps.newHashMap(properties);
        this.brokerName = (String)copiedProps.get(BROKER_NAME);
        if (Strings.isNullOrEmpty((String)this.brokerName)) {
            throw new DdlException("Broker name is null. Please add properties('broker_name'='xxx') when create table");
        }
        copiedProps.remove(BROKER_NAME);
        String pathsStr = (String)copiedProps.get(PATH);
        if (Strings.isNullOrEmpty((String)pathsStr)) {
            throw new DdlException("Path is null. Please add properties('path'='xxx') when create table");
        }
        copiedProps.remove(PATH);
        String[] origPaths = pathsStr.split(",");
        this.paths = Lists.newArrayList();
        try {
            for (String origPath : origPaths) {
                origPath = origPath.trim();
                origPath = URLDecoder.decode(origPath, "UTF-8");
                this.paths.add(origPath);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new DdlException("Encounter path encoding exception: " + e.getMessage());
        }
        this.columnSeparator = (String)copiedProps.get(COLUMN_SEPARATOR);
        if (Strings.isNullOrEmpty((String)this.columnSeparator)) {
            this.columnSeparator = "\t";
        }
        copiedProps.remove(COLUMN_SEPARATOR);
        this.lineDelimiter = (String)copiedProps.get(LINE_DELIMITER);
        if (Strings.isNullOrEmpty((String)this.lineDelimiter)) {
            this.lineDelimiter = "\n";
        }
        copiedProps.remove(LINE_DELIMITER);
        this.fileFormat = (String)copiedProps.get(FILE_FORMAT);
        if (this.fileFormat != null) {
            this.fileFormat = this.fileFormat.toLowerCase();
            switch (this.fileFormat) {
                case "csv": 
                case "parquet": {
                    break;
                }
                default: {
                    throw new DdlException("Invalid file type: " + ((Object)copiedProps).toString() + ".Only support csv and parquet.");
                }
            }
        }
        copiedProps.remove(FILE_FORMAT);
        if (!copiedProps.isEmpty()) {
            throw new DdlException("Unknown table properties: " + ((Object)copiedProps).toString());
        }
    }

    @Override
    public TTableDescriptor toThrift() {
        TBrokerTable tBrokerTable = new TBrokerTable();
        TTableDescriptor tTableDescriptor = new TTableDescriptor(this.getId(), TTableType.BROKER_TABLE, this.fullSchema.size(), 0, this.getName(), "");
        tTableDescriptor.setBrokerTable(tBrokerTable);
        return tTableDescriptor;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        Text.writeString((DataOutput)out, (String)this.brokerName);
        out.writeInt(this.paths.size());
        for (String string : this.paths) {
            Text.writeString((DataOutput)out, (String)string);
        }
        Text.writeString((DataOutput)out, (String)this.columnSeparator);
        Text.writeString((DataOutput)out, (String)this.lineDelimiter);
        out.writeInt(this.brokerProperties.size());
        for (Map.Entry entry : this.brokerProperties.entrySet()) {
            Text.writeString((DataOutput)out, (String)((String)entry.getKey()));
            Text.writeString((DataOutput)out, (String)((String)entry.getValue()));
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int i;
        super.readFields(in);
        this.brokerName = Text.readString((DataInput)in);
        int size = in.readInt();
        this.paths = Lists.newArrayList();
        for (i = 0; i < size; ++i) {
            this.paths.add(Text.readString((DataInput)in));
        }
        this.columnSeparator = Text.readString((DataInput)in);
        this.lineDelimiter = Text.readString((DataInput)in);
        this.brokerProperties = Maps.newHashMap();
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            String key = Text.readString((DataInput)in);
            String val = Text.readString((DataInput)in);
            this.brokerProperties.put(key, val);
        }
    }
}

