/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.doris.analysis.ModifyBrokerClause;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.FsBroker;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.util.NetUtils;
import org.apache.doris.common.util.TimeUtils;

public class BrokerMgr {
    public static final ImmutableList<String> BROKER_PROC_NODE_TITLE_NAMES = new ImmutableList.Builder().add((Object)"Name").add((Object)"IP").add((Object)"HostName").add((Object)"Port").add((Object)"Alive").add((Object)"LastStartTime").add((Object)"LastUpdateTime").add((Object)"ErrMsg").build();
    public static final int HOSTNAME_INDEX = 2;
    private final Map<String, ArrayListMultimap<String, FsBroker>> brokersMap = Maps.newHashMap();
    private final Map<String, List<FsBroker>> brokerListMap = Maps.newHashMap();
    private final ReentrantLock lock = new ReentrantLock();
    private BrokerProcNode procNode = null;

    public Map<String, List<FsBroker>> getBrokerListMap() {
        return this.brokerListMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FsBroker> getAllBrokers() {
        ArrayList brokers = Lists.newArrayList();
        this.lock.lock();
        try {
            for (List<FsBroker> list : this.brokerListMap.values()) {
                brokers.addAll(list);
            }
        }
        finally {
            this.lock.unlock();
        }
        return brokers;
    }

    public void execute(ModifyBrokerClause clause) throws DdlException {
        switch (clause.getOp()) {
            case OP_ADD: {
                this.addBrokers(clause.getBrokerName(), clause.getHostPortPairs());
                break;
            }
            case OP_DROP: {
                this.dropBrokers(clause.getBrokerName(), clause.getHostPortPairs());
                break;
            }
            case OP_DROP_ALL: {
                this.dropAllBroker(clause.getBrokerName());
                break;
            }
        }
    }

    public boolean containsBroker(String brokerName) {
        this.lock.lock();
        try {
            boolean bl = this.brokersMap.containsKey(brokerName);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FsBroker getAnyBroker(String brokerName) {
        this.lock.lock();
        try {
            List<FsBroker> brokerList = this.brokerListMap.get(brokerName);
            if (brokerList == null || brokerList.isEmpty()) {
                FsBroker fsBroker = null;
                return fsBroker;
            }
            Collections.shuffle(brokerList);
            for (FsBroker fsBroker : brokerList) {
                if (!fsBroker.isAlive) continue;
                FsBroker fsBroker2 = fsBroker;
                return fsBroker2;
            }
            Iterator<FsBroker> iterator = null;
            return iterator;
        }
        finally {
            this.lock.unlock();
        }
    }

    public FsBroker getBroker(String brokerName, String host) throws AnalysisException {
        if (brokerName.equalsIgnoreCase("__DORIS_MULTI_LOAD_BROKER__")) {
            return new FsBroker("127.0.0.1", 0);
        }
        this.lock.lock();
        try {
            ArrayListMultimap<String, FsBroker> brokerAddsMap = this.brokersMap.get(brokerName);
            if (brokerAddsMap == null || brokerAddsMap.size() == 0) {
                throw new AnalysisException("Unknown broker name(" + brokerName + ")");
            }
            List<FsBroker> brokers = brokerAddsMap.get((Object)host);
            for (FsBroker fsBroker : brokers) {
                if (!fsBroker.isAlive) continue;
                FsBroker fsBroker2 = fsBroker;
                return fsBroker2;
            }
            brokers = this.brokerListMap.get(brokerName);
            Collections.shuffle(brokers);
            for (FsBroker fsBroker : brokers) {
                if (!fsBroker.isAlive) continue;
                FsBroker fsBroker3 = fsBroker;
                return fsBroker3;
            }
            throw new AnalysisException("failed to find alive broker: " + brokerName);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FsBroker getBroker(String name, String host, int port) {
        this.lock.lock();
        try {
            ArrayListMultimap<String, FsBroker> brokerAddsMap = this.brokersMap.get(name);
            if (brokerAddsMap == null || brokerAddsMap.size() == 0) {
                FsBroker fsBroker = null;
                return fsBroker;
            }
            List addressList = brokerAddsMap.get((Object)host);
            if (addressList.isEmpty()) {
                FsBroker fsBroker = null;
                return fsBroker;
            }
            for (FsBroker fsBroker : addressList) {
                if (fsBroker.port != port) continue;
                FsBroker fsBroker2 = fsBroker;
                return fsBroker2;
            }
            Iterator iterator = null;
            return iterator;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBrokers(String name, Collection<Pair<String, Integer>> addresses) throws DdlException {
        this.lock.lock();
        try {
            ArrayListMultimap brokerAddrsMap = this.brokersMap.get(name);
            if (brokerAddrsMap == null) {
                brokerAddrsMap = ArrayListMultimap.create();
            }
            ArrayList addedBrokerAddress = Lists.newArrayList();
            for (Pair<String, Integer> pair : addresses) {
                List addressList = brokerAddrsMap.get((Object)((String)pair.first));
                for (FsBroker addr : addressList) {
                    if (addr.port != (Integer)pair.second) continue;
                    throw new DdlException("Broker(" + (String)pair.first + ":" + pair.second + ") has already in brokers.");
                }
                addedBrokerAddress.add(new FsBroker((String)pair.first, (Integer)pair.second));
            }
            Catalog.getCurrentCatalog().getEditLog().logAddBroker(new ModifyBrokerInfo(name, addedBrokerAddress));
            for (FsBroker address : addedBrokerAddress) {
                brokerAddrsMap.put((Object)address.ip, (Object)address);
            }
            this.brokersMap.put(name, (ArrayListMultimap<String, FsBroker>)brokerAddrsMap);
            this.brokerListMap.put(name, Lists.newArrayList((Iterable)brokerAddrsMap.values()));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayAddBrokers(String name, List<FsBroker> addresses) {
        this.lock.lock();
        try {
            ArrayListMultimap brokerAddrsMap = this.brokersMap.get(name);
            if (brokerAddrsMap == null) {
                brokerAddrsMap = ArrayListMultimap.create();
                this.brokersMap.put(name, (ArrayListMultimap<String, FsBroker>)brokerAddrsMap);
            }
            for (FsBroker address : addresses) {
                brokerAddrsMap.put((Object)address.ip, (Object)address);
            }
            this.brokerListMap.put(name, Lists.newArrayList((Iterable)brokerAddrsMap.values()));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropBrokers(String name, Collection<Pair<String, Integer>> addresses) throws DdlException {
        this.lock.lock();
        try {
            ArrayListMultimap<String, FsBroker> brokerAddrsMap = this.brokersMap.get(name);
            if (brokerAddrsMap == null) {
                throw new DdlException("Unknown broker name(" + name + ")");
            }
            ArrayList droppedAddressList = Lists.newArrayList();
            for (Pair<String, Integer> pair : addresses) {
                List addressList = brokerAddrsMap.get((Object)((String)pair.first));
                boolean found = false;
                for (FsBroker addr : addressList) {
                    if (addr.port != (Integer)pair.second) continue;
                    droppedAddressList.add(addr);
                    found = true;
                    break;
                }
                if (found) continue;
                throw new DdlException("Broker(" + (String)pair.first + ":" + pair.second + ") has not in brokers.");
            }
            Catalog.getCurrentCatalog().getEditLog().logDropBroker(new ModifyBrokerInfo(name, droppedAddressList));
            for (FsBroker address : droppedAddressList) {
                brokerAddrsMap.remove((Object)address.ip, (Object)address);
            }
            this.brokerListMap.put(name, Lists.newArrayList((Iterable)brokerAddrsMap.values()));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayDropBrokers(String name, List<FsBroker> addresses) {
        this.lock.lock();
        try {
            ArrayListMultimap<String, FsBroker> brokerAddrsMap = this.brokersMap.get(name);
            for (FsBroker addr : addresses) {
                brokerAddrsMap.remove((Object)addr.ip, (Object)addr);
            }
            this.brokerListMap.put(name, Lists.newArrayList((Iterable)brokerAddrsMap.values()));
        }
        finally {
            this.lock.unlock();
        }
    }

    public void dropAllBroker(String name) throws DdlException {
        this.lock.lock();
        try {
            if (!this.brokersMap.containsKey(name)) {
                throw new DdlException("Unknown broker name(" + name + ")");
            }
            Catalog.getCurrentCatalog().getEditLog().logDropAllBroker(name);
            this.brokersMap.remove(name);
            this.brokerListMap.remove(name);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void replayDropAllBroker(String name) {
        this.lock.lock();
        try {
            this.brokersMap.remove(name);
            this.brokerListMap.remove(name);
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<List<String>> getBrokersInfo() {
        this.lock.lock();
        try {
            if (this.procNode == null) {
                this.procNode = new BrokerProcNode();
            }
            List<List<String>> list = this.procNode.fetchResult().getRows();
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    public BrokerProcNode getProcNode() {
        this.lock.lock();
        try {
            if (this.procNode == null) {
                this.procNode = new BrokerProcNode();
            }
            BrokerProcNode brokerProcNode = this.procNode;
            return brokerProcNode;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static class ModifyBrokerInfo
    implements Writable {
        public String brokerName;
        public List<FsBroker> brokerAddresses;

        public ModifyBrokerInfo() {
        }

        public ModifyBrokerInfo(String brokerName, List<FsBroker> brokerAddresses) {
            this.brokerName = brokerName;
            this.brokerAddresses = brokerAddresses;
        }

        public void write(DataOutput out) throws IOException {
            Text.writeString((DataOutput)out, (String)this.brokerName);
            out.writeInt(this.brokerAddresses.size());
            for (FsBroker address : this.brokerAddresses) {
                address.write(out);
            }
        }

        public void readFields(DataInput in) throws IOException {
            this.brokerName = Text.readString((DataInput)in);
            int size = in.readInt();
            this.brokerAddresses = Lists.newArrayList();
            for (int i = 0; i < size; ++i) {
                this.brokerAddresses.add(FsBroker.readIn(in));
            }
        }

        public static ModifyBrokerInfo readIn(DataInput in) throws IOException {
            ModifyBrokerInfo info = new ModifyBrokerInfo();
            info.readFields(in);
            return info;
        }
    }

    public class BrokerProcNode
    implements ProcNodeInterface {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ProcResult fetchResult() {
            BaseProcResult result = new BaseProcResult();
            result.setNames((List<String>)BROKER_PROC_NODE_TITLE_NAMES);
            BrokerMgr.this.lock.lock();
            try {
                for (Map.Entry entry : BrokerMgr.this.brokersMap.entrySet()) {
                    String brokerName = (String)entry.getKey();
                    for (FsBroker broker : ((ArrayListMultimap)entry.getValue()).values()) {
                        ArrayList row = Lists.newArrayList();
                        row.add(brokerName);
                        row.add(broker.ip);
                        row.add(NetUtils.getHostnameByIp(broker.ip));
                        row.add(String.valueOf(broker.port));
                        row.add(String.valueOf(broker.isAlive));
                        row.add(TimeUtils.longToTimeString(broker.lastStartTime));
                        row.add(TimeUtils.longToTimeString(broker.lastUpdateTime));
                        row.add(broker.heartbeatErrMsg);
                        result.addRow(row);
                    }
                }
            }
            finally {
                BrokerMgr.this.lock.unlock();
            }
            return result;
        }
    }
}

