/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;

public class AuthorizationInfo
implements Writable {
    private String dbName;
    private Set<String> tableNameList;

    public AuthorizationInfo() {
    }

    public AuthorizationInfo(String dbName, Set<String> tableNameList) {
        this.dbName = dbName;
        this.tableNameList = tableNameList;
    }

    public String getDbName() {
        return this.dbName;
    }

    public Set<String> getTableNameList() {
        return this.tableNameList;
    }

    public void write(DataOutput out) throws IOException {
        if (this.dbName == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Text.writeString((DataOutput)out, (String)this.dbName);
        }
        if (this.tableNameList == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(this.tableNameList.size());
            for (String tableName : this.tableNameList) {
                Text.writeString((DataOutput)out, (String)tableName);
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        if (in.readBoolean()) {
            this.dbName = Text.readString((DataInput)in);
        }
        if (in.readBoolean()) {
            this.tableNameList = Sets.newHashSet();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                this.tableNameList.add(Text.readString((DataInput)in));
            }
        }
    }

    public String toString() {
        Gson gson = new Gson();
        return gson.toJson((Object)this);
    }
}

