/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.gson.annotations.SerializedName;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.Config;
import org.apache.doris.thrift.TColumnType;
import org.apache.doris.thrift.TTypeDesc;
import org.apache.doris.thrift.TTypeNode;
import org.apache.doris.thrift.TTypeNodeType;

public class ArrayType
extends Type {
    @SerializedName(value="itemType")
    private Type itemType;

    public ArrayType() {
        this.itemType = NULL;
    }

    public ArrayType(Type itemType) {
        this.itemType = itemType;
    }

    public void setItemType(Type itemType) {
        this.itemType = itemType;
    }

    public Type getItemType() {
        return this.itemType;
    }

    @Override
    public PrimitiveType getPrimitiveType() {
        return PrimitiveType.ARRAY;
    }

    @Override
    public boolean matchesType(Type t) {
        if (this.equals(t)) {
            return true;
        }
        if (!t.isArrayType()) {
            return false;
        }
        if (this.itemType.isNull()) {
            return true;
        }
        return this.itemType.matchesType(((ArrayType)t).itemType);
    }

    public static ArrayType create() {
        return new ArrayType();
    }

    public static ArrayType create(Type type) {
        return new ArrayType(type);
    }

    @Override
    public String toSql(int depth) {
        if (depth >= MAX_NESTING_DEPTH) {
            return "ARRAY<...>";
        }
        return String.format("ARRAY<%s>", this.itemType.toSql(depth + 1));
    }

    public boolean equals(Object other) {
        if (!(other instanceof ArrayType)) {
            return false;
        }
        ArrayType otherArrayType = (ArrayType)other;
        return otherArrayType.itemType.equals(this.itemType);
    }

    @Override
    public void toThrift(TTypeDesc container) {
        TTypeNode node = new TTypeNode();
        container.types.add(node);
        Preconditions.checkNotNull((Object)this.itemType);
        node.setType(TTypeNodeType.ARRAY);
        this.itemType.toThrift(container);
    }

    @Override
    protected String prettyPrint(int lpad) {
        String leftPadding = Strings.repeat((String)" ", (int)lpad);
        if (!this.itemType.isStructType()) {
            return leftPadding + this.toSql();
        }
        String structStr = this.itemType.prettyPrint(lpad);
        structStr = structStr.substring(lpad);
        return String.format("%sARRAY<%s>", leftPadding, structStr);
    }

    @Override
    public boolean isSupported() {
        if (!Config.enable_complex_type_support) {
            return false;
        }
        return !this.itemType.isNull();
    }

    public String toString() {
        return this.toSql(0);
    }

    @Override
    public TColumnType toColumnTypeThrift() {
        TColumnType thrift = new TColumnType();
        thrift.type = PrimitiveType.ARRAY.toThrift();
        return thrift;
    }

    @Override
    public boolean isFixedLengthType() {
        return false;
    }

    @Override
    public boolean supportsTablePartitioning() {
        return this.isSupported() && !this.isComplexType();
    }

    @Override
    public int getSlotSize() {
        return PrimitiveType.ARRAY.getSlotSize();
    }
}

