/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.doris.analysis.CastExpr;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.analysis.FunctionName;
import org.apache.doris.analysis.SelectStmt;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.SqlParser;
import org.apache.doris.analysis.SqlScanner;
import org.apache.doris.analysis.TypeDef;
import org.apache.doris.catalog.Function;
import org.apache.doris.catalog.FunctionSet;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.util.SqlParserUtils;
import org.apache.doris.thrift.TFunctionBinaryType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AliasFunction
extends Function {
    private static final Logger LOG = LogManager.getLogger(AliasFunction.class);
    private static final String DIGITAL_MASKING = "digital_masking";
    private Expr originFunction;
    private List<String> parameters = new ArrayList<String>();
    private List<String> typeDefParams = new ArrayList<String>();

    protected AliasFunction() {
    }

    public AliasFunction(FunctionName fnName, List<Type> argTypes, Type retType, boolean hasVarArgs) {
        super(fnName, argTypes, retType, hasVarArgs);
    }

    public static AliasFunction createFunction(FunctionName functionName, Type[] argTypes, Type retType, boolean hasVarArgs, List<String> parameters, Expr originFunction) {
        AliasFunction aliasFunction = new AliasFunction(functionName, Arrays.asList(argTypes), retType, hasVarArgs);
        aliasFunction.setBinaryType(TFunctionBinaryType.NATIVE);
        aliasFunction.setUserVisible(true);
        aliasFunction.originFunction = originFunction;
        aliasFunction.parameters = parameters;
        return aliasFunction;
    }

    public static void initBuiltins(FunctionSet functionSet) {
        String oriStmt = "select concat(left(id,3),'****',right(id,4));";
        try {
            functionSet.addBuiltin(AliasFunction.createBuiltin(DIGITAL_MASKING, Lists.newArrayList((Object[])new Type[]{Type.BIGINT}), Type.VARCHAR, false, Lists.newArrayList((Object[])new String[]{"id"}), AliasFunction.getExpr(oriStmt), true, false));
            functionSet.addBuiltin(AliasFunction.createBuiltin(DIGITAL_MASKING, Lists.newArrayList((Object[])new Type[]{Type.BIGINT}), Type.VARCHAR, false, Lists.newArrayList((Object[])new String[]{"id"}), AliasFunction.getExpr(oriStmt), true, true));
        }
        catch (AnalysisException e) {
            LOG.error("Add builtin alias function error {}", (Throwable)e);
        }
    }

    public static Expr getExpr(String sql) throws AnalysisException {
        SelectStmt parsedStmt;
        SqlScanner input = new SqlScanner(new StringReader(sql), (Long)0L);
        SqlParser parser = new SqlParser(input);
        try {
            parsedStmt = (SelectStmt)SqlParserUtils.getFirstStmt(parser);
        }
        catch (Error e) {
            LOG.info("error happened when parsing stmt {}", (Object)sql, (Object)e);
            throw new AnalysisException("sql parsing error, please check your sql");
        }
        catch (AnalysisException e) {
            String syntaxError = parser.getErrorMsg(sql);
            LOG.info("analysis exception happened when parsing stmt {}, error: {}", (Object)sql, (Object)syntaxError, (Object)e);
            if (syntaxError == null) {
                throw e;
            }
            throw new AnalysisException(syntaxError, e);
        }
        catch (Exception e) {
            LOG.info("unexpected exception happened when parsing stmt {}, error: {}", (Object)sql, (Object)parser.getErrorMsg(sql), (Object)e);
            throw new AnalysisException("Unexpected exception: " + e.getMessage());
        }
        return parsedStmt.getSelectList().getItems().get(0).getExpr();
    }

    private static AliasFunction createBuiltin(String name, ArrayList<Type> argTypes, Type retType, boolean hasVarArgs, List<String> parameters, Expr originFunction, boolean userVisible, boolean isVectorized) {
        AliasFunction aliasFunction = new AliasFunction(new FunctionName(name), argTypes, retType, hasVarArgs);
        aliasFunction.setBinaryType(TFunctionBinaryType.BUILTIN);
        aliasFunction.setUserVisible(userVisible);
        aliasFunction.originFunction = originFunction;
        aliasFunction.parameters = parameters;
        aliasFunction.vectorized = isVectorized;
        return aliasFunction;
    }

    public Expr getOriginFunction() {
        return this.originFunction;
    }

    public void setOriginFunction(Expr originFunction) {
        this.originFunction = originFunction;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public void analyze() throws AnalysisException {
        List<Expr> exprs;
        if (this.parameters.size() != this.getArgs().length) {
            throw new AnalysisException("Alias function [" + this.functionName() + "] args number is not equal to parameters number");
        }
        if (this.originFunction instanceof FunctionCallExpr) {
            exprs = ((FunctionCallExpr)this.originFunction).getFnParams().exprs();
        } else if (this.originFunction instanceof CastExpr) {
            exprs = this.originFunction.getChildren();
            TypeDef targetTypeDef = ((CastExpr)this.originFunction).getTargetTypeDef();
            if (targetTypeDef.getType().isScalarType()) {
                ScalarType scalarType = (ScalarType)targetTypeDef.getType();
                PrimitiveType primitiveType = scalarType.getPrimitiveType();
                switch (primitiveType) {
                    case DECIMALV2: {
                        if (!Strings.isNullOrEmpty((String)scalarType.getScalarPrecisionStr())) {
                            this.typeDefParams.add(scalarType.getScalarPrecisionStr());
                        }
                        if (Strings.isNullOrEmpty((String)scalarType.getScalarScaleStr())) break;
                        this.typeDefParams.add(scalarType.getScalarScaleStr());
                        break;
                    }
                    case CHAR: 
                    case VARCHAR: {
                        if (Strings.isNullOrEmpty((String)scalarType.getLenStr())) break;
                        this.typeDefParams.add(scalarType.getLenStr());
                    }
                }
            }
        } else {
            throw new AnalysisException("Not supported expr type: " + this.originFunction);
        }
        HashSet<String> set = new HashSet<String>();
        for (String str : this.parameters) {
            if (!set.add(str)) {
                throw new AnalysisException("Alias function [" + this.functionName() + "] has duplicate parameter [" + str + "].");
            }
            boolean existFlag = false;
            for (Expr expr : exprs) {
                existFlag |= this.checkParams(expr, str);
            }
            for (String typeDefParam : this.typeDefParams) {
                existFlag |= typeDefParam.equals(str);
            }
            if (existFlag) continue;
            throw new AnalysisException("Alias function [" + this.functionName() + "]  do not contain parameter [" + str + "].");
        }
    }

    private boolean checkParams(Expr expr, String param) {
        for (Expr e : expr.getChildren()) {
            if (!this.checkParams(e, param)) continue;
            return true;
        }
        return expr instanceof SlotRef && param.equals(((SlotRef)expr).getColumnName());
    }

    @Override
    public String toSql(boolean ifNotExists) {
        this.setSlotRefLabel(this.originFunction);
        StringBuilder sb = new StringBuilder("CREATE ALIAS FUNCTION ");
        if (ifNotExists) {
            sb.append("IF NOT EXISTS ");
        }
        sb.append(this.signatureString()).append(" WITH PARAMETER(").append(this.getParamsSting(this.parameters)).append(") AS ").append(this.originFunction.toSql()).append(";");
        return sb.toString();
    }

    @Override
    public void write(DataOutput output) throws IOException {
        Function.FunctionType.ALIAS.write(output);
        super.writeFields(output);
        output.writeInt(this.parameters.size());
        for (String p : this.parameters) {
            Text.writeString((DataOutput)output, (String)p);
        }
        Expr.writeTo(this.originFunction, output);
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        int counter = input.readInt();
        for (int i = 0; i < counter; ++i) {
            this.parameters.add(Text.readString((DataInput)input));
        }
        this.originFunction = Expr.readIn(input);
    }

    @Override
    public String getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("parameter", this.getParamsSting(this.parameters));
        this.setSlotRefLabel(this.originFunction);
        String functionStr = this.originFunction.toSql();
        functionStr = functionStr.replaceAll("'", "`");
        properties.put("origin_function", functionStr);
        return new Gson().toJson(properties);
    }

    private void setSlotRefLabel(Expr expr) {
        for (Expr e : expr.getChildren()) {
            this.setSlotRefLabel(e);
        }
        if (expr instanceof SlotRef) {
            ((SlotRef)expr).setLabel("`" + ((SlotRef)expr).getColumnName() + "`");
        }
    }

    private String getParamsSting(List<String> parameters) {
        return parameters.stream().map(String::toString).collect(Collectors.joining(", "));
    }
}

