/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.thrift.TAggregationType;

public enum AggregateType {
    SUM("SUM"),
    MIN("MIN"),
    MAX("MAX"),
    REPLACE("REPLACE"),
    REPLACE_IF_NOT_NULL("REPLACE_IF_NOT_NULL"),
    HLL_UNION("HLL_UNION"),
    NONE("NONE"),
    BITMAP_UNION("BITMAP_UNION");

    private static EnumMap<AggregateType, EnumSet<PrimitiveType>> compatibilityMap;
    private final String sqlName;

    private AggregateType(String sqlName) {
        this.sqlName = sqlName;
    }

    public static boolean checkCompatibility(AggregateType aggType, PrimitiveType priType) {
        return compatibilityMap.get((Object)aggType).contains((Object)priType);
    }

    public String toSql() {
        return this.sqlName;
    }

    public String toString() {
        return this.toSql();
    }

    public boolean checkCompatibility(PrimitiveType priType) {
        return AggregateType.checkCompatibility(this, priType);
    }

    public boolean isReplaceFamily() {
        switch (this) {
            case REPLACE: 
            case REPLACE_IF_NOT_NULL: {
                return true;
            }
        }
        return false;
    }

    public TAggregationType toThrift() {
        switch (this) {
            case SUM: {
                return TAggregationType.SUM;
            }
            case MAX: {
                return TAggregationType.MAX;
            }
            case MIN: {
                return TAggregationType.MIN;
            }
            case REPLACE: {
                return TAggregationType.REPLACE;
            }
            case REPLACE_IF_NOT_NULL: {
                return TAggregationType.REPLACE_IF_NOT_NULL;
            }
            case NONE: {
                return TAggregationType.NONE;
            }
            case HLL_UNION: {
                return TAggregationType.HLL_UNION;
            }
            case BITMAP_UNION: {
                return TAggregationType.BITMAP_UNION;
            }
        }
        return null;
    }

    static {
        compatibilityMap = new EnumMap(AggregateType.class);
        ArrayList primitiveTypeList = Lists.newArrayList();
        primitiveTypeList.add(PrimitiveType.TINYINT);
        primitiveTypeList.add(PrimitiveType.SMALLINT);
        primitiveTypeList.add(PrimitiveType.INT);
        primitiveTypeList.add(PrimitiveType.BIGINT);
        primitiveTypeList.add(PrimitiveType.LARGEINT);
        primitiveTypeList.add(PrimitiveType.FLOAT);
        primitiveTypeList.add(PrimitiveType.DOUBLE);
        primitiveTypeList.add(PrimitiveType.DECIMALV2);
        compatibilityMap.put(SUM, EnumSet.copyOf(primitiveTypeList));
        primitiveTypeList.clear();
        primitiveTypeList.add(PrimitiveType.TINYINT);
        primitiveTypeList.add(PrimitiveType.SMALLINT);
        primitiveTypeList.add(PrimitiveType.INT);
        primitiveTypeList.add(PrimitiveType.BIGINT);
        primitiveTypeList.add(PrimitiveType.LARGEINT);
        primitiveTypeList.add(PrimitiveType.FLOAT);
        primitiveTypeList.add(PrimitiveType.DOUBLE);
        primitiveTypeList.add(PrimitiveType.DECIMALV2);
        primitiveTypeList.add(PrimitiveType.DATE);
        primitiveTypeList.add(PrimitiveType.DATETIME);
        primitiveTypeList.add(PrimitiveType.CHAR);
        primitiveTypeList.add(PrimitiveType.VARCHAR);
        primitiveTypeList.add(PrimitiveType.STRING);
        compatibilityMap.put(MIN, EnumSet.copyOf(primitiveTypeList));
        primitiveTypeList.clear();
        primitiveTypeList.add(PrimitiveType.TINYINT);
        primitiveTypeList.add(PrimitiveType.SMALLINT);
        primitiveTypeList.add(PrimitiveType.INT);
        primitiveTypeList.add(PrimitiveType.BIGINT);
        primitiveTypeList.add(PrimitiveType.LARGEINT);
        primitiveTypeList.add(PrimitiveType.FLOAT);
        primitiveTypeList.add(PrimitiveType.DOUBLE);
        primitiveTypeList.add(PrimitiveType.DECIMALV2);
        primitiveTypeList.add(PrimitiveType.DATE);
        primitiveTypeList.add(PrimitiveType.DATETIME);
        primitiveTypeList.add(PrimitiveType.CHAR);
        primitiveTypeList.add(PrimitiveType.VARCHAR);
        primitiveTypeList.add(PrimitiveType.STRING);
        compatibilityMap.put(MAX, EnumSet.copyOf(primitiveTypeList));
        primitiveTypeList.clear();
        EnumSet<PrimitiveType> exc_bitmap_hll = EnumSet.allOf(PrimitiveType.class);
        exc_bitmap_hll.remove((Object)PrimitiveType.BITMAP);
        exc_bitmap_hll.remove((Object)PrimitiveType.HLL);
        compatibilityMap.put(REPLACE, EnumSet.copyOf(exc_bitmap_hll));
        compatibilityMap.put(REPLACE_IF_NOT_NULL, EnumSet.copyOf(exc_bitmap_hll));
        primitiveTypeList.clear();
        primitiveTypeList.add(PrimitiveType.HLL);
        compatibilityMap.put(HLL_UNION, EnumSet.copyOf(primitiveTypeList));
        primitiveTypeList.clear();
        primitiveTypeList.add(PrimitiveType.BITMAP);
        compatibilityMap.put(BITMAP_UNION, EnumSet.copyOf(primitiveTypeList));
        compatibilityMap.put(NONE, EnumSet.copyOf(exc_bitmap_hll));
    }
}

