/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.doris.analysis.FunctionName;
import org.apache.doris.catalog.ColumnType;
import org.apache.doris.catalog.Function;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.io.IOUtils;
import org.apache.doris.common.util.URI;
import org.apache.doris.thrift.TAggregateFunction;
import org.apache.doris.thrift.TFunction;
import org.apache.doris.thrift.TFunctionBinaryType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AggregateFunction
extends Function {
    private static final Logger LOG = LogManager.getLogger(AggregateFunction.class);
    public static ImmutableSet<String> NOT_NULLABLE_AGGREGATE_FUNCTION_NAME_SET = ImmutableSet.of((Object)"row_number", (Object)"rank", (Object)"dense_rank", (Object)"multi_distinct_count", (Object)"multi_distinct_sum", (Object)"hll_union_agg", (Object[])new String[]{"hll_union", "bitmap_union", "bitmap_intersect", "count", "approx_count_distinct", "ndv", "bitmap_union_int", "bitmap_union_count", "ndv_no_finalize", "window_funnel"});
    public static ImmutableSet<String> ALWAYS_NULLABLE_AGGREGATE_FUNCTION_NAME_SET = ImmutableSet.of((Object)"stddev_samp", (Object)"variance_samp", (Object)"var_samp", (Object)"percentile_approx");
    private Type intermediateType;
    private String updateFnSymbol;
    private String initFnSymbol;
    private String serializeFnSymbol;
    private String mergeFnSymbol;
    private String getValueFnSymbol;
    private String removeFnSymbol;
    private String finalizeFnSymbol;
    private static String BE_BUILTINS_CLASS = "AggregateFunctions";
    private boolean ignoresDistinct;
    private boolean isAnalyticFn;
    private boolean isAggregateFn;
    private boolean returnsNonNullOnEmpty;

    protected AggregateFunction() {
    }

    public AggregateFunction(FunctionName fnName, List<Type> argTypes, Type retType, Type intermediateType, URI location, String updateFnSymbol, String initFnSymbol, String serializeFnSymbol, String mergeFnSymbol, String getValueFnSymbol, String removeFnSymbol, String finalizeFnSymbol) {
        this(fnName, argTypes, retType, intermediateType, location, updateFnSymbol, initFnSymbol, serializeFnSymbol, mergeFnSymbol, getValueFnSymbol, removeFnSymbol, finalizeFnSymbol, false);
    }

    public AggregateFunction(FunctionName fnName, List<Type> argTypes, Type retType, Type intermediateType, boolean hasVarArgs) {
        super(fnName, argTypes, retType, hasVarArgs);
        this.intermediateType = intermediateType != null && intermediateType.equals(retType) ? null : intermediateType;
        this.ignoresDistinct = false;
        this.isAnalyticFn = false;
        this.isAggregateFn = true;
        this.returnsNonNullOnEmpty = false;
    }

    public static AggregateFunction createBuiltin(String name, List<Type> argTypes, Type retType, Type intermediateType, boolean ignoresDistinct, boolean isAnalyticFn, boolean returnsNonNullOnEmpty) {
        return AggregateFunction.createBuiltin(name, argTypes, retType, intermediateType, false, ignoresDistinct, isAnalyticFn, returnsNonNullOnEmpty);
    }

    public static AggregateFunction createBuiltin(String name, List<Type> argTypes, Type retType, Type intermediateType, boolean hasVarArgs, boolean ignoresDistinct, boolean isAnalyticFn, boolean returnsNonNullOnEmpty) {
        AggregateFunction fn = new AggregateFunction(new FunctionName(name), argTypes, retType, intermediateType, hasVarArgs);
        fn.setBinaryType(TFunctionBinaryType.BUILTIN);
        fn.ignoresDistinct = ignoresDistinct;
        fn.isAnalyticFn = isAnalyticFn;
        fn.isAggregateFn = true;
        fn.returnsNonNullOnEmpty = returnsNonNullOnEmpty;
        return fn;
    }

    public AggregateFunction(FunctionName fnName, List<Type> argTypes, Type retType, Type intermediateType, URI location, String updateFnSymbol, String initFnSymbol, String serializeFnSymbol, String mergeFnSymbol, String getValueFnSymbol, String removeFnSymbol, String finalizeFnSymbol, boolean vectorized) {
        this(fnName, argTypes, retType, intermediateType, false, location, updateFnSymbol, initFnSymbol, serializeFnSymbol, mergeFnSymbol, getValueFnSymbol, removeFnSymbol, finalizeFnSymbol, vectorized);
    }

    public AggregateFunction(FunctionName fnName, List<Type> argTypes, Type retType, Type intermediateType, boolean hasVarArgs, URI location, String updateFnSymbol, String initFnSymbol, String serializeFnSymbol, String mergeFnSymbol, String getValueFnSymbol, String removeFnSymbol, String finalizeFnSymbol, boolean vectorized) {
        super(fnName, argTypes, retType, hasVarArgs, vectorized, NOT_NULLABLE_AGGREGATE_FUNCTION_NAME_SET.contains((Object)fnName.getFunction()) ? Function.NullableMode.ALWAYS_NOT_NULLABLE : (ALWAYS_NULLABLE_AGGREGATE_FUNCTION_NAME_SET.contains((Object)fnName.getFunction()) ? Function.NullableMode.ALWAYS_NULLABLE : Function.NullableMode.DEPEND_ON_ARGUMENT));
        this.setLocation(location);
        this.intermediateType = intermediateType.equals(retType) ? null : intermediateType;
        this.updateFnSymbol = updateFnSymbol;
        this.initFnSymbol = initFnSymbol;
        this.serializeFnSymbol = serializeFnSymbol;
        this.mergeFnSymbol = mergeFnSymbol;
        this.getValueFnSymbol = getValueFnSymbol;
        this.removeFnSymbol = removeFnSymbol;
        this.finalizeFnSymbol = finalizeFnSymbol;
        this.ignoresDistinct = false;
        this.isAnalyticFn = false;
        this.isAggregateFn = true;
        this.returnsNonNullOnEmpty = false;
    }

    public static AggregateFunction createBuiltin(String name, List<Type> argTypes, Type retType, Type intermediateType, String initFnSymbol, String updateFnSymbol, String mergeFnSymbol, String serializeFnSymbol, String finalizeFnSymbol, boolean ignoresDistinct, boolean isAnalyticFn, boolean returnsNonNullOnEmpty) {
        return AggregateFunction.createBuiltin(name, argTypes, retType, intermediateType, initFnSymbol, updateFnSymbol, mergeFnSymbol, serializeFnSymbol, finalizeFnSymbol, ignoresDistinct, isAnalyticFn, returnsNonNullOnEmpty, false);
    }

    public static AggregateFunction createBuiltin(String name, List<Type> argTypes, Type retType, Type intermediateType, String initFnSymbol, String updateFnSymbol, String mergeFnSymbol, String serializeFnSymbol, String finalizeFnSymbol, boolean ignoresDistinct, boolean isAnalyticFn, boolean returnsNonNullOnEmpty, boolean vectorized) {
        return AggregateFunction.createBuiltin(name, argTypes, retType, intermediateType, initFnSymbol, updateFnSymbol, mergeFnSymbol, serializeFnSymbol, null, null, finalizeFnSymbol, ignoresDistinct, isAnalyticFn, returnsNonNullOnEmpty, vectorized);
    }

    public static AggregateFunction createBuiltin(String name, List<Type> argTypes, Type retType, Type intermediateType, String initFnSymbol, String updateFnSymbol, String mergeFnSymbol, String serializeFnSymbol, String getValueFnSymbol, String removeFnSymbol, String finalizeFnSymbol, boolean ignoresDistinct, boolean isAnalyticFn, boolean returnsNonNullOnEmpty) {
        return AggregateFunction.createBuiltin(name, argTypes, retType, intermediateType, initFnSymbol, updateFnSymbol, mergeFnSymbol, serializeFnSymbol, getValueFnSymbol, removeFnSymbol, finalizeFnSymbol, ignoresDistinct, isAnalyticFn, returnsNonNullOnEmpty, false);
    }

    public static AggregateFunction createBuiltin(String name, List<Type> argTypes, Type retType, Type intermediateType, String initFnSymbol, String updateFnSymbol, String mergeFnSymbol, String serializeFnSymbol, String getValueFnSymbol, String removeFnSymbol, String finalizeFnSymbol, boolean ignoresDistinct, boolean isAnalyticFn, boolean returnsNonNullOnEmpty, boolean vectorized) {
        return AggregateFunction.createBuiltin(name, argTypes, retType, intermediateType, false, initFnSymbol, updateFnSymbol, mergeFnSymbol, serializeFnSymbol, getValueFnSymbol, removeFnSymbol, finalizeFnSymbol, ignoresDistinct, isAnalyticFn, returnsNonNullOnEmpty, vectorized);
    }

    public static AggregateFunction createBuiltin(String name, List<Type> argTypes, Type retType, Type intermediateType, boolean hasVarArgs, String initFnSymbol, String updateFnSymbol, String mergeFnSymbol, String serializeFnSymbol, String getValueFnSymbol, String removeFnSymbol, String finalizeFnSymbol, boolean ignoresDistinct, boolean isAnalyticFn, boolean returnsNonNullOnEmpty) {
        return AggregateFunction.createBuiltin(name, argTypes, retType, intermediateType, hasVarArgs, initFnSymbol, updateFnSymbol, mergeFnSymbol, serializeFnSymbol, getValueFnSymbol, removeFnSymbol, finalizeFnSymbol, ignoresDistinct, isAnalyticFn, returnsNonNullOnEmpty, false);
    }

    public static AggregateFunction createBuiltin(String name, List<Type> argTypes, Type retType, Type intermediateType, boolean hasVarArgs, String initFnSymbol, String updateFnSymbol, String mergeFnSymbol, String serializeFnSymbol, String getValueFnSymbol, String removeFnSymbol, String finalizeFnSymbol, boolean ignoresDistinct, boolean isAnalyticFn, boolean returnsNonNullOnEmpty, boolean vectorized) {
        AggregateFunction fn = new AggregateFunction(new FunctionName(name), argTypes, retType, intermediateType, hasVarArgs, null, updateFnSymbol, initFnSymbol, serializeFnSymbol, mergeFnSymbol, getValueFnSymbol, removeFnSymbol, finalizeFnSymbol, vectorized);
        fn.setBinaryType(TFunctionBinaryType.BUILTIN);
        fn.ignoresDistinct = ignoresDistinct;
        fn.isAnalyticFn = isAnalyticFn;
        fn.isAggregateFn = true;
        fn.returnsNonNullOnEmpty = returnsNonNullOnEmpty;
        return fn;
    }

    public static AggregateFunction createAnalyticBuiltin(String name, List<Type> argTypes, Type retType, Type intermediateType, boolean vectorized) {
        return AggregateFunction.createAnalyticBuiltin(name, argTypes, retType, intermediateType, null, null, null, null, null, true, vectorized);
    }

    public static AggregateFunction createAnalyticBuiltin(String name, List<Type> argTypes, Type retType, Type intermediateType, String initFnSymbol, String updateFnSymbol, String removeFnSymbol, String getValueFnSymbol, String finalizeFnSymbol) {
        return AggregateFunction.createAnalyticBuiltin(name, argTypes, retType, intermediateType, initFnSymbol, updateFnSymbol, removeFnSymbol, getValueFnSymbol, finalizeFnSymbol, true, false);
    }

    public static AggregateFunction createAnalyticBuiltin(String name, List<Type> argTypes, Type retType, Type intermediateType, String initFnSymbol, String updateFnSymbol, String removeFnSymbol, String getValueFnSymbol, String finalizeFnSymbol, boolean vectorized) {
        return AggregateFunction.createAnalyticBuiltin(name, argTypes, retType, intermediateType, initFnSymbol, updateFnSymbol, removeFnSymbol, getValueFnSymbol, finalizeFnSymbol, true, vectorized);
    }

    public static AggregateFunction createAnalyticBuiltin(String name, List<Type> argTypes, Type retType, Type intermediateType, String initFnSymbol, String updateFnSymbol, String removeFnSymbol, String getValueFnSymbol, String finalizeFnSymbol, boolean isUserVisible, boolean vectorized) {
        AggregateFunction fn = new AggregateFunction(new FunctionName(name), argTypes, retType, intermediateType, null, updateFnSymbol, initFnSymbol, null, null, getValueFnSymbol, removeFnSymbol, finalizeFnSymbol, vectorized);
        fn.setBinaryType(TFunctionBinaryType.BUILTIN);
        fn.ignoresDistinct = false;
        fn.isAnalyticFn = true;
        fn.isAggregateFn = false;
        fn.returnsNonNullOnEmpty = false;
        fn.setUserVisible(isUserVisible);
        return fn;
    }

    public AggregateFunction(FunctionName fnName, Type[] argTypes, Type retType, boolean hasVarArgs, Type intermediateType, URI location, String initFnSymbol, String updateFnSymbol, String mergeFnSymbol, String serializeFnSymbol, String finalizeFnSymbol, String getValueFnSymbol, String removeFnSymbol) {
        super(fnName, Arrays.asList(argTypes), retType, hasVarArgs);
        this.setLocation(location);
        this.intermediateType = intermediateType.equals(retType) ? null : intermediateType;
        this.updateFnSymbol = updateFnSymbol;
        this.initFnSymbol = initFnSymbol;
        this.serializeFnSymbol = serializeFnSymbol;
        this.mergeFnSymbol = mergeFnSymbol;
        this.getValueFnSymbol = getValueFnSymbol;
        this.removeFnSymbol = removeFnSymbol;
        this.finalizeFnSymbol = finalizeFnSymbol;
        this.ignoresDistinct = false;
        this.isAnalyticFn = true;
        this.isAggregateFn = true;
        this.returnsNonNullOnEmpty = false;
    }

    public String getUpdateFnSymbol() {
        return this.updateFnSymbol;
    }

    public String getInitFnSymbol() {
        return this.initFnSymbol;
    }

    public String getSerializeFnSymbol() {
        return this.serializeFnSymbol;
    }

    public String getMergeFnSymbol() {
        return this.mergeFnSymbol;
    }

    public String getGetValueFnSymbol() {
        return this.getValueFnSymbol;
    }

    public String getRemoveFnSymbol() {
        return this.removeFnSymbol;
    }

    public String getFinalizeFnSymbol() {
        return this.finalizeFnSymbol;
    }

    public boolean ignoresDistinct() {
        return this.ignoresDistinct;
    }

    public boolean isAnalyticFn() {
        return this.isAnalyticFn;
    }

    public boolean isAggregateFn() {
        return this.isAggregateFn;
    }

    public boolean returnsNonNullOnEmpty() {
        return this.returnsNonNullOnEmpty;
    }

    public Type getIntermediateType() {
        return this.intermediateType;
    }

    public void setUpdateFnSymbol(String fn) {
        this.updateFnSymbol = fn;
    }

    public void setInitFnSymbol(String fn) {
        this.initFnSymbol = fn;
    }

    public void setSerializeFnSymbol(String fn) {
        this.serializeFnSymbol = fn;
    }

    public void setMergeFnSymbol(String fn) {
        this.mergeFnSymbol = fn;
    }

    public void setGetValueFnSymbol(String fn) {
        this.getValueFnSymbol = fn;
    }

    public void setRemoveFnSymbol(String fn) {
        this.removeFnSymbol = fn;
    }

    public void setFinalizeFnSymbol(String fn) {
        this.finalizeFnSymbol = fn;
    }

    public void setIntermediateType(Type t) {
        this.intermediateType = t;
    }

    @Override
    public String toSql(boolean ifNotExists) {
        StringBuilder sb = new StringBuilder("CREATE AGGREGATE FUNCTION ");
        if (ifNotExists) {
            sb.append("IF NOT EXISTS ");
        }
        sb.append(this.signatureString()).append(" RETURNS " + this.getReturnType());
        if (this.getIntermediateType() != null) {
            sb.append(" INTERMEDIATE " + this.getIntermediateType());
        }
        sb.append(" PROPERTIES (").append("\n  \"INIT_FN\"=\"" + this.getInitFnSymbol() + "\"").append(",\n  \"UPDATE_FN\"=\"" + this.getUpdateFnSymbol() + "\"").append(",\n  \"MERGE_FN\"=\"" + this.getMergeFnSymbol() + "\"");
        if (this.getSerializeFnSymbol() != null) {
            sb.append(",\n  \"SERIALIZE_FN\"=\"" + this.getSerializeFnSymbol() + "\"");
        }
        if (this.getFinalizeFnSymbol() != null) {
            sb.append(",\n  \"FINALIZE_FN\"=\"" + this.getFinalizeFnSymbol() + "\"");
        }
        sb.append(",\n  \"OBJECT_FILE\"=").append("\"" + (this.getLocation() == null ? "" : this.getLocation().toString()) + "\"");
        sb.append(",\n  \"MD5\"=").append("\"" + this.getChecksum() + "\"");
        sb.append("\n);");
        return sb.toString();
    }

    @Override
    public TFunction toThrift() {
        TFunction fn = super.toThrift();
        TAggregateFunction aggFn = new TAggregateFunction();
        aggFn.setIsAnalyticOnlyFn(this.isAnalyticFn && !this.isAggregateFn);
        aggFn.setUpdateFnSymbol(this.updateFnSymbol);
        aggFn.setInitFnSymbol(this.initFnSymbol);
        if (this.serializeFnSymbol != null) {
            aggFn.setSerializeFnSymbol(this.serializeFnSymbol);
        }
        aggFn.setMergeFnSymbol(this.mergeFnSymbol);
        if (this.getValueFnSymbol != null) {
            aggFn.setGetValueFnSymbol(this.getValueFnSymbol);
        }
        if (this.removeFnSymbol != null) {
            aggFn.setRemoveFnSymbol(this.removeFnSymbol);
        }
        if (this.finalizeFnSymbol != null) {
            aggFn.setFinalizeFnSymbol(this.finalizeFnSymbol);
        }
        if (this.intermediateType != null) {
            aggFn.setIntermediateType(this.intermediateType.toThrift());
        } else {
            aggFn.setIntermediateType(this.getReturnType().toThrift());
        }
        fn.setAggregateFn(aggFn);
        return fn;
    }

    @Override
    public void write(DataOutput output) throws IOException {
        Function.FunctionType.AGGREGATE.write(output);
        super.writeFields(output);
        boolean hasInterType = this.intermediateType != null;
        output.writeBoolean(hasInterType);
        if (hasInterType) {
            ColumnType.write(output, this.intermediateType);
        }
        IOUtils.writeOptionString((DataOutput)output, (String)this.updateFnSymbol);
        IOUtils.writeOptionString((DataOutput)output, (String)this.initFnSymbol);
        IOUtils.writeOptionString((DataOutput)output, (String)this.serializeFnSymbol);
        IOUtils.writeOptionString((DataOutput)output, (String)this.mergeFnSymbol);
        IOUtils.writeOptionString((DataOutput)output, (String)this.getValueFnSymbol);
        IOUtils.writeOptionString((DataOutput)output, (String)this.removeFnSymbol);
        IOUtils.writeOptionString((DataOutput)output, (String)this.finalizeFnSymbol);
        output.writeBoolean(this.ignoresDistinct);
        output.writeBoolean(this.isAnalyticFn);
        output.writeBoolean(this.isAggregateFn);
        output.writeBoolean(this.returnsNonNullOnEmpty);
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        if (input.readBoolean()) {
            this.intermediateType = ColumnType.read(input);
        }
        this.updateFnSymbol = IOUtils.readOptionStringOrNull((DataInput)input);
        this.initFnSymbol = IOUtils.readOptionStringOrNull((DataInput)input);
        this.serializeFnSymbol = IOUtils.readOptionStringOrNull((DataInput)input);
        this.mergeFnSymbol = IOUtils.readOptionStringOrNull((DataInput)input);
        this.getValueFnSymbol = IOUtils.readOptionStringOrNull((DataInput)input);
        this.removeFnSymbol = IOUtils.readOptionStringOrNull((DataInput)input);
        this.finalizeFnSymbol = IOUtils.readOptionStringOrNull((DataInput)input);
        this.ignoresDistinct = input.readBoolean();
        this.isAnalyticFn = input.readBoolean();
        this.isAggregateFn = input.readBoolean();
        this.returnsNonNullOnEmpty = input.readBoolean();
    }

    @Override
    public String getProperties() {
        HashMap properties = Maps.newHashMap();
        properties.put("object_file", this.getLocation() == null ? "" : this.getLocation().toString());
        properties.put("md5", this.checksum);
        properties.put("init_fn", this.initFnSymbol);
        properties.put("update_fn", this.updateFnSymbol);
        properties.put("merge_fn", this.mergeFnSymbol);
        properties.put("serialize_fn", this.serializeFnSymbol);
        properties.put("finalize_fn", this.finalizeFnSymbol);
        if (this.getValueFnSymbol != null) {
            properties.put("get_value_fn", this.getValueFnSymbol);
        }
        if (this.removeFnSymbol != null) {
            properties.put("remove_fn", this.removeFnSymbol);
        }
        return new Gson().toJson((Object)properties);
    }

    public static class AggregateFunctionBuilder {
        TFunctionBinaryType binaryType;
        FunctionName name;
        Type[] argTypes;
        Type retType;
        boolean hasVarArgs;
        Type intermediateType;
        URI location;
        String initFnSymbol;
        String updateFnSymbol;
        String serializeFnSymbol;
        String finalizeFnSymbol;
        String mergeFnSymbol;
        String removeFnSymbol;
        String getValueFnSymbol;

        private AggregateFunctionBuilder(TFunctionBinaryType binaryType) {
            this.binaryType = binaryType;
        }

        public static AggregateFunctionBuilder createUdfBuilder() {
            return new AggregateFunctionBuilder(TFunctionBinaryType.NATIVE);
        }

        public AggregateFunctionBuilder name(FunctionName name) {
            this.name = name;
            return this;
        }

        public AggregateFunctionBuilder argsType(Type[] argTypes) {
            this.argTypes = argTypes;
            return this;
        }

        public AggregateFunctionBuilder retType(Type type) {
            this.retType = type;
            return this;
        }

        public AggregateFunctionBuilder hasVarArgs(boolean hasVarArgs) {
            this.hasVarArgs = hasVarArgs;
            return this;
        }

        public AggregateFunctionBuilder intermediateType(Type type) {
            this.intermediateType = type;
            return this;
        }

        public AggregateFunctionBuilder location(URI location) {
            this.location = location;
            return this;
        }

        public AggregateFunctionBuilder initFnSymbol(String symbol) {
            this.initFnSymbol = symbol;
            return this;
        }

        public AggregateFunctionBuilder updateFnSymbol(String symbol) {
            this.updateFnSymbol = symbol;
            return this;
        }

        public AggregateFunctionBuilder mergeFnSymbol(String symbol) {
            this.mergeFnSymbol = symbol;
            return this;
        }

        public AggregateFunctionBuilder serializeFnSymbol(String symbol) {
            this.serializeFnSymbol = symbol;
            return this;
        }

        public AggregateFunctionBuilder finalizeFnSymbol(String symbol) {
            this.finalizeFnSymbol = symbol;
            return this;
        }

        public AggregateFunctionBuilder getValueFnSymbol(String symbol) {
            this.getValueFnSymbol = symbol;
            return this;
        }

        public AggregateFunctionBuilder removeFnSymbol(String symbol) {
            this.removeFnSymbol = symbol;
            return this;
        }

        public AggregateFunction build() {
            AggregateFunction fn = new AggregateFunction(this.name, this.argTypes, this.retType, this.hasVarArgs, this.intermediateType, this.location, this.initFnSymbol, this.updateFnSymbol, this.mergeFnSymbol, this.serializeFnSymbol, this.finalizeFnSymbol, this.getValueFnSymbol, this.removeFnSymbol);
            fn.setBinaryType(this.binaryType);
            return fn;
        }
    }
}

