/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.doris.mysql.privilege.PaloPrivilege;
import org.apache.doris.mysql.privilege.PrivBitSet;

public enum AccessPrivilege {
    READ_ONLY(1, "READ_ONLY"),
    READ_WRITE(2, "READ_WRITE"),
    ALL(3, "ALL"),
    NODE_PRIV(4, "Privilege for cluster node operations"),
    GRANT_PRIV(5, "Privilege for granting privilege"),
    SELECT_PRIV(6, "Privilege for select data in tables"),
    LOAD_PRIV(7, "Privilege for loading data into tables"),
    ALTER_PRIV(8, "Privilege for alter database or table"),
    CREATE_PRIV(9, "Privilege for creating database or table"),
    DROP_PRIV(10, "Privilege for dropping database or table"),
    ADMIN_PRIV(11, "All privileges except NODE_PRIV"),
    USAGE_PRIV(12, "Privilege for use resource");

    private int flag;
    private String desc;

    private AccessPrivilege(int flag, String desc) {
        this.flag = flag;
        this.desc = desc;
    }

    public PrivBitSet toPaloPrivilege() {
        Preconditions.checkState((this.flag > 0 && this.flag < 13 ? 1 : 0) != 0);
        switch (this.flag) {
            case 1: {
                return PrivBitSet.of(PaloPrivilege.SELECT_PRIV);
            }
            case 2: 
            case 3: {
                return PrivBitSet.of(PaloPrivilege.SELECT_PRIV, PaloPrivilege.LOAD_PRIV, PaloPrivilege.ALTER_PRIV, PaloPrivilege.CREATE_PRIV, PaloPrivilege.DROP_PRIV);
            }
            case 4: {
                return PrivBitSet.of(PaloPrivilege.NODE_PRIV);
            }
            case 5: {
                return PrivBitSet.of(PaloPrivilege.GRANT_PRIV);
            }
            case 6: {
                return PrivBitSet.of(PaloPrivilege.SELECT_PRIV);
            }
            case 7: {
                return PrivBitSet.of(PaloPrivilege.LOAD_PRIV);
            }
            case 8: {
                return PrivBitSet.of(PaloPrivilege.ALTER_PRIV);
            }
            case 9: {
                return PrivBitSet.of(PaloPrivilege.CREATE_PRIV);
            }
            case 10: {
                return PrivBitSet.of(PaloPrivilege.DROP_PRIV);
            }
            case 11: {
                return PrivBitSet.of(PaloPrivilege.ADMIN_PRIV);
            }
            case 12: {
                return PrivBitSet.of(PaloPrivilege.USAGE_PRIV);
            }
        }
        return null;
    }

    public static AccessPrivilege fromName(String privStr) {
        try {
            return AccessPrivilege.valueOf(privStr.toUpperCase());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static AccessPrivilege merge(List<AccessPrivilege> privileges) {
        if (privileges == null || privileges.isEmpty()) {
            return null;
        }
        AccessPrivilege privilege = null;
        for (AccessPrivilege iter : privileges) {
            if (privilege == null) {
                privilege = iter;
                continue;
            }
            if (iter.flag <= privilege.flag) continue;
            privilege = iter;
        }
        return privilege;
    }

    public String toString() {
        return this.desc;
    }
}

