/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.blockrule;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.doris.analysis.AlterSqlBlockRuleStmt;
import org.apache.doris.analysis.CreateSqlBlockRuleStmt;
import org.apache.doris.analysis.DropSqlBlockRuleStmt;
import org.apache.doris.analysis.ShowSqlBlockRuleStmt;
import org.apache.doris.blockrule.SqlBlockRule;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.UserException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.SqlBlockUtil;
import org.apache.doris.metric.MetricRepo;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SqlBlockRuleMgr
implements Writable {
    private static final Logger LOG = LogManager.getLogger(SqlBlockRuleMgr.class);
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    @SerializedName(value="nameToSqlBlockRuleMap")
    private Map<String, SqlBlockRule> nameToSqlBlockRuleMap = Maps.newConcurrentMap();

    private void writeLock() {
        this.lock.writeLock().lock();
    }

    private void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    public boolean existRule(String name) {
        return this.nameToSqlBlockRuleMap.containsKey(name);
    }

    public List<SqlBlockRule> getSqlBlockRule(ShowSqlBlockRuleStmt stmt) throws AnalysisException {
        String ruleName = stmt.getRuleName();
        if (StringUtils.isNotEmpty((CharSequence)ruleName)) {
            if (this.nameToSqlBlockRuleMap.containsKey(ruleName)) {
                SqlBlockRule sqlBlockRule = this.nameToSqlBlockRuleMap.get(ruleName);
                return Lists.newArrayList((Object[])new SqlBlockRule[]{sqlBlockRule});
            }
            return Lists.newArrayList();
        }
        return Lists.newArrayList(this.nameToSqlBlockRuleMap.values());
    }

    private static void verifyLimitations(SqlBlockRule sqlBlockRule) throws DdlException {
        if (sqlBlockRule.getPartitionNum() < 0L) {
            throw new DdlException("the value of partition_num can't be a negative");
        }
        if (sqlBlockRule.getTabletNum() < 0L) {
            throw new DdlException("the value of tablet_num can't be a negative");
        }
        if (sqlBlockRule.getCardinality() < 0L) {
            throw new DdlException("the value of cardinality can't be a negative");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSqlBlockRule(CreateSqlBlockRuleStmt stmt) throws UserException {
        this.writeLock();
        try {
            SqlBlockRule sqlBlockRule = SqlBlockRule.fromCreateStmt(stmt);
            String ruleName = sqlBlockRule.getName();
            if (this.existRule(ruleName)) {
                throw new DdlException("the sql block rule " + ruleName + " already create");
            }
            SqlBlockRuleMgr.verifyLimitations(sqlBlockRule);
            this.unprotectedAdd(sqlBlockRule);
            Catalog.getCurrentCatalog().getEditLog().logCreateSqlBlockRule(sqlBlockRule);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void replayCreate(SqlBlockRule sqlBlockRule) {
        this.unprotectedAdd(sqlBlockRule);
        LOG.info("replay create sql block rule: {}", (Object)sqlBlockRule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterSqlBlockRule(AlterSqlBlockRuleStmt stmt) throws AnalysisException, DdlException {
        this.writeLock();
        try {
            SqlBlockRule sqlBlockRule = SqlBlockRule.fromAlterStmt(stmt);
            String ruleName = sqlBlockRule.getName();
            if (!this.existRule(ruleName)) {
                throw new DdlException("the sql block rule " + ruleName + " not exist");
            }
            SqlBlockRule originRule = this.nameToSqlBlockRuleMap.get(ruleName);
            if (sqlBlockRule.getSql().equals("NULL")) {
                sqlBlockRule.setSql(originRule.getSql());
            }
            if (sqlBlockRule.getSqlHash().equals("NULL")) {
                sqlBlockRule.setSqlHash(originRule.getSqlHash());
            }
            if (sqlBlockRule.getPartitionNum().equals(AlterSqlBlockRuleStmt.LONG_NOT_SET)) {
                sqlBlockRule.setPartitionNum(originRule.getPartitionNum());
            }
            if (sqlBlockRule.getTabletNum().equals(AlterSqlBlockRuleStmt.LONG_NOT_SET)) {
                sqlBlockRule.setTabletNum(originRule.getTabletNum());
            }
            if (sqlBlockRule.getCardinality().equals(AlterSqlBlockRuleStmt.LONG_NOT_SET)) {
                sqlBlockRule.setCardinality(originRule.getCardinality());
            }
            if (sqlBlockRule.getGlobal() == null) {
                sqlBlockRule.setGlobal(originRule.getGlobal());
            }
            if (sqlBlockRule.getEnable() == null) {
                sqlBlockRule.setEnable(originRule.getEnable());
            }
            SqlBlockRuleMgr.verifyLimitations(sqlBlockRule);
            SqlBlockUtil.checkAlterValidate(sqlBlockRule);
            this.unprotectedUpdate(sqlBlockRule);
            Catalog.getCurrentCatalog().getEditLog().logAlterSqlBlockRule(sqlBlockRule);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void replayAlter(SqlBlockRule sqlBlockRule) {
        this.unprotectedUpdate(sqlBlockRule);
        LOG.info("replay alter sql block rule: {}", (Object)sqlBlockRule);
    }

    private void unprotectedUpdate(SqlBlockRule sqlBlockRule) {
        this.nameToSqlBlockRuleMap.put(sqlBlockRule.getName(), sqlBlockRule);
    }

    private void unprotectedAdd(SqlBlockRule sqlBlockRule) {
        this.nameToSqlBlockRuleMap.put(sqlBlockRule.getName(), sqlBlockRule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropSqlBlockRule(DropSqlBlockRuleStmt stmt) throws DdlException {
        this.writeLock();
        try {
            List<String> ruleNames = stmt.getRuleNames();
            for (String ruleName : ruleNames) {
                if (this.existRule(ruleName)) continue;
                throw new DdlException("the sql block rule " + ruleName + " not exist");
            }
            this.unprotectedDrop(ruleNames);
            Catalog.getCurrentCatalog().getEditLog().logDropSqlBlockRule(ruleNames);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void replayDrop(List<String> ruleNames) {
        this.unprotectedDrop(ruleNames);
        LOG.info("replay drop sql block ruleNames: {}", ruleNames);
    }

    public void unprotectedDrop(List<String> ruleNames) {
        ruleNames.forEach(name -> this.nameToSqlBlockRuleMap.remove(name));
    }

    public void matchSql(String originSql, String sqlHash, String user) throws AnalysisException {
        String[] bindSqlBlockRules;
        List globalRules = this.nameToSqlBlockRuleMap.values().stream().filter(SqlBlockRule::getGlobal).collect(Collectors.toList());
        for (SqlBlockRule rule : globalRules) {
            this.matchSql(rule, originSql, sqlHash);
        }
        for (String ruleName : bindSqlBlockRules = Catalog.getCurrentCatalog().getAuth().getSqlBlockRules(user)) {
            SqlBlockRule rule = this.nameToSqlBlockRuleMap.get(ruleName);
            if (rule == null) continue;
            this.matchSql(rule, originSql, sqlHash);
        }
    }

    private void matchSql(SqlBlockRule rule, String originSql, String sqlHash) throws AnalysisException {
        if (rule.getEnable().booleanValue()) {
            if (StringUtils.isNotEmpty((CharSequence)rule.getSqlHash()) && !"NULL".equals(rule.getSqlHash()) && rule.getSqlHash().equals(sqlHash)) {
                MetricRepo.COUNTER_HIT_SQL_BLOCK_RULE.increase(1L);
                throw new AnalysisException("sql match hash sql block rule: " + rule.getName());
            }
            if (StringUtils.isNotEmpty((CharSequence)rule.getSql()) && !"NULL".equals(rule.getSql()) && rule.getSqlPattern() != null && rule.getSqlPattern().matcher(originSql).find()) {
                MetricRepo.COUNTER_HIT_SQL_BLOCK_RULE.increase(1L);
                throw new AnalysisException("sql match regex sql block rule: " + rule.getName());
            }
        }
    }

    public void checkLimitations(Long partitionNum, Long tabletNum, Long cardinality, String user) throws AnalysisException {
        String[] bindSqlBlockRules;
        List globalRules = this.nameToSqlBlockRuleMap.values().stream().filter(SqlBlockRule::getGlobal).collect(Collectors.toList());
        for (SqlBlockRule rule : globalRules) {
            this.checkLimitations(rule, partitionNum, tabletNum, cardinality);
        }
        for (String ruleName : bindSqlBlockRules = Catalog.getCurrentCatalog().getAuth().getSqlBlockRules(user)) {
            SqlBlockRule rule = this.nameToSqlBlockRuleMap.get(ruleName);
            if (rule == null) continue;
            this.checkLimitations(rule, partitionNum, tabletNum, cardinality);
        }
    }

    private void checkLimitations(SqlBlockRule rule, Long partitionNum, Long tabletNum, Long cardinality) throws AnalysisException {
        if (rule.getPartitionNum() == 0L && rule.getTabletNum() == 0L && rule.getCardinality() == 0L) {
            return;
        }
        if (rule.getEnable().booleanValue() && (rule.getPartitionNum() != 0L && rule.getPartitionNum() < partitionNum || rule.getTabletNum() != 0L && rule.getTabletNum() < tabletNum || rule.getCardinality() != 0L && rule.getCardinality() < cardinality)) {
            MetricRepo.COUNTER_HIT_SQL_BLOCK_RULE.increase(1L);
            if (rule.getPartitionNum() < partitionNum && rule.getPartitionNum() != 0L) {
                throw new AnalysisException("sql hits sql block rule: " + rule.getName() + ", reach partition_num : " + rule.getPartitionNum());
            }
            if (rule.getTabletNum() < tabletNum && rule.getTabletNum() != 0L) {
                throw new AnalysisException("sql hits sql block rule: " + rule.getName() + ", reach tablet_num : " + rule.getTabletNum());
            }
            if (rule.getCardinality() < cardinality && rule.getCardinality() != 0L) {
                throw new AnalysisException("sql hits sql block rule: " + rule.getName() + ", reach cardinality : " + rule.getCardinality());
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)GsonUtils.GSON.toJson((Object)this));
    }

    public static SqlBlockRuleMgr read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (SqlBlockRuleMgr)GsonUtils.GSON.fromJson(json, SqlBlockRuleMgr.class);
    }
}

