/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.blockrule;

import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.doris.analysis.AlterSqlBlockRuleStmt;
import org.apache.doris.analysis.CreateSqlBlockRuleStmt;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;

public class SqlBlockRule
implements Writable {
    public static final String NAME_TYPE = "SQL BLOCK RULE NAME";
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="sql")
    private String sql;
    @SerializedName(value="sqlHash")
    private String sqlHash;
    @SerializedName(value="partitionNum")
    private Long partitionNum;
    @SerializedName(value="tabletNum")
    private Long tabletNum;
    @SerializedName(value="cardinality")
    private Long cardinality;
    @SerializedName(value="global")
    private Boolean global;
    @SerializedName(value="enable")
    private Boolean enable;
    private Pattern sqlPattern;

    public SqlBlockRule(String name, String sql, String sqlHash, Long partitionNum, Long tabletNum, Long cardinality, Boolean global, Boolean enable) {
        this.name = name;
        this.sql = sql;
        this.sqlHash = sqlHash;
        this.partitionNum = partitionNum;
        this.tabletNum = tabletNum;
        this.cardinality = cardinality;
        this.global = global;
        this.enable = enable;
        if (StringUtils.isNotEmpty((CharSequence)sql)) {
            this.sqlPattern = Pattern.compile(sql);
        }
    }

    public static SqlBlockRule fromCreateStmt(CreateSqlBlockRuleStmt stmt) {
        return new SqlBlockRule(stmt.getRuleName(), stmt.getSql(), stmt.getSqlHash(), stmt.getPartitionNum(), stmt.getTabletNum(), stmt.getCardinality(), stmt.isGlobal(), stmt.isEnable());
    }

    public static SqlBlockRule fromAlterStmt(AlterSqlBlockRuleStmt stmt) {
        return new SqlBlockRule(stmt.getRuleName(), stmt.getSql(), stmt.getSqlHash(), stmt.getPartitionNum(), stmt.getTabletNum(), stmt.getCardinality(), stmt.getGlobal(), stmt.getEnable());
    }

    public String getName() {
        return this.name;
    }

    public String getSql() {
        return this.sql;
    }

    public Pattern getSqlPattern() {
        return this.sqlPattern;
    }

    public String getSqlHash() {
        return this.sqlHash;
    }

    public Long getPartitionNum() {
        return this.partitionNum;
    }

    public Long getTabletNum() {
        return this.tabletNum;
    }

    public Long getCardinality() {
        return this.cardinality;
    }

    public Boolean getGlobal() {
        return this.global;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setSqlPattern(Pattern sqlPattern) {
        this.sqlPattern = sqlPattern;
    }

    public void setSqlHash(String sqlHash) {
        this.sqlHash = sqlHash;
    }

    public void setPartitionNum(Long partitionNum) {
        this.partitionNum = partitionNum;
    }

    public void setTabletNum(Long tabletNum) {
        this.tabletNum = tabletNum;
    }

    public void setCardinality(Long cardinality) {
        this.cardinality = cardinality;
    }

    public void setGlobal(Boolean global) {
        this.global = global;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public List<String> getShowInfo() {
        return Lists.newArrayList((Object[])new String[]{this.name, this.sql, this.sqlHash, this.partitionNum == null ? "0" : Long.toString(this.partitionNum), this.tabletNum == null ? "0" : Long.toString(this.tabletNum), this.cardinality == null ? "0" : Long.toString(this.cardinality), String.valueOf(this.global), String.valueOf(this.enable)});
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)GsonUtils.GSON.toJson((Object)this));
    }

    public static SqlBlockRule read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        SqlBlockRule sqlBlockRule = (SqlBlockRule)GsonUtils.GSON.fromJson(json, SqlBlockRule.class);
        if (StringUtils.isNotEmpty((CharSequence)sqlBlockRule.getSql()) && !"NULL".equals(sqlBlockRule.getSql())) {
            sqlBlockRule.setSqlPattern(Pattern.compile(sqlBlockRule.getSql()));
        }
        return sqlBlockRule;
    }
}

