/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.backup;

public class Status {
    private ErrCode errCode;
    private String errMsg;
    public static final Status OK = new Status(ErrCode.OK, "");

    public Status(ErrCode errCode, String errMsg) {
        this.errCode = errCode;
        this.errMsg = errMsg;
    }

    public ErrCode getErrCode() {
        return this.errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public boolean ok() {
        return this.errCode == ErrCode.OK;
    }

    public boolean equals(Object other) {
        if (other instanceof Status) {
            return this.errCode == ((Status)other).getErrCode();
        }
        return this == other;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.errCode.name());
        if (!this.ok()) {
            sb.append(", msg: ").append(this.errMsg);
        }
        sb.append("]");
        return sb.toString();
    }

    public static enum ErrCode {
        OK,
        NOT_FOUND,
        BAD_FILE,
        CREATE_REMOTE_PATH_FAILED,
        IS_DIR,
        IS_FILE,
        TIMEOUT,
        BAD_CONNECTION,
        COMMON_ERROR,
        OLAP_VERSION_ALREADY_MERGED;

    }
}

