/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.backup;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;

public class SnapshotInfo
implements Writable {
    private long dbId;
    private long tblId;
    private long partitionId;
    private long indexId;
    private long tabletId;
    private long beId;
    private int schemaHash;
    private String path;
    private List<String> files = Lists.newArrayList();

    public SnapshotInfo() {
    }

    public SnapshotInfo(long dbId, long tblId, long partitionId, long indexId, long tabletId, long beId, int schemaHash, String path, List<String> files) {
        this.dbId = dbId;
        this.tblId = tblId;
        this.partitionId = partitionId;
        this.indexId = indexId;
        this.tabletId = tabletId;
        this.beId = beId;
        this.schemaHash = schemaHash;
        this.path = path;
        this.files = files;
    }

    public long getDbId() {
        return this.dbId;
    }

    public long getTblId() {
        return this.tblId;
    }

    public long getPartitionId() {
        return this.partitionId;
    }

    public long getIndexId() {
        return this.indexId;
    }

    public long getTabletId() {
        return this.tabletId;
    }

    public long getBeId() {
        return this.beId;
    }

    public int getSchemaHash() {
        return this.schemaHash;
    }

    public String getPath() {
        return this.path;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public void setFiles(List<String> files) {
        this.files = files;
    }

    public String getTabletPath() {
        String basePath = Joiner.on((String)"/").join((Object)this.path, (Object)this.tabletId, new Object[]{this.schemaHash});
        return basePath;
    }

    public static SnapshotInfo read(DataInput in) throws IOException {
        SnapshotInfo info = new SnapshotInfo();
        info.readFields(in);
        return info;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.dbId);
        out.writeLong(this.tblId);
        out.writeLong(this.partitionId);
        out.writeLong(this.indexId);
        out.writeLong(this.tabletId);
        out.writeLong(this.beId);
        out.writeInt(this.schemaHash);
        Text.writeString((DataOutput)out, (String)this.path);
        out.writeInt(this.files.size());
        for (String file : this.files) {
            Text.writeString((DataOutput)out, (String)file);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.dbId = in.readLong();
        this.tblId = in.readLong();
        this.partitionId = in.readLong();
        this.indexId = in.readLong();
        this.tabletId = in.readLong();
        this.beId = in.readLong();
        this.schemaHash = in.readInt();
        this.path = Text.readString((DataInput)in);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.files.add(Text.readString((DataInput)in));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("tablet id: ").append(this.tabletId);
        sb.append(", be id: ").append(this.beId);
        sb.append(", path: ").append(this.path);
        sb.append(", files:").append(this.files);
        return sb.toString();
    }
}

