/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.backup;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.doris.analysis.BackupStmt;
import org.apache.doris.backup.AbstractJob;
import org.apache.doris.backup.BackupJobInfo;
import org.apache.doris.backup.BackupMeta;
import org.apache.doris.backup.RestoreFileMapping;
import org.apache.doris.backup.SnapshotInfo;
import org.apache.doris.backup.Status;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.DataProperty;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.FsBroker;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.MaterializedIndexMeta;
import org.apache.doris.catalog.OdbcCatalogResource;
import org.apache.doris.catalog.OdbcTable;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.PartitionInfo;
import org.apache.doris.catalog.PartitionType;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.ReplicaAllocation;
import org.apache.doris.catalog.Resource;
import org.apache.doris.catalog.ResourceMgr;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.catalog.TabletMeta;
import org.apache.doris.catalog.View;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.MarkedCountDownLatch;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.resource.Tag;
import org.apache.doris.task.AgentBatchTask;
import org.apache.doris.task.AgentTask;
import org.apache.doris.task.AgentTaskExecutor;
import org.apache.doris.task.AgentTaskQueue;
import org.apache.doris.task.CreateReplicaTask;
import org.apache.doris.task.DirMoveTask;
import org.apache.doris.task.DownloadTask;
import org.apache.doris.task.ReleaseSnapshotTask;
import org.apache.doris.task.SnapshotTask;
import org.apache.doris.thrift.TFinishTaskRequest;
import org.apache.doris.thrift.TStatusCode;
import org.apache.doris.thrift.TStorageMedium;
import org.apache.doris.thrift.TStorageType;
import org.apache.doris.thrift.TTaskType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RestoreJob
extends AbstractJob {
    private static final Logger LOG = LogManager.getLogger(RestoreJob.class);
    private String backupTimestamp;
    private BackupJobInfo jobInfo;
    private boolean allowLoad;
    private RestoreJobState state;
    private BackupMeta backupMeta;
    private RestoreFileMapping fileMapping = new RestoreFileMapping();
    private long metaPreparedTime = -1L;
    private long snapshotFinishedTime = -1L;
    private long downloadFinishedTime = -1L;
    private ReplicaAllocation replicaAlloc;
    private List<Pair<String, Partition>> restoredPartitions = Lists.newArrayList();
    private List<Table> restoredTbls = Lists.newArrayList();
    private List<Resource> restoredResources = Lists.newArrayList();
    private com.google.common.collect.Table<Long, Long, Long> restoredVersionInfo = HashBasedTable.create();
    private com.google.common.collect.Table<Long, Long, SnapshotInfo> snapshotInfos = HashBasedTable.create();
    private Map<Long, Long> unfinishedSignatureToId = Maps.newConcurrentMap();
    private int metaVersion = -1;
    private Map<String, String> properties = Maps.newHashMap();

    public RestoreJob() {
        super(AbstractJob.JobType.RESTORE);
    }

    public RestoreJob(String label, String backupTs, long dbId, String dbName, BackupJobInfo jobInfo, boolean allowLoad, ReplicaAllocation replicaAlloc, long timeoutMs, int metaVersion, Catalog catalog, long repoId) {
        super(AbstractJob.JobType.RESTORE, label, dbId, dbName, timeoutMs, catalog, repoId);
        this.backupTimestamp = backupTs;
        this.jobInfo = jobInfo;
        this.allowLoad = allowLoad;
        this.replicaAlloc = replicaAlloc;
        this.state = RestoreJobState.PENDING;
        this.metaVersion = metaVersion;
    }

    public RestoreJobState getState() {
        return this.state;
    }

    public RestoreFileMapping getFileMapping() {
        return this.fileMapping;
    }

    public int getMetaVersion() {
        return this.metaVersion;
    }

    public synchronized boolean finishTabletSnapshotTask(SnapshotTask task, TFinishTaskRequest request) {
        if (this.checkTaskStatus(task, task.getJobId(), request)) {
            return false;
        }
        Preconditions.checkState((boolean)request.isSetSnapshotPath());
        SnapshotInfo info = new SnapshotInfo(task.getDbId(), task.getTableId(), task.getPartitionId(), task.getIndexId(), task.getTabletId(), task.getBackendId(), task.getSchemaHash(), request.getSnapshotPath(), Lists.newArrayList());
        this.snapshotInfos.put((Object)task.getTabletId(), (Object)task.getBackendId(), (Object)info);
        this.taskProgress.remove(task.getSignature());
        Long removedTabletId = this.unfinishedSignatureToId.remove(task.getSignature());
        if (removedTabletId != null) {
            this.taskErrMsg.remove(task.getSignature());
            Preconditions.checkState((task.getTabletId() == removedTabletId.longValue() ? 1 : 0) != 0, (Object)removedTabletId);
            LOG.debug("get finished snapshot info: {}, unfinished tasks num: {}, remove result: {}. {}", (Object)info, (Object)this.unfinishedSignatureToId.size(), (Object)this, (Object)removedTabletId);
            return true;
        }
        return false;
    }

    public synchronized boolean finishTabletDownloadTask(DownloadTask task, TFinishTaskRequest request) {
        if (this.checkTaskStatus(task, task.getJobId(), request)) {
            return false;
        }
        Preconditions.checkState((boolean)request.isSetDownloadedTabletIds());
        for (Long tabletId : request.getDownloadedTabletIds()) {
            SnapshotInfo info = (SnapshotInfo)this.snapshotInfos.get((Object)tabletId, (Object)task.getBackendId());
            if (info != null) continue;
            LOG.warn("failed to find snapshot infos of tablet {} in be {}, {}", (Object)tabletId, (Object)task.getBackendId(), (Object)this);
            return false;
        }
        this.taskProgress.remove(task.getSignature());
        Long beId = this.unfinishedSignatureToId.remove(task.getSignature());
        if (beId == null || beId.longValue() != task.getBackendId()) {
            LOG.warn("invalid download task: {}. {}", (Object)task, (Object)this);
            return false;
        }
        this.taskErrMsg.remove(task.getSignature());
        return true;
    }

    public synchronized boolean finishDirMoveTask(DirMoveTask task, TFinishTaskRequest request) {
        if (this.checkTaskStatus(task, task.getJobId(), request)) {
            return false;
        }
        this.taskProgress.remove(task.getSignature());
        Long tabletId = this.unfinishedSignatureToId.remove(task.getSignature());
        if (tabletId == null || tabletId.longValue() != task.getTabletId()) {
            LOG.warn("invalid dir move task: {}. {}", (Object)task, (Object)this);
            return false;
        }
        this.taskErrMsg.remove(task.getSignature());
        return true;
    }

    private boolean checkTaskStatus(AgentTask task, long jobId, TFinishTaskRequest request) {
        Preconditions.checkState((jobId == this.jobId ? 1 : 0) != 0);
        Preconditions.checkState((this.dbId == task.getDbId() ? 1 : 0) != 0);
        if (request.getTaskStatus().getStatusCode() != TStatusCode.OK) {
            this.taskErrMsg.put(task.getSignature(), Joiner.on((String)",").join((Iterable)request.getTaskStatus().getErrorMsgs()));
            return true;
        }
        return false;
    }

    @Override
    public synchronized void replayRun() {
        LOG.info("replay run restore job: {}", (Object)this);
        switch (this.state) {
            case DOWNLOAD: {
                this.replayCheckAndPrepareMeta();
                break;
            }
            case FINISHED: {
                this.replayWaitingAllTabletsCommitted();
                break;
            }
        }
    }

    @Override
    public synchronized void replayCancel() {
        this.cancelInternal(true);
    }

    @Override
    public boolean isPending() {
        return this.state == RestoreJobState.PENDING;
    }

    @Override
    public boolean isCancelled() {
        return this.state == RestoreJobState.CANCELLED;
    }

    @Override
    public void run() {
        if (this.state == RestoreJobState.FINISHED || this.state == RestoreJobState.CANCELLED) {
            return;
        }
        if (System.currentTimeMillis() - this.createTime > this.timeoutMs) {
            this.status = new Status(Status.ErrCode.TIMEOUT, "restore job with label: " + this.label + "  timeout.");
            this.cancelInternal(false);
            return;
        }
        if (this.repo == null) {
            this.repo = this.catalog.getBackupHandler().getRepoMgr().getRepo(this.repoId);
            if (this.repo == null) {
                this.status = new Status(Status.ErrCode.COMMON_ERROR, "failed to get repository: " + this.repoId);
                this.cancelInternal(false);
                return;
            }
        }
        LOG.info("run restore job: {}", (Object)this);
        this.checkIfNeedCancel();
        if (this.status.ok()) {
            switch (this.state) {
                case PENDING: {
                    this.checkAndPrepareMeta();
                    break;
                }
                case SNAPSHOTING: {
                    this.waitingAllSnapshotsFinished();
                    break;
                }
                case DOWNLOAD: {
                    this.downloadSnapshots();
                    break;
                }
                case DOWNLOADING: {
                    this.waitingAllDownloadFinished();
                    break;
                }
                case COMMIT: {
                    this.commit();
                    break;
                }
                case COMMITTING: {
                    this.waitingAllTabletsCommitted();
                    break;
                }
            }
        }
        if (!this.status.ok()) {
            this.cancelInternal(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfNeedCancel() {
        if (this.state == RestoreJobState.PENDING) {
            return;
        }
        Database db = this.catalog.getDbNullable(this.dbId);
        if (db == null) {
            this.status = new Status(Status.ErrCode.NOT_FOUND, "database " + this.dbId + " has been dropped");
            return;
        }
        for (RestoreFileMapping.IdChain idChain : this.fileMapping.getMapping().keySet()) {
            OlapTable tbl = (OlapTable)db.getTableNullable(idChain.getTblId());
            if (tbl == null) {
                this.status = new Status(Status.ErrCode.NOT_FOUND, "table " + idChain.getTblId() + " has been dropped");
                return;
            }
            tbl.readLock();
            try {
                Partition part = tbl.getPartition(idChain.getPartId());
                if (part == null) {
                    this.status = new Status(Status.ErrCode.NOT_FOUND, "partition " + idChain.getPartId() + " has been dropped");
                    return;
                }
                MaterializedIndex index = part.getIndex(idChain.getIdxId());
                if (index != null) continue;
                this.status = new Status(Status.ErrCode.NOT_FOUND, "index " + idChain.getIdxId() + " has been dropped");
                return;
            }
            finally {
                tbl.readUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkAndPrepareMeta() {
        block85: {
            block83: {
                block84: {
                    block82: {
                        db = this.catalog.getDbNullable(this.dbId);
                        if (db == null) {
                            this.status = new Status(Status.ErrCode.NOT_FOUND, "database " + this.dbId + " does not exist");
                            return;
                        }
                        this.jobId = this.catalog.getNextId();
                        if (!this.downloadAndDeserializeMetaInfo()) {
                            return;
                        }
                        Preconditions.checkNotNull((Object)this.backupMeta);
                        for (String var3_3 : this.jobInfo.backupOlapTableObjects.keySet()) {
                            var4_21 = db.getTableNullable(this.jobInfo.getAliasByOriginNameIfSet(var3_3));
                            if (var4_21 == null) continue;
                            if (var4_21.getType() != Table.TableType.OLAP) {
                                this.status = new Status(Status.ErrCode.COMMON_ERROR, "Only support retore OLAP table: " + var4_21.getName());
                                return;
                            }
                            olapTbl = (OlapTable)var4_21;
                            if (!olapTbl.writeLockIfExist()) continue;
                            try {
                                if (olapTbl.getState() != OlapTable.OlapTableState.NORMAL) {
                                    this.status = new Status(Status.ErrCode.COMMON_ERROR, "Table " + var4_21.getName() + "'s state is not NORMAL: " + olapTbl.getState().name());
                                    return;
                                }
                                if (olapTbl.existTempPartitions()) {
                                    this.status = new Status(Status.ErrCode.COMMON_ERROR, "Do not support restoring table with temp partitions");
                                    return;
                                }
                                for (Partition var7_46 : olapTbl.getPartitions()) {
                                    if (this.catalog.getLoadInstance().checkPartitionLoadFinished(var7_46.getId(), null)) continue;
                                    this.status = new Status(Status.ErrCode.COMMON_ERROR, "Table " + var4_21.getName() + "'s has unfinished load job");
                                    return;
                                }
                                olapTbl.setState(OlapTable.OlapTableState.RESTORE);
                                tblInfo = this.jobInfo.backupOlapTableObjects.get(var3_3);
                                for (Map.Entry<String, BackupJobInfo.BackupPartitionInfo> partitionEntry : tblInfo.partitions.entrySet()) {
                                    partitionName = partitionEntry.getKey();
                                    partition = olapTbl.getPartition(partitionName);
                                    if (partition == null) continue;
                                    partition.setState(Partition.PartitionState.RESTORE);
                                }
                            }
                            finally {
                                olapTbl.writeUnlock();
                            }
                        }
                        for (BackupJobInfo.BackupViewInfo var3_5 : this.jobInfo.newBackupObjects.views) {
                            var4_23 = db.getTableNullable(this.jobInfo.getAliasByOriginNameIfSet(var3_5.name));
                            if (var4_23 == null || var4_23.getType() == Table.TableType.VIEW) continue;
                            this.status = new Status(Status.ErrCode.COMMON_ERROR, "The local table " + var4_23.getName() + " with the same name but a different type of backup meta.");
                            return;
                        }
                        for (BackupJobInfo.BackupOdbcTableInfo var3_7 : this.jobInfo.newBackupObjects.odbcTables) {
                            var4_25 = db.getTableNullable(this.jobInfo.getAliasByOriginNameIfSet(var3_7.dorisTableName));
                            if (var4_25 == null || var4_25.getType() == Table.TableType.ODBC) continue;
                            this.status = new Status(Status.ErrCode.COMMON_ERROR, "The local table " + var4_25.getName() + " with the same name but a different type of backup meta.");
                            return;
                        }
                        for (BackupJobInfo.BackupOdbcResourceInfo var3_9 : this.jobInfo.newBackupObjects.odbcResources) {
                            var4_27 = Catalog.getCurrentCatalog().getResourceMgr().getResource(var3_9.name);
                            if (var4_27 == null || var4_27.getType() == Resource.ResourceType.ODBC_CATALOG) continue;
                            this.status = new Status(Status.ErrCode.COMMON_ERROR, "The local resource " + var4_27.getName() + " with the same name but a different type of backup meta.");
                            return;
                        }
                        batchTask = new AgentBatchTask();
                        db.readLock();
                        for (Map.Entry<String, BackupJobInfo.BackupOlapTableInfo> var4_29 : this.jobInfo.backupOlapTableObjects.entrySet()) {
                            tableName = var4_29.getKey();
                            tblInfo = var4_29.getValue();
                            var7_48 = this.backupMeta.getTable(tableName);
                            Preconditions.checkNotNull((Object)var7_48);
                            localTbl = db.getTableNullable(this.jobInfo.getAliasByOriginNameIfSet(tableName));
                            if (localTbl != null) {
                                if (localTbl.getType() != Table.TableType.OLAP) {
                                    this.status = new Status(Status.ErrCode.COMMON_ERROR, "The type of local table should be same as type of remote table: " + var7_48.getName());
                                    return;
                                }
                                localOlapTbl = (OlapTable)localTbl;
                                remoteOlapTbl = (OlapTable)var7_48;
                                localOlapTbl.readLock();
                                try {
                                    intersectPartNames = Lists.newArrayList();
                                    st = localOlapTbl.getIntersectPartNamesWith(remoteOlapTbl, intersectPartNames);
                                    if (!st.ok()) {
                                        this.status = st;
                                        return;
                                    }
                                    RestoreJob.LOG.debug("get intersect part names: {}, job: {}", (Object)intersectPartNames, (Object)this);
                                    if (!localOlapTbl.getSignature(1, intersectPartNames).equals(remoteOlapTbl.getSignature(1, intersectPartNames))) {
                                        this.status = new Status(Status.ErrCode.COMMON_ERROR, "Table " + this.jobInfo.getAliasByOriginNameIfSet(tableName) + " already exist but with different schema");
                                        return;
                                    }
                                    for (Map.Entry<String, BackupJobInfo.BackupPartitionInfo> partitionEntry : tblInfo.partitions.entrySet()) {
                                        partitionName = partitionEntry.getKey();
                                        backupPartInfo = partitionEntry.getValue();
                                        localPartition = localOlapTbl.getPartition(partitionName);
                                        if (localPartition != null) {
                                            localPartInfo = localOlapTbl.getPartitionInfo();
                                            if (localPartInfo.getType() == PartitionType.RANGE || localPartInfo.getType() == PartitionType.LIST) {
                                                localItem = localPartInfo.getItem(localPartition.getId());
                                                if (!localItem.equals(remoteItem = remoteOlapTbl.getPartitionInfo().getItem(backupPartInfo.id))) {
                                                    this.status = new Status(Status.ErrCode.COMMON_ERROR, "Partition " + partitionName + " in table " + localTbl.getName() + " has different partition item with partition in repository");
                                                    return;
                                                }
                                                if (!this.genFileMappingWhenBackupReplicasEqual(localPartInfo, localPartition, localTbl, backupPartInfo, partitionName, tblInfo)) continue;
                                                return;
                                            }
                                            if (!this.genFileMappingWhenBackupReplicasEqual(localPartInfo, localPartition, localTbl, backupPartInfo, partitionName, tblInfo)) continue;
                                            return;
                                        }
                                        localPartitionInfo = localOlapTbl.getPartitionInfo();
                                        if (localPartitionInfo.getType() != PartitionType.RANGE && localPartitionInfo.getType() != PartitionType.LIST) {
                                            this.status = new Status(Status.ErrCode.COMMON_ERROR, "No partition exist in single partitioned table " + localOlapTbl.getName());
                                            return;
                                        }
                                        remoteItem = remoteOlapTbl.getPartitionInfo().getItem(backupPartInfo.id);
                                        if (localPartitionInfo.getAnyIntersectItem(remoteItem, false) != null) {
                                            this.status = new Status(Status.ErrCode.COMMON_ERROR, "Partition " + partitionName + " in table " + localTbl.getName() + " has conflict partition item with existing items");
                                            return;
                                        }
                                        restorePart = this.resetPartitionForRestore(localOlapTbl, remoteOlapTbl, partitionName, db.getClusterName(), this.replicaAlloc);
                                        if (restorePart == null) {
                                            return;
                                        }
                                        this.restoredPartitions.add(Pair.create(localOlapTbl.getName(), restorePart));
                                    }
                                    continue;
                                }
                                finally {
                                    localOlapTbl.readUnlock();
                                    continue;
                                }
                            }
                            remoteOlapTbl = (OlapTable)var7_48;
                            allPartNames = remoteOlapTbl.getPartitionNames();
                            for (String partName : allPartNames) {
                                if (tblInfo.containsPart(partName)) continue;
                                remoteOlapTbl.dropPartitionAndReserveTablet(partName);
                            }
                            st = remoteOlapTbl.resetIdsForRestore(this.catalog, db, this.replicaAlloc);
                            if (!st.ok()) {
                                this.status = st;
                                return;
                            }
                            remoteOlapTbl.resetPropertiesForRestore();
                            remoteOlapTbl.setState(this.allowLoad != false ? OlapTable.OlapTableState.RESTORE_WITH_LOAD : OlapTable.OlapTableState.RESTORE);
                            RestoreJob.LOG.debug("put remote table {} to restoredTbls", (Object)remoteOlapTbl.getName());
                            this.restoredTbls.add(remoteOlapTbl);
                        }
                        for (BackupJobInfo.BackupViewInfo var4_31 : this.jobInfo.newBackupObjects.views) {
                            backupViewName = var4_31.name;
                            localTbl = db.getTableNullable(this.jobInfo.getAliasByOriginNameIfSet(backupViewName));
                            var7_50 = (View)this.backupMeta.getTable(backupViewName);
                            if (localTbl != null) {
                                Preconditions.checkState((boolean)(localTbl.getType() == Table.TableType.VIEW));
                                localView = (View)localTbl;
                                if (localView.getSignature(1).equals(var7_50.getSignature(1))) continue;
                                this.status = new Status(Status.ErrCode.COMMON_ERROR, "View " + this.jobInfo.getAliasByOriginNameIfSet(backupViewName) + " already exist but with different schema");
                                return;
                            }
                            var7_50.resetIdsForRestore(this.catalog);
                            this.restoredTbls.add(var7_50);
                        }
                        for (BackupJobInfo.BackupOdbcTableInfo var4_33 : this.jobInfo.newBackupObjects.odbcTables) {
                            backupOdbcTableName = var4_33.dorisTableName;
                            localTbl = db.getTableNullable(this.jobInfo.getAliasByOriginNameIfSet(backupOdbcTableName));
                            var7_52 = (OdbcTable)this.backupMeta.getTable(backupOdbcTableName);
                            if (localTbl != null) {
                                Preconditions.checkState((boolean)(localTbl.getType() == Table.TableType.ODBC));
                                localOdbcTable = (OdbcTable)localTbl;
                                if (localOdbcTable.getSignature(1).equals(var7_52.getSignature(1))) continue;
                                this.status = new Status(Status.ErrCode.COMMON_ERROR, "Odbc table " + this.jobInfo.getAliasByOriginNameIfSet(backupOdbcTableName) + " already exist but with different schema");
                                return;
                            }
                            var7_52.resetIdsForRestore(this.catalog);
                            this.restoredTbls.add(var7_52);
                        }
                        RestoreJob.LOG.debug("finished to prepare restored partitions and tables. {}", (Object)this);
                        for (Pair<String, Partition> var4_35 : this.restoredPartitions) {
                            localTbl = (OlapTable)db.getTableNullable((String)var4_35.first);
                            Preconditions.checkNotNull((Object)localTbl, (Object)localTbl.getName());
                            restorePart = (Partition)var4_35.second;
                            var7_54 = (OlapTable)this.backupMeta.getTable((String)var4_35.first);
                            backupPartitionInfo = this.jobInfo.getOlapTableInfo((String)var4_35.first).getPartInfo(restorePart.getName());
                            this.createReplicas(db, batchTask, localTbl, (Partition)restorePart);
                            this.genFileMapping(localTbl, (Partition)restorePart, var7_54.getId(), backupPartitionInfo, this.allowLoad == false);
                        }
                        var3_14 = this.restoredTbls.iterator();
lbl173:
                        // 2 sources

                        while (true) {
                            if (!var3_14.hasNext()) break block82;
                            var4_37 = var3_14.next();
                            if (var4_37.getType() != Table.TableType.OLAP) break block83;
                            restoreOlapTable = (OlapTable)var4_37;
                            restorePart = restoreOlapTable.getPartitions().iterator();
                            break block84;
                            break;
                        }
                        finally {
                            db.readUnlock();
                        }
                    }
                    RestoreJob.LOG.debug("finished to generate create replica tasks. {}", (Object)this);
                    this.checkAndRestoreResources();
                    if (!this.status.ok()) {
                        return;
                    }
                    RestoreJob.LOG.debug("finished to restore resources. {}", (Object)this.jobId);
                    var3_15 = false;
                    var4_38 = new MarkedCountDownLatch<Long, Long>(batchTask.getTaskNum());
                    if (batchTask.getTaskNum() > 0) {
                        for (AgentTask task : batchTask.getAllTasks()) {
                            var4_38.addMark(task.getBackendId(), task.getTabletId());
                            ((CreateReplicaTask)task).setLatch(var4_38);
                            AgentTaskQueue.addTask(task);
                        }
                        AgentTaskExecutor.submit(batchTask);
                        timeout = (long)Config.tablet_create_timeout_second * 1000L * (long)batchTask.getTaskNum();
                        timeout = Math.min(600000L, timeout);
                        try {
                            RestoreJob.LOG.info("begin to send create replica tasks to BE for restore. total {} tasks. timeout: {}", (Object)batchTask.getTaskNum(), (Object)timeout);
                            var3_16 = var4_38.await(timeout, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException var7_57) {
                            RestoreJob.LOG.warn("InterruptedException: ", (Throwable)var7_57);
                            var3_17 = false;
                        }
                    } else {
                        var3_19 = true;
                    }
                    if (var3_20 == false) {
                        unfinishedMarks = var4_38.getLeftMarks();
                        subList = unfinishedMarks.subList(0, Math.min(unfinishedMarks.size(), 10));
                        var7_61 = Joiner.on((String)", ").join(subList);
                        this.status = new Status(Status.ErrCode.COMMON_ERROR, "Failed to create replicas for restore. unfinished marks: " + var7_61);
                        return;
                    }
                    RestoreJob.LOG.debug("finished to create all restored replcias. {}", (Object)this);
                    timeout = this.restoredPartitions.iterator();
                    break block85;
                }
                while (restorePart.hasNext()) {
                    var7_56 = (Partition)restorePart.next();
                    this.createReplicas(db, batchTask, restoreOlapTable, var7_56);
                    backupOlapTableInfo = this.jobInfo.getOlapTableInfo(restoreOlapTable.getName());
                    this.genFileMapping(restoreOlapTable, var7_56, backupOlapTableInfo.id, backupOlapTableInfo.getPartInfo(var7_56.getName()), this.allowLoad == false);
                }
            }
            var4_37.setName(this.jobInfo.getAliasByOriginNameIfSet(var4_37.getName()));
            ** continue;
        }
        while (timeout.hasNext()) {
            entry = timeout.next();
            var7_60 = (OlapTable)db.getTableNullable((String)entry.first);
            var7_60.writeLock();
            try {
                restoredPart = (Partition)entry.second;
                remoteTbl = (OlapTable)this.backupMeta.getTable((String)entry.first);
                if (var7_60.getPartitionInfo().getType() == PartitionType.RANGE || var7_60.getPartitionInfo().getType() == PartitionType.LIST) {
                    remotePartitionInfo = remoteTbl.getPartitionInfo();
                    localPartitionInfo = var7_60.getPartitionInfo();
                    backupPartitionInfo = this.jobInfo.getOlapTableInfo((String)entry.first).getPartInfo(restoredPart.getName());
                    remotePartId = backupPartitionInfo.id;
                    remoteItem = remoteTbl.getPartitionInfo().getItem(remotePartId);
                    remoteDataProperty = remotePartitionInfo.getDataProperty(remotePartId);
                    localPartitionInfo.addPartition(restoredPart.getId(), false, remoteItem, remoteDataProperty, this.replicaAlloc, remotePartitionInfo.getIsInMemory(remotePartId));
                }
                var7_60.addPartition(restoredPart);
            }
            finally {
                var7_60.writeUnlock();
            }
        }
        for (Table tbl : this.restoredTbls) {
            if (!db.writeLockIfExist()) {
                this.status = new Status(Status.ErrCode.COMMON_ERROR, "Database " + db.getFullName() + " has been dropped");
                return;
            }
            tbl.writeLock();
            try {
                if (db.createTable(tbl)) continue;
                this.status = new Status(Status.ErrCode.COMMON_ERROR, "Table " + tbl.getName() + " already exist in db: " + db.getFullName());
                return;
            }
            finally {
                tbl.writeUnlock();
                db.writeUnlock();
            }
        }
        RestoreJob.LOG.info("finished to prepare meta. {}", (Object)this);
        if (this.jobInfo.content == null || this.jobInfo.content == BackupStmt.BackupContent.ALL) {
            this.prepareAndSendSnapshotTaskForOlapTable(db);
        }
        this.metaPreparedTime = System.currentTimeMillis();
        this.state = RestoreJobState.SNAPSHOTING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareAndSendSnapshotTaskForOlapTable(Database db) {
        LOG.info("begin to make snapshot. {} when restore content is ALL", (Object)this);
        this.unfinishedSignatureToId.clear();
        this.taskProgress.clear();
        this.taskErrMsg.clear();
        HashMultimap bePathsMap = HashMultimap.create();
        AgentBatchTask batchTask = new AgentBatchTask();
        db.readLock();
        try {
            for (RestoreFileMapping.IdChain idChain : this.fileMapping.getMapping().keySet()) {
                OlapTable tbl = (OlapTable)db.getTableNullable(idChain.getTblId());
                tbl.readLock();
                try {
                    Partition part = tbl.getPartition(idChain.getPartId());
                    MaterializedIndex index = part.getIndex(idChain.getIdxId());
                    Tablet tablet = index.getTablet(idChain.getTabletId());
                    Replica replica = tablet.getReplicaById(idChain.getReplicaId());
                    long signature = this.catalog.getNextId();
                    SnapshotTask task = new SnapshotTask(null, replica.getBackendId(), signature, this.jobId, db.getId(), tbl.getId(), part.getId(), index.getId(), tablet.getId(), part.getVisibleVersion(), tbl.getSchemaHashByIndexId(index.getId()), this.timeoutMs, true);
                    batchTask.addTask(task);
                    this.unfinishedSignatureToId.put(signature, tablet.getId());
                    bePathsMap.put((Object)replica.getBackendId(), (Object)replica.getPathHash());
                }
                finally {
                    tbl.readUnlock();
                }
            }
        }
        finally {
            db.readUnlock();
        }
        org.apache.doris.common.Status st = Catalog.getCurrentSystemInfo().checkExceedDiskCapacityLimit((Multimap<Long, Long>)bePathsMap, true);
        if (!st.ok()) {
            this.status = new Status(Status.ErrCode.COMMON_ERROR, st.getErrorMsg());
            return;
        }
        for (AgentTask task : batchTask.getAllTasks()) {
            AgentTaskQueue.addTask(task);
        }
        AgentTaskExecutor.submit(batchTask);
        LOG.info("finished to send snapshot tasks, num: {}. {}", (Object)batchTask.getTaskNum(), (Object)this);
    }

    private void checkAndRestoreResources() {
        ResourceMgr resourceMgr = Catalog.getCurrentCatalog().getResourceMgr();
        for (BackupJobInfo.BackupOdbcResourceInfo backupOdbcResourceInfo : this.jobInfo.newBackupObjects.odbcResources) {
            String backupResourceName = backupOdbcResourceInfo.name;
            Resource localResource = resourceMgr.getResource(backupResourceName);
            OdbcCatalogResource remoteOdbcResource = (OdbcCatalogResource)this.backupMeta.getResource(backupResourceName);
            if (localResource != null) {
                if (localResource.getType() != Resource.ResourceType.ODBC_CATALOG) {
                    this.status = new Status(Status.ErrCode.COMMON_ERROR, "The type of local resource " + backupResourceName + " is not same as restored resource");
                    return;
                }
                OdbcCatalogResource localOdbcResource = (OdbcCatalogResource)localResource;
                if (localOdbcResource.getSignature(1) == remoteOdbcResource.getSignature(1)) continue;
                this.status = new Status(Status.ErrCode.COMMON_ERROR, "Odbc resource " + this.jobInfo.getAliasByOriginNameIfSet(backupResourceName) + " already exist but with different properties");
                return;
            }
            try {
                resourceMgr.createResource(remoteOdbcResource);
            }
            catch (DdlException e) {
                this.status = new Status(Status.ErrCode.COMMON_ERROR, e.getMessage());
                return;
            }
            this.restoredResources.add(remoteOdbcResource);
        }
    }

    private boolean genFileMappingWhenBackupReplicasEqual(PartitionInfo localPartInfo, Partition localPartition, Table localTbl, BackupJobInfo.BackupPartitionInfo backupPartInfo, String partitionName, BackupJobInfo.BackupOlapTableInfo tblInfo) {
        short restoreReplicaNum = this.replicaAlloc.getTotalReplicaNum();
        short localReplicaNum = localPartInfo.getReplicaAllocation(localPartition.getId()).getTotalReplicaNum();
        if (localReplicaNum != restoreReplicaNum) {
            this.status = new Status(Status.ErrCode.COMMON_ERROR, "Partition " + partitionName + " in table " + localTbl.getName() + " has different replication num '" + localReplicaNum + "' with partition in repository, which is " + restoreReplicaNum);
            return true;
        }
        OlapTable localOlapTbl = (OlapTable)localTbl;
        this.genFileMapping(localOlapTbl, localPartition, tblInfo.id, backupPartInfo, true);
        this.restoredVersionInfo.put((Object)localOlapTbl.getId(), (Object)localPartition.getId(), (Object)backupPartInfo.version);
        return false;
    }

    private void createReplicas(Database db, AgentBatchTask batchTask, OlapTable localTbl, Partition restorePart) {
        Set<String> bfColumns = localTbl.getCopiedBfColumns();
        double bfFpp = localTbl.getBfFpp();
        for (MaterializedIndex restoredIdx : restorePart.getMaterializedIndices(MaterializedIndex.IndexExtState.VISIBLE)) {
            MaterializedIndexMeta indexMeta = localTbl.getIndexMetaByIndexId(restoredIdx.getId());
            TabletMeta tabletMeta = new TabletMeta(db.getId(), localTbl.getId(), restorePart.getId(), restoredIdx.getId(), indexMeta.getSchemaHash(), TStorageMedium.HDD);
            for (Tablet restoreTablet : restoredIdx.getTablets()) {
                Catalog.getCurrentInvertedIndex().addTablet(restoreTablet.getId(), tabletMeta);
                for (Replica restoreReplica : restoreTablet.getReplicas()) {
                    Catalog.getCurrentInvertedIndex().addReplica(restoreTablet.getId(), restoreReplica);
                    CreateReplicaTask task = new CreateReplicaTask(restoreReplica.getBackendId(), this.dbId, localTbl.getId(), restorePart.getId(), restoredIdx.getId(), restoreTablet.getId(), indexMeta.getShortKeyColumnCount(), indexMeta.getSchemaHash(), restoreReplica.getVersion(), indexMeta.getKeysType(), TStorageType.COLUMN, TStorageMedium.HDD, indexMeta.getSchema(), bfColumns, bfFpp, null, localTbl.getCopiedIndexes(), localTbl.isInMemory(), localTbl.getPartitionInfo().getTabletType(restorePart.getId()), localTbl.getCompressionType());
                    task.setInRestoreMode(true);
                    batchTask.addTask(task);
                }
            }
        }
    }

    private Partition resetPartitionForRestore(OlapTable localTbl, OlapTable remoteTbl, String partName, String clusterName, ReplicaAllocation replicaAlloc) {
        Preconditions.checkState((localTbl.getPartition(partName) == null ? 1 : 0) != 0);
        Partition remotePart = remoteTbl.getPartition(partName);
        Preconditions.checkNotNull((Object)remotePart);
        PartitionInfo localPartitionInfo = localTbl.getPartitionInfo();
        Preconditions.checkState((localPartitionInfo.getType() == PartitionType.RANGE || localPartitionInfo.getType() == PartitionType.LIST ? 1 : 0) != 0);
        long newPartId = this.catalog.getNextId();
        remotePart.setIdForRestore(newPartId);
        Map<String, Long> localIdxNameToId = localTbl.getIndexNameToId();
        for (String localIdxName : localIdxNameToId.keySet()) {
            long remoteIdxId = remoteTbl.getIndexIdByName(localIdxName);
            MaterializedIndex remoteIdx = remotePart.getIndex(remoteIdxId);
            long localIdxId = localIdxNameToId.get(localIdxName);
            remoteIdx.setIdForRestore(localIdxId);
            if (localIdxId == localTbl.getBaseIndexId()) continue;
            remotePart.deleteRollupIndex(remoteIdxId);
            remotePart.createRollupIndex(remoteIdx);
        }
        long visibleVersion = remotePart.getVisibleVersion();
        for (MaterializedIndex remoteIdx : remotePart.getMaterializedIndices(MaterializedIndex.IndexExtState.VISIBLE)) {
            int schemaHash = remoteTbl.getSchemaHashByIndexId(remoteIdx.getId());
            int remotetabletSize = remoteIdx.getTablets().size();
            remoteIdx.clearTabletsForRestore();
            for (int i = 0; i < remotetabletSize; ++i) {
                long newTabletId = this.catalog.getNextId();
                Tablet newTablet = new Tablet(newTabletId);
                remoteIdx.addTablet(newTablet, null, true);
                try {
                    Map<Tag, List<Long>> beIds = Catalog.getCurrentSystemInfo().selectBackendIdsForReplicaCreation(replicaAlloc, clusterName, null);
                    for (Map.Entry<Tag, List<Long>> entry : beIds.entrySet()) {
                        for (Long beId : entry.getValue()) {
                            long newReplicaId = this.catalog.getNextId();
                            Replica newReplica = new Replica(newReplicaId, beId, Replica.ReplicaState.NORMAL, visibleVersion, schemaHash);
                            newTablet.addReplica(newReplica, true);
                        }
                    }
                    continue;
                }
                catch (DdlException e) {
                    this.status = new Status(Status.ErrCode.COMMON_ERROR, e.getMessage());
                    return null;
                }
            }
        }
        return remotePart;
    }

    private void genFileMapping(OlapTable localTbl, Partition localPartition, Long remoteTblId, BackupJobInfo.BackupPartitionInfo backupPartInfo, boolean overwrite) {
        for (MaterializedIndex localIdx : localPartition.getMaterializedIndices(MaterializedIndex.IndexExtState.VISIBLE)) {
            LOG.debug("get index id: {}, index name: {}", (Object)localIdx.getId(), (Object)localTbl.getIndexNameById(localIdx.getId()));
            BackupJobInfo.BackupIndexInfo backupIdxInfo = backupPartInfo.getIdx(localTbl.getIndexNameById(localIdx.getId()));
            Preconditions.checkState((backupIdxInfo.sortedTabletInfoList.size() == localIdx.getTablets().size() ? 1 : 0) != 0);
            for (int i = 0; i < localIdx.getTablets().size(); ++i) {
                Tablet localTablet = localIdx.getTablets().get(i);
                BackupJobInfo.BackupTabletInfo backupTabletInfo = backupIdxInfo.sortedTabletInfoList.get(i);
                LOG.debug("get tablet mapping: {} to {}, index {}", (Object)backupTabletInfo.id, (Object)localTablet.getId(), (Object)i);
                for (Replica localReplica : localTablet.getReplicas()) {
                    RestoreFileMapping.IdChain src = new RestoreFileMapping.IdChain(remoteTblId, backupPartInfo.id, backupIdxInfo.id, backupTabletInfo.id, -1L);
                    RestoreFileMapping.IdChain dest = new RestoreFileMapping.IdChain(localTbl.getId(), localPartition.getId(), localIdx.getId(), localTablet.getId(), localReplica.getId());
                    this.fileMapping.putMapping(dest, src, overwrite);
                }
            }
        }
    }

    private boolean downloadAndDeserializeMetaInfo() {
        ArrayList backupMetas = Lists.newArrayList();
        Status st = this.repo.getSnapshotMetaFile(this.jobInfo.name, backupMetas, this.metaVersion == -1 ? this.jobInfo.metaVersion : this.metaVersion);
        if (!st.ok()) {
            this.status = st;
            return false;
        }
        Preconditions.checkState((backupMetas.size() == 1 ? 1 : 0) != 0);
        this.backupMeta = (BackupMeta)backupMetas.get(0);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replayCheckAndPrepareMeta() {
        Database db;
        try {
            db = this.catalog.getDbOrMetaException(this.dbId);
        }
        catch (MetaNotFoundException e) {
            LOG.warn("[INCONSISTENT META] replayCheckAndPrepareMeta failed", (Throwable)e);
            return;
        }
        for (String string : this.jobInfo.backupOlapTableObjects.keySet()) {
            Table tbl = db.getTableNullable(this.jobInfo.getAliasByOriginNameIfSet(string));
            if (tbl == null) continue;
            OlapTable olapTbl = (OlapTable)tbl;
            tbl.writeLock();
            try {
                olapTbl.setState(OlapTable.OlapTableState.RESTORE);
                BackupJobInfo.BackupOlapTableInfo tblInfo = this.jobInfo.backupOlapTableObjects.get(string);
                for (Map.Entry<String, BackupJobInfo.BackupPartitionInfo> partitionEntry : tblInfo.partitions.entrySet()) {
                    String partitionName = partitionEntry.getKey();
                    Partition partition = olapTbl.getPartition(partitionName);
                    if (partition == null) continue;
                    partition.setState(Partition.PartitionState.RESTORE);
                }
            }
            finally {
                tbl.writeUnlock();
            }
        }
        for (Pair pair : this.restoredPartitions) {
            OlapTable localTbl = (OlapTable)db.getTableNullable((String)pair.first);
            Partition restorePart = (Partition)pair.second;
            OlapTable remoteTbl = (OlapTable)this.backupMeta.getTable((String)pair.first);
            PartitionInfo localPartitionInfo = localTbl.getPartitionInfo();
            PartitionInfo remotePartitionInfo = remoteTbl.getPartitionInfo();
            BackupJobInfo.BackupPartitionInfo backupPartitionInfo = this.jobInfo.getOlapTableInfo((String)pair.first).getPartInfo(restorePart.getName());
            long remotePartId = backupPartitionInfo.id;
            DataProperty remoteDataProperty = remotePartitionInfo.getDataProperty(remotePartId);
            localPartitionInfo.addPartition(restorePart.getId(), false, remotePartitionInfo.getItem(remotePartId), remoteDataProperty, this.replicaAlloc, remotePartitionInfo.getIsInMemory(remotePartId));
            localTbl.addPartition(restorePart);
            for (MaterializedIndex restoreIdx : restorePart.getMaterializedIndices(MaterializedIndex.IndexExtState.VISIBLE)) {
                int schemaHash = localTbl.getSchemaHashByIndexId(restoreIdx.getId());
                TabletMeta tabletMeta = new TabletMeta(db.getId(), localTbl.getId(), restorePart.getId(), restoreIdx.getId(), schemaHash, TStorageMedium.HDD);
                for (Tablet restoreTablet : restoreIdx.getTablets()) {
                    Catalog.getCurrentInvertedIndex().addTablet(restoreTablet.getId(), tabletMeta);
                    for (Replica restoreReplica : restoreTablet.getReplicas()) {
                        Catalog.getCurrentInvertedIndex().addReplica(restoreTablet.getId(), restoreReplica);
                    }
                }
            }
        }
        for (Table table : this.restoredTbls) {
            db.writeLock();
            table.writeLock();
            try {
                db.createTable(table);
            }
            finally {
                table.writeUnlock();
                db.writeUnlock();
            }
            if (table.getType() != Table.TableType.OLAP) continue;
            OlapTable olapRestoreTbl = (OlapTable)table;
            olapRestoreTbl.writeLock();
            try {
                for (Partition restorePart : olapRestoreTbl.getPartitions()) {
                    for (MaterializedIndex restoreIdx : restorePart.getMaterializedIndices(MaterializedIndex.IndexExtState.VISIBLE)) {
                        int schemaHash = olapRestoreTbl.getSchemaHashByIndexId(restoreIdx.getId());
                        TabletMeta tabletMeta = new TabletMeta(db.getId(), table.getId(), restorePart.getId(), restoreIdx.getId(), schemaHash, TStorageMedium.HDD);
                        for (Tablet restoreTablet : restoreIdx.getTablets()) {
                            Catalog.getCurrentInvertedIndex().addTablet(restoreTablet.getId(), tabletMeta);
                            for (Replica restoreReplica : restoreTablet.getReplicas()) {
                                Catalog.getCurrentInvertedIndex().addReplica(restoreTablet.getId(), restoreReplica);
                            }
                        }
                    }
                }
            }
            finally {
                olapRestoreTbl.writeUnlock();
            }
        }
        ResourceMgr resourceMgr = Catalog.getCurrentCatalog().getResourceMgr();
        for (Resource resource : this.restoredResources) {
            resourceMgr.replayCreateResource(resource);
        }
        LOG.info("replay check and prepare meta. {}", (Object)this);
    }

    private void waitingAllSnapshotsFinished() {
        if (this.unfinishedSignatureToId.isEmpty()) {
            this.snapshotFinishedTime = System.currentTimeMillis();
            this.state = RestoreJobState.DOWNLOAD;
            this.catalog.getEditLog().logRestoreJob(this);
            LOG.info("finished making snapshots. {}", (Object)this);
            return;
        }
        LOG.info("waiting {} replicas to make snapshot: [{}]. {}", (Object)this.unfinishedSignatureToId.size(), this.unfinishedSignatureToId, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void downloadSnapshots() {
        ArrayListMultimap dbToSnapshotInfos = ArrayListMultimap.create();
        for (SnapshotInfo info : this.snapshotInfos.values()) {
            dbToSnapshotInfos.put((Object)info.getDbId(), (Object)info);
        }
        this.unfinishedSignatureToId.clear();
        this.taskProgress.clear();
        this.taskErrMsg.clear();
        AgentBatchTask batchTask = new AgentBatchTask();
        Iterator<Object> iterator = dbToSnapshotInfos.keySet().iterator();
        while (iterator.hasNext()) {
            long dbId = (Long)iterator.next();
            List infos = dbToSnapshotInfos.get((Object)dbId);
            Database db = this.catalog.getDbNullable(dbId);
            if (db == null) {
                this.status = new Status(Status.ErrCode.NOT_FOUND, "db " + dbId + " does not exist");
                return;
            }
            ArrayListMultimap beToSnapshots = ArrayListMultimap.create();
            for (SnapshotInfo info : infos) {
                beToSnapshots.put((Object)info.getBeId(), (Object)info);
            }
            db.readLock();
            try {
                for (Long beId : beToSnapshots.keySet()) {
                    List beSnapshotInfos = beToSnapshots.get((Object)beId);
                    int totalNum = beSnapshotInfos.size();
                    int batchNum = Math.min(totalNum, 3);
                    int taskNumPerBatch = Math.max(totalNum / batchNum, 1);
                    LOG.debug("backend {} has {} batch, total {} tasks, {}", (Object)beId, (Object)batchNum, (Object)totalNum, (Object)this);
                    ArrayList brokerAddrs = Lists.newArrayList();
                    Status st = this.repo.getBrokerAddress(beId, this.catalog, brokerAddrs);
                    if (!st.ok()) {
                        this.status = st;
                        return;
                    }
                    Preconditions.checkState((brokerAddrs.size() == 1 ? 1 : 0) != 0);
                    int index = 0;
                    for (int batch = 0; batch < batchNum; ++batch) {
                        HashMap srcToDest = Maps.newHashMap();
                        int currentBatchTaskNum = batch == batchNum - 1 ? totalNum - index : taskNumPerBatch;
                        for (int j = 0; j < currentBatchTaskNum; ++j) {
                            SnapshotInfo info;
                            Table tbl;
                            if ((tbl = db.getTableNullable((info = (SnapshotInfo)beSnapshotInfos.get(index++)).getTblId())) == null) {
                                this.status = new Status(Status.ErrCode.NOT_FOUND, "restored table " + info.getTabletId() + " does not exist");
                                return;
                            }
                            OlapTable olapTbl = (OlapTable)tbl;
                            olapTbl.readLock();
                            try {
                                Partition part = olapTbl.getPartition(info.getPartitionId());
                                if (part == null) {
                                    this.status = new Status(Status.ErrCode.NOT_FOUND, "partition " + info.getPartitionId() + " does not exist in restored table: " + tbl.getName());
                                    return;
                                }
                                MaterializedIndex idx = part.getIndex(info.getIndexId());
                                if (idx == null) {
                                    this.status = new Status(Status.ErrCode.NOT_FOUND, "index " + info.getIndexId() + " does not exist in partion " + part.getName() + "of restored table " + tbl.getName());
                                    return;
                                }
                                Tablet tablet = idx.getTablet(info.getTabletId());
                                if (tablet == null) {
                                    this.status = new Status(Status.ErrCode.NOT_FOUND, "tablet " + info.getTabletId() + " does not exist in restored table " + tbl.getName());
                                    return;
                                }
                                Replica replica = tablet.getReplicaByBackendId(info.getBeId());
                                if (replica == null) {
                                    this.status = new Status(Status.ErrCode.NOT_FOUND, "replica in be " + info.getBeId() + " of tablet " + tablet.getId() + " does not exist in restored table " + tbl.getName());
                                    return;
                                }
                                RestoreFileMapping.IdChain catalogIds = new RestoreFileMapping.IdChain(tbl.getId(), part.getId(), idx.getId(), info.getTabletId(), replica.getId());
                                RestoreFileMapping.IdChain repoIds = this.fileMapping.get(catalogIds);
                                if (repoIds == null) {
                                    this.status = new Status(Status.ErrCode.NOT_FOUND, "failed to get id mapping of catalog ids: " + catalogIds.toString());
                                    LOG.info("current file mapping: {}", (Object)this.fileMapping);
                                    return;
                                }
                                String repoTabletPath = this.jobInfo.getFilePath(repoIds);
                                String src = this.repo.getRepoPath(this.label, repoTabletPath);
                                if (src == null) {
                                    this.status = new Status(Status.ErrCode.COMMON_ERROR, "invalid src path: " + repoTabletPath);
                                    return;
                                }
                                SnapshotInfo snapshotInfo = (SnapshotInfo)this.snapshotInfos.get((Object)info.getTabletId(), (Object)info.getBeId());
                                Preconditions.checkNotNull((Object)snapshotInfo, (Object)(info.getTabletId() + "-" + info.getBeId()));
                                String dest = snapshotInfo.getTabletPath();
                                srcToDest.put(src, dest);
                                LOG.debug("create download src path: {}, dest path: {}", (Object)src, (Object)dest);
                                continue;
                            }
                            finally {
                                olapTbl.readUnlock();
                            }
                        }
                        long signature = this.catalog.getNextId();
                        DownloadTask task = new DownloadTask(null, (long)beId, signature, this.jobId, dbId, srcToDest, (FsBroker)brokerAddrs.get(0), this.repo.getStorage().getProperties(), this.repo.getStorage().getStorageType());
                        batchTask.addTask(task);
                        this.unfinishedSignatureToId.put(signature, beId);
                    }
                }
            }
            finally {
                db.readUnlock();
            }
        }
        iterator = batchTask.getAllTasks().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                AgentTaskExecutor.submit(batchTask);
                this.state = RestoreJobState.DOWNLOADING;
                LOG.info("finished to send download tasks to BE. num: {}. {}", (Object)batchTask.getTaskNum(), (Object)this);
                return;
            }
            AgentTask task = (AgentTask)iterator.next();
            AgentTaskQueue.addTask(task);
        }
    }

    private void waitingAllDownloadFinished() {
        if (this.unfinishedSignatureToId.isEmpty()) {
            this.downloadFinishedTime = System.currentTimeMillis();
            this.state = RestoreJobState.COMMIT;
            this.backupMeta = null;
            this.catalog.getEditLog().logRestoreJob(this);
            LOG.info("finished to download. {}", (Object)this);
        }
        LOG.info("waiting {} tasks to finish downloading from repo. {}", (Object)this.unfinishedSignatureToId.size(), (Object)this);
    }

    private void commit() {
        this.unfinishedSignatureToId.clear();
        this.taskProgress.clear();
        this.taskErrMsg.clear();
        AgentBatchTask batchTask = new AgentBatchTask();
        for (Table.Cell cell : this.snapshotInfos.cellSet()) {
            SnapshotInfo info = (SnapshotInfo)cell.getValue();
            long signature = this.catalog.getNextId();
            DirMoveTask task = new DirMoveTask(null, (Long)cell.getColumnKey(), signature, this.jobId, this.dbId, info.getTblId(), info.getPartitionId(), info.getTabletId(), (Long)cell.getRowKey(), info.getTabletPath(), info.getSchemaHash(), true);
            batchTask.addTask(task);
            this.unfinishedSignatureToId.put(signature, info.getTabletId());
        }
        for (AgentTask task : batchTask.getAllTasks()) {
            AgentTaskQueue.addTask(task);
        }
        AgentTaskExecutor.submit(batchTask);
        this.state = RestoreJobState.COMMITTING;
        LOG.info("finished to send move dir tasks. num: {}. {}", (Object)batchTask.getTaskNum(), (Object)this);
    }

    private void waitingAllTabletsCommitted() {
        if (this.unfinishedSignatureToId.isEmpty()) {
            LOG.info("finished to commit all tablet. {}", (Object)this);
            Status st = this.allTabletCommitted(false);
            if (!st.ok()) {
                this.status = st;
            }
            return;
        }
        LOG.info("waiting {} tablets to commit. {}", (Object)this.unfinishedSignatureToId.size(), (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status allTabletCommitted(boolean isReplay) {
        Database db = this.catalog.getDbNullable(this.dbId);
        if (db == null) {
            return new Status(Status.ErrCode.NOT_FOUND, "database " + this.dbId + " does not exist");
        }
        this.setTableStateToNormal(db);
        Iterator iterator = this.restoredVersionInfo.rowKeySet().iterator();
        while (iterator.hasNext()) {
            long tblId = (Long)iterator.next();
            Table tbl = db.getTableNullable(tblId);
            if (tbl == null) continue;
            OlapTable olapTbl = (OlapTable)tbl;
            if (!tbl.writeLockIfExist()) continue;
            try {
                Map map = (Map)this.restoredVersionInfo.rowMap().get(tblId);
                for (Map.Entry entry : map.entrySet()) {
                    long partId = (Long)entry.getKey();
                    Partition part = olapTbl.getPartition(partId);
                    if (part == null) continue;
                    part.updateVersionForRestore((Long)entry.getValue());
                    for (MaterializedIndex idx : part.getMaterializedIndices(MaterializedIndex.IndexExtState.VISIBLE)) {
                        for (Tablet tablet : idx.getTablets()) {
                            for (Replica replica : tablet.getReplicas()) {
                                if (replica.checkVersionCatchUp(part.getVisibleVersion(), false)) continue;
                                replica.updateVersionInfo(part.getVisibleVersion(), replica.getDataSize(), replica.getRowCount());
                            }
                        }
                    }
                    LOG.debug("restore set partition {} version in table {}, version: {}", (Object)partId, (Object)tblId, entry.getValue());
                }
            }
            finally {
                tbl.writeUnlock();
            }
        }
        if (!isReplay) {
            this.restoredPartitions.clear();
            this.restoredTbls.clear();
            this.restoredResources.clear();
            this.releaseSnapshots();
            this.snapshotInfos.clear();
            this.finishedTime = System.currentTimeMillis();
            this.state = RestoreJobState.FINISHED;
            this.catalog.getEditLog().logRestoreJob(this);
        }
        LOG.info("job is finished. is replay: {}. {}", (Object)isReplay, (Object)this);
        return Status.OK;
    }

    private void releaseSnapshots() {
        if (this.snapshotInfos.isEmpty()) {
            return;
        }
        AgentBatchTask batchTask = new AgentBatchTask();
        for (SnapshotInfo info : this.snapshotInfos.values()) {
            ReleaseSnapshotTask releaseTask = new ReleaseSnapshotTask(null, info.getBeId(), info.getDbId(), info.getTabletId(), info.getPath());
            batchTask.addTask(releaseTask);
        }
        AgentTaskExecutor.submit(batchTask);
        LOG.info("send {} release snapshot tasks, job: {}", (Object)this.snapshotInfos.size(), (Object)this);
    }

    private void replayWaitingAllTabletsCommitted() {
        this.allTabletCommitted(true);
    }

    public List<String> getInfo() {
        ArrayList info = Lists.newArrayList();
        info.add(String.valueOf(this.jobId));
        info.add(this.label);
        info.add(this.backupTimestamp);
        info.add(this.dbName);
        info.add(this.state.name());
        info.add(String.valueOf(this.allowLoad));
        info.add(String.valueOf(this.replicaAlloc.getTotalReplicaNum()));
        info.add(this.replicaAlloc.toCreateStmt());
        info.add(this.getRestoreObjs());
        info.add(TimeUtils.longToTimeString(this.createTime));
        info.add(TimeUtils.longToTimeString(this.metaPreparedTime));
        info.add(TimeUtils.longToTimeString(this.snapshotFinishedTime));
        info.add(TimeUtils.longToTimeString(this.downloadFinishedTime));
        info.add(TimeUtils.longToTimeString(this.finishedTime));
        info.add(Joiner.on((String)", ").join(this.unfinishedSignatureToId.entrySet()));
        info.add(Joiner.on((String)", ").join((Iterable)this.taskProgress.entrySet().stream().map(e -> "[" + e.getKey() + ": " + ((Pair)e.getValue()).first + "/" + ((Pair)e.getValue()).second + "]").collect(Collectors.toList())));
        info.add(Joiner.on((String)", ").join((Iterable)this.taskErrMsg.entrySet().stream().map(n -> "[" + n.getKey() + ": " + (String)n.getValue() + "]").collect(Collectors.toList())));
        info.add(this.status.toString());
        info.add(String.valueOf(this.timeoutMs / 1000L));
        return info;
    }

    private String getRestoreObjs() {
        Preconditions.checkState((this.jobInfo != null ? 1 : 0) != 0);
        return this.jobInfo.getInfo();
    }

    @Override
    public boolean isDone() {
        return this.state == RestoreJobState.FINISHED || this.state == RestoreJobState.CANCELLED;
    }

    @Override
    public synchronized Status cancel() {
        if (this.isDone()) {
            return new Status(Status.ErrCode.COMMON_ERROR, "Job with label " + this.label + " can not be cancelled. state: " + (Object)((Object)this.state));
        }
        this.status = new Status(Status.ErrCode.COMMON_ERROR, "user cancelled, current state: " + this.state.name());
        this.cancelInternal(false);
        return Status.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelInternal(boolean isReplay) {
        Database db;
        if (!isReplay) {
            switch (this.state) {
                case SNAPSHOTING: {
                    for (Long l : this.unfinishedSignatureToId.keySet()) {
                        AgentTaskQueue.removeTaskOfType(TTaskType.MAKE_SNAPSHOT, l);
                    }
                    break;
                }
                case DOWNLOADING: {
                    for (Long l : this.unfinishedSignatureToId.keySet()) {
                        AgentTaskQueue.removeTaskOfType(TTaskType.DOWNLOAD, l);
                    }
                    break;
                }
                case COMMITTING: {
                    for (Long l : this.unfinishedSignatureToId.keySet()) {
                        AgentTaskQueue.removeTaskOfType(TTaskType.MOVE, l);
                    }
                    break;
                }
            }
        }
        if ((db = this.catalog.getDbNullable(this.dbId)) != null) {
            this.setTableStateToNormal(db);
            for (Table restoreTbl : this.restoredTbls) {
                LOG.info("remove restored table when cancelled: {}", (Object)restoreTbl.getName());
                if (!db.writeLockIfExist()) continue;
                try {
                    if (restoreTbl.getType() != Table.TableType.OLAP) continue;
                    OlapTable restoreOlapTable = (OlapTable)restoreTbl;
                    restoreOlapTable.writeLock();
                    try {
                        for (Partition part : restoreOlapTable.getPartitions()) {
                            for (MaterializedIndex idx : part.getMaterializedIndices(MaterializedIndex.IndexExtState.VISIBLE)) {
                                for (Tablet tablet : idx.getTablets()) {
                                    Catalog.getCurrentInvertedIndex().deleteTablet(tablet.getId());
                                }
                            }
                        }
                        db.dropTable(restoreTbl.getName());
                    }
                    finally {
                        restoreTbl.writeUnlock();
                    }
                }
                finally {
                    db.writeUnlock();
                }
            }
            for (Pair<String, Partition> entry : this.restoredPartitions) {
                OlapTable restoreTbl = (OlapTable)db.getTableNullable((String)entry.first);
                if (restoreTbl == null || !restoreTbl.writeLockIfExist()) continue;
                LOG.info("remove restored partition in table {} when cancelled: {}", (Object)restoreTbl.getName(), (Object)((Partition)entry.second).getName());
                try {
                    restoreTbl.dropPartition(this.dbId, ((Partition)entry.second).getName(), true);
                }
                finally {
                    restoreTbl.writeUnlock();
                }
            }
            ResourceMgr resourceMgr = Catalog.getCurrentCatalog().getResourceMgr();
            for (Resource resource : this.restoredResources) {
                LOG.info("remove restored resource when cancelled: {}", (Object)resource.getName());
                resourceMgr.dropResource(resource);
            }
        }
        if (!isReplay) {
            this.backupMeta = null;
            this.releaseSnapshots();
            this.snapshotInfos.clear();
            RestoreJobState restoreJobState = this.state;
            this.finishedTime = System.currentTimeMillis();
            this.state = RestoreJobState.CANCELLED;
            this.catalog.getEditLog().logRestoreJob(this);
            LOG.info("finished to cancel restore job. current state: {}. is replay: {}. {}", (Object)restoreJobState.name(), (Object)isReplay, (Object)this);
            return;
        }
        LOG.info("finished to cancel restore job. is replay: {}. {}", (Object)isReplay, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTableStateToNormal(Database db) {
        for (String tableName : this.jobInfo.backupOlapTableObjects.keySet()) {
            Table tbl = db.getTableNullable(this.jobInfo.getAliasByOriginNameIfSet(tableName));
            if (tbl == null || tbl.getType() != Table.TableType.OLAP) continue;
            OlapTable olapTbl = (OlapTable)tbl;
            if (!tbl.writeLockIfExist()) continue;
            try {
                if (olapTbl.getState() == OlapTable.OlapTableState.RESTORE || olapTbl.getState() == OlapTable.OlapTableState.RESTORE_WITH_LOAD) {
                    olapTbl.setState(OlapTable.OlapTableState.NORMAL);
                }
                BackupJobInfo.BackupOlapTableInfo tblInfo = this.jobInfo.backupOlapTableObjects.get(tableName);
                for (Map.Entry<String, BackupJobInfo.BackupPartitionInfo> partitionEntry : tblInfo.partitions.entrySet()) {
                    String partitionName = partitionEntry.getKey();
                    Partition partition = olapTbl.getPartition(partitionName);
                    if (partition == null || partition.getState() != Partition.PartitionState.RESTORE) continue;
                    partition.setState(Partition.PartitionState.NORMAL);
                }
            }
            finally {
                tbl.writeUnlock();
            }
        }
    }

    public static RestoreJob read(DataInput in) throws IOException {
        RestoreJob job = new RestoreJob();
        job.readFields(in);
        return job;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        Text.writeString((DataOutput)out, (String)this.backupTimestamp);
        this.jobInfo.write(out);
        out.writeBoolean(this.allowLoad);
        Text.writeString((DataOutput)out, (String)this.state.name());
        if (this.backupMeta != null) {
            out.writeBoolean(true);
            this.backupMeta.write(out);
        } else {
            out.writeBoolean(false);
        }
        this.fileMapping.write(out);
        out.writeLong(this.metaPreparedTime);
        out.writeLong(this.snapshotFinishedTime);
        out.writeLong(this.downloadFinishedTime);
        this.replicaAlloc.write(out);
        out.writeInt(this.restoredPartitions.size());
        for (Pair<String, Partition> pair : this.restoredPartitions) {
            Text.writeString((DataOutput)out, (String)((String)pair.first));
            ((Partition)pair.second).write(out);
        }
        out.writeInt(this.restoredTbls.size());
        for (Table table : this.restoredTbls) {
            table.write(out);
        }
        out.writeInt(this.restoredVersionInfo.rowKeySet().size());
        Iterator<Object> iterator = this.restoredVersionInfo.rowKeySet().iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            out.writeLong(l);
            out.writeInt(this.restoredVersionInfo.row((Object)l).size());
            for (Map.Entry entry : this.restoredVersionInfo.row((Object)l).entrySet()) {
                out.writeLong((Long)entry.getKey());
                out.writeLong((Long)entry.getValue());
                out.writeLong(0L);
            }
        }
        out.writeInt(this.snapshotInfos.rowKeySet().size());
        iterator = this.snapshotInfos.rowKeySet().iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            out.writeLong(l);
            Map map = this.snapshotInfos.row((Object)l);
            out.writeInt(map.size());
            for (Map.Entry entry : map.entrySet()) {
                out.writeLong((Long)entry.getKey());
                ((SnapshotInfo)entry.getValue()).write(out);
            }
        }
        out.writeInt(this.restoredResources.size());
        for (Resource resource : this.restoredResources) {
            resource.write(out);
        }
        out.writeInt(this.properties.size());
        for (Map.Entry entry : this.properties.entrySet()) {
            Text.writeString((DataOutput)out, (String)((String)entry.getKey()));
            Text.writeString((DataOutput)out, (String)((String)entry.getValue()));
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int j;
        int innerSize;
        int i;
        super.readFields(in);
        this.backupTimestamp = Text.readString((DataInput)in);
        this.jobInfo = BackupJobInfo.read(in);
        this.allowLoad = in.readBoolean();
        this.state = RestoreJobState.valueOf(Text.readString((DataInput)in));
        if (in.readBoolean()) {
            this.backupMeta = BackupMeta.read(in);
        }
        this.fileMapping = RestoreFileMapping.read(in);
        this.metaPreparedTime = in.readLong();
        this.snapshotFinishedTime = in.readLong();
        this.downloadFinishedTime = in.readLong();
        if (Catalog.getCurrentCatalogJournalVersion() < 105) {
            int restoreReplicationNum = in.readInt();
            this.replicaAlloc = new ReplicaAllocation((short)restoreReplicationNum);
        } else {
            this.replicaAlloc = ReplicaAllocation.read(in);
        }
        int size = in.readInt();
        for (i = 0; i < size; ++i) {
            String tblName = Text.readString((DataInput)in);
            Partition part = Partition.read(in);
            this.restoredPartitions.add(Pair.create(tblName, part));
        }
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            this.restoredTbls.add(Table.read(in));
        }
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            long tblId = in.readLong();
            innerSize = in.readInt();
            for (j = 0; j < innerSize; ++j) {
                long partId = in.readLong();
                long version = in.readLong();
                long versionHash = in.readLong();
                this.restoredVersionInfo.put((Object)tblId, (Object)partId, (Object)version);
            }
        }
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            long tabletId = in.readLong();
            innerSize = in.readInt();
            for (j = 0; j < innerSize; ++j) {
                long beId = in.readLong();
                SnapshotInfo info = SnapshotInfo.read(in);
                this.snapshotInfos.put((Object)tabletId, (Object)beId, (Object)info);
            }
        }
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            this.restoredResources.add(Resource.read(in));
        }
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            String key = Text.readString((DataInput)in);
            String value = Text.readString((DataInput)in);
            this.properties.put(key, value);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(", backup ts: ").append(this.backupTimestamp);
        sb.append(", state: ").append(this.state.name());
        return sb.toString();
    }

    public static enum RestoreJobState {
        PENDING,
        SNAPSHOTING,
        DOWNLOAD,
        DOWNLOADING,
        COMMIT,
        COMMITTING,
        FINISHED,
        CANCELLED;

    }
}

