/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.backup;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.doris.common.io.Writable;

public class RestoreFileMapping
implements Writable {
    private Map<IdChain, IdChain> mapping = Maps.newHashMap();
    private Map<Long, Boolean> overwriteMap = Maps.newHashMap();

    public void putMapping(IdChain key, IdChain value, boolean overwrite) {
        this.mapping.put(key, value);
        this.overwriteMap.put(key.getTabletId(), overwrite);
    }

    public IdChain get(IdChain key) {
        return this.mapping.get(key);
    }

    public Map<IdChain, IdChain> getMapping() {
        return this.mapping;
    }

    public boolean isOverwrite(long tabletId) {
        if (this.overwriteMap.containsKey(tabletId)) {
            return this.overwriteMap.get(tabletId);
        }
        return false;
    }

    public static RestoreFileMapping read(DataInput in) throws IOException {
        RestoreFileMapping mapping = new RestoreFileMapping();
        mapping.readFields(in);
        return mapping;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.mapping.size());
        for (Map.Entry<IdChain, IdChain> entry : this.mapping.entrySet()) {
            entry.getKey().write(out);
            entry.getValue().write(out);
        }
        out.writeInt(this.overwriteMap.size());
        for (Map.Entry<Object, Object> entry : this.overwriteMap.entrySet()) {
            out.writeLong((Long)entry.getKey());
            out.writeBoolean((Boolean)entry.getValue());
        }
    }

    public void readFields(DataInput in) throws IOException {
        int i;
        int size = in.readInt();
        for (i = 0; i < size; ++i) {
            IdChain key = IdChain.read(in);
            IdChain val = IdChain.read(in);
            this.mapping.put(key, val);
        }
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            long tabletId = in.readLong();
            boolean overwrite = in.readBoolean();
            this.overwriteMap.put(tabletId, overwrite);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<IdChain, IdChain> entry : this.mapping.entrySet()) {
            sb.append(entry.getKey()).append(" : ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    public static class IdChain
    implements Writable {
        private Long[] chain;

        private IdChain() {
        }

        public IdChain(Long ... ids) {
            Preconditions.checkState((ids.length == 5 ? 1 : 0) != 0);
            this.chain = ids;
        }

        public Long getTblId() {
            return this.chain[0];
        }

        public long getPartId() {
            return this.chain[1];
        }

        public long getIdxId() {
            return this.chain[2];
        }

        public long getTabletId() {
            return this.chain[3];
        }

        public long getReplicaId() {
            return this.chain[4];
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append(Joiner.on((String)"-").join((Object[])this.chain));
            sb.append("]");
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IdChain)) {
                return false;
            }
            IdChain other = (IdChain)obj;
            for (int i = 0; i < 5; ++i) {
                if (this.chain[i].equals(other.chain[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int code = this.chain[0].hashCode();
            for (int i = 1; i < 5; ++i) {
                code ^= this.chain[i].hashCode();
            }
            return code;
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.chain.length);
            for (Long id : this.chain) {
                out.writeLong(id);
            }
        }

        public void readFields(DataInput in) throws IOException {
            int size = in.readInt();
            this.chain = new Long[size];
            for (int i = 0; i < size; ++i) {
                this.chain[i] = in.readLong();
            }
        }

        public static IdChain read(DataInput in) throws IOException {
            IdChain chain = new IdChain();
            chain.readFields(in);
            return chain;
        }
    }
}

