/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.backup;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.doris.backup.Repository;
import org.apache.doris.backup.Status;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.Daemon;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RepositoryMgr
extends Daemon
implements Writable {
    private static final Logger LOG = LogManager.getLogger(RepositoryMgr.class);
    private Map<String, Repository> repoNameMap = Maps.newConcurrentMap();
    private Map<Long, Repository> repoIdMap = Maps.newConcurrentMap();
    private ReentrantLock lock = new ReentrantLock();

    public RepositoryMgr() {
        super(Repository.class.getSimpleName(), 600000L);
    }

    @Override
    protected void runOneCycle() {
        for (Repository repo : this.repoNameMap.values()) {
            if (repo.ping()) continue;
            LOG.warn("Failed to connect repository {}. msg: {}", (Object)repo.getName(), (Object)repo.getErrorMsg());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status addAndInitRepoIfNotExist(Repository repo, boolean isReplay) {
        this.lock.lock();
        try {
            if (!this.repoNameMap.containsKey(repo.getName())) {
                Status st;
                if (!isReplay && !(st = repo.initRepository()).ok()) {
                    Status status = st;
                    return status;
                }
                this.repoNameMap.put(repo.getName(), repo);
                this.repoIdMap.put(repo.getId(), repo);
                if (!isReplay) {
                    Catalog.getCurrentCatalog().getEditLog().logCreateRepository(repo);
                }
                LOG.info("successfully adding repo {} to repository mgr. is replay: {}", (Object)repo.getName(), (Object)isReplay);
                Status status = Status.OK;
                return status;
            }
            Status status = new Status(Status.ErrCode.COMMON_ERROR, "repository with same name already exist: " + repo.getName());
            return status;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Repository getRepo(String repoName) {
        return this.repoNameMap.get(repoName);
    }

    public Repository getRepo(long repoId) {
        return this.repoIdMap.get(repoId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status removeRepo(String repoName, boolean isReplay) {
        this.lock.lock();
        try {
            Repository repo = this.repoNameMap.remove(repoName);
            if (repo != null) {
                this.repoIdMap.remove(repo.getId());
                if (!isReplay) {
                    Catalog.getCurrentCatalog().getEditLog().logDropRepository(repoName);
                }
                LOG.info("successfully removing repo {} from repository mgr", (Object)repoName);
                Status status = Status.OK;
                return status;
            }
            Status status = new Status(Status.ErrCode.NOT_FOUND, "repository does not exist");
            return status;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<List<String>> getReposInfo() {
        ArrayList infos = Lists.newArrayList();
        for (Repository repo : this.repoIdMap.values()) {
            infos.add(repo.getInfo());
        }
        return infos;
    }

    public static RepositoryMgr read(DataInput in) throws IOException {
        RepositoryMgr mgr = new RepositoryMgr();
        mgr.readFields(in);
        return mgr;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.repoNameMap.size());
        for (Repository repo : this.repoNameMap.values()) {
            repo.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Repository repo = Repository.read(in);
            this.repoNameMap.put(repo.getName(), repo);
            this.repoIdMap.put(repo.getId(), repo);
        }
    }
}

