/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.backup;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.StorageBackend;
import org.apache.doris.backup.BlobStorage;
import org.apache.doris.backup.RemoteFile;
import org.apache.doris.backup.Status;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.FsBroker;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ClientPool;
import org.apache.doris.common.Pair;
import org.apache.doris.common.util.BrokerUtil;
import org.apache.doris.service.FrontendOptions;
import org.apache.doris.thrift.TBrokerCheckPathExistRequest;
import org.apache.doris.thrift.TBrokerCheckPathExistResponse;
import org.apache.doris.thrift.TBrokerCloseReaderRequest;
import org.apache.doris.thrift.TBrokerCloseWriterRequest;
import org.apache.doris.thrift.TBrokerDeletePathRequest;
import org.apache.doris.thrift.TBrokerFD;
import org.apache.doris.thrift.TBrokerFileStatus;
import org.apache.doris.thrift.TBrokerListPathRequest;
import org.apache.doris.thrift.TBrokerListResponse;
import org.apache.doris.thrift.TBrokerOpenMode;
import org.apache.doris.thrift.TBrokerOpenReaderRequest;
import org.apache.doris.thrift.TBrokerOpenReaderResponse;
import org.apache.doris.thrift.TBrokerOpenWriterRequest;
import org.apache.doris.thrift.TBrokerOpenWriterResponse;
import org.apache.doris.thrift.TBrokerOperationStatus;
import org.apache.doris.thrift.TBrokerOperationStatusCode;
import org.apache.doris.thrift.TBrokerPReadRequest;
import org.apache.doris.thrift.TBrokerPWriteRequest;
import org.apache.doris.thrift.TBrokerReadResponse;
import org.apache.doris.thrift.TBrokerRenamePathRequest;
import org.apache.doris.thrift.TBrokerVersion;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TPaloBrokerService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;

public class BrokerStorage
extends BlobStorage {
    private static final Logger LOG = LogManager.getLogger(BrokerStorage.class);

    public BrokerStorage(String brokerName, Map<String, String> properties) {
        this.setName(brokerName);
        this.setProperties(properties);
        this.setType(StorageBackend.StorageType.BROKER);
    }

    public String getBrokerName() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status downloadWithFileSize(String remoteFilePath, String localFilePath, long fileSize) {
        TBrokerFD fd;
        LOG.debug("download from {} to {}, file size: {}.", (Object)remoteFilePath, (Object)localFilePath, (Object)fileSize);
        long start = System.currentTimeMillis();
        Pair<TPaloBrokerService.Client, TNetworkAddress> pair = this.getBroker();
        if (pair == null) {
            return new Status(Status.ErrCode.COMMON_ERROR, "failed to get broker client");
        }
        TPaloBrokerService.Client client = (TPaloBrokerService.Client)pair.first;
        TNetworkAddress address = (TNetworkAddress)pair.second;
        try {
            TBrokerOpenReaderRequest req = new TBrokerOpenReaderRequest(TBrokerVersion.VERSION_ONE, remoteFilePath, 0L, BrokerStorage.clientId(), this.getProperties());
            TBrokerOpenReaderResponse rep = client.openReader(req);
            TBrokerOperationStatus opst = rep.getOpStatus();
            if (opst.getStatusCode() != TBrokerOperationStatusCode.OK) {
                return new Status(Status.ErrCode.COMMON_ERROR, "failed to open reader on broker " + BrokerUtil.printBroker(this.getName(), address) + " for file: " + remoteFilePath + ". msg: " + opst.getMessage());
            }
            fd = rep.getFd();
            LOG.info("finished to open reader. fd: {}. download {} to {}.", (Object)fd, (Object)remoteFilePath, (Object)localFilePath);
        }
        catch (TException e) {
            return new Status(Status.ErrCode.COMMON_ERROR, "failed to open reader on broker " + BrokerUtil.printBroker(this.getName(), address) + " for file: " + remoteFilePath + ". msg: " + e.getMessage());
        }
        Preconditions.checkNotNull((Object)fd);
        File localFile = new File(localFilePath);
        if (localFile.exists()) {
            try {
                Files.walk(Paths.get(localFilePath, new String[0]), FileVisitOption.FOLLOW_LINKS).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (IOException e) {
                return new Status(Status.ErrCode.COMMON_ERROR, "failed to delete exist local file: " + localFilePath);
            }
        }
        Status status = Status.OK;
        try {
            if (!localFile.createNewFile()) {
                return new Status(Status.ErrCode.COMMON_ERROR, "failed to create local file: " + localFilePath);
            }
        }
        catch (IOException e) {
            return new Status(Status.ErrCode.COMMON_ERROR, "failed to create local file: " + localFilePath + ", msg: " + e.getMessage());
        }
        String lastErrMsg = null;
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(localFile));){
            TBrokerReadResponse rep;
            long bufSize = 0x100000L;
            long readOffset = 0L;
            for (long leftSize = fileSize; leftSize > 0L; leftSize -= (long)rep.getData().length) {
                int tryTimes;
                long readLen = Math.min(leftSize, 0x100000L);
                rep = null;
                for (tryTimes = 0; tryTimes < 3; ++tryTimes) {
                    try {
                        TBrokerPReadRequest req = new TBrokerPReadRequest(TBrokerVersion.VERSION_ONE, fd, readOffset, readLen);
                        rep = client.pread(req);
                        if (rep.getOpStatus().getStatusCode() != TBrokerOperationStatusCode.OK) {
                            lastErrMsg = String.format("failed to read via broker %s. current read offset: %d, read length: %d, file size: %d, file: %s, err code: %d, msg: %s", BrokerUtil.printBroker(this.getName(), address), readOffset, readLen, fileSize, remoteFilePath, rep.getOpStatus().getStatusCode().getValue(), rep.getOpStatus().getMessage());
                            LOG.warn(lastErrMsg);
                            status = new Status(Status.ErrCode.COMMON_ERROR, lastErrMsg);
                        }
                        if (rep.opStatus.statusCode != TBrokerOperationStatusCode.END_OF_FILE) {
                            LOG.debug("download. readLen: {}, read data len: {}, left size:{}. total size: {}", (Object)readLen, (Object)rep.getData().length, (Object)leftSize, (Object)fileSize);
                            break;
                        }
                        LOG.debug("read eof: " + remoteFilePath);
                        break;
                    }
                    catch (TTransportException e) {
                        if (e.getType() == 3) {
                            lastErrMsg = String.format("failed to read via broker %s. current read offset: %d, read length: %d, file size: %d, file: %s, timeout.", BrokerUtil.printBroker(this.getName(), address), readOffset, readLen, fileSize, remoteFilePath);
                            continue;
                        }
                        lastErrMsg = String.format("failed to read via broker %s. current read offset: %d, read length: %d, file size: %d, file: %s. msg: %s", BrokerUtil.printBroker(this.getName(), address), readOffset, readLen, fileSize, remoteFilePath, e.getMessage());
                        LOG.warn(lastErrMsg);
                        status = new Status(Status.ErrCode.COMMON_ERROR, lastErrMsg);
                        break;
                    }
                    catch (TException e) {
                        lastErrMsg = String.format("failed to read via broker %s. current read offset: %d, read length: %d, file size: %d, file: %s. msg: %s", BrokerUtil.printBroker(this.getName(), address), readOffset, readLen, fileSize, remoteFilePath, e.getMessage());
                        LOG.warn(lastErrMsg);
                        status = new Status(Status.ErrCode.COMMON_ERROR, lastErrMsg);
                        break;
                    }
                }
                if (status.ok() && tryTimes < 3) {
                    Preconditions.checkNotNull(rep);
                    if ((long)rep.getData().length != readLen) {
                        LOG.warn("the actual read length does not equal to the expected read length: {} vs. {}, file: {}, broker: {}", (Object)rep.getData().length, (Object)readLen, (Object)remoteFilePath, (Object)BrokerUtil.printBroker(this.getName(), address));
                    }
                    out.write(rep.getData());
                    readOffset += (long)rep.getData().length;
                    continue;
                }
                status = new Status(Status.ErrCode.COMMON_ERROR, lastErrMsg);
                break;
            }
        }
        catch (IOException e) {
            Status status2 = new Status(Status.ErrCode.COMMON_ERROR, "Got exception: " + e.getMessage() + ", broker: " + BrokerUtil.printBroker(this.getName(), address));
            return status2;
        }
        finally {
            Status closeStatus = this.closeReader(client, address, fd);
            if (!closeStatus.ok()) {
                LOG.warn(closeStatus.getErrMsg());
                if (status.ok()) {
                    status = closeStatus;
                }
                ClientPool.brokerPool.invalidateObject(address, client);
            } else {
                ClientPool.brokerPool.returnObject(address, client);
            }
        }
        LOG.info("finished to download from {} to {} with size: {}. cost {} ms", (Object)remoteFilePath, (Object)localFilePath, (Object)fileSize, (Object)(System.currentTimeMillis() - start));
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status directUpload(String content, String remoteFile) {
        Pair<TPaloBrokerService.Client, TNetworkAddress> pair = this.getBroker();
        if (pair == null) {
            return new Status(Status.ErrCode.COMMON_ERROR, "failed to get broker client");
        }
        TPaloBrokerService.Client client = (TPaloBrokerService.Client)pair.first;
        TNetworkAddress address = (TNetworkAddress)pair.second;
        TBrokerFD fd = new TBrokerFD();
        Status status = Status.OK;
        try {
            status = this.openWriter(client, address, remoteFile, fd);
            if (!status.ok()) {
                Status status2 = status;
                return status2;
            }
            try {
                ByteBuffer bb = ByteBuffer.wrap(content.getBytes(StandardCharsets.UTF_8));
                TBrokerPWriteRequest req = new TBrokerPWriteRequest(TBrokerVersion.VERSION_ONE, fd, 0L, bb);
                TBrokerOperationStatus opst = client.pwrite(req);
                if (opst.getStatusCode() != TBrokerOperationStatusCode.OK) {
                    status = new Status(Status.ErrCode.COMMON_ERROR, "write failed: " + opst.getMessage() + ", broker: " + BrokerUtil.printBroker(this.getName(), address));
                }
            }
            catch (TException e) {
                status = new Status(Status.ErrCode.BAD_CONNECTION, "write exception: " + e.getMessage() + ", broker: " + BrokerUtil.printBroker(this.getName(), address));
            }
        }
        finally {
            Status closeStatus = this.closeWriter(client, address, fd);
            if (closeStatus.getErrCode() == Status.ErrCode.BAD_CONNECTION || status.getErrCode() == Status.ErrCode.BAD_CONNECTION) {
                ClientPool.brokerPool.invalidateObject(address, client);
            } else {
                ClientPool.brokerPool.returnObject(address, client);
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status upload(String localPath, String remotePath) {
        long start = System.currentTimeMillis();
        Pair<TPaloBrokerService.Client, TNetworkAddress> pair = this.getBroker();
        if (pair == null) {
            return new Status(Status.ErrCode.COMMON_ERROR, "failed to get broker client");
        }
        TPaloBrokerService.Client client = (TPaloBrokerService.Client)pair.first;
        TNetworkAddress address = (TNetworkAddress)pair.second;
        TBrokerFD fd = new TBrokerFD();
        Status status = this.openWriter(client, address, remotePath, fd);
        if (!status.ok()) {
            return status;
        }
        File localFile = new File(localPath);
        long fileLength = localFile.length();
        byte[] readBuf = new byte[1024];
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(localFile));){
            int bytesRead;
            String lastErrMsg = null;
            long writeOffset = 0L;
            while ((bytesRead = in.read(readBuf)) != -1) {
                int tryTimes;
                ByteBuffer bb = ByteBuffer.wrap(readBuf, 0, bytesRead);
                for (tryTimes = 0; tryTimes < 3; ++tryTimes) {
                    try {
                        TBrokerPWriteRequest req = new TBrokerPWriteRequest(TBrokerVersion.VERSION_ONE, fd, writeOffset, bb);
                        TBrokerOperationStatus opst = client.pwrite(req);
                        if (opst.getStatusCode() == TBrokerOperationStatusCode.OK) break;
                        lastErrMsg = String.format("failed to write via broker %s. current write offset: %d, write length: %d, file length: %d, file: %s, err code: %d, msg: %s", BrokerUtil.printBroker(this.getName(), address), writeOffset, bytesRead, fileLength, remotePath, opst.getStatusCode().getValue(), opst.getMessage());
                        LOG.warn(lastErrMsg);
                        status = new Status(Status.ErrCode.COMMON_ERROR, lastErrMsg);
                        break;
                    }
                    catch (TTransportException e) {
                        if (e.getType() == 3) {
                            lastErrMsg = String.format("failed to write via broker %s. current write offset: %d, write length: %d, file length: %d, file: %s. timeout", BrokerUtil.printBroker(this.getName(), address), writeOffset, bytesRead, fileLength, remotePath);
                            continue;
                        }
                        lastErrMsg = String.format("failed to write via broker %s. current write offset: %d, write length: %d, file length: %d, file: %s. encounter TTransportException: %s", BrokerUtil.printBroker(this.getName(), address), writeOffset, bytesRead, fileLength, remotePath, e.getMessage());
                        LOG.warn(lastErrMsg, (Throwable)e);
                        status = new Status(Status.ErrCode.COMMON_ERROR, lastErrMsg);
                        break;
                    }
                    catch (TException e) {
                        lastErrMsg = String.format("failed to write via broker %s. current write offset: %d, write length: %d, file length: %d, file: %s. encounter TException: %s", BrokerUtil.printBroker(this.getName(), address), writeOffset, bytesRead, fileLength, remotePath, e.getMessage());
                        LOG.warn(lastErrMsg, (Throwable)e);
                        status = new Status(Status.ErrCode.COMMON_ERROR, lastErrMsg);
                        break;
                    }
                }
                if (status.ok() && tryTimes < 3) {
                    writeOffset += (long)bytesRead;
                    continue;
                }
                status = new Status(Status.ErrCode.COMMON_ERROR, lastErrMsg);
                break;
            }
        }
        catch (FileNotFoundException e1) {
            Status status2 = new Status(Status.ErrCode.COMMON_ERROR, "encounter file not found exception: " + e1.getMessage() + ", broker: " + BrokerUtil.printBroker(this.getName(), address));
            return status2;
        }
        catch (IOException e1) {
            Status status3 = new Status(Status.ErrCode.COMMON_ERROR, "encounter io exception: " + e1.getMessage() + ", broker: " + BrokerUtil.printBroker(this.getName(), address));
            return status3;
        }
        finally {
            Status closeStatus = this.closeWriter(client, address, fd);
            if (!closeStatus.ok()) {
                LOG.warn(closeStatus.getErrMsg());
                if (status.ok()) {
                    status = closeStatus;
                }
                ClientPool.brokerPool.invalidateObject(address, client);
            } else {
                ClientPool.brokerPool.returnObject(address, client);
            }
        }
        if (status.ok()) {
            LOG.info("finished to upload {} to remote path {}. cost: {} ms", (Object)localPath, (Object)remotePath, (Object)(System.currentTimeMillis() - start));
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status rename(String origFilePath, String destFilePath) {
        long start = System.currentTimeMillis();
        Pair<TPaloBrokerService.Client, TNetworkAddress> pair = this.getBroker();
        if (pair == null) {
            return new Status(Status.ErrCode.COMMON_ERROR, "failed to get broker client");
        }
        TPaloBrokerService.Client client = (TPaloBrokerService.Client)pair.first;
        TNetworkAddress address = (TNetworkAddress)pair.second;
        boolean needReturn = true;
        try {
            TBrokerRenamePathRequest req = new TBrokerRenamePathRequest(TBrokerVersion.VERSION_ONE, origFilePath, destFilePath, this.getProperties());
            TBrokerOperationStatus ost = client.renamePath(req);
            if (ost.getStatusCode() != TBrokerOperationStatusCode.OK) {
                Status status = new Status(Status.ErrCode.COMMON_ERROR, "failed to rename " + origFilePath + " to " + destFilePath + ", msg: " + ost.getMessage() + ", broker: " + BrokerUtil.printBroker(this.getName(), address));
                return status;
            }
        }
        catch (TException e) {
            needReturn = false;
            Status status = new Status(Status.ErrCode.COMMON_ERROR, "failed to rename " + origFilePath + " to " + destFilePath + ", msg: " + e.getMessage() + ", broker: " + BrokerUtil.printBroker(this.getName(), address));
            return status;
        }
        finally {
            if (needReturn) {
                ClientPool.brokerPool.returnObject(address, client);
            } else {
                ClientPool.brokerPool.invalidateObject(address, client);
            }
        }
        LOG.info("finished to rename {} to  {}. cost: {} ms", (Object)origFilePath, (Object)destFilePath, (Object)(System.currentTimeMillis() - start));
        return Status.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status delete(String remotePath) {
        Pair<TPaloBrokerService.Client, TNetworkAddress> pair = this.getBroker();
        if (pair == null) {
            return new Status(Status.ErrCode.COMMON_ERROR, "failed to get broker client");
        }
        TPaloBrokerService.Client client = (TPaloBrokerService.Client)pair.first;
        TNetworkAddress address = (TNetworkAddress)pair.second;
        boolean needReturn = true;
        try {
            TBrokerDeletePathRequest req = new TBrokerDeletePathRequest(TBrokerVersion.VERSION_ONE, remotePath, this.getProperties());
            TBrokerOperationStatus opst = client.deletePath(req);
            if (opst.getStatusCode() != TBrokerOperationStatusCode.OK) {
                Status status = new Status(Status.ErrCode.COMMON_ERROR, "failed to delete remote path: " + remotePath + ". msg: " + opst.getMessage() + ", broker: " + BrokerUtil.printBroker(this.getName(), address));
                return status;
            }
            LOG.info("finished to delete remote path {}.", (Object)remotePath);
        }
        catch (TException e) {
            needReturn = false;
            Status status = new Status(Status.ErrCode.COMMON_ERROR, "failed to delete remote path: " + remotePath + ". msg: " + e.getMessage() + ", broker: " + BrokerUtil.printBroker(this.getName(), address));
            return status;
        }
        finally {
            if (needReturn) {
                ClientPool.brokerPool.returnObject(address, client);
            } else {
                ClientPool.brokerPool.invalidateObject(address, client);
            }
        }
        return Status.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status list(String remotePath, List<RemoteFile> result) {
        Pair<TPaloBrokerService.Client, TNetworkAddress> pair = this.getBroker();
        if (pair == null) {
            return new Status(Status.ErrCode.COMMON_ERROR, "failed to get broker client");
        }
        TPaloBrokerService.Client client = (TPaloBrokerService.Client)pair.first;
        TNetworkAddress address = (TNetworkAddress)pair.second;
        boolean needReturn = true;
        try {
            TBrokerListPathRequest req = new TBrokerListPathRequest(TBrokerVersion.VERSION_ONE, remotePath, false, this.getProperties());
            req.setFileNameOnly(true);
            TBrokerListResponse rep = client.listPath(req);
            TBrokerOperationStatus opst = rep.getOpStatus();
            if (opst.getStatusCode() != TBrokerOperationStatusCode.OK) {
                Status status = new Status(Status.ErrCode.COMMON_ERROR, "failed to list remote path: " + remotePath + ". msg: " + opst.getMessage() + ", broker: " + BrokerUtil.printBroker(this.getName(), address));
                return status;
            }
            List fileStatus = rep.getFiles();
            for (TBrokerFileStatus tFile : fileStatus) {
                RemoteFile file = new RemoteFile(tFile.path, !tFile.isDir, tFile.size);
                result.add(file);
            }
            LOG.info("finished to list remote path {}. get files: {}", (Object)remotePath, result);
        }
        catch (TException e) {
            needReturn = false;
            Status status = new Status(Status.ErrCode.COMMON_ERROR, "failed to list remote path: " + remotePath + ". msg: " + e.getMessage() + ", broker: " + BrokerUtil.printBroker(this.getName(), address));
            return status;
        }
        finally {
            if (needReturn) {
                ClientPool.brokerPool.returnObject(address, client);
            } else {
                ClientPool.brokerPool.invalidateObject(address, client);
            }
        }
        return Status.OK;
    }

    @Override
    public Status makeDir(String remotePath) {
        return new Status(Status.ErrCode.COMMON_ERROR, "mkdir is not implemented.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status checkPathExist(String remotePath) {
        Pair<TPaloBrokerService.Client, TNetworkAddress> pair = this.getBroker();
        if (pair == null) {
            return new Status(Status.ErrCode.COMMON_ERROR, "failed to get broker client");
        }
        TPaloBrokerService.Client client = (TPaloBrokerService.Client)pair.first;
        TNetworkAddress address = (TNetworkAddress)pair.second;
        boolean needReturn = true;
        try {
            TBrokerCheckPathExistRequest req = new TBrokerCheckPathExistRequest(TBrokerVersion.VERSION_ONE, remotePath, this.getProperties());
            TBrokerCheckPathExistResponse rep = client.checkPathExist(req);
            TBrokerOperationStatus opst = rep.getOpStatus();
            if (opst.getStatusCode() != TBrokerOperationStatusCode.OK) {
                Status status = new Status(Status.ErrCode.COMMON_ERROR, "failed to check remote path exist: " + remotePath + ", broker: " + BrokerUtil.printBroker(this.getName(), address) + ". msg: " + opst.getMessage());
                return status;
            }
            if (!rep.isIsPathExist()) {
                Status status = new Status(Status.ErrCode.NOT_FOUND, "remote path does not exist: " + remotePath);
                return status;
            }
            Status status = Status.OK;
            return status;
        }
        catch (TException e) {
            needReturn = false;
            Status status = new Status(Status.ErrCode.COMMON_ERROR, "failed to check remote path exist: " + remotePath + ", broker: " + BrokerUtil.printBroker(this.getName(), address) + ". msg: " + e.getMessage());
            return status;
        }
        finally {
            if (needReturn) {
                ClientPool.brokerPool.returnObject(address, client);
            } else {
                ClientPool.brokerPool.invalidateObject(address, client);
            }
        }
    }

    @Override
    public StorageBackend.StorageType getStorageType() {
        return StorageBackend.StorageType.BROKER;
    }

    public Pair<TPaloBrokerService.Client, TNetworkAddress> getBroker() {
        TPaloBrokerService.Client client;
        FsBroker broker;
        Pair<Object, Object> result = new Pair<Object, Object>(null, null);
        try {
            String localIP = FrontendOptions.getLocalHostAddress();
            broker = Catalog.getCurrentCatalog().getBrokerMgr().getBroker(this.getName(), localIP);
        }
        catch (AnalysisException e) {
            LOG.warn("failed to get a broker address: " + e.getMessage());
            return null;
        }
        TNetworkAddress address = new TNetworkAddress(broker.ip, broker.port);
        try {
            client = ClientPool.brokerPool.borrowObject(address);
        }
        catch (Exception e) {
            LOG.warn("failed to get broker client: " + e.getMessage());
            return null;
        }
        result.first = client;
        result.second = address;
        LOG.info("get broker: {}", (Object)BrokerUtil.printBroker(this.getName(), address));
        return result;
    }

    private Status openWriter(TPaloBrokerService.Client client, TNetworkAddress address, String remoteFile, TBrokerFD fd) {
        try {
            TBrokerOpenWriterRequest req = new TBrokerOpenWriterRequest(TBrokerVersion.VERSION_ONE, remoteFile, TBrokerOpenMode.APPEND, BrokerStorage.clientId(), this.getProperties());
            TBrokerOpenWriterResponse rep = client.openWriter(req);
            TBrokerOperationStatus opst = rep.getOpStatus();
            if (opst.getStatusCode() != TBrokerOperationStatusCode.OK) {
                return new Status(Status.ErrCode.COMMON_ERROR, "failed to open writer on broker " + BrokerUtil.printBroker(this.getName(), address) + " for file: " + remoteFile + ". msg: " + opst.getMessage());
            }
            fd.setHigh(rep.getFd().getHigh());
            fd.setLow(rep.getFd().getLow());
            LOG.info("finished to open writer. fd: {}. directly upload to remote path {}.", (Object)fd, (Object)remoteFile);
        }
        catch (TException e) {
            return new Status(Status.ErrCode.BAD_CONNECTION, "failed to open writer on broker " + BrokerUtil.printBroker(this.getName(), address) + ", err: " + e.getMessage());
        }
        return Status.OK;
    }

    private Status closeWriter(TPaloBrokerService.Client client, TNetworkAddress address, TBrokerFD fd) {
        try {
            TBrokerCloseWriterRequest req = new TBrokerCloseWriterRequest(TBrokerVersion.VERSION_ONE, fd);
            TBrokerOperationStatus st = client.closeWriter(req);
            if (st.getStatusCode() != TBrokerOperationStatusCode.OK) {
                return new Status(Status.ErrCode.COMMON_ERROR, "failed to close writer on broker " + BrokerUtil.printBroker(this.getName(), address) + " for fd: " + fd);
            }
            LOG.info("finished to close writer. fd: {}.", (Object)fd);
        }
        catch (TException e) {
            return new Status(Status.ErrCode.BAD_CONNECTION, "failed to close writer on broker " + BrokerUtil.printBroker(this.getName(), address) + ", fd " + fd + ", msg: " + e.getMessage());
        }
        return Status.OK;
    }

    private Status closeReader(TPaloBrokerService.Client client, TNetworkAddress address, TBrokerFD fd) {
        try {
            TBrokerCloseReaderRequest req = new TBrokerCloseReaderRequest(TBrokerVersion.VERSION_ONE, fd);
            TBrokerOperationStatus st = client.closeReader(req);
            if (st.getStatusCode() != TBrokerOperationStatusCode.OK) {
                return new Status(Status.ErrCode.COMMON_ERROR, "failed to close reader on broker " + BrokerUtil.printBroker(this.getName(), address) + " for fd: " + fd);
            }
            LOG.info("finished to close reader. fd: {}.", (Object)fd);
        }
        catch (TException e) {
            return new Status(Status.ErrCode.BAD_CONNECTION, "failed to close reader on broker " + BrokerUtil.printBroker(this.getName(), address) + ", fd " + fd + ", msg: " + e.getMessage());
        }
        return Status.OK;
    }
}

