/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.backup;

import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.StorageBackend;
import org.apache.doris.backup.BrokerStorage;
import org.apache.doris.backup.RemoteFile;
import org.apache.doris.backup.S3Storage;
import org.apache.doris.backup.Status;
import org.apache.doris.common.Config;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.service.FrontendOptions;

public abstract class BlobStorage
implements Writable {
    public static final String STORAGE_TYPE = "_DORIS_STORAGE_TYPE_";
    private Map<String, String> properties = Maps.newHashMap();
    private String name;
    private StorageBackend.StorageType type;
    private String location;

    public static String clientId() {
        return FrontendOptions.getLocalHostAddress() + ":" + Config.edit_log_port;
    }

    public static BlobStorage create(String name, StorageBackend.StorageType type, Map<String, String> properties) {
        if (type == StorageBackend.StorageType.S3) {
            return new S3Storage(properties);
        }
        if (type == StorageBackend.StorageType.BROKER) {
            return new BrokerStorage(name, properties);
        }
        throw new UnsupportedOperationException(type.toString() + "backend is not implemented");
    }

    public static BlobStorage read(DataInput in) throws IOException {
        String name = Text.readString((DataInput)in);
        HashMap properties = Maps.newHashMap();
        StorageBackend.StorageType type = StorageBackend.StorageType.BROKER;
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String key = Text.readString((DataInput)in);
            String value = Text.readString((DataInput)in);
            properties.put(key, value);
        }
        if (properties.containsKey(STORAGE_TYPE)) {
            type = StorageBackend.StorageType.valueOf((String)properties.get(STORAGE_TYPE));
            properties.remove(STORAGE_TYPE);
        }
        return BlobStorage.create(name, type, properties);
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public StorageBackend.StorageType getType() {
        return this.type;
    }

    public void setType(StorageBackend.StorageType type) {
        this.type = type;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public abstract Status downloadWithFileSize(String var1, String var2, long var3);

    public abstract Status directUpload(String var1, String var2);

    public abstract Status upload(String var1, String var2);

    public abstract Status rename(String var1, String var2);

    public abstract Status delete(String var1);

    public abstract Status list(String var1, List<RemoteFile> var2);

    public abstract Status makeDir(String var1);

    public abstract Status checkPathExist(String var1);

    public abstract StorageBackend.StorageType getStorageType();

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.name);
        this.properties.put(STORAGE_TYPE, this.type.name());
        out.writeInt(this.getProperties().size());
        for (Map.Entry<String, String> entry : this.getProperties().entrySet()) {
            Text.writeString((DataOutput)out, (String)entry.getKey());
            Text.writeString((DataOutput)out, (String)entry.getValue());
        }
    }
}

