/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.backup;

import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.doris.catalog.Resource;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.io.Writable;
import org.apache.doris.meta.MetaContext;

public class BackupMeta
implements Writable {
    private Map<String, Table> tblNameMap = Maps.newHashMap();
    private Map<Long, Table> tblIdMap = Maps.newHashMap();
    private Map<String, Resource> resourceNameMap = Maps.newHashMap();

    private BackupMeta() {
    }

    public BackupMeta(List<Table> tables, List<Resource> resources) {
        for (Table table : tables) {
            this.tblNameMap.put(table.getName(), table);
            this.tblIdMap.put(table.getId(), table);
        }
        for (Resource resource : resources) {
            this.resourceNameMap.put(resource.getName(), resource);
        }
    }

    public Map<String, Table> getTables() {
        return this.tblNameMap;
    }

    public Map<String, Resource> getResourceNameMap() {
        return this.resourceNameMap;
    }

    public Table getTable(String tblName) {
        return this.tblNameMap.get(tblName);
    }

    public Resource getResource(String resourceName) {
        return this.resourceNameMap.get(resourceName);
    }

    public Table getTable(Long tblId) {
        return this.tblIdMap.get(tblId);
    }

    public static BackupMeta fromFile(String filePath, int metaVersion) throws IOException {
        File file = new File(filePath);
        MetaContext metaContext = new MetaContext();
        metaContext.setMetaVersion(metaVersion);
        metaContext.setThreadLocalInfo();
        try {
            BackupMeta backupMeta;
            try (DataInputStream dis = new DataInputStream(new FileInputStream(file));){
                BackupMeta backupMeta2;
                backupMeta = backupMeta2 = BackupMeta.read(dis);
            }
            return backupMeta;
        }
        finally {
            MetaContext.remove();
        }
    }

    public void writeToFile(File metaInfoFile) throws IOException {
        try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(metaInfoFile));){
            this.write(dos);
            dos.flush();
        }
    }

    public boolean compatibleWith(BackupMeta other) {
        return false;
    }

    public static BackupMeta read(DataInput in) throws IOException {
        BackupMeta backupMeta = new BackupMeta();
        backupMeta.readFields(in);
        return backupMeta;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.tblNameMap.size());
        for (Table table : this.tblNameMap.values()) {
            table.write(out);
        }
        out.writeInt(this.resourceNameMap.size());
        for (Resource resource : this.resourceNameMap.values()) {
            resource.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int i;
        int size = in.readInt();
        for (i = 0; i < size; ++i) {
            Table tbl = Table.read(in);
            this.tblNameMap.put(tbl.getName(), tbl);
            this.tblIdMap.put(tbl.getId(), tbl);
        }
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            Resource resource = Resource.read(in);
            this.resourceNameMap.put(resource.getName(), resource);
        }
    }
}

