/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.backup;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.doris.analysis.BackupStmt;
import org.apache.doris.analysis.PartitionNames;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.backup.BackupMeta;
import org.apache.doris.backup.RestoreFileMapping;
import org.apache.doris.backup.SnapshotInfo;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.OdbcCatalogResource;
import org.apache.doris.catalog.OdbcTable;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.Resource;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.catalog.View;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackupJobInfo
implements Writable {
    private static final Logger LOG = LogManager.getLogger(BackupJobInfo.class);
    @SerializedName(value="name")
    public String name;
    @SerializedName(value="database")
    public String dbName;
    @SerializedName(value="id")
    public long dbId;
    @SerializedName(value="backup_time")
    public long backupTime;
    @SerializedName(value="content")
    public BackupStmt.BackupContent content;
    @SerializedName(value="backup_objects")
    public Map<String, BackupOlapTableInfo> backupOlapTableObjects = Maps.newHashMap();
    @SerializedName(value="new_backup_objects")
    public NewBackupObjects newBackupObjects = new NewBackupObjects();
    public boolean success;
    @SerializedName(value="backup_result")
    public String successJson = "succeed";
    @SerializedName(value="meta_version")
    public int metaVersion;
    public Map<String, String> tblAlias = Maps.newHashMap();

    public void initBackupJobInfoAfterDeserialize() {
        this.success = this.successJson.equals("succeed");
        if (this.metaVersion == 0) {
            this.metaVersion = FeConstants.meta_version;
        }
        for (BackupOlapTableInfo backupOlapTableInfo : this.backupOlapTableObjects.values()) {
            for (BackupPartitionInfo backupPartitionInfo : backupOlapTableInfo.partitions.values()) {
                for (BackupIndexInfo backupIndexInfo : backupPartitionInfo.indexes.values()) {
                    List sortedTabletIds = backupIndexInfo.getSortedTabletIds();
                    for (Long tabletId : sortedTabletIds) {
                        List<String> files = backupIndexInfo.getTabletFiles(tabletId);
                        if (files == null) continue;
                        BackupTabletInfo backupTabletInfo = new BackupTabletInfo(tabletId, files);
                        backupIndexInfo.sortedTabletInfoList.add(backupTabletInfo);
                    }
                }
            }
        }
    }

    public Table.TableType getTypeByTblName(String tblName) {
        if (this.backupOlapTableObjects.containsKey(tblName)) {
            return Table.TableType.OLAP;
        }
        for (BackupViewInfo backupViewInfo : this.newBackupObjects.views) {
            if (!backupViewInfo.name.equals(tblName)) continue;
            return Table.TableType.VIEW;
        }
        for (BackupOdbcTableInfo backupOdbcTableInfo : this.newBackupObjects.odbcTables) {
            if (!backupOdbcTableInfo.dorisTableName.equals(tblName)) continue;
            return Table.TableType.ODBC;
        }
        return null;
    }

    public BackupOlapTableInfo getOlapTableInfo(String tblName) {
        return this.backupOlapTableObjects.get(tblName);
    }

    public void removeTable(TableRef tableRef, Table.TableType tableType) {
        switch (tableType) {
            case OLAP: {
                this.removeOlapTable(tableRef);
                break;
            }
            case VIEW: {
                this.removeView(tableRef);
                break;
            }
            case ODBC: {
                this.removeOdbcTable(tableRef);
                break;
            }
        }
    }

    public void removeOlapTable(TableRef tableRef) {
        String tblName = tableRef.getName().getTbl();
        BackupOlapTableInfo tblInfo = this.backupOlapTableObjects.get(tblName);
        if (tblInfo == null) {
            LOG.info("Ignore error: exclude table " + tblName + " does not exist in snapshot " + this.name);
            return;
        }
        PartitionNames partitionNames = tableRef.getPartitionNames();
        if (partitionNames == null) {
            this.backupOlapTableObjects.remove(tblInfo);
            return;
        }
        for (String partName : partitionNames.getPartitionNames()) {
            if (tblInfo.containsPart(partName)) {
                tblInfo.partitions.remove(partName);
                continue;
            }
            LOG.info("Ignore error: exclude partition " + partName + " of table " + tblName + " does not exist in snapshot");
        }
    }

    public void removeView(TableRef tableRef) {
        ListIterator<BackupViewInfo> iter = this.newBackupObjects.views.listIterator();
        while (iter.hasNext()) {
            if (!((BackupViewInfo)iter.next()).name.equals(tableRef.getName().getTbl())) continue;
            iter.remove();
            return;
        }
    }

    public void removeOdbcTable(TableRef tableRef) {
        ListIterator<BackupOdbcTableInfo> iter = this.newBackupObjects.odbcTables.listIterator();
        while (iter.hasNext()) {
            BackupOdbcTableInfo backupOdbcTableInfo = (BackupOdbcTableInfo)iter.next();
            if (!backupOdbcTableInfo.dorisTableName.equals(tableRef.getName().getTbl())) continue;
            if (backupOdbcTableInfo.resourceName != null) {
                ListIterator<BackupOdbcResourceInfo> resourceIter = this.newBackupObjects.odbcResources.listIterator();
                while (resourceIter.hasNext()) {
                    if (!((BackupOdbcResourceInfo)resourceIter.next()).name.equals(backupOdbcTableInfo.resourceName)) continue;
                    resourceIter.remove();
                }
            }
            iter.remove();
            return;
        }
    }

    public void retainOlapTables(Set<String> tblNames) {
        Iterator<Map.Entry<String, BackupOlapTableInfo>> iter = this.backupOlapTableObjects.entrySet().iterator();
        while (iter.hasNext()) {
            if (tblNames.contains(iter.next().getKey())) continue;
            iter.remove();
        }
    }

    public void retainView(Set<String> viewNames) {
        ListIterator<BackupViewInfo> iter = this.newBackupObjects.views.listIterator();
        while (iter.hasNext()) {
            if (viewNames.contains(((BackupViewInfo)iter.next()).name)) continue;
            iter.remove();
        }
    }

    public void retainOdbcTables(Set<String> odbcTableNames) {
        ListIterator<BackupOdbcTableInfo> odbcIter = this.newBackupObjects.odbcTables.listIterator();
        HashSet removedOdbcResourceNames = Sets.newHashSet();
        while (odbcIter.hasNext()) {
            BackupOdbcTableInfo backupOdbcTableInfo = (BackupOdbcTableInfo)odbcIter.next();
            if (odbcTableNames.contains(backupOdbcTableInfo.dorisTableName)) continue;
            removedOdbcResourceNames.add(backupOdbcTableInfo.resourceName);
            odbcIter.remove();
        }
        ListIterator<BackupOdbcResourceInfo> resourceIter = this.newBackupObjects.odbcResources.listIterator();
        while (resourceIter.hasNext()) {
            if (!removedOdbcResourceNames.contains(((BackupOdbcResourceInfo)resourceIter.next()).name)) continue;
            resourceIter.remove();
        }
    }

    public void setAlias(String orig, String alias) {
        this.tblAlias.put(orig, alias);
    }

    public String getAliasByOriginNameIfSet(String orig) {
        return this.tblAlias.containsKey(orig) ? this.tblAlias.get(orig) : orig;
    }

    public String getOrginNameByAlias(String alias) {
        for (Map.Entry<String, String> entry : this.tblAlias.entrySet()) {
            if (!entry.getValue().equals(alias)) continue;
            return entry.getKey();
        }
        return alias;
    }

    public String getFilePath(String db, String tbl, String part, String idx, long tabletId) {
        if (!db.equalsIgnoreCase(this.dbName)) {
            LOG.debug("db name does not equal: {}-{}", (Object)this.dbName, (Object)db);
            return null;
        }
        BackupOlapTableInfo tblInfo = this.backupOlapTableObjects.get(tbl);
        if (tblInfo == null) {
            LOG.debug("tbl {} does not exist", (Object)tbl);
            return null;
        }
        BackupPartitionInfo partInfo = tblInfo.getPartInfo(part);
        if (partInfo == null) {
            LOG.debug("part {} does not exist", (Object)part);
            return null;
        }
        BackupIndexInfo idxInfo = partInfo.getIdx(idx);
        if (idxInfo == null) {
            LOG.debug("idx {} does not exist", (Object)idx);
            return null;
        }
        ArrayList pathSeg = Lists.newArrayList();
        pathSeg.add("__db_" + this.dbId);
        pathSeg.add("__tbl_" + tblInfo.id);
        pathSeg.add("__part_" + partInfo.id);
        pathSeg.add("__idx_" + idxInfo.id);
        pathSeg.add("__" + tabletId);
        return Joiner.on((String)"/").join((Iterable)pathSeg);
    }

    public String getFilePath(RestoreFileMapping.IdChain ids) {
        ArrayList pathSeg = Lists.newArrayList();
        pathSeg.add("__db_" + this.dbId);
        pathSeg.add("__tbl_" + ids.getTblId());
        pathSeg.add("__part_" + ids.getPartId());
        pathSeg.add("__idx_" + ids.getIdxId());
        pathSeg.add("__" + ids.getTabletId());
        return Joiner.on((String)"/").join((Iterable)pathSeg);
    }

    public static BackupJobInfo fromCatalog(long backupTime, String label, String dbName, long dbId, BackupStmt.BackupContent content, BackupMeta backupMeta, Map<Long, SnapshotInfo> snapshotInfos) {
        BackupJobInfo jobInfo = new BackupJobInfo();
        jobInfo.backupTime = backupTime;
        jobInfo.name = label;
        jobInfo.dbName = dbName;
        jobInfo.dbId = dbId;
        jobInfo.metaVersion = FeConstants.meta_version;
        jobInfo.content = content;
        Collection<Table> tbls = backupMeta.getTables().values();
        for (Table tbl : tbls) {
            if (tbl instanceof OlapTable) {
                OlapTable olapTbl = (OlapTable)tbl;
                BackupOlapTableInfo tableInfo = new BackupOlapTableInfo();
                tableInfo.id = tbl.getId();
                jobInfo.backupOlapTableObjects.put(tbl.getName(), tableInfo);
                for (Partition partition : olapTbl.getPartitions()) {
                    BackupPartitionInfo partitionInfo = new BackupPartitionInfo();
                    partitionInfo.id = partition.getId();
                    partitionInfo.version = partition.getVisibleVersion();
                    tableInfo.partitions.put(partition.getName(), partitionInfo);
                    for (MaterializedIndex index : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.VISIBLE)) {
                        BackupIndexInfo idxInfo = new BackupIndexInfo();
                        idxInfo.id = index.getId();
                        idxInfo.schemaHash = olapTbl.getSchemaHashByIndexId(index.getId());
                        partitionInfo.indexes.put(olapTbl.getIndexNameById(index.getId()), idxInfo);
                        if (content == BackupStmt.BackupContent.METADATA_ONLY) {
                            for (Tablet tablet : index.getTablets()) {
                                idxInfo.tablets.put(tablet.getId(), Lists.newArrayList());
                            }
                        } else {
                            for (Tablet tablet : index.getTablets()) {
                                idxInfo.tablets.put(tablet.getId(), Lists.newArrayList(snapshotInfos.get(tablet.getId()).getFiles()));
                            }
                        }
                        idxInfo.tabletsOrder.addAll(index.getTabletIdsInOrder());
                    }
                }
                continue;
            }
            if (tbl instanceof View) {
                View view = (View)tbl;
                BackupViewInfo backupViewInfo = new BackupViewInfo();
                backupViewInfo.id = view.getId();
                backupViewInfo.name = view.getName();
                jobInfo.newBackupObjects.views.add(backupViewInfo);
                continue;
            }
            if (!(tbl instanceof OdbcTable)) continue;
            OdbcTable odbcTable = (OdbcTable)tbl;
            BackupOdbcTableInfo backupOdbcTableInfo = new BackupOdbcTableInfo();
            backupOdbcTableInfo.id = odbcTable.getId();
            backupOdbcTableInfo.dorisTableName = odbcTable.getName();
            backupOdbcTableInfo.linkedOdbcDatabaseName = odbcTable.getOdbcDatabaseName();
            backupOdbcTableInfo.linkedOdbcTableName = odbcTable.getOdbcTableName();
            if (odbcTable.getOdbcCatalogResourceName() != null) {
                backupOdbcTableInfo.resourceName = odbcTable.getOdbcCatalogResourceName();
            } else {
                backupOdbcTableInfo.host = odbcTable.getHost();
                backupOdbcTableInfo.port = odbcTable.getPort();
                backupOdbcTableInfo.user = odbcTable.getUserName();
                backupOdbcTableInfo.driver = odbcTable.getOdbcDriver();
                backupOdbcTableInfo.odbcType = odbcTable.getOdbcTableTypeName();
            }
            jobInfo.newBackupObjects.odbcTables.add(backupOdbcTableInfo);
        }
        Collection<Resource> resources = backupMeta.getResourceNameMap().values();
        for (Resource resource : resources) {
            if (!(resource instanceof OdbcCatalogResource)) continue;
            OdbcCatalogResource odbcCatalogResource = (OdbcCatalogResource)resource;
            BackupOdbcResourceInfo backupOdbcResourceInfo = new BackupOdbcResourceInfo();
            backupOdbcResourceInfo.name = odbcCatalogResource.getName();
            jobInfo.newBackupObjects.odbcResources.add(backupOdbcResourceInfo);
        }
        return jobInfo;
    }

    public static BackupJobInfo fromFile(String path) throws IOException {
        byte[] bytes = Files.readAllBytes(Paths.get(path, new String[0]));
        String json = new String(bytes, StandardCharsets.UTF_8);
        return BackupJobInfo.genFromJson(json);
    }

    private static BackupJobInfo genFromJson(String json) {
        BackupJobInfo jobInfo = (BackupJobInfo)GsonUtils.GSON.fromJson(json, BackupJobInfo.class);
        jobInfo.initBackupJobInfoAfterDeserialize();
        return jobInfo;
    }

    public void writeToFile(File jobInfoFile) throws FileNotFoundException {
        try (PrintWriter printWriter = new PrintWriter(jobInfoFile);){
            printWriter.print(this.toJson(false));
            printWriter.flush();
        }
    }

    public String getBrief() {
        BriefBackupJobInfo briefBackupJobInfo = BriefBackupJobInfo.fromBackupJobInfo(this);
        Gson gson = GsonUtils.GSON_PRETTY_PRINTING;
        return gson.toJson((Object)briefBackupJobInfo);
    }

    public String toJson(boolean prettyPrinting) {
        Gson gson = prettyPrinting ? GsonUtils.GSON_PRETTY_PRINTING : GsonUtils.GSON;
        return gson.toJson((Object)this);
    }

    public String getInfo() {
        return this.getBrief();
    }

    public static BackupJobInfo read(DataInput in) throws IOException {
        return BackupJobInfo.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.toJson(false));
        out.writeInt(this.tblAlias.size());
        for (Map.Entry<String, String> entry : this.tblAlias.entrySet()) {
            Text.writeString((DataOutput)out, (String)entry.getKey());
            Text.writeString((DataOutput)out, (String)entry.getValue());
        }
    }

    public static BackupJobInfo readFields(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        BackupJobInfo backupJobInfo = BackupJobInfo.genFromJson(json);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String tbl = Text.readString((DataInput)in);
            String alias = Text.readString((DataInput)in);
            backupJobInfo.tblAlias.put(tbl, alias);
        }
        return backupJobInfo;
    }

    public String toString() {
        return this.toJson(true);
    }

    public static class BackupOdbcResourceInfo {
        @SerializedName(value="name")
        public String name;
    }

    public static class BackupOdbcTableInfo {
        @SerializedName(value="id")
        public long id;
        @SerializedName(value="doris_table_name")
        public String dorisTableName;
        @SerializedName(value="linked_odbc_database_name")
        public String linkedOdbcDatabaseName;
        @SerializedName(value="linked_odbc_table_name")
        public String linkedOdbcTableName;
        @SerializedName(value="resource_name")
        public String resourceName;
        @SerializedName(value="host")
        public String host;
        @SerializedName(value="port")
        public String port;
        @SerializedName(value="user")
        public String user;
        @SerializedName(value="driver")
        public String driver;
        @SerializedName(value="odbc_type")
        public String odbcType;
    }

    public static class BackupViewInfo {
        @SerializedName(value="id")
        public long id;
        @SerializedName(value="name")
        public String name;
    }

    public static class BackupTabletInfo {
        @SerializedName(value="id")
        public long id;
        @SerializedName(value="files")
        public List<String> files;

        public BackupTabletInfo(long id, List<String> files) {
            this.id = id;
            this.files = files;
        }
    }

    public static class BackupIndexInfo {
        @SerializedName(value="id")
        public long id;
        @SerializedName(value="schema_hash")
        public int schemaHash;
        @SerializedName(value="tablets")
        public Map<Long, List<String>> tablets = Maps.newHashMap();
        @SerializedName(value="tablets_order")
        public List<Long> tabletsOrder = Lists.newArrayList();
        public List<BackupTabletInfo> sortedTabletInfoList = Lists.newArrayList();

        public List<String> getTabletFiles(long tabletId) {
            return this.tablets.get(tabletId);
        }

        private List<Long> getSortedTabletIds() {
            if (this.tabletsOrder == null || this.tabletsOrder.isEmpty()) {
                ArrayList tmpList = Lists.newArrayList(this.tablets.keySet());
                tmpList.sort((o1, o2) -> Long.valueOf(o1).compareTo((long)o2));
                return tmpList;
            }
            return this.tabletsOrder;
        }
    }

    public static class BackupPartitionInfo {
        @SerializedName(value="id")
        public long id;
        @SerializedName(value="version")
        public long version;
        @SerializedName(value="indexes")
        public Map<String, BackupIndexInfo> indexes = Maps.newHashMap();

        public BackupIndexInfo getIdx(String idxName) {
            return this.indexes.get(idxName);
        }
    }

    public static class BackupOlapTableInfo {
        @SerializedName(value="id")
        public long id;
        @SerializedName(value="partitions")
        public Map<String, BackupPartitionInfo> partitions = Maps.newHashMap();

        public boolean containsPart(String partName) {
            return this.partitions.containsKey(partName);
        }

        public BackupPartitionInfo getPartInfo(String partName) {
            return this.partitions.get(partName);
        }

        public void retainPartitions(Collection<String> partNames) {
            if (partNames == null || partNames.isEmpty()) {
                return;
            }
            Iterator<Map.Entry<String, BackupPartitionInfo>> iter = this.partitions.entrySet().iterator();
            while (iter.hasNext()) {
                if (partNames.contains(iter.next().getKey())) continue;
                iter.remove();
            }
        }
    }

    public static class NewBackupObjects {
        @SerializedName(value="views")
        public List<BackupViewInfo> views = Lists.newArrayList();
        @SerializedName(value="odbc_tables")
        public List<BackupOdbcTableInfo> odbcTables = Lists.newArrayList();
        @SerializedName(value="odbc_resources")
        public List<BackupOdbcResourceInfo> odbcResources = Lists.newArrayList();
    }

    public static class BriefBackupOlapTable {
        @SerializedName(value="name")
        public String name;
        @SerializedName(value="partition_names")
        public List<String> partitionNames;
    }

    public static class BriefBackupJobInfo {
        @SerializedName(value="name")
        public String name;
        @SerializedName(value="database")
        public String database;
        @SerializedName(value="backup_time")
        public long backupTime;
        @SerializedName(value="content")
        public BackupStmt.BackupContent content;
        @SerializedName(value="olap_table_list")
        public List<BriefBackupOlapTable> olapTableList = Lists.newArrayList();
        @SerializedName(value="view_list")
        public List<BackupViewInfo> viewList = Lists.newArrayList();
        @SerializedName(value="odbc_table_list")
        public List<BackupOdbcTableInfo> odbcTableList = Lists.newArrayList();
        @SerializedName(value="odbc_resource_list")
        public List<BackupOdbcResourceInfo> odbcResourceList = Lists.newArrayList();

        public static BriefBackupJobInfo fromBackupJobInfo(BackupJobInfo backupJobInfo) {
            BriefBackupJobInfo briefBackupJobInfo = new BriefBackupJobInfo();
            briefBackupJobInfo.name = backupJobInfo.name;
            briefBackupJobInfo.database = backupJobInfo.dbName;
            briefBackupJobInfo.backupTime = backupJobInfo.backupTime;
            briefBackupJobInfo.content = backupJobInfo.content;
            for (Map.Entry<String, BackupOlapTableInfo> olapTableEntry : backupJobInfo.backupOlapTableObjects.entrySet()) {
                BriefBackupOlapTable briefBackupOlapTable = new BriefBackupOlapTable();
                briefBackupOlapTable.name = olapTableEntry.getKey();
                briefBackupOlapTable.partitionNames = Lists.newArrayList(olapTableEntry.getValue().partitions.keySet());
                briefBackupJobInfo.olapTableList.add(briefBackupOlapTable);
            }
            briefBackupJobInfo.viewList = backupJobInfo.newBackupObjects.views;
            briefBackupJobInfo.odbcTableList = backupJobInfo.newBackupObjects.odbcTables;
            briefBackupJobInfo.odbcResourceList = backupJobInfo.newBackupObjects.odbcResources;
            return briefBackupJobInfo;
        }
    }
}

