/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.backup;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.doris.analysis.BackupStmt;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.backup.AbstractJob;
import org.apache.doris.backup.BackupHandler;
import org.apache.doris.backup.BackupJobInfo;
import org.apache.doris.backup.BackupMeta;
import org.apache.doris.backup.Repository;
import org.apache.doris.backup.SnapshotInfo;
import org.apache.doris.backup.Status;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.FsBroker;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.OdbcTable;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.Resource;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.catalog.View;
import org.apache.doris.common.Pair;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.task.AgentBatchTask;
import org.apache.doris.task.AgentTask;
import org.apache.doris.task.AgentTaskExecutor;
import org.apache.doris.task.AgentTaskQueue;
import org.apache.doris.task.ReleaseSnapshotTask;
import org.apache.doris.task.SnapshotTask;
import org.apache.doris.task.UploadTask;
import org.apache.doris.thrift.TFinishTaskRequest;
import org.apache.doris.thrift.TStatusCode;
import org.apache.doris.thrift.TTaskType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackupJob
extends AbstractJob {
    private static final Logger LOG = LogManager.getLogger(BackupJob.class);
    private List<TableRef> tableRefs = Lists.newArrayList();
    private BackupJobState state;
    private long snapshotFinishedTime = -1L;
    private long snapshotUploadFinishedTime = -1L;
    private Map<Long, Long> unfinishedTaskIds = Maps.newConcurrentMap();
    private Map<Long, SnapshotInfo> snapshotInfos = Maps.newConcurrentMap();
    private BackupMeta backupMeta;
    private BackupJobInfo jobInfo;
    private Path localJobDirPath = null;
    private String localMetaInfoFilePath = null;
    private String localJobInfoFilePath = null;
    private Map<String, String> properties = Maps.newHashMap();

    public BackupJob() {
        super(AbstractJob.JobType.BACKUP);
    }

    public BackupJob(String label, long dbId, String dbName, List<TableRef> tableRefs, long timeoutMs, BackupStmt.BackupContent content, Catalog catalog, long repoId) {
        super(AbstractJob.JobType.BACKUP, label, dbId, dbName, timeoutMs, catalog, repoId);
        this.tableRefs = tableRefs;
        this.state = BackupJobState.PENDING;
        this.properties.put("content", content.name());
    }

    public BackupJobState getState() {
        return this.state;
    }

    public BackupMeta getBackupMeta() {
        return this.backupMeta;
    }

    public BackupJobInfo getJobInfo() {
        return this.jobInfo;
    }

    public String getLocalJobInfoFilePath() {
        return this.localJobInfoFilePath;
    }

    public String getLocalMetaInfoFilePath() {
        return this.localMetaInfoFilePath;
    }

    public BackupStmt.BackupContent getContent() {
        if (this.properties.containsKey("content")) {
            return BackupStmt.BackupContent.valueOf(this.properties.get("content").toUpperCase());
        }
        return BackupStmt.BackupContent.ALL;
    }

    public synchronized boolean finishTabletSnapshotTask(SnapshotTask task, TFinishTaskRequest request) {
        Preconditions.checkState((task.getJobId() == this.jobId ? 1 : 0) != 0);
        if (request.getTaskStatus().getStatusCode() != TStatusCode.OK) {
            this.taskErrMsg.put(task.getSignature(), Joiner.on((String)",").join((Iterable)request.getTaskStatus().getErrorMsgs()));
            if (request.getTaskStatus().getStatusCode() == TStatusCode.OLAP_ERR_VERSION_ALREADY_MERGED) {
                this.status = new Status(Status.ErrCode.OLAP_VERSION_ALREADY_MERGED, "make snapshot failed, version already merged");
                this.cancelInternal();
            }
            return false;
        }
        Preconditions.checkState((boolean)request.isSetSnapshotPath());
        Preconditions.checkState((boolean)request.isSetSnapshotFiles());
        SnapshotInfo info = new SnapshotInfo(task.getDbId(), task.getTableId(), task.getPartitionId(), task.getIndexId(), task.getTabletId(), task.getBackendId(), task.getSchemaHash(), request.getSnapshotPath(), request.getSnapshotFiles());
        this.snapshotInfos.put(task.getTabletId(), info);
        this.taskProgress.remove(task.getTabletId());
        Long oldValue = this.unfinishedTaskIds.remove(task.getTabletId());
        this.taskErrMsg.remove(task.getTabletId());
        LOG.debug("get finished snapshot info: {}, unfinished tasks num: {}, remove result: {}. {}", (Object)info, (Object)this.unfinishedTaskIds.size(), (Object)(oldValue != null ? 1 : 0), (Object)this);
        return oldValue != null;
    }

    public synchronized boolean finishSnapshotUploadTask(UploadTask task, TFinishTaskRequest request) {
        Preconditions.checkState((task.getJobId() == this.jobId ? 1 : 0) != 0);
        if (request.getTaskStatus().getStatusCode() != TStatusCode.OK) {
            this.taskErrMsg.put(task.getSignature(), Joiner.on((String)",").join((Iterable)request.getTaskStatus().getErrorMsgs()));
            return false;
        }
        Preconditions.checkState((boolean)request.isSetTabletFiles());
        Map tabletFileMap = request.getTabletFiles();
        if (tabletFileMap.isEmpty()) {
            LOG.warn("upload snapshot files failed because nothing is uploaded. be: {}. {}", (Object)task.getBackendId(), (Object)this);
            return false;
        }
        HashMap newTabletFileMap = Maps.newHashMap();
        for (Map.Entry entry : tabletFileMap.entrySet()) {
            List files = ((List)entry.getValue()).stream().map(name -> (String)Repository.decodeFileNameWithChecksum((String)name).first).collect(Collectors.toList());
            newTabletFileMap.put((Long)entry.getKey(), files);
        }
        Iterator iterator = newTabletFileMap.keySet().iterator();
        while (iterator.hasNext()) {
            long tabletId = (Long)((Object)iterator.next());
            SnapshotInfo info = this.snapshotInfos.get(tabletId);
            List<String> tabletFiles = info.getFiles();
            List uploadedFiles = (List)newTabletFileMap.get(tabletId);
            if (tabletFiles.size() != uploadedFiles.size()) {
                LOG.warn("upload snapshot files failed because file num is wrong. expect: {}, actual:{}, tablet: {}, be: {}. {}", (Object)tabletFiles.size(), (Object)uploadedFiles.size(), (Object)tabletId, (Object)task.getBackendId(), (Object)this);
                return false;
            }
            if (!Collections2.filter(tabletFiles, (Predicate)Predicates.not((Predicate)Predicates.in((Collection)uploadedFiles))).isEmpty()) {
                LOG.warn("upload snapshot files failed because file is different. expect: [{}], actual: [{}], tablet: {}, be: {}. {}", tabletFiles, (Object)uploadedFiles, (Object)tabletId, (Object)task.getBackendId(), (Object)this);
                return false;
            }
            info.setFiles((List)tabletFileMap.get(tabletId));
        }
        this.taskProgress.remove(task.getSignature());
        Long oldValue = this.unfinishedTaskIds.remove(task.getSignature());
        this.taskErrMsg.remove(task.getSignature());
        LOG.debug("get finished upload snapshot task, unfinished tasks num: {}, remove result: {}. {}", (Object)this.unfinishedTaskIds.size(), (Object)(oldValue != null ? 1 : 0), (Object)this);
        return oldValue != null;
    }

    @Override
    public synchronized void replayRun() {
    }

    @Override
    public synchronized void replayCancel() {
    }

    @Override
    public boolean isPending() {
        return this.state == BackupJobState.PENDING;
    }

    @Override
    public boolean isCancelled() {
        return this.state == BackupJobState.CANCELLED;
    }

    @Override
    public synchronized void run() {
        if (this.state == BackupJobState.FINISHED || this.state == BackupJobState.CANCELLED) {
            return;
        }
        if (System.currentTimeMillis() - this.createTime > this.timeoutMs) {
            this.status = new Status(Status.ErrCode.TIMEOUT, "");
            this.cancelInternal();
            return;
        }
        if (this.repo == null) {
            this.repo = this.catalog.getBackupHandler().getRepoMgr().getRepo(this.repoId);
            if (this.repo == null) {
                this.status = new Status(Status.ErrCode.COMMON_ERROR, "failed to get repository: " + this.repoId);
                this.cancelInternal();
                return;
            }
        }
        LOG.debug("run backup job: {}", (Object)this);
        switch (this.state) {
            case PENDING: {
                this.prepareAndSendSnapshotTask();
                break;
            }
            case SNAPSHOTING: {
                this.waitingAllSnapshotsFinished();
                break;
            }
            case UPLOAD_SNAPSHOT: {
                this.uploadSnapshot();
                break;
            }
            case UPLOADING: {
                this.waitingAllUploadingFinished();
                break;
            }
            case SAVE_META: {
                this.saveMetaInfo();
                break;
            }
            case UPLOAD_INFO: {
                this.uploadMetaAndJobInfoFile();
                break;
            }
        }
        if (!this.status.ok() && this.state != BackupJobState.UPLOAD_INFO) {
            this.cancelInternal();
        }
    }

    @Override
    public synchronized Status cancel() {
        if (this.isDone()) {
            return new Status(Status.ErrCode.COMMON_ERROR, "Job with label " + this.label + " can not be cancelled. state: " + (Object)((Object)this.state));
        }
        this.status = new Status(Status.ErrCode.COMMON_ERROR, "user cancelled");
        this.cancelInternal();
        return Status.OK;
    }

    @Override
    public synchronized boolean isDone() {
        return this.state == BackupJobState.FINISHED || this.state == BackupJobState.CANCELLED;
    }

    private void prepareAndSendSnapshotTask() {
        Database db = this.catalog.getDbNullable(this.dbId);
        if (db == null) {
            this.status = new Status(Status.ErrCode.NOT_FOUND, "database " + this.dbId + " does not exist");
            return;
        }
        this.jobId = this.catalog.getNextId();
        this.unfinishedTaskIds.clear();
        this.taskProgress.clear();
        this.taskErrMsg.clear();
        AgentBatchTask batchTask = new AgentBatchTask();
        block5: for (TableRef tableRef : this.tableRefs) {
            String tblName = tableRef.getName().getTbl();
            Table tbl = db.getTableNullable(tblName);
            if (tbl == null) {
                this.status = new Status(Status.ErrCode.NOT_FOUND, "table " + tblName + " does not exist");
                return;
            }
            switch (tbl.getType()) {
                case OLAP: {
                    this.checkOlapTable((OlapTable)tbl, tableRef);
                    if (this.getContent() != BackupStmt.BackupContent.ALL) continue block5;
                    this.prepareSnapshotTaskForOlapTable((OlapTable)tbl, tableRef, batchTask);
                    break;
                }
                case VIEW: {
                    break;
                }
                case ODBC: {
                    OdbcTable odbcTable = (OdbcTable)tbl;
                    if (odbcTable.getOdbcCatalogResourceName() == null) continue block5;
                    String odbcResourceName = odbcTable.getOdbcCatalogResourceName();
                    Resource resource = Catalog.getCurrentCatalog().getResourceMgr().getResource(odbcResourceName);
                    if (resource != null) continue block5;
                    this.status = new Status(Status.ErrCode.NOT_FOUND, "resource " + odbcResourceName + " related to " + tblName + "does not exist.");
                    return;
                }
                default: {
                    this.status = new Status(Status.ErrCode.COMMON_ERROR, "backup job does not support this type of table " + tblName);
                    return;
                }
            }
        }
        this.prepareBackupMeta(db);
        for (AgentTask task : batchTask.getAllTasks()) {
            AgentTaskQueue.addTask(task);
        }
        AgentTaskExecutor.submit(batchTask);
        this.state = BackupJobState.SNAPSHOTING;
        LOG.info("finished to send snapshot tasks to backend. {}", (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOlapTable(OlapTable olapTable, TableRef backupTableRef) {
        block5: {
            olapTable.readLock();
            try {
                if (backupTableRef.getPartitionNames() == null) break block5;
                for (String partName : backupTableRef.getPartitionNames().getPartitionNames()) {
                    Partition partition = olapTable.getPartition(partName);
                    if (partition != null) continue;
                    this.status = new Status(Status.ErrCode.NOT_FOUND, "partition " + partName + " does not exist  in table" + backupTableRef.getName().getTbl());
                    return;
                }
            }
            finally {
                olapTable.readUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareSnapshotTaskForOlapTable(OlapTable olapTable, TableRef backupTableRef, AgentBatchTask batchTask) {
        olapTable.readLock();
        try {
            if (backupTableRef.getPartitionNames() != null) {
                for (String partName : backupTableRef.getPartitionNames().getPartitionNames()) {
                    Partition partition = olapTable.getPartition(partName);
                    if (partition != null) continue;
                    this.status = new Status(Status.ErrCode.NOT_FOUND, "partition " + partName + " does not exist  in table" + backupTableRef.getName().getTbl());
                    return;
                }
            }
            ArrayList partitions = Lists.newArrayList();
            if (backupTableRef.getPartitionNames() == null) {
                partitions.addAll(olapTable.getPartitions());
            } else {
                for (String partName : backupTableRef.getPartitionNames().getPartitionNames()) {
                    Partition partition = olapTable.getPartition(partName);
                    partitions.add(partition);
                }
            }
            for (Partition partition : partitions) {
                long visibleVersion = partition.getVisibleVersion();
                List<MaterializedIndex> indexes = partition.getMaterializedIndices(MaterializedIndex.IndexExtState.VISIBLE);
                for (MaterializedIndex index : indexes) {
                    int schemaHash = olapTable.getSchemaHashByIndexId(index.getId());
                    List<Tablet> tablets = index.getTablets();
                    for (Tablet tablet : tablets) {
                        Replica replica = this.chooseReplica(tablet, visibleVersion);
                        if (replica == null) {
                            this.status = new Status(Status.ErrCode.COMMON_ERROR, "failed to choose replica to make snapshot for tablet " + tablet.getId() + ". visible version: " + visibleVersion);
                            return;
                        }
                        SnapshotTask task = new SnapshotTask(null, replica.getBackendId(), tablet.getId(), this.jobId, this.dbId, olapTable.getId(), partition.getId(), index.getId(), tablet.getId(), visibleVersion, schemaHash, this.timeoutMs, false);
                        batchTask.addTask(task);
                        this.unfinishedTaskIds.put(tablet.getId(), replica.getBackendId());
                    }
                }
                LOG.info("snapshot for partition {}, version: {}", (Object)partition.getId(), (Object)visibleVersion);
            }
        }
        finally {
            olapTable.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareBackupMeta(Database db) {
        ArrayList copiedTables = Lists.newArrayList();
        ArrayList copiedResources = Lists.newArrayList();
        for (TableRef tableRef : this.tableRefs) {
            String tblName = tableRef.getName().getTbl();
            Table table = db.getTableNullable(tblName);
            table.readLock();
            try {
                if (table.getType() == Table.TableType.OLAP) {
                    OlapTable olapTable = (OlapTable)table;
                    List<String> reservedPartitions = tableRef.getPartitionNames() == null ? null : tableRef.getPartitionNames().getPartitionNames();
                    OlapTable copiedTbl = olapTable.selectiveCopy(reservedPartitions, MaterializedIndex.IndexExtState.VISIBLE, true);
                    if (copiedTbl == null) {
                        this.status = new Status(Status.ErrCode.COMMON_ERROR, "failed to copy table: " + tblName);
                        return;
                    }
                    this.removeUnsupportProperties(copiedTbl);
                    copiedTables.add(copiedTbl);
                    continue;
                }
                if (table.getType() == Table.TableType.VIEW) {
                    View view = (View)table;
                    View copiedView = view.clone();
                    if (copiedView == null) {
                        this.status = new Status(Status.ErrCode.COMMON_ERROR, "failed to copy view: " + tblName);
                        return;
                    }
                    copiedTables.add(copiedView);
                    continue;
                }
                if (table.getType() != Table.TableType.ODBC) continue;
                OdbcTable odbcTable = (OdbcTable)table;
                OdbcTable copiedOdbcTable = odbcTable.clone();
                if (copiedOdbcTable == null) {
                    this.status = new Status(Status.ErrCode.COMMON_ERROR, "failed to copy odbc table: " + tblName);
                    return;
                }
                copiedTables.add(copiedOdbcTable);
                if (copiedOdbcTable.getOdbcCatalogResourceName() == null) continue;
                Resource resource = Catalog.getCurrentCatalog().getResourceMgr().getResource(copiedOdbcTable.getOdbcCatalogResourceName());
                Resource copiedResource = resource.clone();
                if (copiedResource == null) {
                    this.status = new Status(Status.ErrCode.COMMON_ERROR, "failed to copy odbc resource: " + resource.getName());
                    return;
                }
                copiedResources.add(copiedResource);
            }
            finally {
                table.readUnlock();
            }
        }
        this.backupMeta = new BackupMeta(copiedTables, copiedResources);
    }

    private void removeUnsupportProperties(OlapTable tbl) {
        tbl.setColocateGroup(null);
    }

    private void waitingAllSnapshotsFinished() {
        if (this.unfinishedTaskIds.isEmpty()) {
            this.snapshotFinishedTime = System.currentTimeMillis();
            this.state = BackupJobState.UPLOAD_SNAPSHOT;
            this.catalog.getEditLog().logBackupJob(this);
            LOG.info("finished to make snapshots. {}", (Object)this);
            return;
        }
        LOG.info("waiting {} tablets to make snapshot. {}", (Object)this.unfinishedTaskIds.size(), (Object)this);
    }

    private void uploadSnapshot() {
        this.unfinishedTaskIds.clear();
        this.taskProgress.clear();
        this.taskErrMsg.clear();
        ArrayListMultimap beToSnapshots = ArrayListMultimap.create();
        for (SnapshotInfo info : this.snapshotInfos.values()) {
            beToSnapshots.put((Object)info.getBeId(), (Object)info);
        }
        AgentBatchTask batchTask = new AgentBatchTask();
        for (Long beId : beToSnapshots.keySet()) {
            List infos = beToSnapshots.get((Object)beId);
            int totalNum = infos.size();
            int batchNum = Math.min(totalNum, 3);
            int taskNumPerBatch = Math.max(totalNum / batchNum, 1);
            LOG.info("backend {} has {} batch, total {} tasks, {}", (Object)beId, (Object)batchNum, (Object)totalNum, (Object)this);
            ArrayList brokers = Lists.newArrayList();
            Status st = this.repo.getBrokerAddress(beId, this.catalog, brokers);
            if (!st.ok()) {
                this.status = st;
                return;
            }
            Preconditions.checkState((brokers.size() == 1 ? 1 : 0) != 0);
            int index = 0;
            for (int batch = 0; batch < batchNum; ++batch) {
                HashMap srcToDest = Maps.newHashMap();
                int currentBatchTaskNum = batch == batchNum - 1 ? totalNum - index : taskNumPerBatch;
                for (int j = 0; j < currentBatchTaskNum; ++j) {
                    SnapshotInfo info = (SnapshotInfo)infos.get(index++);
                    String src = info.getTabletPath();
                    String dest = this.repo.getRepoTabletPathBySnapshotInfo(this.label, info);
                    if (dest == null) {
                        this.status = new Status(Status.ErrCode.COMMON_ERROR, "Invalid dest path: " + info);
                        return;
                    }
                    srcToDest.put(src, dest);
                }
                long signature = this.catalog.getNextId();
                UploadTask task = new UploadTask(null, (long)beId, signature, this.jobId, (Long)this.dbId, srcToDest, (FsBroker)brokers.get(0), this.repo.getStorage().getProperties(), this.repo.getStorage().getStorageType());
                batchTask.addTask(task);
                this.unfinishedTaskIds.put(signature, beId);
            }
        }
        for (AgentTask task : batchTask.getAllTasks()) {
            AgentTaskQueue.addTask(task);
        }
        AgentTaskExecutor.submit(batchTask);
        this.state = BackupJobState.UPLOADING;
        LOG.info("finished to send upload tasks. {}", (Object)this);
    }

    private void waitingAllUploadingFinished() {
        if (this.unfinishedTaskIds.isEmpty()) {
            this.snapshotUploadFinishedTime = System.currentTimeMillis();
            this.state = BackupJobState.SAVE_META;
            this.catalog.getEditLog().logBackupJob(this);
            LOG.info("finished uploading snapshots. {}", (Object)this);
            return;
        }
        LOG.debug("waiting {} tablets to upload snapshot. {}", (Object)this.unfinishedTaskIds.size(), (Object)this);
    }

    private void saveMetaInfo() {
        String createTimeStr = TimeUtils.longToTimeString(this.createTime, new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss"));
        this.localJobDirPath = Paths.get(BackupHandler.BACKUP_ROOT_DIR.toString(), this.label + "__" + createTimeStr).normalize();
        try {
            File jobDir = new File(this.localJobDirPath.toString());
            if (jobDir.exists()) {
                Files.walk(this.localJobDirPath, FileVisitOption.FOLLOW_LINKS).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            if (!jobDir.mkdirs()) {
                this.status = new Status(Status.ErrCode.COMMON_ERROR, "Failed to create tmp dir: " + this.localJobDirPath);
                return;
            }
            File metaInfoFile = new File(jobDir, "__meta");
            if (!metaInfoFile.createNewFile()) {
                this.status = new Status(Status.ErrCode.COMMON_ERROR, "Failed to create meta info file: " + metaInfoFile.toString());
                return;
            }
            this.backupMeta.writeToFile(metaInfoFile);
            this.localMetaInfoFilePath = metaInfoFile.getAbsolutePath();
            this.jobInfo = BackupJobInfo.fromCatalog(this.createTime, this.label, this.dbName, this.dbId, this.getContent(), this.backupMeta, this.snapshotInfos);
            LOG.debug("job info: {}. {}", (Object)this.jobInfo, (Object)this);
            File jobInfoFile = new File(jobDir, "__info_" + createTimeStr);
            if (!jobInfoFile.createNewFile()) {
                this.status = new Status(Status.ErrCode.COMMON_ERROR, "Failed to create job info file: " + jobInfoFile.toString());
                return;
            }
            this.jobInfo.writeToFile(jobInfoFile);
            this.localJobInfoFilePath = jobInfoFile.getAbsolutePath();
        }
        catch (Exception e) {
            this.status = new Status(Status.ErrCode.COMMON_ERROR, "failed to save meta info and job info file: " + e.getMessage());
            return;
        }
        this.state = BackupJobState.UPLOAD_INFO;
        this.backupMeta = null;
        this.jobInfo = null;
        this.releaseSnapshots();
        this.snapshotInfos.clear();
        this.catalog.getEditLog().logBackupJob(this);
        LOG.info("finished to save meta the backup job info file to local.[{}], [{}] {}", (Object)this.localMetaInfoFilePath, (Object)this.localJobInfoFilePath, (Object)this);
    }

    private void releaseSnapshots() {
        if (this.snapshotInfos.isEmpty()) {
            return;
        }
        AgentBatchTask batchTask = new AgentBatchTask();
        for (SnapshotInfo info : this.snapshotInfos.values()) {
            ReleaseSnapshotTask releaseTask = new ReleaseSnapshotTask(null, info.getBeId(), info.getDbId(), info.getTabletId(), info.getPath());
            batchTask.addTask(releaseTask);
        }
        AgentTaskExecutor.submit(batchTask);
        LOG.info("send {} release snapshot tasks, job: {}", (Object)this.snapshotInfos.size(), (Object)this);
    }

    private void uploadMetaAndJobInfoFile() {
        String remoteMetaInfoFile = this.repo.assembleMetaInfoFilePath(this.label);
        if (!this.uploadFile(this.localMetaInfoFilePath, remoteMetaInfoFile)) {
            return;
        }
        String remoteJobInfoFile = this.repo.assembleJobInfoFilePath(this.label, this.createTime);
        if (!this.uploadFile(this.localJobInfoFilePath, remoteJobInfoFile)) {
            return;
        }
        this.finishedTime = System.currentTimeMillis();
        this.state = BackupJobState.FINISHED;
        this.catalog.getEditLog().logBackupJob(this);
        LOG.info("job is finished. {}", (Object)this);
    }

    private boolean uploadFile(String localFilePath, String remoteFilePath) {
        if (!this.validateLocalFile(localFilePath)) {
            return false;
        }
        this.status = this.repo.upload(localFilePath, remoteFilePath);
        return this.status.ok();
    }

    private boolean validateLocalFile(String filePath) {
        File file = new File(filePath);
        if (!file.exists() || !file.canRead()) {
            this.status = new Status(Status.ErrCode.COMMON_ERROR, "file is invalid: " + filePath);
            return false;
        }
        return true;
    }

    private Replica chooseReplica(Tablet tablet, long visibleVersion) {
        ArrayList replicaIds = Lists.newArrayList();
        for (Replica replica : tablet.getReplicas()) {
            replicaIds.add(replica.getId());
        }
        Collections.sort(replicaIds);
        for (Long replicaId : replicaIds) {
            Replica replica = tablet.getReplicaById(replicaId);
            if (replica.getLastFailedVersion() >= 0L || replica.getVersion() <= visibleVersion && replica.getVersion() != visibleVersion) continue;
            return replica;
        }
        return null;
    }

    private void cancelInternal() {
        switch (this.state) {
            case SNAPSHOTING: {
                for (Long taskId : this.unfinishedTaskIds.keySet()) {
                    AgentTaskQueue.removeTaskOfType(TTaskType.MAKE_SNAPSHOT, taskId);
                }
                break;
            }
            case UPLOADING: {
                for (Long taskId : this.unfinishedTaskIds.keySet()) {
                    AgentTaskQueue.removeTaskOfType(TTaskType.UPLOAD, taskId);
                }
                break;
            }
        }
        if (this.localJobDirPath != null) {
            try {
                File jobDir = new File(this.localJobDirPath.toString());
                if (jobDir.exists()) {
                    Files.walk(this.localJobDirPath, FileVisitOption.FOLLOW_LINKS).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                }
            }
            catch (Exception e) {
                LOG.warn("failed to clean the backup job dir: " + this.localJobDirPath.toString());
            }
        }
        this.releaseSnapshots();
        BackupJobState curState = this.state;
        this.finishedTime = System.currentTimeMillis();
        this.state = BackupJobState.CANCELLED;
        this.catalog.getEditLog().logBackupJob(this);
        LOG.info("finished to cancel backup job. current state: {}. {}", (Object)curState.name(), (Object)this);
    }

    public List<String> getInfo() {
        ArrayList info = Lists.newArrayList();
        info.add(String.valueOf(this.jobId));
        info.add(this.label);
        info.add(this.dbName);
        info.add(this.state.name());
        info.add(this.getBackupObjs());
        info.add(TimeUtils.longToTimeString(this.createTime));
        info.add(TimeUtils.longToTimeString(this.snapshotFinishedTime));
        info.add(TimeUtils.longToTimeString(this.snapshotUploadFinishedTime));
        info.add(TimeUtils.longToTimeString(this.finishedTime));
        info.add(Joiner.on((String)", ").join(this.unfinishedTaskIds.entrySet()));
        info.add(Joiner.on((String)", ").join((Iterable)this.taskProgress.entrySet().stream().map(e -> "[" + e.getKey() + ": " + ((Pair)e.getValue()).first + "/" + ((Pair)e.getValue()).second + "]").collect(Collectors.toList())));
        info.add(Joiner.on((String)", ").join((Iterable)this.taskErrMsg.entrySet().stream().map(n -> "[" + n.getKey() + ": " + (String)n.getValue() + "]").collect(Collectors.toList())));
        info.add(this.status.toString());
        info.add(String.valueOf(this.timeoutMs / 1000L));
        return info;
    }

    private String getBackupObjs() {
        List list = this.tableRefs.stream().map(n -> "[" + n.toString() + "]").collect(Collectors.toList());
        return Joiner.on((String)", ").join(list);
    }

    public static BackupJob read(DataInput in) throws IOException {
        BackupJob job = new BackupJob();
        job.readFields(in);
        return job;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.tableRefs.size());
        for (TableRef tableRef : this.tableRefs) {
            tableRef.write(out);
        }
        Text.writeString((DataOutput)out, (String)this.state.name());
        out.writeLong(this.snapshotFinishedTime);
        out.writeLong(this.snapshotUploadFinishedTime);
        out.writeInt(this.snapshotInfos.size());
        for (SnapshotInfo snapshotInfo : this.snapshotInfos.values()) {
            snapshotInfo.write(out);
        }
        if (this.backupMeta == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.backupMeta.write(out);
        }
        if (Strings.isNullOrEmpty((String)this.localMetaInfoFilePath)) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Text.writeString((DataOutput)out, (String)this.localMetaInfoFilePath);
        }
        if (Strings.isNullOrEmpty((String)this.localJobInfoFilePath)) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Text.writeString((DataOutput)out, (String)this.localJobInfoFilePath);
        }
        out.writeInt(this.properties.size());
        for (Map.Entry entry : this.properties.entrySet()) {
            Text.writeString((DataOutput)out, (String)((String)entry.getKey()));
            Text.writeString((DataOutput)out, (String)((String)entry.getValue()));
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int i;
        super.readFields(in);
        int size = in.readInt();
        this.tableRefs = Lists.newArrayList();
        for (i = 0; i < size; ++i) {
            TableRef tblRef = new TableRef();
            tblRef.readFields(in);
            this.tableRefs.add(tblRef);
        }
        this.state = BackupJobState.valueOf(Text.readString((DataInput)in));
        this.snapshotFinishedTime = in.readLong();
        this.snapshotUploadFinishedTime = in.readLong();
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            SnapshotInfo snapshotInfo = new SnapshotInfo();
            snapshotInfo.readFields(in);
            this.snapshotInfos.put(snapshotInfo.getTabletId(), snapshotInfo);
        }
        if (in.readBoolean()) {
            this.backupMeta = BackupMeta.read(in);
        }
        if (in.readBoolean()) {
            this.localMetaInfoFilePath = Text.readString((DataInput)in);
        }
        if (in.readBoolean()) {
            this.localJobInfoFilePath = Text.readString((DataInput)in);
        }
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            String key = Text.readString((DataInput)in);
            String value = Text.readString((DataInput)in);
            this.properties.put(key, value);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(", state: ").append(this.state.name());
        return sb.toString();
    }

    public static enum BackupJobState {
        PENDING,
        SNAPSHOTING,
        UPLOAD_SNAPSHOT,
        UPLOADING,
        SAVE_META,
        UPLOAD_INFO,
        FINISHED,
        CANCELLED;

    }
}

