/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.backup;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.doris.backup.BackupJob;
import org.apache.doris.backup.Repository;
import org.apache.doris.backup.RestoreJob;
import org.apache.doris.backup.Status;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.Pair;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;

public abstract class AbstractJob
implements Writable {
    protected JobType type;
    protected Catalog catalog;
    protected Repository repo;
    protected long repoId;
    protected long jobId = -1L;
    protected String label;
    protected long dbId;
    protected String dbName;
    protected Status status = Status.OK;
    protected long createTime = -1L;
    protected long finishedTime = -1L;
    protected long timeoutMs;
    protected Map<Long, Pair<Integer, Integer>> taskProgress = Maps.newConcurrentMap();
    protected boolean isTypeRead = false;
    protected Map<Long, String> taskErrMsg = Maps.newHashMap();

    protected AbstractJob(JobType type) {
        this.type = type;
    }

    protected AbstractJob(JobType type, String label, long dbId, String dbName, long timeoutMs, Catalog catalog, long repoId) {
        this.type = type;
        this.label = label;
        this.dbId = dbId;
        this.dbName = dbName;
        this.createTime = System.currentTimeMillis();
        this.timeoutMs = timeoutMs;
        this.catalog = catalog;
        this.repoId = repoId;
    }

    public JobType getType() {
        return this.type;
    }

    public long getJobId() {
        return this.jobId;
    }

    public String getLabel() {
        return this.label;
    }

    public long getDbId() {
        return this.dbId;
    }

    public String getDbName() {
        return this.dbName;
    }

    public Status getStatus() {
        return this.status;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getFinishedTime() {
        return this.finishedTime;
    }

    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    public long getRepoId() {
        return this.repoId;
    }

    public void setTypeRead(boolean isTypeRead) {
        this.isTypeRead = isTypeRead;
    }

    public abstract void run();

    public abstract Status cancel();

    public abstract void replayRun();

    public abstract void replayCancel();

    public abstract boolean isDone();

    public abstract boolean isPending();

    public abstract boolean isCancelled();

    public static AbstractJob read(DataInput in) throws IOException {
        AbstractJob job = null;
        JobType type = JobType.valueOf(Text.readString((DataInput)in));
        if (type == JobType.BACKUP) {
            job = new BackupJob();
        } else if (type == JobType.RESTORE) {
            job = new RestoreJob();
        } else {
            throw new IOException("Unknown job type: " + type.name());
        }
        job.setTypeRead(true);
        job.readFields(in);
        return job;
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.type.name());
        out.writeLong(this.repoId);
        Text.writeString((DataOutput)out, (String)this.label);
        out.writeLong(this.jobId);
        out.writeLong(this.dbId);
        Text.writeString((DataOutput)out, (String)this.dbName);
        out.writeLong(this.createTime);
        out.writeLong(this.finishedTime);
        out.writeLong(this.timeoutMs);
        if (!this.taskErrMsg.isEmpty()) {
            out.writeBoolean(true);
            int savedNum = Math.min(3, this.taskErrMsg.size());
            out.writeInt(savedNum);
            for (Map.Entry<Long, String> entry : this.taskErrMsg.entrySet()) {
                if (savedNum == 0) break;
                out.writeLong(entry.getKey());
                Text.writeString((DataOutput)out, (String)entry.getValue());
                --savedNum;
            }
            Preconditions.checkState((savedNum == 0 ? 1 : 0) != 0, (Object)savedNum);
        } else {
            out.writeBoolean(false);
        }
    }

    public void readFields(DataInput in) throws IOException {
        if (!this.isTypeRead) {
            this.type = JobType.valueOf(Text.readString((DataInput)in));
            this.isTypeRead = true;
        }
        this.repoId = in.readLong();
        this.label = Text.readString((DataInput)in);
        this.jobId = in.readLong();
        this.dbId = in.readLong();
        this.dbName = Text.readString((DataInput)in);
        this.createTime = in.readLong();
        this.finishedTime = in.readLong();
        this.timeoutMs = in.readLong();
        if (in.readBoolean()) {
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                long taskId = in.readLong();
                String msg = Text.readString((DataInput)in);
                this.taskErrMsg.put(taskId, msg);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.type.name());
        sb.append(" repo id: ").append(this.repoId).append(", label: ").append(this.label);
        sb.append(", job id: ").append(this.jobId).append(", db id: ").append(this.dbId).append(", db name: ").append(this.dbName);
        sb.append(", status: ").append(this.status);
        sb.append(", timeout: ").append(this.timeoutMs);
        return sb.toString();
    }

    public static enum JobType {
        BACKUP,
        RESTORE;

    }
}

