/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ParseNode;
import org.apache.doris.analysis.QueryStmt;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.analysis.ToSqlUtils;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.View;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.UserException;

public class WithClause
implements ParseNode {
    private final ArrayList<View> views_;

    public WithClause(ArrayList<View> views) {
        Preconditions.checkNotNull(views);
        Preconditions.checkState((!views.isEmpty() ? 1 : 0) != 0);
        this.views_ = views;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        Analyzer withClauseAnalyzer = Analyzer.createWithNewGlobalState(analyzer);
        withClauseAnalyzer.setIsWithClause();
        if (analyzer.isExplain()) {
            withClauseAnalyzer.setIsExplain();
        }
        for (View view : this.views_) {
            Analyzer viewAnalyzer = new Analyzer(withClauseAnalyzer);
            view.getQueryStmt().analyze(viewAnalyzer);
            withClauseAnalyzer.registerLocalView(view);
        }
        for (View localView : withClauseAnalyzer.getLocalViews().values()) {
            analyzer.registerLocalView(localView);
        }
    }

    private WithClause(WithClause other) {
        Preconditions.checkNotNull((Object)other);
        this.views_ = Lists.newArrayList();
        for (View view : other.views_) {
            this.views_.add(new View(view.getName(), view.getQueryStmt().clone(), view.getOriginalColLabels()));
        }
    }

    public void reset() {
        for (View view : this.views_) {
            view.getQueryStmt().reset();
        }
    }

    public void getTables(Analyzer analyzer, Map<Long, Table> tableMap, Set<String> parentViewNameSet) throws AnalysisException {
        for (View view : this.views_) {
            QueryStmt stmt = view.getQueryStmt();
            parentViewNameSet.add(view.getName());
            stmt.getTables(analyzer, tableMap, parentViewNameSet);
        }
    }

    public void getTableRefs(Analyzer analyzer, List<TableRef> tblRefs, Set<String> parentViewNameSet) {
        for (View view : this.views_) {
            QueryStmt stmt = view.getQueryStmt();
            parentViewNameSet.add(view.getName());
            stmt.getTableRefs(analyzer, tblRefs, parentViewNameSet);
        }
    }

    public WithClause clone() {
        return new WithClause(this);
    }

    @Override
    public String toSql() {
        ArrayList viewStrings = Lists.newArrayList();
        for (View view : this.views_) {
            String aliasSql = ToSqlUtils.getIdentSql(view.getName());
            if (view.hasColLabels()) {
                aliasSql = aliasSql + "(" + Joiner.on((String)", ").join(ToSqlUtils.getIdentSqlList(view.getOriginalColLabels())) + ")";
            }
            viewStrings.add(aliasSql + " AS (" + view.getQueryStmt().toSql() + ")");
        }
        return "WITH " + Joiner.on((String)",").join((Iterable)viewStrings);
    }

    public List<View> getViews() {
        return this.views_;
    }
}

