/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VirtualSlotRef
extends SlotRef {
    private static final Logger LOG = LogManager.getLogger(VirtualSlotRef.class);
    private TupleDescriptor tupleDescriptor;
    private List<Expr> realSlots;

    public VirtualSlotRef(String col, Type type, TupleDescriptor tupleDescriptor, List<Expr> realSlots) {
        super(null, col);
        this.type = type;
        this.tupleDescriptor = tupleDescriptor;
        this.realSlots = realSlots;
    }

    protected VirtualSlotRef(VirtualSlotRef other) {
        super(other);
        if (other.realSlots != null) {
            this.realSlots = Expr.cloneList(other.realSlots);
        }
        this.tupleDescriptor = other.tupleDescriptor;
    }

    public static VirtualSlotRef read(DataInput in) throws IOException {
        VirtualSlotRef virtualSlotRef = new VirtualSlotRef(null, Type.BIGINT, null, new ArrayList<Expr>());
        virtualSlotRef.readFields(in);
        return virtualSlotRef;
    }

    public String getRealColumnName() {
        if (this.getColumnName().startsWith("GROUPING_PREFIX_")) {
            return this.getColumnName().substring("GROUPING_PREFIX_".length());
        }
        return this.getColumnName();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        if (CollectionUtils.isEmpty(this.realSlots)) {
            out.writeInt(0);
        } else {
            out.writeInt(this.realSlots.size());
            for (Expr slotRef : this.realSlots) {
                slotRef.write(out);
            }
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        int realSlotsSize = in.readInt();
        if (realSlotsSize > 0) {
            for (int i = 0; i < realSlotsSize; ++i) {
                this.realSlots.add(SlotRef.read(in));
            }
        }
    }

    public List<Expr> getRealSlots() {
        return this.realSlots;
    }

    public void setRealSlots(List<Expr> realSlots) {
        this.realSlots = realSlots;
    }

    @Override
    public Expr clone() {
        return new VirtualSlotRef(this);
    }

    @Override
    public void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        this.desc = analyzer.registerVirtualColumnRef(super.getColumnName(), this.type, this.tupleDescriptor);
        this.numDistinctValues = this.desc.getStats().getNumDistinctValues();
    }
}

