/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DefaultValueExpr;
import org.apache.doris.analysis.Expr;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;

public class ValueList {
    private List<ArrayList<Expr>> rows;

    public ValueList(ArrayList<Expr> row) {
        this.rows = Lists.newArrayList();
        this.rows.add(row);
    }

    public ValueList(List<ArrayList<Expr>> rows) {
        this.rows = rows;
    }

    public List<ArrayList<Expr>> getRows() {
        return this.rows;
    }

    public void addRow(ArrayList<Expr> row) {
        this.rows.add(row);
    }

    public ArrayList<Expr> getFirstRow() {
        return this.rows.get(0);
    }

    public void analyzeForSelect(Analyzer analyzer) throws AnalysisException {
        if (this.rows.isEmpty()) {
            throw new AnalysisException("No row in value list");
        }
        ArrayList<Expr> firstRow = null;
        int rowIdx = 0;
        for (ArrayList<Expr> row : this.rows) {
            ++rowIdx;
            if (firstRow != null && row.size() != firstRow.size()) {
                throw new AnalysisException("Column count doesn't match value count at row " + rowIdx);
            }
            for (int i = 0; i < row.size(); ++i) {
                Expr expr = row.get(i);
                if (expr instanceof DefaultValueExpr) {
                    throw new AnalysisException("Default expression can't exist in SELECT statement at row " + rowIdx);
                }
                expr.analyze(analyzer);
                if (firstRow == null) continue;
                Type dstType = firstRow.get(i).getType();
                if (expr.getType().getPrimitiveType().equals((Object)dstType.getPrimitiveType())) continue;
                row.set(i, expr.castTo(dstType));
            }
            if (firstRow != null) continue;
            firstRow = row;
        }
    }
}

