/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.CaseSensibility;
import org.apache.doris.common.FeNameFormat;
import org.apache.doris.common.PatternMatcher;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.thrift.TUserIdentity;

public class UserIdentity
implements Writable {
    private String user;
    private String host;
    private boolean isDomain;
    private boolean isAnalyzed = false;
    public static final UserIdentity ROOT = new UserIdentity("root", "%");
    public static final UserIdentity ADMIN;
    public static final UserIdentity UNKNOWN;

    private UserIdentity() {
    }

    public UserIdentity(String user, String host) {
        this.user = Strings.nullToEmpty((String)user);
        this.host = Strings.nullToEmpty((String)host);
        this.isDomain = false;
    }

    public UserIdentity(String user, String host, boolean isDomain) {
        this.user = Strings.nullToEmpty((String)user);
        this.host = Strings.nullToEmpty((String)host);
        this.isDomain = isDomain;
    }

    public static UserIdentity createAnalyzedUserIdentWithIp(String user, String host) {
        UserIdentity userIdentity = new UserIdentity(user, host);
        userIdentity.setIsAnalyzed();
        return userIdentity;
    }

    public static UserIdentity createAnalyzedUserIdentWithDomain(String user, String domain) {
        UserIdentity userIdentity = new UserIdentity(user, domain, true);
        userIdentity.setIsAnalyzed();
        return userIdentity;
    }

    public static UserIdentity fromThrift(TUserIdentity tUserIdent) {
        UserIdentity userIdentity = new UserIdentity(tUserIdent.getUsername(), tUserIdent.getHost(), tUserIdent.is_domain);
        userIdentity.setIsAnalyzed();
        return userIdentity;
    }

    public String getQualifiedUser() {
        Preconditions.checkState((boolean)this.isAnalyzed);
        return this.user;
    }

    public String getHost() {
        return this.host;
    }

    public boolean isDomain() {
        return this.isDomain;
    }

    public void setIsAnalyzed() {
        this.isAnalyzed = true;
    }

    public void analyze(String clusterName) throws AnalysisException {
        if (this.isAnalyzed) {
            return;
        }
        if (Strings.isNullOrEmpty((String)this.user)) {
            throw new AnalysisException("Does not support anonymous user");
        }
        FeNameFormat.checkUserName(this.user);
        if (!this.user.equals("root") && !this.user.equals("admin")) {
            this.user = ClusterNamespace.getFullName(clusterName, this.user);
        }
        if (Strings.isNullOrEmpty((String)this.host)) {
            if (!this.isDomain) {
                this.host = "%";
            } else {
                throw new AnalysisException("Domain is empty");
            }
        }
        PatternMatcher.createMysqlPattern(this.host, CaseSensibility.HOST.getCaseSensibility());
        this.isAnalyzed = true;
    }

    public static UserIdentity fromString(String userIdentStr) {
        if (Strings.isNullOrEmpty((String)userIdentStr)) {
            return null;
        }
        String[] parts = userIdentStr.split("@");
        if (parts.length != 2) {
            return null;
        }
        String user = parts[0];
        if (!user.startsWith("'") || !user.endsWith("'")) {
            return null;
        }
        String host = parts[1];
        if (host.startsWith("['") && host.endsWith("']")) {
            UserIdentity userIdent = new UserIdentity(user.substring(1, user.length() - 1), host.substring(2, host.length() - 2), true);
            userIdent.setIsAnalyzed();
            return userIdent;
        }
        if (host.startsWith("'") && host.endsWith("'")) {
            UserIdentity userIdent = new UserIdentity(user.substring(1, user.length() - 1), host.substring(1, host.length() - 1));
            userIdent.setIsAnalyzed();
            return userIdent;
        }
        return null;
    }

    public boolean isRootUser() {
        return this.user.equals("root");
    }

    public TUserIdentity toThrift() {
        Preconditions.checkState((boolean)this.isAnalyzed);
        TUserIdentity tUserIdent = new TUserIdentity();
        tUserIdent.setHost(this.host);
        tUserIdent.setUsername(this.user);
        tUserIdent.setIsDomain(this.isDomain);
        return tUserIdent;
    }

    public static UserIdentity read(DataInput in) throws IOException {
        UserIdentity userIdentity = new UserIdentity();
        userIdentity.readFields(in);
        return userIdentity;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UserIdentity)) {
            return false;
        }
        UserIdentity other = (UserIdentity)obj;
        return this.user.equals(other.getQualifiedUser()) && this.host.equals(other.getHost()) && this.isDomain == other.isDomain;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.user.hashCode();
        result = 31 * result + this.host.hashCode();
        result = 31 * result + Boolean.valueOf(this.isDomain).hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("'");
        if (!Strings.isNullOrEmpty((String)this.user)) {
            sb.append(this.user);
        }
        sb.append("'@");
        if (!Strings.isNullOrEmpty((String)this.host)) {
            if (this.isDomain) {
                sb.append("['").append(this.host).append("']");
            } else {
                sb.append("'").append(this.host).append("'");
            }
        } else {
            sb.append("%");
        }
        return sb.toString();
    }

    public void write(DataOutput out) throws IOException {
        Preconditions.checkState((boolean)this.isAnalyzed);
        Text.writeString((DataOutput)out, (String)this.user);
        Text.writeString((DataOutput)out, (String)this.host);
        out.writeBoolean(this.isDomain);
    }

    public void readFields(DataInput in) throws IOException {
        this.user = Text.readString((DataInput)in);
        this.host = Text.readString((DataInput)in);
        this.isDomain = in.readBoolean();
        this.isAnalyzed = true;
    }

    static {
        ROOT.setIsAnalyzed();
        ADMIN = new UserIdentity("admin", "%");
        ADMIN.setIsAnalyzed();
        UNKNOWN = new UserIdentity("unknown", "%");
        UNKNOWN.setIsAnalyzed();
    }
}

