/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.TreeSet;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.LargeIntLiteral;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TableName;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.catalog.AggregateType;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.KeysType;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.UserException;
import org.apache.doris.rewrite.ExprRewriter;

public class UpdateStmt
extends DdlStmt {
    private TableName tableName;
    private List<Expr> setExprs;
    private Expr whereExpr;
    private Table targetTable;
    private TupleDescriptor srcTupleDesc;

    public UpdateStmt(TableName tableName, List<Expr> setExprs, Expr whereExpr) {
        this.tableName = tableName;
        this.setExprs = setExprs;
        this.whereExpr = whereExpr;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public List<Expr> getSetExprs() {
        return this.setExprs;
    }

    public Expr getWhereExpr() {
        return this.whereExpr;
    }

    public Table getTargetTable() {
        return this.targetTable;
    }

    public TupleDescriptor getSrcTupleDesc() {
        return this.srcTupleDesc;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        this.analyzeTargetTable(analyzer);
        this.analyzeSetExprs(analyzer);
        this.analyzeWhereExpr(analyzer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeTargetTable(Analyzer analyzer) throws AnalysisException {
        this.tableName.analyze(analyzer);
        String dbName = this.tableName.getDb();
        String targetTableName = this.tableName.getTbl();
        Preconditions.checkNotNull((Object)dbName);
        Preconditions.checkNotNull((Object)targetTableName);
        Database database = Catalog.getCurrentCatalog().getDbOrAnalysisException(dbName);
        this.targetTable = database.getTableOrAnalysisException(this.tableName.getTbl());
        if (this.targetTable.getType() != Table.TableType.OLAP || ((OlapTable)this.targetTable).getKeysType() != KeysType.UNIQUE_KEYS) {
            throw new AnalysisException("Only unique olap table could be updated.");
        }
        this.targetTable.readLock();
        try {
            this.srcTupleDesc = analyzer.registerOlapTable(this.targetTable, this.tableName, null);
        }
        finally {
            this.targetTable.readUnlock();
        }
    }

    private void analyzeSetExprs(Analyzer analyzer) throws AnalysisException {
        TreeSet<String> columnMappingNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (Expr setExpr : this.setExprs) {
            if (!(setExpr instanceof BinaryPredicate)) {
                throw new AnalysisException("Set function expr only support eq binary predicate. Expr: " + setExpr.toSql());
            }
            BinaryPredicate predicate = (BinaryPredicate)setExpr;
            if (predicate.getOp() != BinaryPredicate.Operator.EQ) {
                throw new AnalysisException("Set function expr only support eq binary predicate. The predicate operator error, op: " + (Object)((Object)predicate.getOp()));
            }
            Expr lhs = (Expr)predicate.getChild(0);
            if (!(lhs instanceof SlotRef)) {
                throw new AnalysisException("Set function expr only support eq binary predicate which's child(0) must be a column name. The child(0) expr error. expr: " + lhs.toSql());
            }
            String column = ((SlotRef)lhs).getColumnName();
            if (columnMappingNames.add(column)) continue;
            throw new AnalysisException("Duplicate column setting: " + column);
        }
        for (Expr setExpr : this.setExprs) {
            Preconditions.checkState((boolean)(setExpr instanceof BinaryPredicate));
            Expr lhs = (Expr)setExpr.getChild(0);
            if (!(lhs instanceof SlotRef)) {
                throw new AnalysisException("The left side of the set expr must be the column name");
            }
            lhs.analyze(analyzer);
            if (((SlotRef)lhs).getColumn().getAggregationType() != AggregateType.REPLACE) {
                throw new AnalysisException("Only value columns of unique table could be updated.");
            }
            Expr rhs = (Expr)setExpr.getChild(1);
            this.checkLargeIntOverflow(rhs);
            rhs.analyze(analyzer);
            if (lhs.getType() == rhs.getType()) continue;
            setExpr.setChild(1, rhs.checkTypeCompatibility(lhs.getType()));
        }
    }

    private void checkLargeIntOverflow(Expr expr) throws AnalysisException {
        if (expr instanceof LargeIntLiteral) {
            expr.analyzeImpl(this.analyzer);
        }
    }

    private void analyzeWhereExpr(Analyzer analyzer) throws AnalysisException {
        if (this.whereExpr == null) {
            throw new AnalysisException("Where clause is required");
        }
        this.whereExpr = analyzer.getExprRewriter().rewrite(this.whereExpr, analyzer, ExprRewriter.ClauseType.WHERE_CLAUSE);
        this.whereExpr.analyze(analyzer);
        if (!this.whereExpr.getType().equals(Type.BOOLEAN)) {
            throw new AnalysisException("Where clause is not a valid statement return bool");
        }
        analyzer.registerConjunct(this.whereExpr, this.srcTupleDesc.getId());
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder("UPDATE ");
        sb.append(this.tableName.toSql()).append("\n");
        sb.append("  ").append("SET ");
        for (Expr setExpr : this.setExprs) {
            sb.append(setExpr.toSql()).append(", ");
        }
        sb.append("\n");
        if (this.whereExpr != null) {
            sb.append("  ").append("WHERE ").append(this.whereExpr.toSql());
        }
        return sb.toString();
    }
}

