/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ParseNode;
import org.apache.doris.catalog.ArrayType;
import org.apache.doris.catalog.MapType;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.StructField;
import org.apache.doris.catalog.StructType;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;

public class TypeDef
implements ParseNode {
    private boolean isAnalyzed;
    private final Type parsedType;

    public TypeDef(Type parsedType) {
        this.parsedType = parsedType;
    }

    public static TypeDef create(PrimitiveType type) {
        return new TypeDef(ScalarType.createType(type));
    }

    public static TypeDef createDecimal(int precision, int scale) {
        return new TypeDef(ScalarType.createDecimalV2Type(precision, scale));
    }

    public static TypeDef createVarchar(int len) {
        return new TypeDef(ScalarType.createVarchar(len));
    }

    public static TypeDef createChar(int len) {
        return new TypeDef(ScalarType.createChar(len));
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.isAnalyzed) {
            return;
        }
        if (this.parsedType.exceedsMaxNestingDepth()) {
            throw new AnalysisException(String.format("Type exceeds the maximum nesting depth of %s:\n%s", Type.MAX_NESTING_DEPTH, this.parsedType.toSql()));
        }
        this.analyze(this.parsedType);
        this.isAnalyzed = true;
    }

    private void analyze(Type type) throws AnalysisException {
        Type itemType;
        if (!type.isSupported()) {
            throw new AnalysisException("Unsupported data type: " + type.toSql());
        }
        if (type.isScalarType()) {
            this.analyzeScalarType((ScalarType)type);
        }
        if (type.isArrayType()) {
            itemType = ((ArrayType)type).getItemType();
            this.analyze(itemType);
        }
        if (type.isComplexType()) {
            if (!Config.enable_complex_type_support) {
                throw new AnalysisException("Unsupported data type: " + type.toSql());
            }
            if (type.isArrayType()) {
                itemType = (ScalarType)((ArrayType)type).getItemType();
                this.analyzeNestedType((ScalarType)itemType);
            }
            if (type.isMapType()) {
                ScalarType keyType = (ScalarType)((MapType)type).getKeyType();
                ScalarType valueType = (ScalarType)((MapType)type).getKeyType();
                this.analyzeNestedType(keyType);
                this.analyzeNestedType(valueType);
            }
            if (type.isStructType()) {
                ArrayList<StructField> fields = ((StructType)type).getFields();
                for (int i = 0; i < fields.size(); ++i) {
                    ScalarType filedType = (ScalarType)fields.get(i).getType();
                    this.analyzeNestedType(filedType);
                }
            }
        }
    }

    private void analyzeNestedType(ScalarType type) throws AnalysisException {
        if (type.isNull()) {
            throw new AnalysisException("Unsupported data type: " + type.toSql());
        }
        if (type.getPrimitiveType().isStringType() && !type.isAssignedStrLenInColDefinition()) {
            type.setLength(1);
        }
        this.analyze(type);
    }

    private void analyzeScalarType(ScalarType scalarType) throws AnalysisException {
        PrimitiveType type = scalarType.getPrimitiveType();
        switch (type) {
            case CHAR: 
            case VARCHAR: {
                int maxLen;
                String name;
                if (type == PrimitiveType.VARCHAR) {
                    name = "VARCHAR";
                    maxLen = 65533;
                } else if (type == PrimitiveType.CHAR) {
                    name = "CHAR";
                    maxLen = 255;
                } else {
                    Preconditions.checkState((boolean)false);
                    return;
                }
                int len = scalarType.getLength();
                if (len <= 0) {
                    throw new AnalysisException(name + " size must be > 0: " + len);
                }
                if (scalarType.getLength() <= maxLen) break;
                throw new AnalysisException(name + " size must be <= " + maxLen + ": " + len);
            }
            case DECIMALV2: {
                int precision = scalarType.decimalPrecision();
                int scale = scalarType.decimalScale();
                if (precision < 1 || precision > 27) {
                    throw new AnalysisException("Precision of decimal must between 1 and 27. Precision was set to: " + precision + ".");
                }
                if (scale < 0 || scale > 9) {
                    throw new AnalysisException("Scale of decimal must between 0 and 9. Scale was set to: " + scale + ".");
                }
                if (scale < precision) break;
                throw new AnalysisException("Scale of decimal must be smaller than precision. Scale is " + scale + " and precision is " + precision);
            }
            case INVALID_TYPE: {
                throw new AnalysisException("Invalid type.");
            }
        }
    }

    public Type getType() {
        return this.parsedType;
    }

    public String toString() {
        return this.parsedType.toSql();
    }

    @Override
    public String toSql() {
        return this.parsedType.toSql();
    }
}

