/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.analysis.Predicate;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.UserException;
import org.apache.doris.thrift.TExprNode;
import org.apache.doris.thrift.TExprNodeType;
import org.apache.doris.thrift.TTupleIsNullPredicate;

public class TupleIsNullPredicate
extends Predicate {
    private final List<TupleId> tupleIds = Lists.newArrayList();

    public TupleIsNullPredicate(List<TupleId> tupleIds) {
        Preconditions.checkState((tupleIds != null && !tupleIds.isEmpty() ? 1 : 0) != 0);
        this.tupleIds.addAll(tupleIds);
    }

    protected TupleIsNullPredicate(TupleIsNullPredicate other) {
        super(other);
        this.tupleIds.addAll(other.tupleIds);
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        super.analyzeImpl(analyzer);
    }

    @Override
    protected boolean isConstantImpl() {
        return false;
    }

    @Override
    public boolean isBoundByTupleIds(List<TupleId> tids) {
        for (TupleId tid : tids) {
            if (!this.tupleIds.contains(tid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Expr clone() {
        return new TupleIsNullPredicate(this);
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.TUPLE_IS_NULL_PRED;
        msg.tuple_is_null_pred = new TTupleIsNullPredicate();
        for (TupleId tid : this.tupleIds) {
            msg.tuple_is_null_pred.addToTupleIds(tid.asInt());
        }
    }

    public List<TupleId> getTupleIds() {
        return this.tupleIds;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof TupleIsNullPredicate)) {
            return false;
        }
        TupleIsNullPredicate other = (TupleIsNullPredicate)o;
        return other.tupleIds.containsAll(this.tupleIds) && this.tupleIds.containsAll(other.tupleIds);
    }

    public static List<Expr> wrapExprs(List<Expr> inputExprs, List<TupleId> tids, Analyzer analyzer) throws UserException {
        for (TupleId tid : tids) {
            TupleDescriptor tupleDesc = analyzer.getTupleDesc(tid);
            Preconditions.checkState((boolean)tupleDesc.getIsMaterialized());
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)inputExprs.size());
        for (Expr e : inputExprs) {
            result.add(TupleIsNullPredicate.wrapExpr(e, tids, analyzer));
        }
        return result;
    }

    public static Expr wrapExpr(Expr expr, List<TupleId> tids, Analyzer analyzer) throws UserException {
        if (!TupleIsNullPredicate.requiresNullWrapping(expr, analyzer)) {
            return expr;
        }
        ArrayList params = Lists.newArrayList();
        params.add(new TupleIsNullPredicate(tids));
        params.add(new NullLiteral());
        params.add(expr);
        Expr ifExpr = new FunctionCallExpr("if", (List<Expr>)params);
        ifExpr.analyzeNoThrow(analyzer);
        if (expr.getType().getPrimitiveType() != ifExpr.getType().getPrimitiveType()) {
            ifExpr = ifExpr.uncheckedCastTo(expr.getType());
        }
        return ifExpr;
    }

    private static boolean requiresNullWrapping(Expr expr, Analyzer analyzer) {
        return !expr.getType().isNull();
    }

    @Override
    public String toSqlImpl() {
        return "TupleIsNull(" + Joiner.on((String)",").join(this.tupleIds) + ")";
    }

    public static Expr unwrapExpr(Expr expr) {
        if (expr instanceof FunctionCallExpr) {
            FunctionCallExpr fnCallExpr = (FunctionCallExpr)expr;
            List<Expr> params = fnCallExpr.getParams().exprs();
            if (fnCallExpr.getFnName().getFunction().equals("if") && params.get(0) instanceof TupleIsNullPredicate && Expr.IS_NULL_LITERAL.apply((Object)params.get(1))) {
                return TupleIsNullPredicate.unwrapExpr(params.get(2));
            }
        }
        for (int i = 0; i < expr.getChildren().size(); ++i) {
            expr.setChild(i, TupleIsNullPredicate.unwrapExpr((Expr)expr.getChild(i)));
        }
        return expr;
    }

    @Override
    public boolean isNullable() {
        return false;
    }
}

