/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.TableName;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.catalog.ColumnStats;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.Table;
import org.apache.doris.thrift.TTupleDescriptor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TupleDescriptor {
    private static final Logger LOG = LogManager.getLogger(TupleDescriptor.class);
    private final TupleId id;
    private final String debugName;
    private final ArrayList<SlotDescriptor> slots;
    private Table table;
    private TableRef ref;
    private String[] aliases_;
    private boolean hasExplicitAlias_;
    private boolean isMaterialized = true;
    private int byteSize;
    private int numNullBytes;
    private int numNullableSlots;
    private long cardinality;
    private float avgSerializedSize;

    public TupleDescriptor(TupleId id) {
        this.id = id;
        this.slots = new ArrayList();
        this.debugName = "";
        this.cardinality = -1L;
    }

    public TupleDescriptor(TupleId id, String debugName) {
        this.id = id;
        this.slots = new ArrayList();
        this.debugName = debugName;
        this.cardinality = -1L;
    }

    public void addSlot(SlotDescriptor desc) {
        desc.setSlotOffset(this.slots.size());
        this.slots.add(desc);
    }

    public TupleId getId() {
        return this.id;
    }

    public TableRef getRef() {
        return this.ref;
    }

    public void setRef(TableRef new_ref) {
        this.ref = new_ref;
    }

    public ArrayList<SlotDescriptor> getSlots() {
        return this.slots;
    }

    public void setCardinality(long cardinality) {
        this.cardinality = cardinality;
    }

    public long getCardinality() {
        return this.cardinality;
    }

    public ArrayList<SlotDescriptor> getMaterializedSlots() {
        ArrayList result = Lists.newArrayList();
        for (SlotDescriptor slot : this.slots) {
            if (!slot.isMaterialized()) continue;
            result.add(slot);
        }
        return result;
    }

    public SlotDescriptor getColumnSlot(String columnName) {
        for (SlotDescriptor slotDesc : this.slots) {
            if (slotDesc.getColumn() == null || !slotDesc.getColumn().getName().equalsIgnoreCase(columnName)) continue;
            return slotDesc;
        }
        return null;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table tbl) {
        this.table = tbl;
    }

    public int getByteSize() {
        return this.byteSize;
    }

    public boolean getIsMaterialized() {
        return this.isMaterialized;
    }

    public boolean isMaterialized() {
        return this.isMaterialized;
    }

    public void setIsMaterialized(boolean value) {
        this.isMaterialized = value;
    }

    public float getAvgSerializedSize() {
        return this.avgSerializedSize;
    }

    public void setAliases(String[] aliases, boolean hasExplicitAlias) {
        this.aliases_ = aliases;
        this.hasExplicitAlias_ = hasExplicitAlias;
    }

    public boolean hasExplicitAlias() {
        return this.hasExplicitAlias_;
    }

    public String getAlias() {
        return this.aliases_ != null ? this.aliases_[0] : null;
    }

    public TableName getAliasAsName() {
        return this.aliases_ != null ? new TableName(null, this.aliases_[0]) : null;
    }

    public TTupleDescriptor toThrift() {
        TTupleDescriptor ttupleDesc = new TTupleDescriptor(this.id.asInt(), this.byteSize, this.numNullBytes);
        ttupleDesc.setNumNullSlots(this.numNullableSlots);
        if (this.table != null && this.table.getId() >= 0L) {
            ttupleDesc.setTableId((long)((int)this.table.getId()));
        }
        return ttupleDesc;
    }

    public void computeStatAndMemLayout() {
        this.computeStat();
        this.computeMemLayout();
    }

    @Deprecated
    public void computeStat() {
        this.avgSerializedSize = 0.0f;
        for (SlotDescriptor d : this.slots) {
            if (!d.isMaterialized()) continue;
            ColumnStats stats = d.getStats();
            if (stats.hasAvgSerializedSize()) {
                this.avgSerializedSize += d.getStats().getAvgSerializedSize();
                continue;
            }
            this.avgSerializedSize += (float)d.getType().getSlotSize();
        }
    }

    @Deprecated
    public void computeMemLayout() {
        ArrayList slotsBySize = Lists.newArrayListWithCapacity((int)PrimitiveType.getMaxSlotSize());
        for (int i = 0; i <= PrimitiveType.getMaxSlotSize(); ++i) {
            slotsBySize.add(new ArrayList());
        }
        this.numNullableSlots = 0;
        for (SlotDescriptor d : this.slots) {
            ColumnStats stats = d.getStats();
            if (!d.isMaterialized()) continue;
            ((List)slotsBySize.get(d.getType().getSlotSize())).add(d);
            if (!d.getIsNullable()) continue;
            ++this.numNullableSlots;
        }
        Preconditions.checkState((boolean)((List)slotsBySize.get(0)).isEmpty());
        int offset = this.numNullBytes = (this.numNullableSlots + 7) / 8;
        int nullIndicatorByte = 0;
        int nullIndicatorBit = 0;
        int slotIdx = 0;
        for (int slotSize = 1; slotSize <= PrimitiveType.getMaxSlotSize(); ++slotSize) {
            if (((List)slotsBySize.get(slotSize)).isEmpty()) continue;
            if (slotSize > 1) {
                int alignTo = slotSize;
                offset = (offset + alignTo - 1) / alignTo * alignTo;
            }
            for (SlotDescriptor d : (List)slotsBySize.get(slotSize)) {
                d.setByteSize(slotSize);
                d.setByteOffset(offset);
                d.setSlotIdx(slotIdx++);
                offset += slotSize;
                if (d.getIsNullable()) {
                    d.setNullIndicatorByte(nullIndicatorByte);
                    d.setNullIndicatorBit(nullIndicatorBit);
                    if ((nullIndicatorBit = (nullIndicatorBit + 1) % 8) != 0) continue;
                    ++nullIndicatorByte;
                    continue;
                }
                d.setNullIndicatorBit(-1);
                d.setNullIndicatorByte(0);
            }
        }
        this.byteSize = offset;
    }

    public boolean isCompatible(TupleDescriptor desc) {
        if (this.slots.size() != desc.slots.size()) {
            return false;
        }
        for (int i = 0; i < this.slots.size(); ++i) {
            if (this.slots.get(i).getType() == desc.slots.get(i).getType()) continue;
            return false;
        }
        return true;
    }

    public void materializeSlots() {
        for (SlotDescriptor slot : this.slots) {
            slot.setIsMaterialized(true);
        }
    }

    public void getTableIdToColumnNames(Map<Long, Set<String>> tableIdToColumnNames) {
        for (SlotDescriptor slotDescriptor : this.slots) {
            if (!slotDescriptor.isMaterialized()) continue;
            if (slotDescriptor.getColumn() != null) {
                TupleDescriptor parent = slotDescriptor.getParent();
                Preconditions.checkState((parent != null ? 1 : 0) != 0);
                Table table = parent.getTable();
                Preconditions.checkState((table != null ? 1 : 0) != 0);
                Long tableId = table.getId();
                Set<String> columnNames = tableIdToColumnNames.get(tableId);
                if (columnNames == null) {
                    columnNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                    tableIdToColumnNames.put(tableId, columnNames);
                }
                columnNames.add(slotDescriptor.getColumn().getName());
                continue;
            }
            for (Expr expr : slotDescriptor.getSourceExprs()) {
                expr.getTableIdToColumnNames(tableIdToColumnNames);
            }
        }
    }

    public String toString() {
        String tblStr = this.table == null ? "null" : this.table.getName();
        ArrayList slotStrings = Lists.newArrayList();
        for (SlotDescriptor slot : this.slots) {
            slotStrings.add(slot.debugString());
        }
        return MoreObjects.toStringHelper((Object)this).add("id", this.id.asInt()).add("tbl", (Object)tblStr).add("byte_size", this.byteSize).add("is_materialized", this.isMaterialized).add("slots", (Object)("[" + Joiner.on((String)", ").join((Iterable)slotStrings) + "]")).toString();
    }

    public String debugString() {
        String tblStr = this.getTable() == null ? "null" : this.getTable().getName();
        ArrayList slotStrings = Lists.newArrayList();
        for (SlotDescriptor slot : this.slots) {
            slotStrings.add(slot.debugString());
        }
        return MoreObjects.toStringHelper((Object)this).add("id", this.id.asInt()).add("name", (Object)this.debugName).add("tbl", (Object)tblStr).add("byte_size", this.byteSize).add("is_materialized", this.isMaterialized).add("slots", (Object)("[" + Joiner.on((String)", ").join((Iterable)slotStrings) + "]")).toString();
    }

    public String getExplainString() {
        StringBuilder builder = new StringBuilder();
        String prefix = "  ";
        String tblStr = this.getTable() == null ? "null" : this.getTable().getName();
        builder.append(MoreObjects.toStringHelper((Object)this).add("id", this.id.asInt()).add("tbl", (Object)tblStr).add("byteSize", this.byteSize).add("materialized", this.isMaterialized).toString());
        builder.append("\n");
        for (SlotDescriptor slot : this.slots) {
            builder.append(slot.getExplainString(prefix)).append("\n");
        }
        return builder.toString();
    }
}

