/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ArithmeticExpr;
import org.apache.doris.analysis.Expr;
import org.apache.doris.catalog.Function;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.thrift.TExprNode;
import org.apache.doris.thrift.TExprNodeType;
import org.apache.doris.thrift.TExprOpcode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TimestampArithmeticExpr
extends Expr {
    private static final Logger LOG = LogManager.getLogger(TimestampArithmeticExpr.class);
    private static Map<String, TimeUnit> TIME_UNITS_MAP = new HashMap<String, TimeUnit>();
    private final String funcName;
    private final String timeUnitIdent;
    private final boolean intervalFirst;
    private ArithmeticExpr.Operator op;
    private TimeUnit timeUnit;

    public TimestampArithmeticExpr(String funcName, Expr e1, Expr e2, String timeUnitIdent) {
        this.funcName = funcName;
        this.timeUnitIdent = timeUnitIdent;
        this.intervalFirst = false;
        this.children.add(e1);
        this.children.add(e2);
    }

    public TimestampArithmeticExpr(ArithmeticExpr.Operator op, Expr e1, Expr e2, String timeUnitIdent, boolean intervalFirst) {
        Preconditions.checkState((op == ArithmeticExpr.Operator.ADD || op == ArithmeticExpr.Operator.SUBTRACT ? 1 : 0) != 0);
        this.funcName = null;
        this.op = op;
        this.timeUnitIdent = timeUnitIdent;
        this.intervalFirst = intervalFirst;
        this.children.add(e1);
        this.children.add(e2);
    }

    protected TimestampArithmeticExpr(TimestampArithmeticExpr other) {
        super(other);
        this.funcName = other.funcName;
        this.op = other.op;
        this.timeUnitIdent = other.timeUnitIdent;
        this.timeUnit = other.timeUnit;
        this.intervalFirst = other.intervalFirst;
    }

    @Override
    public Expr clone() {
        return new TimestampArithmeticExpr(this);
    }

    @Override
    public boolean isVectorized() {
        return false;
    }

    private Type fixType() {
        PrimitiveType t1 = ((Expr)this.getChild(0)).getType().getPrimitiveType();
        if (t1 == PrimitiveType.DATETIME) {
            return Type.DATETIME;
        }
        if (t1 == PrimitiveType.DATE) {
            return Type.DATE;
        }
        if (PrimitiveType.isImplicitCast(t1, PrimitiveType.DATETIME)) {
            return Type.DATETIME;
        }
        return Type.INVALID;
    }

    @Override
    public void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        String funcOpName;
        if (this.funcName != null && this.funcName.equalsIgnoreCase("TIMESTAMPDIFF")) {
            this.timeUnit = TIME_UNITS_MAP.get(this.timeUnitIdent.toUpperCase());
            if (this.timeUnit == null) {
                throw new AnalysisException("Invalid time unit '" + this.timeUnitIdent + "' in timestamp arithmetic expression '" + this.toSql() + "'.");
            }
            Type dateType = this.fixType();
            if (dateType.isDate() && this.timeUnit.isDateTime()) {
                dateType = Type.DATETIME;
            }
            if (!((Expr)this.getChild(0)).getType().isDateType() && !((Expr)this.getChild(0)).getType().isNull()) {
                if (!dateType.isValid()) {
                    throw new AnalysisException("Operand '" + ((Expr)this.getChild(0)).toSql() + "' of timestamp arithmetic expression '" + this.toSql() + "' returns type '" + ((Expr)this.getChild(0)).getType() + "'. Expected type 'TIMESTAMP/DATE/DATETIME'.");
                }
                this.castChild(dateType, 0);
            }
            if (!((Expr)this.getChild(1)).getType().isDateType() && !((Expr)this.getChild(1)).getType().isNull()) {
                if (!dateType.isValid()) {
                    throw new AnalysisException("Operand '" + ((Expr)this.getChild(1)).toSql() + "' of timestamp arithmetic expression '" + this.toSql() + "' returns type '" + ((Expr)this.getChild(1)).getType() + "'. Expected type 'TIMESTAMP/DATE/DATETIME'.");
                }
                this.castChild(dateType, 1);
            }
            this.type = Type.BIGINT;
            this.opcode = this.getOpCode();
            funcOpName = String.format("%sS_%s", new Object[]{this.timeUnit, "DIFF"});
        } else {
            if (this.funcName != null) {
                if (this.funcName.toUpperCase().equals("DATE_ADD") || this.funcName.toUpperCase().equals("DAYS_ADD") || this.funcName.toUpperCase().equals("ADDDATE") || this.funcName.toUpperCase().equals("TIMESTAMPADD")) {
                    this.op = ArithmeticExpr.Operator.ADD;
                } else if (this.funcName.toUpperCase().equals("DATE_SUB") || this.funcName.toUpperCase().equals("DAYS_SUB") || this.funcName.toUpperCase().equals("SUBDATE")) {
                    this.op = ArithmeticExpr.Operator.SUBTRACT;
                } else {
                    throw new AnalysisException("Encountered function name '" + this.funcName + "' in timestamp arithmetic expression '" + this.toSql() + "'. Expected function name 'DATE_ADD/DAYS_ADD/ADDDATE/TIMESTAMPADD'or 'DATE_SUB/DAYS_SUB/SUBDATE");
                }
            }
            this.timeUnit = TIME_UNITS_MAP.get(this.timeUnitIdent.toUpperCase());
            if (this.timeUnit == null) {
                throw new AnalysisException("Invalid time unit '" + this.timeUnitIdent + "' in timestamp arithmetic expression '" + this.toSql() + "'.");
            }
            Type dateType = this.fixType();
            if (dateType.isDate() && this.timeUnit.isDateTime()) {
                dateType = Type.DATETIME;
            }
            if (!((Expr)this.getChild(0)).getType().isDateType() && !((Expr)this.getChild(0)).getType().isNull()) {
                if (!dateType.isValid()) {
                    throw new AnalysisException("Operand '" + ((Expr)this.getChild(0)).toSql() + "' of timestamp arithmetic expression '" + this.toSql() + "' returns type '" + ((Expr)this.getChild(0)).getType() + "'. Expected type 'TIMESTAMP/DATE/DATETIME'.");
                }
                this.castChild(dateType, 0);
            }
            if (!((Expr)this.getChild(1)).getType().isScalarType()) {
                throw new AnalysisException("must be a scalar type.");
            }
            if (!((Expr)this.getChild(1)).getType().isScalarType(PrimitiveType.INT)) {
                if (!ScalarType.canCastTo((ScalarType)((Expr)this.getChild(1)).getType(), Type.INT)) {
                    throw new AnalysisException("Operand '" + ((Expr)this.getChild(1)).toSql() + "' of timestamp arithmetic expression '" + this.toSql() + "' returns type '" + ((Expr)this.getChild(1)).getType() + "' which is incompatible with expected type 'INT'.");
                }
                this.castChild(Type.INT, 1);
            }
            this.type = dateType;
            this.opcode = this.getOpCode();
            funcOpName = String.format("%sS_%s", new Object[]{this.timeUnit, this.op == ArithmeticExpr.Operator.ADD ? "ADD" : "SUB"});
        }
        this.fn = this.getBuiltinFunction(analyzer, funcOpName.toLowerCase(), this.collectChildReturnTypes(), Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
        LOG.debug("fn is {} name is {}", (Object)this.fn, (Object)funcOpName);
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.COMPUTE_FUNCTION_CALL;
        msg.setOpcode(this.opcode);
    }

    public ArithmeticExpr.Operator getOp() {
        return this.op;
    }

    private TExprOpcode getOpCode() throws AnalysisException {
        switch (this.timeUnit) {
            case YEAR: {
                if (this.op == ArithmeticExpr.Operator.ADD) {
                    return TExprOpcode.TIMESTAMP_YEARS_ADD;
                }
                return TExprOpcode.TIMESTAMP_YEARS_SUB;
            }
            case MONTH: {
                if (this.op == ArithmeticExpr.Operator.ADD) {
                    return TExprOpcode.TIMESTAMP_MONTHS_ADD;
                }
                return TExprOpcode.TIMESTAMP_MONTHS_SUB;
            }
            case WEEK: {
                if (this.op == ArithmeticExpr.Operator.ADD) {
                    return TExprOpcode.TIMESTAMP_WEEKS_ADD;
                }
                return TExprOpcode.TIMESTAMP_WEEKS_SUB;
            }
            case DAY: {
                if (this.op == ArithmeticExpr.Operator.ADD) {
                    return TExprOpcode.TIMESTAMP_DAYS_ADD;
                }
                return TExprOpcode.TIMESTAMP_DAYS_SUB;
            }
            case HOUR: {
                if (this.op == ArithmeticExpr.Operator.ADD) {
                    return TExprOpcode.TIMESTAMP_HOURS_ADD;
                }
                return TExprOpcode.TIMESTAMP_HOURS_SUB;
            }
            case MINUTE: {
                if (this.op == ArithmeticExpr.Operator.ADD) {
                    return TExprOpcode.TIMESTAMP_MINUTES_ADD;
                }
                return TExprOpcode.TIMESTAMP_MINUTES_SUB;
            }
            case SECOND: {
                if (this.op == ArithmeticExpr.Operator.ADD) {
                    return TExprOpcode.TIMESTAMP_SECONDS_ADD;
                }
                return TExprOpcode.TIMESTAMP_SECONDS_SUB;
            }
        }
        ErrorReport.reportAnalysisException(ErrorCode.ERR_BAD_TIMEUNIT, new Object[]{this.timeUnit});
        return null;
    }

    @Override
    public String toSqlImpl() {
        StringBuilder strBuilder = new StringBuilder();
        if (this.funcName != null) {
            if (this.funcName.equalsIgnoreCase("TIMESTAMPDIFF") || this.funcName.equalsIgnoreCase("TIMESTAMPADD")) {
                strBuilder.append(this.funcName).append("(");
                strBuilder.append(this.timeUnitIdent).append(", ");
                strBuilder.append(((Expr)this.getChild(1)).toSql()).append(", ");
                strBuilder.append(((Expr)this.getChild(0)).toSql()).append(")");
                return strBuilder.toString();
            }
            strBuilder.append(this.funcName).append("(");
            strBuilder.append(((Expr)this.getChild(0)).toSql()).append(", ");
            strBuilder.append("INTERVAL ");
            strBuilder.append(((Expr)this.getChild(1)).toSql());
            strBuilder.append(" ").append(this.timeUnitIdent);
            strBuilder.append(")");
            return strBuilder.toString();
        }
        if (this.intervalFirst) {
            strBuilder.append("INTERVAL ");
            strBuilder.append(((Expr)this.getChild(1)).toSql() + " ");
            strBuilder.append(this.timeUnitIdent);
            strBuilder.append(" ").append(this.op.toString()).append(" ");
            strBuilder.append(((Expr)this.getChild(0)).toSql());
        } else {
            strBuilder.append(((Expr)this.getChild(0)).toSql());
            strBuilder.append(" " + this.op.toString() + " ");
            strBuilder.append("INTERVAL ");
            strBuilder.append(((Expr)this.getChild(1)).toSql() + " ");
            strBuilder.append(this.timeUnitIdent);
        }
        return strBuilder.toString();
    }

    static {
        for (TimeUnit timeUnit : TimeUnit.values()) {
            TIME_UNITS_MAP.put(timeUnit.toString(), timeUnit);
        }
    }

    public static enum TimeUnit {
        YEAR("YEAR"),
        MONTH("MONTH"),
        WEEK("WEEK"),
        DAY("DAY"),
        HOUR("HOUR"),
        MINUTE("MINUTE"),
        SECOND("SECOND"),
        MICROSECOND("MICROSECOND"),
        SECOND_MICROSECOND("SECOND_MICROSECOND"),
        MINUTE_MICROSECOND("MINUTE_MICROSECOND"),
        MINUTE_SECOND("MINUTE_SECOND"),
        HOUR_MICROSECOND("HOUR_MICROSECOND"),
        HOUR_SECOND("HOUR_SECOND"),
        HOUR_MINUTE("HOUR_MINUTE"),
        DAY_MICROSECOND("DAY_MICROSECOND"),
        DAY_SECOND("DAY_SECOND"),
        DAY_MINUTE("DAY_MINUTE"),
        DAY_HOUR("DAY_HOUR"),
        YEAR_MONTH("YEAR_MONTH");

        private final String description;

        private TimeUnit(String description) {
            this.description = description;
        }

        public boolean isDateTime() {
            return this == HOUR || this == MINUTE || this == SECOND || this == MICROSECOND;
        }

        public String toString() {
            return this.description;
        }
    }
}

