/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.util.Map;
import org.apache.doris.alter.AlterOpType;
import org.apache.doris.analysis.AlterTableClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.FeNameFormat;

public class TableRenameClause
extends AlterTableClause {
    private String newTableName;

    public TableRenameClause(String newTableName) {
        super(AlterOpType.RENAME);
        this.newTableName = newTableName;
        this.needTableStable = false;
    }

    public String getNewTableName() {
        return this.newTableName;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)this.newTableName)) {
            throw new AnalysisException("New Table name is not set");
        }
        FeNameFormat.checkTableName(this.newTableName);
    }

    @Override
    public Map<String, String> getProperties() {
        return null;
    }

    @Override
    public String toSql() {
        return "RENAME " + this.newTableName;
    }

    public String toString() {
        return this.toSql();
    }
}

