/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.doris.analysis.AnalyticExpr;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.BoolLiteral;
import org.apache.doris.analysis.CompoundPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.JoinOperator;
import org.apache.doris.analysis.LateralViewRef;
import org.apache.doris.analysis.ParseNode;
import org.apache.doris.analysis.PartitionNames;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TableName;
import org.apache.doris.analysis.ToSqlUtils;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.Pair;
import org.apache.doris.common.UserException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.rewrite.ExprRewriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TableRef
implements ParseNode,
Writable {
    private static final Logger LOG = LogManager.getLogger(TableRef.class);
    protected TableName name;
    private PartitionNames partitionNames = null;
    protected String[] aliases_;
    protected boolean hasExplicitAlias_;
    protected JoinOperator joinOp;
    protected List<String> usingColNames;
    private ArrayList<String> joinHints;
    private ArrayList<String> sortHints;
    private ArrayList<String> commonHints;
    protected ArrayList<LateralViewRef> lateralViewRefs;
    private boolean isForcePreAggOpened;
    protected Expr onClause;
    protected TableRef leftTblRef;
    protected boolean isAnalyzed;
    protected List<TupleId> allTableRefIds_ = Lists.newArrayList();
    protected List<TupleId> allMaterializedTupleIds_ = Lists.newArrayList();
    protected List<TupleId> correlatedTupleIds_ = Lists.newArrayList();
    protected TupleDescriptor desc;
    private boolean isBroadcastJoin;
    private boolean isPartitionJoin;
    private String sortColumn = null;

    public TableRef() {
    }

    public TableRef(TableName name, String alias) {
        this(name, alias, null);
    }

    public TableRef(TableName name, String alias, PartitionNames partitionNames) {
        this(name, alias, partitionNames, null);
    }

    public TableRef(TableName name, String alias, PartitionNames partitionNames, ArrayList<String> commonHints) {
        this.name = name;
        if (alias != null) {
            if (Catalog.isStoredTableNamesLowerCase()) {
                alias = alias.toLowerCase();
            }
            this.aliases_ = new String[]{alias};
            this.hasExplicitAlias_ = true;
        } else {
            this.hasExplicitAlias_ = false;
        }
        this.partitionNames = partitionNames;
        this.commonHints = commonHints;
        this.isAnalyzed = false;
    }

    protected TableRef(TableRef other) {
        this.name = other.name;
        this.aliases_ = other.aliases_;
        this.hasExplicitAlias_ = other.hasExplicitAlias_;
        this.joinOp = other.joinOp;
        this.joinHints = other.joinHints != null ? Lists.newArrayList(other.joinHints) : null;
        this.sortHints = other.sortHints != null ? Lists.newArrayList(other.sortHints) : null;
        this.onClause = other.onClause != null ? other.onClause.clone().reset() : null;
        this.partitionNames = other.partitionNames != null ? new PartitionNames(other.partitionNames) : null;
        this.commonHints = other.commonHints;
        this.usingColNames = other.usingColNames != null ? Lists.newArrayList(other.usingColNames) : null;
        this.leftTblRef = null;
        this.isAnalyzed = other.isAnalyzed;
        this.allTableRefIds_ = Lists.newArrayList(other.allTableRefIds_);
        this.allMaterializedTupleIds_ = Lists.newArrayList(other.allMaterializedTupleIds_);
        this.correlatedTupleIds_ = Lists.newArrayList(other.correlatedTupleIds_);
        this.desc = other.desc;
        this.lateralViewRefs = null;
        if (other.lateralViewRefs != null) {
            this.lateralViewRefs = Lists.newArrayList();
            for (LateralViewRef viewRef : other.lateralViewRefs) {
                this.lateralViewRefs.add((LateralViewRef)viewRef.clone());
            }
        }
    }

    public PartitionNames getPartitionNames() {
        return this.partitionNames;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        ErrorReport.reportAnalysisException(ErrorCode.ERR_UNRESOLVED_TABLE_REF, this.tableRefToSql());
    }

    public TupleDescriptor createTupleDescriptor(Analyzer analyzer) throws AnalysisException {
        ErrorReport.reportAnalysisException(ErrorCode.ERR_UNRESOLVED_TABLE_REF, this.tableRefToSql());
        return null;
    }

    public JoinOperator getJoinOp() {
        return this.joinOp == null ? JoinOperator.INNER_JOIN : this.joinOp;
    }

    public void setJoinOp(JoinOperator op) {
        this.joinOp = op;
    }

    public Expr getOnClause() {
        return this.onClause;
    }

    public void setOnClause(Expr e) {
        this.onClause = e;
    }

    public TableName getName() {
        return this.name;
    }

    public TupleDescriptor getDesc() {
        Preconditions.checkState((boolean)this.isAnalyzed);
        Preconditions.checkState((this.desc != null ? 1 : 0) != 0);
        return this.desc;
    }

    public TupleId getId() {
        Preconditions.checkState((boolean)this.isAnalyzed);
        Preconditions.checkState((this.desc != null ? 1 : 0) != 0);
        return this.desc.getId();
    }

    public List<TupleId> getMaterializedTupleIds() {
        Preconditions.checkState((boolean)this.isAnalyzed);
        Preconditions.checkNotNull((Object)this.desc);
        return this.desc.getId().asList();
    }

    public List<TupleId> getAllMaterializedTupleIds() {
        if (this.leftTblRef != null) {
            ArrayList result = Lists.newArrayList(this.leftTblRef.getAllMaterializedTupleIds());
            result.addAll(this.getMaterializedTupleIds());
            return result;
        }
        return this.getMaterializedTupleIds();
    }

    public boolean isRelative() {
        return false;
    }

    public boolean isCorrelated() {
        return !this.correlatedTupleIds_.isEmpty();
    }

    public Table getTable() {
        return this.desc.getTable();
    }

    public void setUsingClause(List<String> colNames) {
        this.usingColNames = colNames;
    }

    public List<String> getUsingClause() {
        return this.usingColNames;
    }

    public TableRef getLeftTblRef() {
        return this.leftTblRef;
    }

    public void setLeftTblRef(TableRef leftTblRef) {
        this.leftTblRef = leftTblRef;
    }

    public ArrayList<String> getJoinHints() {
        return this.joinHints;
    }

    public boolean hasJoinHints() {
        return CollectionUtils.isNotEmpty(this.joinHints);
    }

    public void setJoinHints(ArrayList<String> hints) {
        this.joinHints = hints;
    }

    public boolean isBroadcastJoin() {
        return this.isBroadcastJoin;
    }

    public boolean isPartitionJoin() {
        return this.isPartitionJoin;
    }

    public boolean isForcePreAggOpened() {
        return this.isForcePreAggOpened;
    }

    public void setSortHints(ArrayList<String> hints) {
        this.sortHints = hints;
    }

    public String getSortColumn() {
        return this.sortColumn;
    }

    public void setLateralViewRefs(ArrayList<LateralViewRef> lateralViewRefs) {
        this.lateralViewRefs = lateralViewRefs;
    }

    public ArrayList<LateralViewRef> getLateralViewRefs() {
        return this.lateralViewRefs;
    }

    protected void analyzeLateralViewRef(Analyzer analyzer) throws UserException {
        if (this.lateralViewRefs == null) {
            return;
        }
        for (LateralViewRef lateralViewRef : this.lateralViewRefs) {
            lateralViewRef.setRelatedTable(this);
            lateralViewRef.analyze(analyzer);
        }
    }

    protected void analyzeSortHints() throws AnalysisException {
        if (this.sortHints == null) {
            return;
        }
        Iterator<String> iterator = this.sortHints.iterator();
        while (iterator.hasNext()) {
            String hint;
            this.sortColumn = hint = iterator.next();
        }
    }

    private void analyzeJoinHints() throws AnalysisException {
        if (this.joinHints == null) {
            return;
        }
        for (String hint : this.joinHints) {
            if (hint.toUpperCase().equals("BROADCAST")) {
                if (this.joinOp == JoinOperator.RIGHT_OUTER_JOIN || this.joinOp == JoinOperator.FULL_OUTER_JOIN || this.joinOp == JoinOperator.RIGHT_SEMI_JOIN || this.joinOp == JoinOperator.RIGHT_ANTI_JOIN) {
                    throw new AnalysisException(this.joinOp.toString() + " does not support BROADCAST.");
                }
                if (this.isPartitionJoin) {
                    throw new AnalysisException("Conflicting JOIN hint: " + hint);
                }
                this.isBroadcastJoin = true;
                continue;
            }
            if (hint.toUpperCase().equals("SHUFFLE")) {
                if (this.joinOp == JoinOperator.CROSS_JOIN) {
                    throw new AnalysisException("CROSS JOIN does not support SHUFFLE.");
                }
                if (this.isBroadcastJoin) {
                    throw new AnalysisException("Conflicting JOIN hint: " + hint);
                }
                this.isPartitionJoin = true;
                continue;
            }
            throw new AnalysisException("JOIN hint not recognized: " + hint);
        }
    }

    protected void analyzeHints() throws AnalysisException {
        if (this.commonHints == null || this.commonHints.isEmpty()) {
            return;
        }
        for (String hint : this.commonHints) {
            if (!hint.toUpperCase().equals("PREAGGOPEN")) continue;
            this.isForcePreAggOpened = true;
            break;
        }
    }

    public void analyzeJoin(Analyzer analyzer) throws AnalysisException {
        Preconditions.checkState((this.leftTblRef == null || this.leftTblRef.isAnalyzed ? 1 : 0) != 0);
        Preconditions.checkState((this.desc != null ? 1 : 0) != 0);
        this.analyzeJoinHints();
        this.allTableRefIds_.clear();
        this.allMaterializedTupleIds_.clear();
        if (this.leftTblRef != null) {
            this.allTableRefIds_.addAll(this.leftTblRef.getAllTableRefIds());
            this.allMaterializedTupleIds_.addAll(this.leftTblRef.getAllMaterializedTupleIds());
        }
        this.allTableRefIds_.add(this.getId());
        this.allMaterializedTupleIds_.addAll(this.getMaterializedTupleIds());
        if (this.usingColNames != null) {
            Preconditions.checkState((this.onClause == null ? 1 : 0) != 0);
            for (String colName : this.usingColNames) {
                if (this.leftTblRef.getDesc().getTable().getColumn(colName) == null) {
                    throw new AnalysisException("Unknown column " + colName + " for alias " + this.leftTblRef.getAlias() + " (in \"" + this.toSql() + "\")");
                }
                if (this.desc.getTable().getColumn(colName) == null) {
                    throw new AnalysisException("Unknown column " + colName + " for alias " + this.getAlias() + " (in \"" + this.toSql() + "\")");
                }
                BinaryPredicate eqPred = new BinaryPredicate(BinaryPredicate.Operator.EQ, new SlotRef(this.leftTblRef.getAliasAsName(), colName), new SlotRef(this.getAliasAsName(), colName));
                if (this.onClause == null) {
                    this.onClause = eqPred;
                    continue;
                }
                this.onClause = new CompoundPredicate(CompoundPredicate.Operator.AND, this.onClause, eqPred);
            }
        }
        boolean lhsIsNullable = false;
        boolean rhsIsNullable = false;
        if (this.leftTblRef != null) {
            for (TupleId tupleId : this.leftTblRef.getAllTableRefIds()) {
                Pair<TupleId, TupleId> tids = new Pair<TupleId, TupleId>(tupleId, this.getId());
                analyzer.registerAnyTwoTalesJoinOperator(tids, this.joinOp);
            }
        }
        if (this.joinOp == JoinOperator.LEFT_OUTER_JOIN || this.joinOp == JoinOperator.FULL_OUTER_JOIN) {
            analyzer.registerOuterJoinedTids(this.getId().asList(), this);
            analyzer.registerOuterJoinedMaterilizeTids(this.getMaterializedTupleIds());
        }
        if (this.joinOp == JoinOperator.RIGHT_OUTER_JOIN || this.joinOp == JoinOperator.FULL_OUTER_JOIN) {
            analyzer.registerOuterJoinedTids(this.leftTblRef.getAllTableRefIds(), this);
            analyzer.registerOuterJoinedMaterilizeTids(this.leftTblRef.getAllMaterializedTupleIds());
        }
        if (this.joinOp == JoinOperator.FULL_OUTER_JOIN) {
            analyzer.registerFullOuterJoinedTids(this.leftTblRef.getAllTableRefIds(), this);
            analyzer.registerFullOuterJoinedTids(this.getId().asList(), this);
            analyzer.registerOuterJoinedMaterilizeTids(this.leftTblRef.getAllMaterializedTupleIds());
            analyzer.registerOuterJoinedMaterilizeTids(this.getMaterializedTupleIds());
        }
        TupleId semiJoinedTupleId = null;
        if (this.joinOp == JoinOperator.LEFT_SEMI_JOIN || this.joinOp == JoinOperator.LEFT_ANTI_JOIN || this.joinOp == JoinOperator.NULL_AWARE_LEFT_ANTI_JOIN) {
            analyzer.registerSemiJoinedTid(this.getId(), this);
            semiJoinedTupleId = this.getId();
        }
        if (this.joinOp == JoinOperator.RIGHT_SEMI_JOIN || this.joinOp == JoinOperator.RIGHT_ANTI_JOIN) {
            analyzer.registerSemiJoinedTid(this.leftTblRef.getId(), this);
            semiJoinedTupleId = this.leftTblRef.getId();
        }
        if (this.joinOp == JoinOperator.RIGHT_ANTI_JOIN || this.joinOp == JoinOperator.RIGHT_SEMI_JOIN) {
            this.isPartitionJoin = true;
            this.isBroadcastJoin = false;
        }
        if (this.onClause != null && this.joinOp == JoinOperator.CROSS_JOIN) {
            throw new AnalysisException("Cross join can't be used with ON clause");
        }
        if (this.onClause != null) {
            analyzer.setVisibleSemiJoinedTuple(semiJoinedTupleId);
            this.onClause.analyze(analyzer);
            analyzer.setVisibleSemiJoinedTuple(null);
            this.onClause.checkReturnsBool("ON clause", true);
            if (this.onClause.contains(Expr.isAggregatePredicate())) {
                throw new AnalysisException("aggregate function not allowed in ON clause: " + this.toSql());
            }
            if (this.onClause.contains(AnalyticExpr.class)) {
                throw new AnalysisException("analytic expression not allowed in ON clause: " + this.toSql());
            }
            HashSet onClauseTupleIds = Sets.newHashSet();
            List<Expr> conjuncts = this.onClause.getConjuncts();
            analyzer.registerOnClauseConjuncts(conjuncts, this);
            for (Expr e : conjuncts) {
                ArrayList tupleIds = Lists.newArrayList();
                e.getIds(tupleIds, null);
                onClauseTupleIds.addAll(tupleIds);
            }
        } else {
            if (!this.isRelative() && !this.isCorrelated() && (this.getJoinOp().isOuterJoin() || this.getJoinOp().isSemiJoin())) {
                throw new AnalysisException(this.joinOp.toString() + " requires an ON or USING clause.");
            }
            analyzer.registerOnClauseConjuncts(Collections.emptyList(), this);
        }
    }

    public void rewriteExprs(ExprRewriter rewriter, Analyzer analyzer) throws AnalysisException {
        Preconditions.checkState((boolean)this.isAnalyzed);
        if (this.onClause != null) {
            Expr expr = this.onClause.clone();
            this.onClause = rewriter.rewrite(this.onClause, analyzer, ExprRewriter.ClauseType.ON_CLAUSE);
            if ((this.joinOp.isOuterJoin() || this.joinOp.isSemiAntiJoin()) && this.onClause instanceof BoolLiteral && !((BoolLiteral)this.onClause).getValue()) {
                this.onClause = expr;
            }
        }
    }

    private String joinOpToSql() {
        Preconditions.checkState((this.joinOp != null ? 1 : 0) != 0);
        switch (this.joinOp) {
            case INNER_JOIN: {
                return "INNER JOIN";
            }
            case LEFT_OUTER_JOIN: {
                return "LEFT OUTER JOIN";
            }
            case LEFT_SEMI_JOIN: {
                return "LEFT SEMI JOIN";
            }
            case LEFT_ANTI_JOIN: {
                return "LEFT ANTI JOIN";
            }
            case RIGHT_SEMI_JOIN: {
                return "RIGHT SEMI JOIN";
            }
            case RIGHT_ANTI_JOIN: {
                return "RIGHT ANTI JOIN";
            }
            case RIGHT_OUTER_JOIN: {
                return "RIGHT OUTER JOIN";
            }
            case FULL_OUTER_JOIN: {
                return "FULL OUTER JOIN";
            }
            case CROSS_JOIN: {
                return "CROSS JOIN";
            }
        }
        return "bad join op: " + this.joinOp.toString();
    }

    public List<TupleId> getAllTableRefIds() {
        Preconditions.checkState((boolean)this.isAnalyzed);
        return this.allTableRefIds_;
    }

    public String tableRefToSql() {
        String tblName = this.tableNameToSql();
        if (this.lateralViewRefs != null) {
            for (LateralViewRef viewRef : this.lateralViewRefs) {
                tblName = tblName + " " + viewRef.toSql();
            }
        }
        return tblName;
    }

    protected String tableNameToSql() {
        String aliasSql = null;
        String alias = this.getExplicitAlias();
        if (alias != null) {
            aliasSql = ToSqlUtils.getIdentSql(alias);
        }
        String tblName = this.name.toSql() + (aliasSql != null ? " " + aliasSql : "");
        return tblName;
    }

    @Override
    public String toSql() {
        if (this.joinOp == null) {
            return (this.leftTblRef != null ? ", " : "") + this.tableRefToSql();
        }
        StringBuilder output = new StringBuilder(" " + this.joinOpToSql() + " ");
        if (this.joinHints != null && !this.joinHints.isEmpty()) {
            output.append("[").append(Joiner.on((String)", ").join(this.joinHints)).append("] ");
        }
        output.append(this.tableRefToSql()).append(" ");
        if (this.usingColNames != null) {
            output.append("USING (").append(Joiner.on((String)", ").join(this.usingColNames)).append(")");
        } else if (this.onClause != null) {
            output.append("ON ").append(this.onClause.toSql());
        }
        return output.toString();
    }

    public String getAlias() {
        if (!this.hasExplicitAlias()) {
            return this.name.toString();
        }
        return this.getUniqueAlias();
    }

    public TableName getAliasAsName() {
        if (this.hasExplicitAlias()) {
            return new TableName(null, this.getUniqueAlias());
        }
        return this.name;
    }

    public String[] getAliases() {
        return this.aliases_;
    }

    public String getUniqueAlias() {
        return this.aliases_[0];
    }

    public boolean hasExplicitAlias() {
        return this.hasExplicitAlias_;
    }

    public String getExplicitAlias() {
        if (this.hasExplicitAlias()) {
            return this.getUniqueAlias();
        }
        return null;
    }

    public boolean isAnalyzed() {
        return this.isAnalyzed;
    }

    public boolean isResolved() {
        return !this.getClass().equals(TableRef.class);
    }

    public List<TupleId> getAllTupleIds() {
        Preconditions.checkState((boolean)this.isAnalyzed);
        if (this.leftTblRef != null) {
            List<TupleId> result = this.leftTblRef.getAllTupleIds();
            result.add(this.desc.getId());
            return result;
        }
        return Lists.newArrayList((Object[])new TupleId[]{this.desc.getId()});
    }

    protected void setJoinAttrs(TableRef other) {
        this.joinOp = other.joinOp;
        this.joinHints = other.joinHints;
        this.onClause = other.onClause;
        this.usingColNames = other.usingColNames;
    }

    public void reset() {
        this.isAnalyzed = false;
        if (this.usingColNames != null) {
            this.onClause = null;
        } else if (this.onClause != null) {
            this.onClause.reset();
        }
        this.leftTblRef = null;
        this.allTableRefIds_.clear();
        this.allMaterializedTupleIds_.clear();
        this.correlatedTupleIds_.clear();
        this.desc = null;
        if (this.lateralViewRefs != null) {
            for (LateralViewRef lateralViewRef : this.lateralViewRefs) {
                lateralViewRef.reset();
            }
        }
    }

    public TableRef clone() {
        return new TableRef(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        if (this.partitionNames != null) {
            sb.append(this.partitionNames.toSql());
        }
        if (this.aliases_ != null && this.aliases_.length > 0) {
            sb.append(" AS ").append(this.aliases_[0]);
        }
        return sb.toString();
    }

    public void write(DataOutput out) throws IOException {
        this.name.write(out);
        if (this.partitionNames == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.partitionNames.write(out);
        }
        if (this.hasExplicitAlias()) {
            out.writeBoolean(true);
            Text.writeString((DataOutput)out, (String)this.getExplicitAlias());
        } else {
            out.writeBoolean(false);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.name = new TableName();
        this.name.readFields(in);
        if (in.readBoolean()) {
            this.partitionNames = PartitionNames.read(in);
        }
        if (in.readBoolean()) {
            String alias = Text.readString((DataInput)in);
            this.aliases_ = new String[]{alias};
        }
    }
}

