/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.FeNameFormat;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.mysql.privilege.PaloAuth;

public class TablePattern
implements Writable {
    private String db;
    private String tbl;
    boolean isAnalyzed = false;
    public static TablePattern ALL = new TablePattern("*", "*");

    private TablePattern() {
    }

    public TablePattern(String db, String tbl) {
        this.db = Strings.isNullOrEmpty((String)db) ? "*" : db;
        this.tbl = Strings.isNullOrEmpty((String)tbl) ? "*" : tbl;
    }

    public String getQualifiedDb() {
        Preconditions.checkState((boolean)this.isAnalyzed);
        return this.db;
    }

    public String getTbl() {
        return this.tbl;
    }

    public PaloAuth.PrivLevel getPrivLevel() {
        Preconditions.checkState((boolean)this.isAnalyzed);
        if (this.db.equals("*")) {
            return PaloAuth.PrivLevel.GLOBAL;
        }
        if (!this.tbl.equals("*")) {
            return PaloAuth.PrivLevel.TABLE;
        }
        return PaloAuth.PrivLevel.DATABASE;
    }

    public void analyze(String clusterName) throws AnalysisException {
        if (this.isAnalyzed) {
            return;
        }
        if (this.db.equals("*") && !this.tbl.equals("*")) {
            throw new AnalysisException("Do not support format: " + this.toString());
        }
        if (!this.db.equals("*")) {
            FeNameFormat.checkDbName(this.db);
            this.db = ClusterNamespace.getFullName(clusterName, this.db);
        }
        if (!this.tbl.equals("*")) {
            FeNameFormat.checkTableName(this.tbl);
        }
        this.isAnalyzed = true;
    }

    public static TablePattern read(DataInput in) throws IOException {
        TablePattern tablePattern = new TablePattern();
        tablePattern.readFields(in);
        return tablePattern;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TablePattern)) {
            return false;
        }
        TablePattern other = (TablePattern)obj;
        return this.db.equals(other.getQualifiedDb()) && this.tbl.equals(other.getTbl());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.db.hashCode();
        result = 31 * result + this.tbl.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.db).append(".").append(this.tbl);
        return sb.toString();
    }

    public void write(DataOutput out) throws IOException {
        Preconditions.checkState((boolean)this.isAnalyzed);
        Text.writeString((DataOutput)out, (String)this.db);
        Text.writeString((DataOutput)out, (String)this.tbl);
    }

    public void readFields(DataInput in) throws IOException {
        this.db = Text.readString((DataInput)in);
        this.tbl = Text.readString((DataInput)in);
        this.isAnalyzed = true;
    }

    static {
        try {
            ALL.analyze("");
        }
        catch (AnalysisException analysisException) {
            // empty catch block
        }
    }
}

