/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;

public class TableName
implements Writable {
    private String tbl;
    private String db;

    public TableName() {
    }

    public TableName(String db, String tbl) {
        if (Catalog.isStoredTableNamesLowerCase() && !Strings.isNullOrEmpty((String)tbl)) {
            tbl = tbl.toLowerCase();
        }
        this.db = db;
        this.tbl = tbl;
    }

    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)this.db)) {
            this.db = analyzer.getDefaultDb();
            if (Strings.isNullOrEmpty((String)this.db)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
        } else {
            if (Strings.isNullOrEmpty((String)analyzer.getClusterName())) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_CLUSTER_NAME_NULL, new Object[0]);
            }
            this.db = ClusterNamespace.getFullName(analyzer.getClusterName(), this.db);
        }
        if (Strings.isNullOrEmpty((String)this.tbl)) {
            throw new AnalysisException("Table name is null");
        }
    }

    public String getDb() {
        return this.db;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public String getTbl() {
        return this.tbl;
    }

    public boolean isEmpty() {
        return this.tbl.isEmpty();
    }

    public boolean isFullyQualified() {
        return this.db != null && !this.db.isEmpty() && !this.tbl.isEmpty();
    }

    public String getNoClusterString() {
        if (this.db == null) {
            return this.tbl;
        }
        String dbName = ClusterNamespace.getNameFromFullName(this.db);
        if (dbName == null) {
            return this.db + "." + this.tbl;
        }
        return dbName + "." + this.tbl;
    }

    public String toString() {
        if (this.db == null) {
            return this.tbl;
        }
        return this.db + "." + this.tbl;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof TableName) {
            return this.toString().equals(other.toString());
        }
        return false;
    }

    public String toSql() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.db != null) {
            stringBuilder.append("`").append(this.db).append("`.");
        }
        stringBuilder.append("`").append(this.tbl).append("`");
        return stringBuilder.toString();
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.db);
        Text.writeString((DataOutput)out, (String)this.tbl);
    }

    public void readFields(DataInput in) throws IOException {
        this.db = Text.readString((DataInput)in);
        this.tbl = Text.readString((DataInput)in);
    }

    public TableName cloneWithoutAnalyze() {
        TableName tableName = new TableName(this.db, this.tbl);
        return tableName;
    }
}

