/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.util.Objects;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BoolLiteral;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FloatLiteral;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.SetType;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.qe.VariableMgr;
import org.apache.doris.qe.VariableVarConverters;
import org.apache.doris.thrift.TBoolLiteral;
import org.apache.doris.thrift.TExprNode;
import org.apache.doris.thrift.TExprNodeType;
import org.apache.doris.thrift.TFloatLiteral;
import org.apache.doris.thrift.TIntLiteral;
import org.apache.doris.thrift.TStringLiteral;

public class SysVariableDesc
extends Expr {
    private String name;
    private SetType setType;
    private boolean boolValue;
    private long intValue;
    private double floatValue;
    private String strValue;
    private LiteralExpr literalExpr;

    public SysVariableDesc(String name) {
        this(name, SetType.SESSION);
    }

    public SysVariableDesc(String name, SetType setType) {
        this.name = name;
        this.setType = setType;
    }

    protected SysVariableDesc(SysVariableDesc other) {
        super(other);
        this.name = other.name;
        this.setType = other.setType;
        this.boolValue = other.boolValue;
        this.intValue = other.intValue;
        this.floatValue = other.floatValue;
        this.strValue = other.strValue;
    }

    @Override
    public Expr clone() {
        return new SysVariableDesc(this);
    }

    @Override
    public void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        VariableMgr.fillValue(analyzer.getContext().getSessionVariable(), this);
        if (!Strings.isNullOrEmpty((String)this.name) && VariableVarConverters.hasConverter(this.name).booleanValue()) {
            this.setType(Type.VARCHAR);
            try {
                this.setStringValue(VariableVarConverters.decode(this.name, this.intValue));
            }
            catch (DdlException e) {
                ErrorReport.reportAnalysisException(e.getMessage(), new Object[0]);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public SetType getSetType() {
        return this.setType;
    }

    public void setBoolValue(boolean value) {
        this.boolValue = value;
        this.literalExpr = new BoolLiteral(value);
    }

    public void setIntValue(long value) {
        this.intValue = value;
        this.literalExpr = new IntLiteral(value);
    }

    public void setFloatValue(double value) {
        this.floatValue = value;
        this.literalExpr = new FloatLiteral(value);
    }

    public void setStringValue(String value) {
        this.strValue = value;
        this.literalExpr = new StringLiteral(value);
    }

    public Expr getLiteralExpr() {
        return this.literalExpr;
    }

    @Override
    public Expr getResultValue() throws AnalysisException {
        if (!Strings.isNullOrEmpty((String)this.name) && VariableVarConverters.hasConverter(this.name).booleanValue()) {
            try {
                StringLiteral s = new StringLiteral(VariableVarConverters.decode(this.name, this.intValue));
                s.setBeConverted(this.name);
                return s;
            }
            catch (DdlException e) {
                throw new AnalysisException(e.getMessage());
            }
        }
        return super.getResultValue();
    }

    @Override
    protected boolean isConstantImpl() {
        return true;
    }

    @Override
    protected void toThrift(TExprNode msg) {
        switch (this.type.getPrimitiveType()) {
            case BOOLEAN: {
                msg.node_type = TExprNodeType.BOOL_LITERAL;
                msg.bool_literal = new TBoolLiteral(this.boolValue);
                break;
            }
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: {
                msg.node_type = TExprNodeType.INT_LITERAL;
                msg.int_literal = new TIntLiteral(this.intValue);
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                msg.node_type = TExprNodeType.FLOAT_LITERAL;
                msg.float_literal = new TFloatLiteral(this.floatValue);
                break;
            }
            default: {
                msg.node_type = TExprNodeType.STRING_LITERAL;
                msg.string_literal = new TStringLiteral(this.strValue);
            }
        }
    }

    @Override
    public String toSqlImpl() {
        StringBuilder sb = new StringBuilder("@@");
        if (this.setType == SetType.GLOBAL) {
            sb.append("GLOBAL.");
        }
        sb.append(this.name);
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toSql();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SysVariableDesc)) {
            return false;
        }
        if (!this.name.equals(((SysVariableDesc)obj).getName())) {
            return false;
        }
        if (!this.setType.equals((Object)((SysVariableDesc)obj).getSetType())) {
            return false;
        }
        return Objects.equals(this.literalExpr, ((SysVariableDesc)obj).getLiteralExpr());
    }
}

