/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.QueryStmt;
import org.apache.doris.analysis.SelectStmt;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.catalog.MultiRowType;
import org.apache.doris.catalog.StructField;
import org.apache.doris.catalog.StructType;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.UserException;
import org.apache.doris.thrift.TExprNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Subquery
extends Expr {
    private static final Logger LOG = LoggerFactory.getLogger(Subquery.class);
    protected QueryStmt stmt;
    protected Analyzer analyzer;

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public QueryStmt getStatement() {
        return this.stmt;
    }

    @Override
    public String toSqlImpl() {
        return "(" + this.stmt.toSql() + ")";
    }

    public Subquery(QueryStmt queryStmt) {
        Preconditions.checkNotNull((Object)queryStmt);
        this.stmt = queryStmt;
        this.stmt.setNeedToSql(true);
    }

    public Subquery(Subquery other) {
        super(other);
        this.stmt = other.stmt.clone();
        this.analyzer = other.analyzer;
    }

    @Override
    public void analyzeImpl(Analyzer parentAnalyzer) throws AnalysisException {
        if (!(this.stmt instanceof SelectStmt)) {
            throw new AnalysisException("A subquery must contain a single select block: " + this.toSql());
        }
        this.analyzer = new Analyzer(parentAnalyzer);
        this.analyzer.setIsSubquery();
        try {
            this.stmt.analyze(this.analyzer);
        }
        catch (UserException e) {
            throw new AnalysisException(e.getMessage(), e);
        }
        this.stmt.getCorrelatedTupleIds(this.analyzer);
        List stmtResultExprs = this.stmt.getResultExprs();
        if (((ArrayList)stmtResultExprs).size() == 1) {
            this.type = ((Expr)((ArrayList)stmtResultExprs).get(0)).getType();
            Preconditions.checkState((!this.type.isComplexType() ? 1 : 0) != 0);
        } else {
            this.type = this.createStructTypeFromExprList();
        }
        if (!((SelectStmt)this.stmt).returnsSingleRow()) {
            this.type = new MultiRowType(this.type);
        }
    }

    @Override
    protected boolean isConstantImpl() {
        return false;
    }

    public boolean returnsScalarColumn() {
        List stmtResultExprs = this.stmt.getResultExprs();
        return ((ArrayList)stmtResultExprs).size() == 1 && ((Expr)((ArrayList)stmtResultExprs).get(0)).getType().isScalarType();
    }

    private StructType createStructTypeFromExprList() {
        List stmtResultExprs = this.stmt.getResultExprs();
        ArrayList structFields = Lists.newArrayList();
        List labels = this.stmt.getColLabels();
        boolean hasUniqueLabels = true;
        if (Sets.newHashSet((Iterable)labels).size() != labels.size()) {
            hasUniqueLabels = false;
        }
        for (int i = 0; i < stmtResultExprs.size(); ++i) {
            Expr expr = (Expr)stmtResultExprs.get(i);
            String fieldName = null;
            fieldName = "_" + Integer.toString(i);
            Preconditions.checkNotNull((Object)fieldName);
            structFields.add(new StructField(fieldName, expr.getType(), null));
        }
        Preconditions.checkState((structFields.size() != 0 ? 1 : 0) != 0);
        return new StructType(structFields);
    }

    @Override
    public boolean isCorrelatedPredicate(List<TupleId> tupleIdList) {
        List<TupleId> tupleIdFromSubquery = this.stmt.collectTupleIds();
        for (TupleId tupleId : tupleIdList) {
            if (!tupleIdFromSubquery.contains(tupleId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        return this.stmt.toSql().equals(((Subquery)o).stmt.toSql());
    }

    @Override
    public Subquery clone() {
        Subquery ret = new Subquery(this);
        LOG.debug("SUBQUERY clone old={} new={}", (Object)System.identityHashCode(this), (Object)System.identityHashCode(ret));
        return ret;
    }

    @Override
    protected void toThrift(TExprNode msg) {
    }
}

