/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Objects;
import org.apache.doris.analysis.DateLiteral;
import org.apache.doris.analysis.DecimalLiteral;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FloatLiteral;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.LargeIntLiteral;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.MaxLiteral;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.io.Text;
import org.apache.doris.qe.VariableVarConverters;
import org.apache.doris.thrift.TExprNode;
import org.apache.doris.thrift.TExprNodeType;
import org.apache.doris.thrift.TStringLiteral;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StringLiteral
extends LiteralExpr {
    private static final Logger LOG = LogManager.getLogger(StringLiteral.class);
    private String value;
    private String beConverted = "";

    public StringLiteral() {
        this.type = Type.VARCHAR;
    }

    public StringLiteral(String value) {
        this.value = value;
        this.type = Type.VARCHAR;
        this.analysisDone();
    }

    protected StringLiteral(StringLiteral other) {
        super(other);
        this.value = other.value;
    }

    public void setBeConverted(String val) {
        this.beConverted = val;
    }

    @Override
    public Expr clone() {
        return new StringLiteral(this);
    }

    @Override
    public int compareLiteral(LiteralExpr expr) {
        if (expr instanceof NullLiteral) {
            return 1;
        }
        if (expr == MaxLiteral.MAX_VALUE) {
            return -1;
        }
        byte[] thisBytes = null;
        byte[] otherBytes = null;
        try {
            thisBytes = this.value.getBytes("UTF-8");
            otherBytes = expr.getStringValue().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Preconditions.checkState((boolean)false);
        }
        int minLength = Math.min(thisBytes.length, otherBytes.length);
        int i = 0;
        for (i = 0; i < minLength; ++i) {
            if (thisBytes[i] < otherBytes[i]) {
                return -1;
            }
            if (thisBytes[i] <= otherBytes[i]) continue;
            return 1;
        }
        if (thisBytes.length > otherBytes.length) {
            if (thisBytes[i] == 0) {
                return 0;
            }
            return 1;
        }
        if (thisBytes.length < otherBytes.length) {
            if (otherBytes[i] == 0) {
                return 0;
            }
            return -1;
        }
        return 0;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isMinValue() {
        return false;
    }

    @Override
    public String toSqlImpl() {
        return "'" + this.value.replaceAll("'", "''") + "'";
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.STRING_LITERAL;
        msg.string_literal = new TStringLiteral(this.getUnescapedValue());
    }

    public String getUnescapedValue() {
        return this.value;
    }

    @Override
    public String getStringValue() {
        return this.value;
    }

    @Override
    public long getLongValue() {
        return Long.valueOf(this.value);
    }

    @Override
    public double getDoubleValue() {
        return Double.valueOf(this.value);
    }

    @Override
    public String getRealValue() {
        return this.getStringValue();
    }

    public LiteralExpr convertToDate(Type targetType) throws AnalysisException {
        DateLiteral newLiteral = null;
        try {
            newLiteral = new DateLiteral(this.value, targetType);
        }
        catch (AnalysisException e) {
            if (targetType.isScalarType(PrimitiveType.DATETIME)) {
                newLiteral = new DateLiteral(this.value, (Type)Type.DATE);
                newLiteral.setType(Type.DATETIME);
            }
            throw e;
        }
        return newLiteral;
    }

    @Override
    protected Expr uncheckedCastTo(Type targetType) throws AnalysisException {
        if (targetType.isNumericType()) {
            switch (targetType.getPrimitiveType()) {
                case TINYINT: 
                case SMALLINT: 
                case INT: 
                case BIGINT: {
                    if (VariableVarConverters.hasConverter(this.beConverted).booleanValue()) {
                        try {
                            return new IntLiteral(VariableVarConverters.encode(this.beConverted, this.value), targetType);
                        }
                        catch (DdlException e) {
                            throw new AnalysisException(e.getMessage());
                        }
                    }
                    return new IntLiteral(this.value, targetType);
                }
                case LARGEINT: {
                    if (VariableVarConverters.hasConverter(this.beConverted).booleanValue()) {
                        try {
                            return new LargeIntLiteral(String.valueOf(VariableVarConverters.encode(this.beConverted, this.value)));
                        }
                        catch (DdlException e) {
                            throw new AnalysisException(e.getMessage());
                        }
                    }
                    return new LargeIntLiteral(this.value);
                }
                case FLOAT: 
                case DOUBLE: {
                    try {
                        return new FloatLiteral(Double.valueOf(this.value), targetType);
                    }
                    catch (NumberFormatException e) {
                        ErrorReport.reportAnalysisException(ErrorCode.ERR_BAD_NUMBER, this.value);
                        break;
                    }
                }
                case DECIMALV2: {
                    return new DecimalLiteral(this.value);
                }
            }
        } else if (targetType.isDateType()) {
            try {
                return this.convertToDate(targetType);
            }
            catch (AnalysisException e) {
            }
        } else {
            if (targetType.equals(this.type)) {
                return this;
            }
            if (targetType.isStringType()) {
                StringLiteral stringLiteral = new StringLiteral(this);
                stringLiteral.setType(targetType);
                return stringLiteral;
            }
        }
        return super.uncheckedCastTo(targetType);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        Text.writeString((DataOutput)out, (String)this.value);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.value = Text.readString((DataInput)in);
    }

    public static StringLiteral read(DataInput in) throws IOException {
        StringLiteral literal = new StringLiteral();
        literal.readFields(in);
        return literal;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode(this.value);
    }
}

